/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.panoply.action.PanPlotWidthAction;
import gov.nasa.giss.panoply.action.PanThinnerPlotAction;
import gov.nasa.giss.panoply.action.PanWiderPlotAction;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanPlotWidthFactor;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.menu.GissCheckBoxMenuItem;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;

public class PanPlotWidthMenu
extends PanMenu {
    private final JMenuItem miCurrentWidth_;
    private final JMenuItem miWider_;
    private final JMenuItem miThinner_;
    private final Hashtable<String, JCheckBoxMenuItem> miPresetsHash_ = new Hashtable(20);

    public PanPlotWidthMenu(PanFrame parent) {
        super(parent, "plot-width-menu");
        boolean parentIsPlot = parent instanceof PanPlotFrame;
        PanPlotMeta pmeta = parentIsPlot ? ((PanPlotFrame)parent).getMeta() : null;
        this.miCurrentWidth_ = this.makeItemFromProperties("current-width", null);
        this.add(this.miCurrentWidth_).setEnabled(false);
        this.addSeparator();
        AbstractAction a = parentIsPlot ? new PanWiderPlotAction(pmeta) : null;
        this.miWider_ = this.makeItemFromProperties("show-wider", a);
        this.add(this.miWider_).setEnabled(false);
        a = parentIsPlot ? new PanThinnerPlotAction(pmeta) : null;
        this.miThinner_ = this.makeItemFromProperties("show-thinner", a);
        this.add(this.miThinner_).setEnabled(false);
        this.addSeparator();
        for (PanPlotWidthFactor pwidth : PanPlotWidthFactor.values()) {
            String aid = pwidth.getActionID();
            String atext = pwidth.toString();
            PanPlotWidthAction a2 = parentIsPlot ? new PanPlotWidthAction(pmeta, pwidth) : null;
            GissCheckBoxMenuItem mi = aid != null ? this.makeCheckBoxItemFromProperties(aid, a2) : this.makeCheckBoxItem(atext, a2);
            this.miPresetsHash_.put(atext, mi);
            this.add(mi).setEnabled(parentIsPlot);
        }
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (!(this.pframe_ instanceof PanPlotFrame)) {
            return;
        }
        PanPlotFrame ppf = (PanPlotFrame)this.pframe_;
        boolean animating = PanPlotFrame.isAnimationInProgress();
        if (animating) {
            return;
        }
        PanPlotMeta pmeta = ppf.getMeta();
        int wf = pmeta.getInt("size.width");
        this.miCurrentWidth_.setText(PanProperties.MENU_PROPS.getString("current-width") + " = " + wf);
        this.miWider_.setEnabled(wf < 100);
        this.miThinner_.setEnabled(wf > 20);
        for (String key : this.miPresetsHash_.keySet()) {
            JCheckBoxMenuItem mi = this.miPresetsHash_.get(key);
            String text = mi.getText();
            PanPlotWidthFactor pwidth = PanPlotWidthFactor.matching(text);
            if (pwidth == null) {
                mi.setSelected(false);
                continue;
            }
            mi.setSelected(pwidth.getWidthFactor() == wf);
        }
    }
}

