/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.SizeVariant;
import gov.nasa.giss.ui.StringComboBox;
import gov.nasa.giss.ui.plaf.GissComboBoxUI;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanGuiUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int STD_MARGIN = 8;
    public static final int STD_SPACING = 4;
    public static final int STD_GAP = 2;
    public static final int GUTTER_GAP = 12;
    public static final Color LIGHT_GRAY = new Color(238, 238, 238);
    public static final Color FOCUS_COLOR = UIManager.getColor("Focus.color");
    private static final int FOCUS_THICKNESS = 1;
    public static final Border NO_BORDER = BorderFactory.createEmptyBorder();
    public static final Border STD_BORDER = BorderFactory.createEmptyBorder(8, 8, 8, 8);
    public static final Border DIALOG_BORDER = BorderFactory.createEmptyBorder(16, 16, 16, 16);
    public static final Border WINDOID_SECT_BORDER = BorderFactory.createEmptyBorder(2, 8, 4, 8);
    public static final Border THIN_UNFOCUSED_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    public static final Border THIN_FOCUSED_BORDER = BorderFactory.createLineBorder(FOCUS_COLOR, 1);
    public static final Border PADDED_UNFOCUSED_BORDER = STD_BORDER;
    public static final Border PADDED_FOCUSED_BORDER = new CompoundBorder(THIN_FOCUSED_BORDER, BorderFactory.createEmptyBorder(7, 7, 7, 7));
    public static final Border SIMPLE_OUTLINE_BORDER = new CompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    public static final Border DEBUG_BORDER = BorderFactory.createLineBorder(Color.RED, 1);

    public static Component gutterGap() {
        return Box.createHorizontalStrut(12);
    }

    public static void setSizeVariant(JComponent jc, SizeVariant size) {
        if (jc == null) {
            return;
        }
        jc.setOpaque(false);
        for (Component c : jc.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            PanGuiUtils.setSizeVariant((JComponent)c, size);
        }
        GuiUtils.setSizeVariant(jc, size);
    }

    public static void setSizeSmall(JComponent jc) {
        PanGuiUtils.setSizeVariant(jc, SizeVariant.SMALL);
    }

    public static void setSizeRegular(JComponent jc) {
        PanGuiUtils.setSizeVariant(jc, SizeVariant.REGULAR);
    }

    public static void applyComboBoxUI(JComboBox<?> jcb, SizeVariant size) {
        jcb.setPreferredSize(null);
        PanGuiUtils.setSizeVariant(jcb, size);
        jcb.setUI(new GissComboBoxUI());
    }

    public static void setMaxWidth(StringComboBox jcb, int width) {
        Dimension minsize = jcb.getPreferredSize();
        Dimension prefsize = jcb.getPreferredSize();
        if (prefsize.width > width) {
            prefsize.width = width;
            jcb.setPreferredSize(prefsize);
            jcb.setMaximumSize(prefsize);
        }
        if (minsize.width > width) {
            minsize.width = width;
            jcb.setMinimumSize(minsize);
        }
    }

    public static void attachKeyStrokeAction(AbstractAction a, String id, InputMap im, ActionMap am) {
        boolean metaIsShortcut = PlatformUtils.isMacintosh();
        String ksStr = metaIsShortcut ? PanProperties.MENU_PROPS.getAttribute(id, "mackeystroke") : PanProperties.MENU_PROPS.getAttribute(id, "keystroke");
        KeyStroke ks = KeyStroke.getKeyStroke(ksStr);
        if (ks == null) {
            LOGGER.trace("KeyStroke for {} is null", (Object)id);
        } else {
            im.put(ks, id);
        }
        am.put(id, a);
    }

    private PanGuiUtils() {
    }
}

