/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.filechooser;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class ExtFileFilter
extends FileFilter {
    private String description_;
    private String[] extensions_;
    private boolean saving_;

    public ExtFileFilter(String extension) {
        this(extension.toUpperCase(), extension);
    }

    public ExtFileFilter(String description, String ... extensions) {
        this.extensions_ = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            this.extensions_[i] = extensions[i].toLowerCase();
        }
        this.description_ = description;
    }

    public void setSaving(boolean b) {
        this.saving_ = b;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        return this.accept(f.getName());
    }

    public boolean accept(String fname) {
        if (this.extensions_.length == 0 || this.extensions_[0].equals("")) {
            return true;
        }
        String lcname = fname.toLowerCase();
        for (String extension : this.extensions_) {
            if (!lcname.endsWith("." + extension)) continue;
            return true;
        }
        return this.saving_;
    }

    public String[] getExtensions() {
        return this.extensions_;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }
}

