/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.table;

import gov.nasa.giss.ui.table.TableThemeID;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableHeaderTheme {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Hashtable<TParamKey, Object> themeProps_ = new Hashtable();
    private static TableHeaderTheme macosGraphiteTheme_;
    private static TableHeaderTheme macosDarkModeTheme_;
    private static TableHeaderTheme oldMacosTheme_;

    public TableHeaderTheme(Object ... props) {
        if (props.length % 2 != 0) {
            throw new IllegalArgumentException("Mis-matched count of properties and keys.");
        }
        for (int i = 0; i < props.length; i += 2) {
            if (props[i] == null) {
                throw new IllegalArgumentException("Property " + i / 2 + " key is null.");
            }
            if (!(props[i] instanceof TParamKey)) {
                throw new IllegalArgumentException("Property " + i / 2 + " key is not a TParamKey.");
            }
            this.themeProps_.put((TParamKey)((Object)props[i]), props[i + 1]);
        }
    }

    public boolean getBoolean(TParamKey key) {
        Object o = this.themeProps_.get((Object)key);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    public Color getColor(TParamKey key) {
        Object o = this.themeProps_.get((Object)key);
        if (o instanceof Color) {
            return this.cloneColor((Color)o);
        }
        return null;
    }

    public int getInt(TParamKey key) {
        Object o = this.themeProps_.get((Object)key);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    private Color cloneColor(Color color) {
        Color cnew = new Color(color.getRGB());
        return cnew;
    }

    public static TableHeaderTheme getTheme(TableThemeID themeID) {
        if (themeID == null) {
            return TableHeaderTheme.getMacosGraphiteTheme();
        }
        switch (themeID) {
            case MACOS_GRAPHITE: {
                return TableHeaderTheme.getMacosGraphiteTheme();
            }
            case MACOS_DARKMODE: 
            case HUD: {
                return TableHeaderTheme.getMacosDarkModeTheme();
            }
            case MACOS_AQUA: {
                return TableHeaderTheme.getMacosAquaTheme();
            }
        }
        return TableHeaderTheme.getMacosGraphiteTheme();
    }

    private static TableHeaderTheme getMacosGraphiteTheme() {
        if (macosGraphiteTheme_ == null) {
            Color selectedColor = new Color(228, 228, 228);
            Color unselectedColor = new Color(240, 240, 240);
            Color gray216 = new Color(216, 216, 216);
            macosGraphiteTheme_ = new TableHeaderTheme(new Object[]{TParamKey.UNSELECTED_TOP_COLOR, unselectedColor, TParamKey.UNSELECTED_BOTTOM_COLOR, unselectedColor, TParamKey.LEFT_UNSELECTED_BORDER_COLOR, unselectedColor, TParamKey.RIGHT_UNSELECTED_BORDER_COLOR, gray216, TParamKey.SELECTED_TOP_COLOR, selectedColor, TParamKey.SELECTED_BOTTOM_COLOR, selectedColor, TParamKey.LEFT_SELECTED_BORDER_COLOR, selectedColor, TParamKey.RIGHT_SELECTED_BORDER_COLOR, gray216, TParamKey.PRESSED_UNSELECTED_TOP_COLOR, selectedColor, TParamKey.PRESSED_UNSELECTED_BOTTOM_COLOR, selectedColor, TParamKey.LEFT_PRESSED_UNSELECTED_BORDER_COLOR, selectedColor, TParamKey.PRESSED_SELECTED_TOP_COLOR, selectedColor, TParamKey.PRESSED_SELECTED_BOTTOM_COLOR, selectedColor, TParamKey.BOTTOM_BORDER_COLOR, new Color(192, 192, 192), TParamKey.TOP_BOTTOM_PADDING, 4, TParamKey.UNSELECTED_FOREGROUND_COLOR, Color.BLACK, TParamKey.FONT_STYLE, 0, TParamKey.FONT_EMPHASIZED, false});
        }
        return macosGraphiteTheme_;
    }

    private static TableHeaderTheme getMacosDarkModeTheme() {
        if (macosDarkModeTheme_ == null) {
            Color selectedColor = new Color(133, 134, 132);
            Color unselectedColor = new Color(55, 56, 52);
            macosDarkModeTheme_ = new TableHeaderTheme(new Object[]{TParamKey.UNSELECTED_TOP_COLOR, unselectedColor, TParamKey.UNSELECTED_BOTTOM_COLOR, unselectedColor, TParamKey.LEFT_UNSELECTED_BORDER_COLOR, unselectedColor, TParamKey.RIGHT_UNSELECTED_BORDER_COLOR, new Color(76, 77, 73), TParamKey.SELECTED_TOP_COLOR, selectedColor, TParamKey.SELECTED_BOTTOM_COLOR, selectedColor, TParamKey.LEFT_SELECTED_BORDER_COLOR, selectedColor, TParamKey.RIGHT_SELECTED_BORDER_COLOR, new Color(145, 146, 144), TParamKey.PRESSED_UNSELECTED_TOP_COLOR, selectedColor, TParamKey.PRESSED_UNSELECTED_BOTTOM_COLOR, selectedColor, TParamKey.LEFT_PRESSED_UNSELECTED_BORDER_COLOR, selectedColor, TParamKey.PRESSED_SELECTED_TOP_COLOR, selectedColor, TParamKey.PRESSED_SELECTED_BOTTOM_COLOR, selectedColor, TParamKey.BOTTOM_BORDER_COLOR, new Color(76, 77, 73), TParamKey.TOP_BOTTOM_PADDING, 4, TParamKey.UNSELECTED_FOREGROUND_COLOR, Color.WHITE, TParamKey.FONT_STYLE, 1, TParamKey.FONT_EMPHASIZED, false});
        }
        return macosDarkModeTheme_;
    }

    private static TableHeaderTheme getMacosAquaTheme() {
        if (oldMacosTheme_ == null) {
            oldMacosTheme_ = new TableHeaderTheme(new Object[]{TParamKey.UNSELECTED_TOP_COLOR, new Color(219, 219, 219), TParamKey.UNSELECTED_BOTTOM_COLOR, new Color(187, 187, 187), TParamKey.LEFT_UNSELECTED_BORDER_COLOR, new Color(217, 217, 217), TParamKey.RIGHT_UNSELECTED_BORDER_COLOR, new Color(156, 156, 156), TParamKey.SELECTED_TOP_COLOR, new Color(194, 207, 221), TParamKey.SELECTED_BOTTOM_COLOR, new Color(125, 147, 178), TParamKey.LEFT_SELECTED_BORDER_COLOR, new Color(171, 187, 206), TParamKey.RIGHT_SELECTED_BORDER_COLOR, new Color(138, 151, 166), TParamKey.PRESSED_UNSELECTED_TOP_COLOR, new Color(196, 196, 196), TParamKey.PRESSED_UNSELECTED_BOTTOM_COLOR, new Color(149, 149, 149), TParamKey.LEFT_PRESSED_UNSELECTED_BORDER_COLOR, new Color(192, 192, 192), TParamKey.PRESSED_SELECTED_TOP_COLOR, new Color(150, 183, 203), TParamKey.PRESSED_SELECTED_BOTTOM_COLOR, new Color(83, 107, 144), TParamKey.BOTTOM_BORDER_COLOR, new Color(85, 85, 85), TParamKey.TOP_BOTTOM_PADDING, 0, TParamKey.UNSELECTED_FOREGROUND_COLOR, Color.BLACK, TParamKey.FONT_STYLE, 1, TParamKey.FONT_EMPHASIZED, true});
        }
        return oldMacosTheme_;
    }

    public TableHeaderTheme copy() {
        TableHeaderTheme tcopy = new TableHeaderTheme(new Object[0]);
        for (TParamKey key : this.themeProps_.keySet()) {
            Object val = this.themeProps_.get((Object)key);
            if (val == null) {
                LOGGER.trace("TableHeaderTheme param {} is unexpectedly null.");
            } else if (val instanceof Color[]) {
                Color[] valarray = val;
                val = Arrays.copyOf(valarray, valarray.length);
            } else if (!(val instanceof Color)) {
                if (val instanceof Boolean) {
                    val = (boolean)((Boolean)val);
                } else if (val instanceof Integer) {
                    val = (int)((Integer)val);
                } else {
                    LOGGER.trace("TableHeaderTheme param {} has unexpected type {}", (Object)key, (Object)val.getClass().getSimpleName());
                }
            }
            tcopy.themeProps_.put(key, val);
        }
        return tcopy;
    }

    public static enum TParamKey {
        LEFT_UNSELECTED_BORDER_COLOR,
        LEFT_PRESSED_UNSELECTED_BORDER_COLOR,
        LEFT_SELECTED_BORDER_COLOR,
        RIGHT_UNSELECTED_BORDER_COLOR,
        RIGHT_SELECTED_BORDER_COLOR,
        BOTTOM_BORDER_COLOR,
        UNSELECTED_TOP_COLOR,
        UNSELECTED_BOTTOM_COLOR,
        SELECTED_TOP_COLOR,
        SELECTED_BOTTOM_COLOR,
        PRESSED_UNSELECTED_TOP_COLOR,
        PRESSED_UNSELECTED_BOTTOM_COLOR,
        PRESSED_SELECTED_TOP_COLOR,
        PRESSED_SELECTED_BOTTOM_COLOR,
        TOP_BOTTOM_PADDING,
        UNSELECTED_FOREGROUND_COLOR,
        FONT_STYLE,
        FONT_EMPHASIZED;

    }
}

