/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.multipdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.io.RandomAccessStreamCache;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.PDStructureElementNameTreeNode;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.PDNumberTreeNode;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDParentTreeValue;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationPopup;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;

public class Splitter {
    private static final Log LOG = LogFactory.getLog(Splitter.class);
    private PDDocument sourceDocument;
    private PDDocument currentDestinationDocument;
    private int splitLength = 1;
    private int startPage = Integer.MIN_VALUE;
    private int endPage = Integer.MAX_VALUE;
    private List<PDDocument> destinationDocuments;
    private Map<COSDictionary, COSDictionary> pageDictMap;
    private Map<COSDictionary, COSDictionary> structDictMap;
    private Map<COSDictionary, COSDictionary> annotDictMap;
    private Map<PDPageDestination, PDPage> destToFixMap;
    private Set<String> idSet;
    private Set<COSName> roleSet;
    private int currentPageNumber;
    private RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction = null;

    public RandomAccessStreamCache.StreamCacheCreateFunction getStreamCacheCreateFunction() {
        return this.streamCacheCreateFunction;
    }

    public void setStreamCacheCreateFunction(RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction) {
        this.streamCacheCreateFunction = streamCacheCreateFunction;
    }

    public List<PDDocument> split(PDDocument document) throws IOException {
        this.currentPageNumber = 0;
        this.destinationDocuments = new ArrayList<PDDocument>();
        this.sourceDocument = document;
        this.pageDictMap = new HashMap<COSDictionary, COSDictionary>();
        this.destToFixMap = new HashMap<PDPageDestination, PDPage>();
        this.annotDictMap = new HashMap<COSDictionary, COSDictionary>();
        this.idSet = new HashSet<String>();
        this.roleSet = new HashSet<COSName>();
        this.processPages();
        for (PDDocument destinationDocument : this.destinationDocuments) {
            this.cloneStructureTree(destinationDocument);
            this.fixDestinations(destinationDocument);
        }
        return this.destinationDocuments;
    }

    private void fixDestinations(PDDocument destinationDocument) {
        PDPageTree pageTree = destinationDocument.getPages();
        for (Map.Entry<PDPageDestination, PDPage> entry : this.destToFixMap.entrySet()) {
            PDPageDestination pageDestination = entry.getKey();
            PDPage srcPage = entry.getValue();
            if (pageTree.indexOf(srcPage) < 0) continue;
            COSDictionary srcPageDict = pageDestination.getPage().getCOSObject();
            COSDictionary dstPageDict = this.pageDictMap.get(srcPageDict);
            PDPage dstPage = new PDPage(dstPageDict);
            if (pageTree.indexOf(dstPage) >= 0) {
                pageDestination.setPage(dstPage);
                continue;
            }
            pageDestination.setPage(null);
        }
    }

    private void cloneStructureTree(PDDocument destinationDocument) throws IOException {
        PDStructureTreeRoot srcStructureTreeRoot = this.sourceDocument.getDocumentCatalog().getStructureTreeRoot();
        if (srcStructureTreeRoot == null) {
            return;
        }
        this.structDictMap = new HashMap<COSDictionary, COSDictionary>();
        PDStructureTreeRoot dstStructureTreeRoot = new PDStructureTreeRoot();
        PDPageTree dstPageTree = destinationDocument.getPages();
        COSBase k1 = srcStructureTreeRoot.getK();
        COSBase k2 = new KCloner(dstPageTree).createClone(k1, dstStructureTreeRoot.getCOSObject(), null);
        dstStructureTreeRoot.setK(k2);
        PDNumberTreeNode srcParentTree = srcStructureTreeRoot.getParentTree();
        Map<Integer, COSObjectable> srcNumberTreeAsMap = PDFMergerUtility.getNumberTreeAsMap(srcParentTree);
        LinkedHashMap<Integer, COSObjectable> dstNumberTreeAsMap = new LinkedHashMap<Integer, COSObjectable>();
        for (int p = 0; p < dstPageTree.getCount(); ++p) {
            PDPage page = dstPageTree.get(p);
            int sp1 = page.getStructParents();
            if (sp1 != -1) {
                this.cloneTreeElement(srcNumberTreeAsMap, dstNumberTreeAsMap, sp1);
            }
            for (PDAnnotation ann : page.getAnnotations()) {
                PDAppearanceStream normalAppearanceStream;
                int sp2 = ann.getStructParent();
                if (sp2 != -1) {
                    this.cloneTreeElement(srcNumberTreeAsMap, dstNumberTreeAsMap, sp2);
                }
                if ((normalAppearanceStream = ann.getNormalAppearanceStream()) == null) continue;
                this.processResources(normalAppearanceStream.getResources(), srcNumberTreeAsMap, dstNumberTreeAsMap, new HashSet<COSDictionary>());
            }
            this.processResources(page.getResources(), srcNumberTreeAsMap, dstNumberTreeAsMap, new HashSet<COSDictionary>());
        }
        PDNumberTreeNode dstNumberTreeNode = new PDNumberTreeNode(PDParentTreeValue.class);
        dstNumberTreeNode.setNumbers(dstNumberTreeAsMap);
        dstStructureTreeRoot.setParentTree(dstNumberTreeNode);
        dstStructureTreeRoot.setParentTreeNextKey(srcStructureTreeRoot.getParentTreeNextKey());
        dstStructureTreeRoot.setClassMap(srcStructureTreeRoot.getClassMap());
        this.cloneRoleMap(srcStructureTreeRoot, dstStructureTreeRoot);
        this.cloneIDTree(srcStructureTreeRoot, dstStructureTreeRoot);
        destinationDocument.getDocumentCatalog().setStructureTreeRoot(dstStructureTreeRoot);
    }

    private void cloneIDTree(PDStructureTreeRoot srcStructTree, PDStructureTreeRoot destStructTree) throws IOException {
        PDNameTreeNode<PDStructureElement> srcIDTree = srcStructTree.getIDTree();
        if (srcIDTree == null) {
            return;
        }
        Map<String, PDStructureElement> srcIDTreeAsMap = PDFMergerUtility.getIDTreeAsMap(srcIDTree);
        HashMap destNames = new HashMap();
        srcIDTreeAsMap.forEach((key, val) -> {
            if (!this.idSet.contains(key)) {
                return;
            }
            COSDictionary dstDict = this.structDictMap.get(val.getCOSObject());
            if (dstDict != null) {
                destNames.put(key, new PDStructureElement(dstDict));
            }
        });
        PDStructureElementNameTreeNode destIDTree = new PDStructureElementNameTreeNode();
        destIDTree.setNames(destNames);
        destStructTree.setIDTree(destIDTree);
    }

    private void cloneRoleMap(PDStructureTreeRoot srcStructTree, PDStructureTreeRoot destStructTree) {
        COSDictionary srcDict = srcStructTree.getCOSObject().getCOSDictionary(COSName.ROLE_MAP);
        if (srcDict == null) {
            return;
        }
        COSDictionary dstDict = new COSDictionary();
        for (Map.Entry<COSName, COSBase> entry : srcDict.entrySet()) {
            if (!this.roleSet.contains(entry.getKey())) continue;
            dstDict.setItem(entry.getKey(), entry.getValue());
        }
        destStructTree.getCOSObject().setItem(COSName.ROLE_MAP, (COSBase)dstDict);
    }

    private void cloneTreeElement(Map<Integer, COSObjectable> srcNumberTreeAsMap, Map<Integer, COSObjectable> dstNumberTreeAsMap, int sp) {
        COSObjectable srcObj = srcNumberTreeAsMap.get(sp);
        COSObjectable dstObj = null;
        if (srcObj != null) {
            COSBase actualSrcObj = srcObj.getCOSObject();
            if (actualSrcObj instanceof COSArray) {
                COSArray srcArray = (COSArray)actualSrcObj;
                COSArray dstArray = new COSArray();
                for (int i = 0; i < srcArray.size(); ++i) {
                    COSBase srcElement = srcArray.getObject(i);
                    dstArray.add(this.structDictMap.get(srcElement));
                }
                dstObj = dstArray;
            } else if (actualSrcObj instanceof COSDictionary) {
                dstObj = this.structDictMap.get(actualSrcObj);
                if (dstObj == null) {
                    LOG.warn((Object)("ParentTree index " + sp + " dictionary not found in /K"));
                }
            } else {
                LOG.warn((Object)("tree element neither dictionary nor array, but " + (actualSrcObj == null ? "(null)" : actualSrcObj.getClass().getSimpleName())));
            }
            if (dstObj != null) {
                dstNumberTreeAsMap.put(sp, dstObj);
            }
        }
    }

    private void processResources(PDResources res, Map<Integer, COSObjectable> srcNumberTreeAsMap, Map<Integer, COSObjectable> dstNumberTreeAsMap, Set<COSDictionary> visited) throws IOException {
        if (res == null) {
            return;
        }
        if (visited.contains(res.getCOSObject())) {
            return;
        }
        visited.add(res.getCOSObject());
        for (COSName name : res.getXObjectNames()) {
            PDXObject xObject = res.getXObject(name);
            int sp2 = -1;
            if (xObject instanceof PDFormXObject) {
                sp2 = ((PDFormXObject)xObject).getStructParents();
                this.processResources(((PDFormXObject)xObject).getResources(), srcNumberTreeAsMap, dstNumberTreeAsMap, visited);
            } else if (xObject instanceof PDImageXObject) {
                sp2 = ((PDImageXObject)xObject).getStructParent();
            }
            if (sp2 == -1) continue;
            this.cloneTreeElement(srcNumberTreeAsMap, dstNumberTreeAsMap, sp2);
        }
    }

    public void setSplitAtPage(int split) {
        if (split <= 0) {
            throw new IllegalArgumentException("Number of pages is smaller than one");
        }
        this.splitLength = split;
    }

    public void setStartPage(int start) {
        if (start <= 0) {
            throw new IllegalArgumentException("Start page is smaller than one");
        }
        this.startPage = start;
    }

    public void setEndPage(int end) {
        if (end <= 0) {
            throw new IllegalArgumentException("End page is smaller than one");
        }
        this.endPage = end;
    }

    private void processPages() throws IOException {
        for (PDPage page : this.sourceDocument.getPages()) {
            if (this.currentPageNumber + 1 >= this.startPage && this.currentPageNumber + 1 <= this.endPage) {
                this.processPage(page);
                ++this.currentPageNumber;
                continue;
            }
            if (this.currentPageNumber > this.endPage) break;
            ++this.currentPageNumber;
        }
    }

    private void createNewDocumentIfNecessary() throws IOException {
        if (this.splitAtPage(this.currentPageNumber) || this.currentDestinationDocument == null) {
            this.currentDestinationDocument = this.createNewDocument();
            this.destinationDocuments.add(this.currentDestinationDocument);
        }
    }

    protected boolean splitAtPage(int pageNumber) {
        return (pageNumber + 1 - Math.max(1, this.startPage)) % this.splitLength == 0;
    }

    protected PDDocument createNewDocument() throws IOException {
        PDDocument document = this.streamCacheCreateFunction != null ? new PDDocument(this.streamCacheCreateFunction) : new PDDocument();
        document.getDocument().setVersion(this.getSourceDocument().getVersion());
        PDDocumentInformation sourceDocumentInformation = this.getSourceDocument().getDocumentInformation();
        if (sourceDocumentInformation != null) {
            COSDictionary sourceDocumentInformationDictionary = sourceDocumentInformation.getCOSObject();
            COSDictionary destDocumentInformationDictionary = new COSDictionary();
            for (COSName key : sourceDocumentInformationDictionary.keySet()) {
                COSBase value = sourceDocumentInformationDictionary.getDictionaryObject(key);
                if (value instanceof COSDictionary) {
                    LOG.warn((Object)("Nested entry for key '" + key.getName() + "' skipped in document information dictionary"));
                    if (this.sourceDocument.getDocumentCatalog().getCOSObject() != this.sourceDocument.getDocumentInformation().getCOSObject()) continue;
                    LOG.warn((Object)"/Root and /Info share the same dictionary");
                    continue;
                }
                if (COSName.TYPE.equals(key)) continue;
                destDocumentInformationDictionary.setItem(key, value);
            }
            document.setDocumentInformation(new PDDocumentInformation(destDocumentInformationDictionary));
        }
        PDDocumentCatalog destCatalog = document.getDocumentCatalog();
        PDDocumentCatalog sourceCatalog = this.getSourceDocument().getDocumentCatalog();
        destCatalog.setViewerPreferences(sourceCatalog.getViewerPreferences());
        destCatalog.setLanguage(sourceCatalog.getLanguage());
        destCatalog.setMarkInfo(sourceCatalog.getMarkInfo());
        destCatalog.setMetadata(sourceCatalog.getMetadata());
        return document;
    }

    protected void processPage(PDPage page) throws IOException {
        this.createNewDocumentIfNecessary();
        PDPage imported = this.getDestinationDocument().importPage(page);
        if (page.getResources() != null && !page.getCOSObject().containsKey(COSName.RESOURCES)) {
            imported.setResources(page.getResources());
            LOG.info((Object)"Resources imported in Splitter");
        }
        if (imported.getCOSObject().containsKey(COSName.B)) {
            imported.getCOSObject().removeItem(COSName.B);
            LOG.warn((Object)"/B entry (beads) removed by splitter");
        }
        this.processAnnotations(imported);
        this.pageDictMap.put(page.getCOSObject(), imported.getCOSObject());
    }

    private void processAnnotations(PDPage imported) throws IOException {
        List<PDAnnotation> annotations = imported.getAnnotations();
        if (annotations.isEmpty()) {
            return;
        }
        ArrayList<PDAnnotation> clonedAnnotations = new ArrayList<PDAnnotation>(annotations.size());
        for (PDAnnotation annotation : annotations) {
            COSDictionary clonedDict = new COSDictionary(annotation.getCOSObject());
            PDAnnotation annotationClone = PDAnnotation.createAnnotation(clonedDict);
            this.annotDictMap.put(annotation.getCOSObject(), clonedDict);
            clonedAnnotations.add(annotationClone);
            if (annotationClone instanceof PDAnnotationLink) {
                PDPage destinationPage;
                PDAnnotationLink link = (PDAnnotationLink)annotationClone;
                PDDestination srcDestination = null;
                try {
                    srcDestination = link.getDestination();
                }
                catch (IOException ex) {
                    LOG.warn((Object)("Incorrect destination in link annotation on page " + (this.currentPageNumber + 1) + " is removed"), (Throwable)ex);
                    link.setDestination(null);
                }
                PDAction action = null;
                if (srcDestination == null && (action = link.getAction()) instanceof PDActionGoTo) {
                    PDActionGoTo goToAction = (PDActionGoTo)action;
                    try {
                        srcDestination = goToAction.getDestination();
                    }
                    catch (IOException ex) {
                        LOG.warn((Object)("GoToAction with incorrect destination in link annotation on page " + (this.currentPageNumber + 1) + " is removed"), (Throwable)ex);
                        link.setAction(null);
                    }
                }
                if (srcDestination instanceof PDNamedDestination) {
                    srcDestination = this.sourceDocument.getDocumentCatalog().findNamedDestinationPage((PDNamedDestination)srcDestination);
                }
                if (srcDestination instanceof PDPageDestination && (destinationPage = ((PDPageDestination)srcDestination).getPage()) != null) {
                    COSArray clonedDestinationArray = new COSArray(((PDPageDestination)srcDestination).getCOSObject().toList());
                    PDPageDestination dstDestination = (PDPageDestination)PDDestination.create(clonedDestinationArray);
                    this.destToFixMap.put(dstDestination, imported);
                    if (action != null) {
                        COSDictionary clonedActionDict = new COSDictionary(action.getCOSObject());
                        PDActionGoTo dstAction = (PDActionGoTo)PDActionFactory.createAction(clonedActionDict);
                        dstAction.setDestination(dstDestination);
                        link.setAction(dstAction);
                    } else {
                        link.setDestination(dstDestination);
                    }
                }
            }
            if (annotationClone instanceof PDAnnotationWidget && annotationClone.getCOSObject().containsKey(COSName.PARENT)) {
                annotationClone.getCOSObject().removeItem(COSName.PARENT);
            }
            if (annotation.getPage() == null) continue;
            annotationClone.setPage(imported);
        }
        for (PDAnnotation annotation : clonedAnnotations) {
            PDAnnotationMarkup annotationMarkup;
            if (annotation instanceof PDAnnotationMarkup) {
                PDAnnotationPopup annotationPopup = ((PDAnnotationMarkup)annotation).getPopup();
                if (annotationPopup == null) continue;
                COSDictionary clonedPopupDict = this.annotDictMap.get(annotationPopup.getCOSObject());
                if (clonedPopupDict != null) {
                    annotation.getCOSObject().setItem(COSName.POPUP, (COSBase)clonedPopupDict);
                } else {
                    clonedPopupDict = new COSDictionary(annotationPopup.getCOSObject());
                    this.annotDictMap.put(annotationPopup.getCOSObject(), clonedPopupDict);
                    PDAnnotationPopup annotationPopupClone = (PDAnnotationPopup)PDAnnotation.createAnnotation(clonedPopupDict);
                    annotationPopupClone.setParent((PDAnnotationMarkup)annotation);
                    ((PDAnnotationMarkup)annotation).setPopup(annotationPopupClone);
                    if (annotationPopupClone.getPage() != null) {
                        annotationPopupClone.setPage(imported);
                    }
                }
            }
            if (!(annotation instanceof PDAnnotationPopup) || (annotationMarkup = ((PDAnnotationPopup)annotation).getParent()) == null) continue;
            COSDictionary clonedMarkupDict = this.annotDictMap.get(annotationMarkup.getCOSObject());
            if (clonedMarkupDict != null) {
                annotation.getCOSObject().setItem(COSName.PARENT, (COSBase)clonedMarkupDict);
                continue;
            }
            clonedMarkupDict = new COSDictionary(annotationMarkup.getCOSObject());
            this.annotDictMap.put(annotationMarkup.getCOSObject(), clonedMarkupDict);
            PDAnnotationMarkup annotationMarkupClone = (PDAnnotationMarkup)PDAnnotation.createAnnotation(clonedMarkupDict);
            annotationMarkupClone.setPopup((PDAnnotationPopup)annotation);
            ((PDAnnotationPopup)annotation).setParent(annotationMarkupClone);
            if (annotationMarkupClone.getPage() == null) continue;
            annotationMarkupClone.setPage(imported);
        }
        imported.setAnnotations(clonedAnnotations);
    }

    protected final PDDocument getSourceDocument() {
        return this.sourceDocument;
    }

    protected final PDDocument getDestinationDocument() {
        return this.currentDestinationDocument;
    }

    private class KCloner {
        PDPageTree dstPageTree;

        public KCloner(PDPageTree dstPageTree) {
            this.dstPageTree = dstPageTree;
        }

        COSBase createClone(COSBase src, COSBase dstParent, COSDictionary currentPageDict) {
            if (src instanceof COSArray) {
                return this.createArrayClone(src, dstParent, currentPageDict);
            }
            if (src instanceof COSDictionary) {
                return this.createDictionaryClone(src, dstParent, currentPageDict);
            }
            return src;
        }

        private COSBase createArrayClone(COSBase src, COSBase dstParent, COSDictionary currentPageDict) {
            COSArray dst = new COSArray();
            for (COSBase base2 : (COSArray)src) {
                COSBase rc = base2 instanceof COSObject ? this.createClone(((COSObject)base2).getObject(), dstParent, currentPageDict) : this.createClone(base2, dstParent, currentPageDict);
                if (rc == null) continue;
                dst.add(rc);
            }
            return dst.size() > 0 ? dst : null;
        }

        private COSBase createDictionaryClone(COSBase src, COSBase dstParent, COSDictionary currentPageDict) {
            COSName s;
            COSDictionary srcDict = (COSDictionary)src;
            COSDictionary dstDict = (COSDictionary)Splitter.this.structDictMap.get(srcDict);
            if (dstDict != null) {
                return dstDict;
            }
            COSDictionary dstPageDict = null;
            if (srcDict.containsKey(COSName.PG)) {
                COSDictionary srcPageDict = srcDict.getCOSDictionary(COSName.PG);
                if (srcPageDict == null) {
                    return null;
                }
                dstPageDict = (COSDictionary)Splitter.this.pageDictMap.get(srcPageDict);
                if (dstPageDict == null) {
                    return null;
                }
                PDPage pDPage = new PDPage(dstPageDict);
                if (this.dstPageTree.indexOf(pDPage) == -1) {
                    return null;
                }
            }
            dstDict = new COSDictionary();
            Splitter.this.structDictMap.put(srcDict, dstDict);
            for (Map.Entry entry : srcDict.entrySet()) {
                COSName key = (COSName)entry.getKey();
                if (COSName.K.equals(key) || COSName.PG.equals(key) || COSName.P.equals(key)) continue;
                dstDict.setItem(key, (COSBase)entry.getValue());
            }
            COSName type = srcDict.getCOSName(COSName.TYPE);
            if (COSName.OBJR.equals(type)) {
                COSDictionary cOSDictionary = srcDict.getCOSDictionary(COSName.OBJ);
                COSDictionary dstObj = (COSDictionary)Splitter.this.annotDictMap.get(cOSDictionary);
                if (dstObj != null) {
                    dstDict.setItem(COSName.OBJ, (COSBase)dstObj);
                } else {
                    this.removePossibleOrphanAnnotation(cOSDictionary, srcDict, currentPageDict, dstDict);
                }
            } else {
                dstDict.setItem(COSName.P, dstParent);
            }
            dstDict.setItem(COSName.PG, (COSBase)dstPageDict);
            COSBase cOSBase = srcDict.getDictionaryObject(COSName.K);
            COSBase cloneKid = this.createClone(cOSBase, dstDict, dstPageDict != null ? dstPageDict : currentPageDict);
            if (cloneKid == null && cOSBase != null) {
                return null;
            }
            if (dstPageDict == null && cloneKid == null && currentPageDict == null) {
                return null;
            }
            dstDict.setItem(COSName.K, cloneKid);
            String id = dstDict.getString(COSName.ID);
            if (id != null) {
                Splitter.this.idSet.add(id);
            }
            if ((s = dstDict.getCOSName(COSName.S)) != null) {
                Splitter.this.roleSet.add(s);
            }
            return dstDict;
        }

        private void removePossibleOrphanAnnotation(COSDictionary srcObj, COSDictionary srcDict, COSDictionary currentPageDict, COSDictionary dstDict) {
            COSBase objType = srcObj.getDictionaryObject(COSName.TYPE);
            COSBase objSubtype = srcObj.getDictionaryObject(COSName.SUBTYPE);
            if (COSName.ANNOT.equals(objType) || COSName.LINK.equals(objSubtype)) {
                COSArray annotationArray;
                COSDictionary srcPageDict = srcDict.getCOSDictionary(COSName.PG);
                if (srcPageDict == null) {
                    srcPageDict = currentPageDict;
                }
                if (srcPageDict != null && ((annotationArray = srcPageDict.getCOSArray(COSName.ANNOTS)) == null || annotationArray.indexOfObject(srcObj) == -1)) {
                    LOG.warn((Object)"An annotation OBJ that isn't in the page has been removed from the structure tree");
                    dstDict.removeItem(COSName.OBJ);
                }
            }
        }
    }
}

