/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.ui;

import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcTransferableVariable;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.ui.DragGhost;
import gov.nasa.giss.ui.treetable.TreeTable;
import gov.nasa.giss.ui.treetable.TreeTableCellRenderer;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import javax.swing.BorderFactory;

public class NcDataTreeTableDragGestureListener
extends DragSourceAdapter
implements DragGestureListener {
    private final TreeTable jtt_;

    public NcDataTreeTableDragGestureListener(TreeTable jtt) {
        this.jtt_ = jtt;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        NcDataNode node = (NcDataNode)this.jtt_.getSelectedNode();
        if (!(node instanceof NcVariable)) {
            return;
        }
        NcVariable ncvar = (NcVariable)node;
        if (!ncvar.isGriddable()) {
            return;
        }
        int row = this.jtt_.getRowForNode(node);
        TreeTableCellRenderer ttcr = (TreeTableCellRenderer)this.jtt_.getCellRenderer(row, 0).getTableCellRendererComponent(this.jtt_, node, false, false, row, 0);
        ttcr.setBorder(BorderFactory.createEmptyBorder());
        ttcr.setSize(ttcr.getPreferredSize());
        ttcr.setLeftShift(ttcr.getIconX(this.jtt_, node, null));
        dge.startDrag(DragSource.DefaultCopyDrop, new DragGhost(ttcr), new Point(5, 5), new NcTransferableVariable(ncvar), this);
    }
}

