/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.ContourLevel;
import gov.nasa.giss.data.ContourLevels;
import gov.nasa.giss.map.LonLatEdges;
import gov.nasa.giss.map.kml.KMLData;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.panoply.data.PanDataLonLatGridded;
import gov.nasa.giss.panoply.plot.PanLLPlotColorContourInsert;
import gov.nasa.giss.panoply.plot.PanLLPlotMapInsert;
import gov.nasa.giss.panoply.plot.PanLLPlotTrajectoryInsert;
import gov.nasa.giss.panoply.plot.PanPlot2D;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotPiece;
import gov.nasa.giss.panoply.plot.PanPlotScaleMeta;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanContourLocation;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanResourceUtils;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatPlot
extends PanPlot2D {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanLLPlotMapInsert map_;
    private boolean alphaKnockout_;

    public PanLonLatPlot(PanPlotMeta pmeta) {
        super(pmeta);
        this.map_ = this.pmeta_.getType() == PanPlotType.LON_LAT ? new PanLLPlotColorContourInsert(this.pmeta_) : new PanLLPlotTrajectoryInsert(this.pmeta_);
        this.attach(this.map_);
        this.placeMap();
        this.parameterChangedPrivate("all");
    }

    public boolean isZoomableMap() {
        return this.pmeta_.getProjectionMeta().isZoomable();
    }

    public LonLatEdges getLonLatEdges() {
        return this.map_.getLonLatEdges();
    }

    public BufferedImage drawKmlIconImage(boolean knockout, boolean borderVis) {
        boolean knockoutNow = knockout || this.alphaKnockout_;
        this.needsDataRedraw_ = true;
        this.refreshMap(knockoutNow);
        BufferedImage img = this.map_.drawKmlIconImage(knockoutNow, borderVis);
        this.needsDataRedraw_ = true;
        this.refreshMap(this.alphaKnockout_);
        return img;
    }

    private void placeMap() {
        Rectangle mfBounds = this.pmeta_.getLayout().getRect("bounds.figure");
        Dimension gridSize = this.pmeta_.getLayout().getDimension("size.gridding");
        int mw = (mfBounds.width - gridSize.width) / 2;
        int mh = (mfBounds.height - gridSize.height) / 2;
        int xshift = 0;
        if (mw > mh && mw > 2) {
            xshift = mw - mh;
            mw = mh;
        }
        this.map_.setLocation(mfBounds.x + xshift, mfBounds.y);
        this.map_.setSize(mfBounds.width - 2 * xshift, mfBounds.height);
        this.map_.setMargins(mw, mh, mw, mh);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.placeMap();
    }

    @Override
    protected void prepareToPaint() {
        super.prepareToPaint();
        this.refreshMap(this.alphaKnockout_);
        this.colorbar_.setVisible(this.pmeta_.getBoolean("include.colorbar"));
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
    }

    private void refreshMap(boolean knockout) {
        if (!(this.data_ instanceof PanDataLonLatGridded)) {
            return;
        }
        if (this.needsDataRedraw_) {
            this.paintDataImage(knockout);
            this.map_.setDataImage(this.dataImage_);
            this.needsRecontour_ = true;
        }
        if (this.map_ instanceof PanLLPlotColorContourInsert) {
            ContourLevels levels = null;
            if (this.needsRecontour_ && this.contourWeight_ > 0) {
                PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
                double[] tvalues = smeta.getContourTickValues();
                this.contours_.setLevelValues(tvalues);
                levels = this.contours_.getLevels();
                if (PanContourLocation.MINOR.matches(this.pmeta_.getString("contour.location"))) {
                    double[] mvalues = smeta.getMajorTickValues();
                    block0: for (ContourLevel level : levels) {
                        double value = level.getValue();
                        level.setLabeled(false);
                        for (int i = 0; i < mvalues.length; ++i) {
                            if (value != mvalues[i]) continue;
                            level.setLabeled(true);
                            continue block0;
                        }
                    }
                }
                ((PanLLPlotColorContourInsert)this.map_).setContours(levels);
            }
            this.needsRecontour_ = false;
        }
    }

    public PointLL transformXY2LL(int x, int y) {
        return this.map_.transformXY2LL((double)(x - this.map_.getLocation().x) + 0.5, (double)(y - this.map_.getLocation().y) + 0.5);
    }

    @Override
    public Point2D.Double transformXY2GridCoords(double x, double y) {
        PointLL ll = this.map_.transformXY2LL(x - (double)this.map_.getLocation().x, y - (double)this.map_.getLocation().y);
        if (ll == null) {
            return null;
        }
        return new Point2D.Double(ll.getLon(), ll.getLat());
    }

    @Override
    public String describePoint(int x, int y) {
        PointLL ll = this.transformXY2LL(x, y);
        if (ll == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (this.map_ instanceof PanLLPlotColorContourInsert) {
            ((PanDataLonLatGridded)this.data_).describeDataAt(sb, ll);
        }
        return sb.toString();
    }

    public PanPlotPiece getKmzColorbar() {
        Rectangle cbarRect = this.pmeta_.getLayout().getRect("bounds.colorbar");
        this.colorbar_.setSize(cbarRect.width, cbarRect.height);
        return this.colorbar_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PanLonLatPlot panLonLatPlot = this;
        synchronized (panLonLatPlot) {
            if (this.map_ != null) {
                this.map_ = null;
            }
            super.flush();
        }
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private void parameterChangedPrivate(String pname) {
        PanPreferences prefs;
        boolean changeAll;
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("interpolate") || pname.contains("scale.method")) {
            this.needsDataRedraw_ = true;
        }
        if (changeAll || pname.contains("proj.name") || pname.contains("proj.lon0") || pname.contains("proj.lat0") || pname.contains("proj.xparam") || pname.contains("scale.method")) {
            this.needsDataRedraw_ = true;
            this.needsRecontour_ = true;
        }
        if ((prefs = PanPreferences.getSharedInstance()).getBoolean("beta:underlays") && (changeAll || pname.contains("beta.alpha.enabled") || pname.contains("beta.alpha.method") || pname.contains("beta.alpha.lavel.1") || pname.contains("beta.alpha.lavel.2") || pname.contains("beta.alpha.knockout") || pname.contains("beta.alpha.underlay"))) {
            boolean alphaEnabled = this.pmeta_.getBoolean("beta.alpha.enabled");
            String uname = this.pmeta_.getString("beta.alpha.underlay");
            KMLData oo = PanResourceUtils.getUnderlay(uname);
            this.alphaKnockout_ = alphaEnabled && oo != null && this.pmeta_.getBoolean("beta.alpha.knockout");
            this.needsDataRedraw_ = true;
        }
    }
}

