/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanDataLonLat;
import gov.nasa.giss.panoply.plot.PanPlotLabel;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.util.PanStringUtils;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.lang.invoke.MethodHandles;
import java.text.AttributedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanMinMaxNote
extends PanPlotLabel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanData data_;
    private PrintfFormat formatter_;
    private String formatString_;
    private boolean super10_;

    public PanMinMaxNote(PanPlotMeta pmeta, PanData data) {
        super(pmeta);
        this.data_ = data;
        this.setHorizontalAlignment(PanPlotLabel.HAlignment.CENTER);
        this.setOpaque(false);
        this.parameterChangedPrivate("all");
    }

    @Override
    protected void prepareToPaint() {
        double mean;
        double min = this.pmeta_.getScaleMeta().getDataMinimum();
        double max = this.pmeta_.getScaleMeta().getDataMaximum();
        String minStr = "Data Min = " + this.formatter_.sprintfx(min);
        String maxStr = ", Max = " + this.formatter_.sprintfx(max);
        String meanStr = null;
        if (this.data_ instanceof PanDataLonLat && !Double.isNaN(mean = ((PanDataLonLat)((Object)this.data_)).getGlobalMean())) {
            meanStr = ", Mean = " + this.formatter_.sprintfx(mean);
        }
        if (meanStr == null) {
            this.setText(minStr + maxStr);
        } else {
            this.setText(minStr + maxStr + meanStr);
        }
        Font font = this.getFont();
        if (this.super10_) {
            this.attribText_ = StringUtils.concatenate(PanStringUtils.convertENotationToSuperscript(minStr, font), PanStringUtils.convertENotationToSuperscript(maxStr, font));
            if (meanStr != null) {
                this.attribText_ = StringUtils.concatenate(this.attribText_, PanStringUtils.convertENotationToSuperscript(meanStr, font));
            }
        } else {
            StringBuilder sb = new StringBuilder(minStr).append(maxStr);
            if (meanStr != null) {
                sb.append(meanStr);
            }
            this.attribText_ = new AttributedString(sb.toString());
        }
        this.attribText_.addAttribute(TextAttribute.FAMILY, font.getFontName());
        this.attribText_.addAttribute(TextAttribute.SIZE, Float.valueOf(font.getSize2D()));
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private void parameterChangedPrivate(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("footnote.minmax.format") || pname.contains("scale.tick.format")) {
            String s = this.pmeta_.getString("footnote.minmax.format");
            if (s == null || s.isEmpty() || s.toLowerCase().startsWith("same")) {
                s = this.pmeta_.getString("scale.tick.format");
            }
            if (s == null) {
                LOGGER.warn("Property {} has null value. Using '%.2f'", (Object)"scale.tick.format");
                s = "%.2f";
            }
            this.formatString_ = s;
            this.formatter_ = new PrintfFormat(this.formatString_);
        }
        if (changeAll || pname.contains("labels.super10")) {
            this.super10_ = this.pmeta_.getBoolean("labels.super10");
        }
    }
}

