/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.map.ProjectionFactory;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.EquirectangularRegional;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanGridLabelStepComboBox;
import gov.nasa.giss.panoply.ui.PanLLGridSpacingComboBox;
import gov.nasa.giss.panoply.ui.PanLinkButton;
import gov.nasa.giss.ui.FloatComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatGridPrefsPanel
extends PanAbstractPrefsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanLLGridSpacingComboBox gridLonSpacingCombo_;
    private PanLLGridSpacingComboBox gridLatSpacingCombo_;
    private PanCheckBox gridLatOffsetCB_;
    private PanCheckBox gridLonPrunedCB_;
    private PanLinkButton linkBtn_;
    private boolean linkedSpacing_;
    private PanGridLabelStepComboBox gridLabelStepCombo_;
    private JLabel gridLabelSizeLabel_;
    private FloatComboBox gridLabelSizeCombo_;
    private boolean refreshing_;

    public PanLonLatGridPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        JLabel topText = new JLabel("When creating a map plot, set\u2026");
        this.setOpaque(false);
        JLabel spacingLabel = new JLabel("Spacing:\u2009");
        this.gridLonSpacingCombo_ = PanLLGridSpacingComboBox.create(null);
        this.gridLatSpacingCombo_ = PanLLGridSpacingComboBox.create(null);
        this.linkedSpacing_ = this.gridLonSpacingCombo_.getSpacing() == this.gridLatSpacingCombo_.getSpacing();
        this.linkBtn_ = new PanLinkButton(null);
        this.linkBtn_.setButtonSize(16);
        this.gridLatOffsetCB_ = PanCheckBox.create("Offset parallels from Equator");
        this.gridLonPrunedCB_ = PanCheckBox.create("Prune meridians near poles");
        this.gridLabelStepCombo_ = PanGridLabelStepComboBox.create(null);
        this.gridLabelSizeLabel_ = new JLabel("\u2014 Size:\u2009");
        this.gridLabelSizeCombo_ = FloatComboBox.create(5.0f, 12.0f);
        JLabel bottomText1 = new JLabel("Grid labels are only available for cylindric and pseudocylindric projections.");
        GuiUtils.setSizeSmall(bottomText1);
        this.gridLonSpacingCombo_.setMaximumSize(this.gridLonSpacingCombo_.getPreferredSize());
        this.gridLatSpacingCombo_.setMaximumSize(this.gridLatSpacingCombo_.getPreferredSize());
        FlexingGridLayout fgl = new FlexingGridLayout(3, 8, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(GuiUtils.createPaddedTitleBorder("Lon-Lat Map Plot Grid"));
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 3, 1));
        ++row;
        this.add((Component)new JLabel("Grid Lines:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(spacingLabel, this.gridLonSpacingCombo_, new JLabel("E-W\u2009\u00d7"), this.gridLatSpacingCombo_, new JLabel("N-S  "), this.linkBtn_), new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(this.gridLatOffsetCB_), new FGConstraint(1, ++row));
        this.add((Component)QuickBox.createLeftBox(this.gridLonPrunedCB_), new FGConstraint(1, ++row));
        this.add((Component)new JLabel("Grid Labels:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.gridLabelStepCombo_, this.gridLabelSizeLabel_, this.gridLabelSizeCombo_), new FGConstraint(1, row));
        this.add((Component)bottomText1, new FGConstraint(1, ++row));
        this.invalidate();
    }

    private void attachListeners() {
        this.gridLonSpacingCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            float spacing = this.gridLonSpacingCombo_.getSpacing();
            prefs_.setFloat("plot:grid.spacing.lon", spacing);
            if (this.linkedSpacing_) {
                this.gridLatSpacingCombo_.setSpacing(spacing);
            }
        });
        this.gridLatSpacingCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            float spacing = this.gridLatSpacingCombo_.getSpacing();
            prefs_.setFloat("plot:grid.spacing.lat", spacing);
            if (this.linkedSpacing_) {
                this.gridLonSpacingCombo_.setSpacing(spacing);
            }
        });
        this.linkBtn_.addActionListener(e -> {
            this.linkedSpacing_ = !this.linkedSpacing_;
            this.linkBtn_.setLinked(this.linkedSpacing_);
            if (this.linkedSpacing_) {
                float spacing = this.gridLonSpacingCombo_.getSpacing();
                this.gridLatSpacingCombo_.setSpacing(spacing);
            }
        });
        this.gridLatOffsetCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:grid.offset.lat", e.getStateChange() == 1);
        });
        this.gridLonPrunedCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:grid.lon.pruned", e.getStateChange() == 1);
        });
        this.gridLabelStepCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:grid.label.step", this.gridLabelStepCombo_.getStep());
        });
        this.gridLabelSizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.setFloat("plot:grid.label.size", this.gridLabelSizeCombo_.getValue());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.gridLonSpacingCombo_.setSpacing(prefs_.getFloat("plot:grid.spacing.lon"));
        this.gridLatSpacingCombo_.setSpacing(prefs_.getFloat("plot:grid.spacing.lat"));
        this.gridLatOffsetCB_.setSelected(prefs_.getBoolean("plot:grid.offset.lat"));
        this.gridLonPrunedCB_.setSelected(prefs_.getBoolean("plot:grid.lon.pruned"));
        this.linkedSpacing_ = this.gridLonSpacingCombo_.getSpacing() == this.gridLatSpacingCombo_.getSpacing();
        this.linkBtn_.setLinked(this.linkedSpacing_);
        this.gridLabelSizeCombo_.setValue(prefs_.getFloat("plot:grid.label.size"));
        this.gridLabelStepCombo_.setStep(prefs_.getInt("plot:grid.label.step"));
        String projname = prefs_.getString("plot:proj.name");
        AbstractProjection proj = projname.equals("Equirectangular Regional") ? new EquirectangularRegional(20, 10) : ProjectionFactory.create(projname, 20, 10);
        boolean projCanLabel = proj.canLabelGrid();
        this.gridLabelStepCombo_.setEnabled(projCanLabel);
        this.gridLabelSizeLabel_.setEnabled(projCanLabel);
        this.gridLabelSizeCombo_.setEnabled(projCanLabel);
        this.gridLonPrunedCB_.setEnabled(proj.canPruneMeridians());
        this.refreshing_ = false;
    }
}

