/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.task;

import gov.nasa.giss.panoply.log.PanLoggingFrame;
import gov.nasa.giss.ui.SlowMessage;
import gov.nasa.giss.util.task.Task;
import java.awt.Component;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanSaveLogFileTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanLoggingFrame parent_;
    private final File file_;
    private String errMsg_;

    public PanSaveLogFileTask(PanLoggingFrame parent, File file) {
        super("Exporting logging file");
        this.parent_ = parent;
        this.file_ = file;
    }

    @Override
    protected Object beginTask() {
        block2: {
            try {
                this.parent_.writeLog(this.file_);
            }
            catch (Exception exc) {
                this.errMsg_ = exc.getMessage();
                LOGGER.error("Could not write log messages to text file.");
                LOGGER.error(exc.toString());
                if (!LOGGER.isTraceEnabled()) break block2;
                exc.printStackTrace();
            }
        }
        return null;
    }

    @Override
    protected void finishTask() {
        if (this.errMsg_ != null) {
            SlowMessage.show((Component)this.parent_, "Output Error", new StringBuilder("There was an error writing out the log messages: ").append(this.errMsg_));
        }
    }
}

