/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.task;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.prefsui.PanPreferencesFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.util.EasyXmlParser;
import gov.nasa.giss.util.task.Task;
import java.awt.EventQueue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.JDOMParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanVersionCheckTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int NEXT_DAYS_GOOD = 21;
    private static final int NEXT_DAYS_BAD = 11;
    private static final int MIN_LAUNCHES = 12;
    private static final DateTimeFormatter DFORMAT_8 = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter DFORMAT_10 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final PanPreferences PREFS = PanPreferences.getSharedInstance();
    private static String webVersion_;
    private static String webBuild_;
    private static String webDate_;
    private static String webAddress_;
    private static String errMsg_;
    private boolean reportNegative_;
    private boolean allowSkip_;
    private static boolean updateAvailable_;

    public PanVersionCheckTask(boolean reportNegative, boolean allowSkip) {
        super("Checking for new Panoply version");
        this.reportNegative_ = reportNegative;
        this.allowSkip_ = allowSkip;
    }

    @Override
    protected Object beginTask() {
        String address = PanProperties.VERSION_PROPS.getString("version-url");
        boolean success = PanVersionCheckTask.loadWebInfo(address, 0);
        LOGGER.trace("loadWebInfo? {}", (Object)success, (Object)0);
        if (success) {
            this.compareBuilds();
        }
        return null;
    }

    @Override
    protected void finishTask() {
        if (errMsg_ != null) {
            PanVersionCheckTask.updatePrefs(11);
            if (this.reportNegative_) {
                PanVersionCheckTask.showMessage("I was unable to obtain current Panoply version info. " + errMsg_);
            }
        } else if (updateAvailable_) {
            PanVersionCheckTask.showUpdateMessage();
        } else {
            PanVersionCheckTask.updatePrefs(21);
            if (this.reportNegative_) {
                PanVersionCheckTask.showMessage("This copy of Panoply is up to date.");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized boolean loadWebInfo(String address, int attempt) {
        block21: {
            errMsg_ = null;
            updateAvailable_ = false;
            Objects.requireNonNull(address, "XML address must not be null");
            if (attempt > 5) {
                errMsg_ = "Receive too many redirects trying to load version info.";
                LOGGER.warn("Too many re-directs. Aborting test.");
                return false;
            }
            LOGGER.trace("Trying to load {}", (Object)address);
            try {
                URL url = new URL(address);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(3000);
                conn.setReadTimeout(4000);
                conn.setRequestProperty("User-Agent", System.getProperty("http.agent"));
                int responseCode = 0;
                String moved = "";
                Map<String, List<String>> map = conn.getHeaderFields();
                Set<Map.Entry<String, List<String>>> eset = map.entrySet();
                for (Map.Entry<String, List<String>> entry : eset) {
                    String sval;
                    String key = entry.getKey();
                    List<String> val = entry.getValue();
                    String string = sval = val == null ? "" : val.toString();
                    if (key == null && sval.contains("HTTP/1.")) {
                        String codeStr = sval.replaceFirst("^.*HTTP/\\d\\.\\d ", "");
                        codeStr = codeStr.replaceFirst(" .*", "");
                        responseCode = Integer.parseInt(codeStr);
                        continue;
                    }
                    if (!"Location".equals(key) || sval.length() <= 2) continue;
                    moved = sval.substring(1, sval.length() - 1);
                }
                switch (responseCode) {
                    case 0: {
                        errMsg_ = "No HTTP response was received when checking for new version info. This may be due to a connectivity problem.";
                        LOGGER.trace("No HTTP response. Status 0.");
                        return false;
                    }
                    case 200: {
                        break;
                    }
                    case 301: 
                    case 302: {
                        LOGGER.trace("Version file has apparently 301/302 MOVED to '{}'.", (Object)moved);
                        return PanVersionCheckTask.loadWebInfo(moved, attempt + 1);
                    }
                    case 403: {
                        errMsg_ = "Received a permission-denied response when checking for new version info.";
                        LOGGER.trace("Version file DENIED due to permissions.");
                        return false;
                    }
                    case 404: {
                        errMsg_ = "Received a file-not-found response when checking for new version info.";
                        LOGGER.trace("Version file NOT FOUND at '{}'.", (Object)address);
                        return false;
                    }
                    default: {
                        errMsg_ = "Received an unexpected response when checking for new version info (" + responseCode + ").";
                        LOGGER.trace("Unexpected HTTP response, status '{}'.", (Object)responseCode);
                        return false;
                    }
                }
                if (conn.getContentLength() < 1) {
                    errMsg_ = "Received an empty response when checking for new version info.";
                    LOGGER.warn("No content returned.");
                    return false;
                }
                Object content = conn.getContent();
                if (content == null) {
                    errMsg_ = "Received an empty response when checking for new version info.";
                    LOGGER.debug("Content is null");
                    return false;
                }
                if (content instanceof InputStream) {
                    return PanVersionCheckTask.parse((InputStream)content);
                }
                if (!(content instanceof String)) {
                    // empty if block
                }
            }
            catch (ConnectException exc) {
                errMsg_ = "Server apparently denied connection when checking for new version info.";
                LOGGER.warn("Server apparently denied connection: ConnectException");
            }
            catch (SocketTimeoutException exc) {
                errMsg_ = "Connection timed out when checking for new version info.";
                LOGGER.warn("Connection timed out.");
            }
            catch (FileNotFoundException exc) {
                errMsg_ = "Received a file-not-found response when checking for new version info.";
                LOGGER.warn("Version file not found on server.");
            }
            catch (JDOMParseException exc) {
                errMsg_ = "Could not parse new version info.";
                LOGGER.warn("Received version info but could not parse it.");
            }
            catch (Exception exc) {
                errMsg_ = "Received an unexpected response when checking for new version info (" + exc.getClass().getSimpleName() + ").";
                LOGGER.warn("Failed. Exception reported: {}", (Object)exc.getClass().getSimpleName());
                if (!LOGGER.isTraceEnabled()) break block21;
                exc.printStackTrace();
            }
        }
        if (errMsg_ == null) {
            errMsg_ = "Somehow failed when checking for new version info.";
        }
        return false;
    }

    private static synchronized boolean parse(InputStream is) throws IOException, JDOMException {
        Document document = EasyXmlParser.parseDocument(is);
        Element root = document.getRootElement();
        if (!"versioninfo".equals(root.getName())) {
            errMsg_ = "Received invalid XML data when checking for new version info.";
            LOGGER.warn("File root element is not 'versioninfo'.");
            return false;
        }
        webVersion_ = null;
        webBuild_ = null;
        webDate_ = null;
        webAddress_ = null;
        for (Element child : root.getChildren()) {
            Attribute aa;
            String childName = child.getName();
            if ("version".equals(childName)) {
                aa = child.getAttribute("value");
                if (aa == null) continue;
                webVersion_ = aa.getValue();
                LOGGER.trace("webVersion {}", (Object)webVersion_);
                continue;
            }
            if ("build".equals(childName)) {
                aa = child.getAttribute("value");
                if (aa == null) continue;
                webBuild_ = aa.getValue();
                LOGGER.trace("webBuild {}", (Object)webBuild_);
                continue;
            }
            if ("date".equals(childName)) {
                aa = child.getAttribute("value");
                if (aa == null) continue;
                webDate_ = aa.getValue();
                LOGGER.trace("webDate {}", (Object)webDate_);
                continue;
            }
            if (!"address".equals(childName) || (aa = child.getAttribute("value")) == null) continue;
            webAddress_ = aa.getValue();
        }
        return true;
    }

    private synchronized void compareBuilds() {
        LOGGER.trace("webBuild {}", (Object)webBuild_);
        if (webBuild_ == null) {
            LOGGER.trace("webBuild is null.");
            PanVersionCheckTask.updatePrefs(11);
            errMsg_ = "Received invalid XML data when checking for new version info.";
            return;
        }
        String thisBuild = PanProperties.VERSION_PROPS.getString("build-id");
        updateAvailable_ = false;
        if (webBuild_.length() > thisBuild.length() || thisBuild.compareToIgnoreCase(webBuild_) < 0) {
            String skipBuld = PREFS.getString("app:version.skip");
            LOGGER.trace("Build on website is newer: {} > {}", (Object)webBuild_, (Object)thisBuild);
            LOGGER.trace("Skip? {}, {}, {}", this.allowSkip_, webBuild_, skipBuld);
            if (this.allowSkip_ && webBuild_.equalsIgnoreCase(skipBuld)) {
                LOGGER.trace("Previously opted to skip this particular update");
            } else {
                updateAvailable_ = true;
            }
        } else if (thisBuild.equals(webBuild_)) {
            LOGGER.trace("Build on website is same: {}", (Object)webBuild_);
        } else {
            LOGGER.trace("Build on website is older ({})? Apparently you're using a beta ({}).", (Object)webBuild_, (Object)thisBuild);
        }
    }

    private static void updatePrefs(int nextOffset) {
        PREFS.set("app:version.last", PanVersionCheckTask.getDayString(0));
        PREFS.set("app:version.next", PanVersionCheckTask.getDayString(nextOffset));
        if (PanPreferencesFrame.instanceExists()) {
            PanPreferencesFrame.getSharedInstance().refresh();
        }
    }

    private static String getDayString(int offset) {
        LocalDate offsetLDT = LocalDate.now().plusDays(offset);
        return DFORMAT_10.format(offsetLDT);
    }

    private static void showUpdateMessage() {
        EventQueue.invokeLater(PanVersionCheckTask::lambda$showUpdateMessage$0);
    }

    public static void showMessage(String message) {
        EventQueue.invokeLater(() -> {
            JFrame jf = GuiUtils.getActiveFrame();
            if (jf == null) {
                LOGGER.debug("Active window is null.");
                return;
            }
            JOptionPane.showMessageDialog(jf, message, "Check for Updates", 2);
        });
    }

    public static boolean isTimeForCheck() {
        LocalDate nextDate;
        block9: {
            if (!PREFS.getBoolean("app:version.enabled")) {
                LOGGER.trace("Automated version checks are disabled");
                return false;
            }
            int icount = PREFS.getInt("app:version.count");
            if (icount < 12) {
                LOGGER.trace("Less than {} launches since last check ({}). No need to check for update.", (Object)12, (Object)icount);
                PREFS.setInt("app:version.count", icount + 1);
                return false;
            }
            PREFS.setInt("app:version.count", 0);
            String nextStr = PREFS.getString("app:version.next");
            nextDate = LocalDate.now();
            try {
                if (nextStr.length() == 8) {
                    nextDate = LocalDate.parse(nextStr, DFORMAT_8);
                } else if (nextStr.length() == 10) {
                    nextDate = LocalDate.parse(nextStr, DFORMAT_10);
                } else {
                    LOGGER.debug("Date string has unexpected character count!");
                }
            }
            catch (Exception exc) {
                LOGGER.debug("Error parsing date string '{}'", (Object)nextStr);
                if (!LOGGER.isTraceEnabled()) break block9;
                exc.printStackTrace();
            }
        }
        if (nextDate == null) {
            LOGGER.trace("Next version check date is null.");
            return false;
        }
        LocalDate today = LocalDate.now();
        long diffDays = ChronoUnit.DAYS.between(nextDate, today);
        LOGGER.trace("Diff days {} -- Time to check: {}", (Object)diffDays, (Object)(diffDays > 0L ? 1 : 0));
        return diffDays >= 0L;
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$showUpdateMessage$0() {
        jf = GuiUtils.getActiveFrame();
        if (jf == null) {
            PanVersionCheckTask.LOGGER.debug("Active window is null.");
            return;
        }
        options = new String[]{"Get Update", "Later"};
        msg = "Version " + PanVersionCheckTask.webVersion_ + " of Panoply is now available. " + "Would you like to\n" + "download it from the NASA/GISS website?";
        choice = JOptionPane.showOptionDialog(jf, msg, "Update Available", 0, 3, null, options, options[0]);
        if (choice == 0) {
            try {
                FileUtils.openBrowserURL(PanVersionCheckTask.webAddress_);
                PanVersionCheckTask.updatePrefs(21);
                return;
            }
            catch (Exception exc) {
                PanVersionCheckTask.LOGGER.error("Could not open URL due to exception: {}", (Object)exc.getClass().getSimpleName());
                if (!PanVersionCheckTask.LOGGER.isTraceEnabled()) ** GOTO lbl20
                exc.printStackTrace();
            }
        } else if (choice == 1) {
            // empty if block
        }
lbl20:
        // 5 sources

        PanVersionCheckTask.updatePrefs(11);
    }
}

