/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.data.nc.NcConfig;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.panoply.authentication.PanCredentialsProvider;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.util.PlatformUtils;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanNcUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static synchronized void initNetcdf(Hashtable<Key, Object> opts) {
        PanPreferences prefs;
        boolean isDesktop;
        block13: {
            LOGGER.trace("");
            if (opts.containsKey((Object)Key.DEVO_MODE) && ((Boolean)opts.get((Object)Key.DEVO_MODE)).booleanValue()) {
                LOGGER.trace("Set NcConfig devo");
                NcConfig.setDevo();
            }
            NcConfig.disableRemotePreload();
            boolean serverMode = opts.containsKey((Object)Key.SERVER_MODE) && (Boolean)opts.get((Object)Key.SERVER_MODE) != false;
            boolean headless = opts.containsKey((Object)Key.HEADLESS) && (Boolean)opts.get((Object)Key.HEADLESS) != false || PlatformUtils.isHeadless();
            isDesktop = !serverMode && !headless;
            PanCredentialsProvider pam = isDesktop ? new PanCredentialsProvider() : null;
            NcConfig.initHttpClient(System.getProperty("http.agent"), pam);
            try {
                NcConfig.initCache("Panoply", "gov.nasa.giss");
            }
            catch (Exception exc) {
                LOGGER.warn("Unable to access cache directory.");
                LOGGER.debug("This could be because your process does not have write access to disk.");
            }
            prefs = PanPreferences.getSharedInstance();
            boolean loadNjConfig = false;
            loadNjConfig = opts.containsKey((Object)Key.LOAD_NJCONFIG) ? ((Boolean)opts.get((Object)Key.LOAD_NJCONFIG)).booleanValue() : prefs.getBoolean("files:load.njconfig");
            if (loadNjConfig) {
                try {
                    if (NcConfig.readNj22Config()) {
                        LOGGER.info("Successfully read nj22config file");
                    } else {
                        LOGGER.info("Could not read nj22config file; possibly it doesn't exist");
                    }
                }
                catch (Exception exc) {
                    LOGGER.warn("Unable to read nj22config file: {}", (Object)exc.getMessage());
                }
            }
            try {
                boolean success = NcConfig.isCLibraryPresent();
                LOGGER.trace("netCDF-C lib available? {}", (Object)success);
            }
            catch (Error err) {
                LOGGER.warn("Err testing for netCDF-C presence, {}", (Object)err.getMessage());
                if (!LOGGER.isTraceEnabled()) break block13;
                err.printStackTrace();
            }
        }
        boolean gribStrict = true;
        gribStrict = opts.containsKey((Object)Key.GRIB1_STRICT) ? ((Boolean)opts.get((Object)Key.GRIB1_STRICT)).booleanValue() : prefs.getBoolean("files:grib.strict");
        try {
            NcConfig.initGribHandling(gribStrict);
        }
        catch (Exception exc) {
            LOGGER.warn("Unable to initialize GRIB handling.");
            LOGGER.debug("There could be errors if you are working with GRIB data and your");
            LOGGER.debug("process does not have write access to disk.");
        }
        if (isDesktop) {
            PanNcUtils.updateAltUnits();
        }
    }

    public static void updateAltUnits() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        NcUnitUtils.setAltEnabled(true);
        if (prefs.getBoolean("units:c_is_celsius")) {
            NcUnitUtils.addAlternative("C", "celsius");
        } else {
            NcUnitUtils.removeAlternative("C");
        }
        if (prefs.getBoolean("units:mb_is_millibar")) {
            NcUnitUtils.addAlternative("mb", "millibar");
        } else {
            NcUnitUtils.removeAlternative("mb");
        }
        if (prefs.getBoolean("units:fraction_is_percent")) {
            NcUnitUtils.addAlternative("fraction", "percent");
        } else {
            NcUnitUtils.removeAlternative("fraction");
        }
    }

    private PanNcUtils() {
    }

    public static enum Key {
        DEVO_MODE("DevoMode"),
        HEADLESS("Headless"),
        SERVER_MODE("ServerMode"),
        LOAD_NJCONFIG("LoadNjConfig"),
        GRIB1_STRICT("Grib1Strict");


        private Key(String value) {
        }
    }
}

