/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.array.NcArrayLonLatReduced;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLat;
import gov.nasa.giss.data.nc.gridder.NcGridderUtils;
import java.awt.Dimension;

public class NcGridderLonLatReducedCF
extends NcGridderLonLat {
    private static final double SMALL_VALUE = 0.001;

    public NcGridderLonLatReducedCF() {
        this(100, 50);
    }

    public NcGridderLonLatReducedCF(Dimension size) {
        this(size.width, size.height);
    }

    public NcGridderLonLatReducedCF(int w, int h) {
        super(w, h);
    }

    @Override
    public void regridNoInterpolate(NcArray a, double[] target) {
        this.prepareGridAxes();
        NcArrayLonLatReduced nca = (NcArrayLonLatReduced)a;
        boolean hasBad = nca.hasBadValues();
        NcAxis yAxis = nca.getYAxis();
        int numYs = yAxis.getLength();
        double[][] yBounds = yAxis.getBounds();
        int[] srcRow = new int[this.gridHeight_];
        int[] srcCol = new int[this.gridWidth_];
        block0: for (int j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < numYs; ++jj) {
                if (!(this.rowYY_[j] <= yBounds[jj][0] && this.rowYY_[j] > yBounds[jj][1]) && (!(this.rowYY_[j] > yBounds[jj][0]) || !(this.rowYY_[j] <= yBounds[jj][1]))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        int prevSRow = -9999;
        for (int j = 0; j < this.gridHeight_; ++j) {
            if (srcRow[j] < 0) continue;
            if (srcRow[j] != prevSRow) {
                NcAxis xAxis = nca.getXAxis(srcRow[j]);
                int numXs = xAxis.getLength();
                double[][] xBounds = xAxis.getBounds();
                block3: for (int i = 0; i < this.gridWidth_; ++i) {
                    srcCol[i] = -1;
                    double lon = this.colXX_[i];
                    for (int ii = 0; ii < numXs; ++ii) {
                        double leftII = xBounds[ii][0];
                        double rightII = xBounds[ii][1];
                        while (lon < leftII) {
                            lon += 360.0;
                        }
                        while (lon > rightII) {
                            lon -= 360.0;
                        }
                        if (!(lon >= leftII) || !(lon < rightII)) continue;
                        srcCol[i] = ii;
                        continue block3;
                    }
                }
                prevSRow = srcRow[j];
            }
            for (int i = 0; i < this.gridWidth_; ++i) {
                if (srcCol[i] < 0) continue;
                double value = nca.valueAt(srcCol[i], srcRow[j]);
                if (hasBad && nca.isMissingOrInvalid(value)) {
                    value = Double.NaN;
                }
                NcGridderUtils.setValue(target, i, j, value, this.gridWidth_, this.gridHeight_);
            }
        }
    }

    @Override
    public void regridInterpolate(NcArray a, double[] target) {
        int j;
        this.prepareGridAxes();
        NcArrayLonLatReduced nca = (NcArrayLonLatReduced)a;
        boolean hasBad = nca.hasBadValues();
        NcAxis yAxis = nca.getYAxis();
        int numYs = yAxis.getLength();
        int lastY = numYs - 1;
        double[] yValues = yAxis.getValues();
        boolean wrapsOnX = this.doesGridWrapOnX(nca);
        int[] srcRow = new int[this.gridHeight_];
        block0: for (j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < lastY; ++jj) {
                if (!(this.rowYY_[j] >= yValues[jj] && this.rowYY_[j] <= yValues[jj + 1]) && (!(this.rowYY_[j] <= yValues[jj]) || !(this.rowYY_[j] >= yValues[jj + 1]))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        for (j = 0; j < this.gridHeight_; ++j) {
            if (srcRow[j] == -1) continue;
            double lat1 = yValues[srcRow[j]];
            double lat2 = yValues[srcRow[j] + 1];
            double yPct = (this.rowYY_[j] - lat1) / (lat2 - lat1);
            NcAxis xAxis1 = nca.getXAxis(srcRow[j]);
            int numXs1 = xAxis1.getLength();
            int lastX1 = numXs1 - 1;
            double[] xValues1 = xAxis1.getValues();
            NcAxis xAxis2 = nca.getXAxis(srcRow[j] + 1);
            int numXs2 = xAxis2.getLength();
            int lastX2 = numXs2 - 1;
            double[] xValues2 = xAxis2.getValues();
            for (int i = 0; i < this.gridWidth_; ++i) {
                double valBR;
                double lon1L;
                double lon2R;
                int ii;
                double lon = this.colXX_[i];
                int srcX1 = -1;
                int srcX2 = -1;
                for (ii = 0; ii < lastX1; ++ii) {
                    if (!this.isLonInRange(lon, xValues1[ii], xValues1[ii + 1])) continue;
                    srcX1 = ii;
                    break;
                }
                for (ii = 0; ii < lastX2; ++ii) {
                    if (!this.isLonInRange(lon, xValues2[ii], xValues2[ii + 1])) continue;
                    srcX2 = ii;
                    break;
                }
                if (srcX1 < 0 && wrapsOnX && this.isLonInRange(lon, xValues1[lastX1], xValues1[0] + 360.0)) {
                    srcX1 = lastX1;
                }
                if (srcX2 < 0 && wrapsOnX && this.isLonInRange(lon, xValues2[lastX2], xValues2[0] + 360.0)) {
                    srcX2 = lastX2;
                }
                if (srcX1 < 0 || srcX2 < 0) continue;
                double lon1R = srcX1 < lastX1 ? xValues1[srcX1 + 1] : xValues1[0] + 360.0;
                double lon2L = xValues2[srcX2];
                double d = lon2R = srcX2 < lastX2 ? xValues2[srcX2 + 1] : xValues2[0] + 360.0;
                for (lon1L = xValues1[srcX1]; lon1L > lon; lon1L -= 360.0) {
                }
                while (lon1L < lon - 360.0) {
                    lon1L += 360.0;
                }
                while (lon1R < lon1L) {
                    lon1R += 360.0;
                }
                while (lon1R > lon1L + 360.0) {
                    lon1R -= 360.0;
                }
                while (lon2L > lon) {
                    lon2L -= 360.0;
                }
                while (lon2L < lon - 360.0) {
                    lon2L += 360.0;
                }
                while (lon2R < lon2L) {
                    lon2R += 360.0;
                }
                while (lon2R > lon2L + 360.0) {
                    lon2R -= 360.0;
                }
                double xPct1 = (lon - lon1L) / (lon1R - lon1L);
                double xPct2 = (lon - lon2L) / (lon2R - lon2L);
                double valTL = nca.valueAt(srcX1, srcRow[j]);
                double valTR = srcX1 < lastX1 ? nca.valueAt(srcX1 + 1, srcRow[j]) : nca.valueAt(0, srcRow[j]);
                double valBL = nca.valueAt(srcX2, srcRow[j] + 1);
                double d2 = valBR = srcX2 < lastX2 ? nca.valueAt(srcX2 + 1, srcRow[j] + 1) : nca.valueAt(0, srcRow[j] + 1);
                if (hasBad) {
                    if (nca.isMissingOrInvalid(valTL)) {
                        valTL = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valTR)) {
                        valTR = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valBL)) {
                        valBL = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valBR)) {
                        valBR = Double.NaN;
                    }
                }
                double v1 = NcGridderUtils.twoPoints(valTL, valTR, xPct1);
                double v2 = NcGridderUtils.twoPoints(valBL, valBR, xPct2);
                double value = NcGridderUtils.twoPoints(v1, v2, yPct);
                NcGridderUtils.setValue(target, i, j, value, this.gridWidth_, this.gridHeight_);
            }
        }
    }

    private boolean isLonInRange(double lon, double left, double right) {
        double lonx;
        if (lon >= left && lon <= right) {
            return true;
        }
        for (lonx = lon; lonx < left; lonx += 360.0) {
        }
        while (lonx > right) {
            lonx -= 360.0;
        }
        return lonx >= left && lonx <= right;
    }

    private boolean doesGridWrapOnX(NcArrayLonLatReduced nca) {
        NcAxis yAxis = nca.getYAxis();
        int numYs = yAxis.getLength();
        int lastY = numYs - 1;
        double[] yValues = yAxis.getValues();
        for (int jj = 0; jj < lastY; ++jj) {
            double dx;
            NcAxis xAxis = nca.getXAxis(jj);
            int numXs = xAxis.getLength();
            if (numXs < 2) continue;
            int lastX = numXs - 1;
            double[] xValues = xAxis.getValues();
            double xNext = xValues[lastX] + (dx = xValues[lastX] - xValues[lastX - 1]) - 360.0;
            if (!(Math.abs(xNext - xValues[0]) > 0.001)) continue;
            return false;
        }
        return true;
    }
}

