/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.TwoHemisphereAzimuthalProjection;

public class AzimuthalEquidistant2H
extends TwoHemisphereAzimuthalProjection {
    public static final String PROJECTION_NAME = "Azimuthal Equidistant (Two-Hemisphere)";
    private static final double RADIUS_FACTOR = 1.5707963267948966;

    public AzimuthalEquidistant2H(int width, int height) {
        this(width, height, 0, 0);
    }

    public AzimuthalEquidistant2H(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 44040256, width, height, xmargin, ymargin, 1.5707963267948966);
        this.finishConstruction();
    }

    @Override
    protected double getKForLambdaPPhiP(double lambdaPRad, double phiPRad) {
        double cosZ = Math.cos(phiPRad) * Math.cos(lambdaPRad);
        if (cosZ == 1.0) {
            return 0.0;
        }
        double z = Math.acos(cosZ);
        return z / Math.sin(z);
    }

    @Override
    protected double getZRadForRho(double rho) {
        return rho * this.invRS_;
    }
}

