/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ObliqueEllipseProjection;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HammerOblique
extends ObliqueEllipseProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Hammer (Oblique)";
    public static final int PROPERTIES = 0xA02020;
    private static final double CSUBX = 2.0;
    private static final double CSUBY = 1.0;
    private static final double CSUBX_B = Math.sqrt(1.75);
    private static final double CSUBY_B = 1.0 / CSUBX_B;
    private static final double MAX_X_OVER_RS = 2.8284271247461903;
    private static final double MAX_Y_OVER_RS = 1.4142135623730951;
    private double cSubX_ = 2.0;
    private double cSubY_ = 1.0;
    private double invCx_;
    private double invCy_;
    private double inv2RS_;
    private double invRSCX_;
    private double invRSCY_;
    private final ProjBooleanParameter brieseParam_ = new ProjBooleanParameter("Apply Briesemeister's scaling", "Apply Briesemeister's scaling", false);

    public HammerOblique(int width, int height) {
        this(width, height, 0, 0);
    }

    public HammerOblique(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0xA02020, width, height, xmargin, ymargin, 2.8284271247461903, 1.4142135623730951);
        this.addParameter(this.brieseParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            this.setBriesemeisterScaling(this.brieseParam_.isSelected());
            super.parameterChanged(e);
        } else if (p.equals(this.brieseParam_)) {
            this.setBriesemeisterScaling(this.brieseParam_.isSelected());
        } else {
            super.parameterChanged(e);
        }
    }

    private void setBriesemeisterScaling(boolean b) {
        this.cSubX_ = b ? CSUBX_B : 2.0;
        this.cSubY_ = b ? CSUBY_B : 1.0;
        this.invCx_ = 1.0 / this.cSubX_;
        this.invCy_ = 1.0 / this.cSubY_;
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        this.setMaxXYOverRS(this.cSubX_ * 1.4142135623730951, this.cSubY_ * 1.4142135623730951);
    }

    @Override
    protected final void finishScaling() {
        this.inv2RS_ = 0.5 * this.invRS_;
        this.invRSCX_ = this.invRS_ * this.invCx_;
        this.invRSCY_ = this.invRS_ * this.invCy_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double[] llP = this.lonlat2lonlatP(lon, lat);
        double halfLambdaPRad = 0.5 * Math.toRadians(llP[0]);
        double phiPRad = Math.toRadians(llP[1]);
        double cosPhiP = Math.cos(phiPRad);
        double cosBeta = cosPhiP * Math.cos(halfLambdaPRad);
        double betaTerm = Math.sqrt(0.5 * (1.0 + cosBeta));
        if (betaTerm < 1.0E-5) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double sinPhiP = Math.sin(phiPRad);
        double invBetaTerm = 1.0 / betaTerm;
        double x = this.cSubX_ * cosPhiP * Math.sin(halfLambdaPRad) * invBetaTerm;
        double y = this.cSubY_ * sinPhiP * invBetaTerm;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaPRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return new PointLL(this.lambdaC_, this.phiC_);
        }
        double sinHalfBeta = this.inv2RS_ * Math.hypot(x * this.invCx_, y * this.invCy_);
        double halfBetaRad = Math.asin(sinHalfBeta);
        double cosHalfBeta = Math.cos(halfBetaRad);
        double phiPRad = Math.asin(y * cosHalfBeta * this.invRSCY_);
        if (Math.abs(phiPRad) > 1.5707963267948966) {
            return null;
        }
        double cosBeta = Math.cos(2.0 * halfBetaRad);
        double d = lambdaPRad = phiPRad == 1.5707963267948966 ? 0.0 : 2.0 * Math.atan2(x * cosHalfBeta * this.invRSCX_, cosBeta);
        if (Math.abs(lambdaPRad) > Math.PI) {
            return null;
        }
        double lambdaP = Math.toDegrees(lambdaPRad);
        double phiP = Math.toDegrees(phiPRad);
        double[] ll = this.lonlatP2lonlat(lambdaP, phiP);
        return new PointLL(ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        HammerOblique hammerOblique = this;
        synchronized (hammerOblique) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverCY = y * this.invCy_;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double lambdaPRad;
                    double x = (double)ix + 0.5;
                    double sinHalfBeta = this.inv2RS_ * Math.hypot(x * this.invCx_, yOverCY);
                    double halfBetaRad = Math.asin(sinHalfBeta);
                    double cosHalfBeta = Math.cos(halfBetaRad);
                    double cosBeta = Math.cos(2.0 * halfBetaRad);
                    double phiPRad = Math.asin(y * cosHalfBeta * this.invRSCY_);
                    if (phiPRad > 1.5707963267948966) continue block3;
                    double d = lambdaPRad = phiPRad == 1.5707963267948966 ? 0.0 : 2.0 * Math.atan2(x * cosHalfBeta * this.invRSCX_, cosBeta);
                    if (lambdaPRad > Math.PI) continue block3;
                    double lambdaP = Math.toDegrees(lambdaPRad);
                    double phiP = Math.toDegrees(phiPRad);
                    double[] llTR = this.lonlatP2lonlat(lambdaP, phiP);
                    double[] llBR = this.lonlatP2lonlat(lambdaP, -phiP);
                    double[] llBL = this.lonlatP2lonlat(-lambdaP, -phiP);
                    double[] llTL = this.lonlatP2lonlat(-lambdaP, phiP);
                    this.setInvPoint(ix, iy, llTR[0], llTR[1]);
                    this.setInvPoint(ix, -iy - 1, llBR[0], llBR[1]);
                    this.setInvPoint(-ix - 1, -iy - 1, llBL[0], llBL[1]);
                    this.setInvPoint(-ix - 1, iy, llTL[0], llTL[1]);
                }
            }
        }
    }
}

