/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hufnagel
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Hufnagel";
    public static final int PROPERTIES = 8200;
    private static final int LUT_SIZE = 301;
    private static final int LUT_SIZE_M1 = 300;
    private static final double EPS = 1.0E-14;
    private double capA_ = 0.6666666666666666;
    private double capB_ = 0.3333333333333333;
    private double psiMax_ = 45.0;
    private double psiMaxRad_ = 0.7853981633974483;
    private double alpha_ = 2.0;
    private double aPlusB_;
    private double halfAPlusB_;
    private double halfB_;
    private double onePlusAMinusHalfB_;
    private double capK_;
    private double capK2_;
    private double invK_;
    private double capC_;
    private double cOverK_;
    private double kOverC_;
    private double kC_;
    private double[] phiLUT_;
    private double[] yLUT_;
    private double[] psiLUT_;
    private int lutCount_ = 301;
    private double psiRadOfMaxX_;

    public Hufnagel(int width, int height) {
        this(width, height, 0, 0);
    }

    public Hufnagel(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8200, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addParameter(new ProjDoubleParameter("Parameter A", "A", "", 0.6666666666666666, -1.0, 1.0));
        this.addParameter(new ProjDoubleParameter("Parameter B", "B", "", 0.3333333333333333, -1.0, 1.0));
        this.addParameter(new ProjDoubleParameter("Parameter angle \u03a8max", "\u03a8max", "\u00b0", 45.0, 0.0, 90.0));
        this.addParameter(new ProjDoubleParameter("Aspect ratio", "\u03b1", "", 2.0, 1.0, 2.5));
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        this.capA_ = ((ProjDoubleParameter)this.getParameter(0)).getValue();
        this.capB_ = ((ProjDoubleParameter)this.getParameter(1)).getValue();
        this.psiMax_ = ((ProjDoubleParameter)this.getParameter(2)).getValue();
        this.alpha_ = ((ProjDoubleParameter)this.getParameter(3)).getValue();
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        double wf;
        this.initIntermediateParams();
        if (Math.abs(this.psiMax_) < 1.0E-5) {
            this.setMaxXYOverRS(Math.PI * this.capK_, this.invK_);
            return;
        }
        if (this.psiRadOfMaxX_ < 1.0E-5) {
            wf = this.kC_ * Math.sqrt(1.0 + this.capA_ + this.capB_);
        } else {
            double cos2Psi = Math.cos(2.0 * this.psiRadOfMaxX_);
            double cos4Psi = Math.cos(4.0 * this.psiRadOfMaxX_);
            double r2 = 1.0 + this.capA_ * cos2Psi + this.capB_ * cos4Psi;
            double r = Math.sqrt(r2);
            wf = this.kC_ * r * Math.cos(this.psiRadOfMaxX_);
        }
        double psi90Rad = this.getPsiForPhi(1.5707963267948966);
        if (LOGGER.isTraceEnabled()) {
            double psiTable = this.approximatePsiFromTable(1.5707963267948966, this.phiLUT_);
            LOGGER.trace("psiMax {}, psiTable {}, psiForPhi {}, lutMax {}", this.psiMax_, Math.toDegrees(psiTable), Math.toDegrees(psi90Rad), Math.toDegrees(this.psiLUT_[300]));
        }
        double sinPsi = Math.sin(psi90Rad);
        double cos2Psi = Math.cos(2.0 * psi90Rad);
        double cos4Psi = Math.cos(4.0 * psi90Rad);
        double r2 = 1.0 + this.capA_ * cos2Psi + this.capB_ * cos4Psi;
        double r = Math.sqrt(r2);
        double hf = this.kOverC_ * r * sinPsi;
        this.setMaxXYOverRS(wf, hf);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        double lambdaRad = this.lonToLambdaRad(lon);
        double absPhiRad = Math.abs(Math.toRadians(lat));
        if (Math.abs(this.psiMax_) < 1.0E-5) {
            x = lambdaRad * this.capK_;
            y = Math.sin(absPhiRad) * this.invK_;
        } else {
            double psiRad = this.getPsiForPhi(absPhiRad);
            if (Double.isNaN(psiRad) || Math.abs(psiRad) > this.psiMaxRad_) {
                LOGGER.trace("Returning null for lat {}", (Object)lat);
                return null;
            }
            double sinPsi = Math.sin(psiRad);
            double cosPsi = Math.cos(psiRad);
            double cos2Psi = Math.cos(2.0 * psiRad);
            double cos4Psi = Math.cos(4.0 * psiRad);
            double r2 = 1.0 + this.capA_ * cos2Psi + this.capB_ * cos4Psi;
            double r = Math.sqrt(r2);
            x = this.kC_ * r * lambdaRad * 0.3183098861837907 * cosPsi;
            y = this.kOverC_ * r * sinPsi;
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double phiRad;
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (this.psiMaxRad_ == 0.0) {
            if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
                return null;
            }
            lambdaRad = x * this.invRS_ * this.invK_;
            phiRad = Math.asin(y * this.invRS_ * this.capK_);
        } else {
            double sin6Psi;
            double sin4Psi;
            double psiRad = this.getPsiForY(y * this.invRS_);
            if (Double.isNaN(psiRad) || Math.abs(psiRad) > this.psiMaxRad_) {
                return null;
            }
            double sin2Psi = Math.sin(2.0 * psiRad);
            double piSinPhi = 0.25 * this.capK2_ * (2.0 * psiRad + this.onePlusAMinusHalfB_ * sin2Psi + this.halfAPlusB_ * (sin4Psi = Math.sin(4.0 * psiRad)) + 0.5 * this.capB_ * (sin6Psi = Math.sin(6.0 * psiRad)));
            double sinPhi = piSinPhi * 0.3183098861837907;
            if (Math.abs(sinPhi) > 1.0) {
                return null;
            }
            phiRad = Math.asin(sinPhi);
            double cosPsi = Math.cos(psiRad);
            double cos2Psi = Math.cos(2.0 * psiRad);
            double cos4Psi = Math.cos(4.0 * psiRad);
            double r2 = 1.0 + this.capA_ * cos2Psi + this.capB_ * cos4Psi;
            double r = Math.sqrt(r2);
            lambdaRad = x * this.invRS_ * Math.PI / (this.kC_ * r * cosPsi);
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Hufnagel hufnagel = this;
        synchronized (hufnagel) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double xFactor;
                double phiRad;
                double y = (double)iy + 0.5;
                if (this.psiMaxRad_ == 0.0) {
                    phiRad = Math.asin(y * this.invRS_ * this.capK_);
                    xFactor = this.invK_;
                } else {
                    double sin6Psi;
                    double sin4Psi;
                    double psiRad;
                    try {
                        psiRad = this.getPsiForY(y * this.invRS_);
                    }
                    catch (Exception c) {
                        break;
                    }
                    if (Double.isNaN(psiRad) || Math.abs(psiRad) > this.psiMaxRad_) break;
                    double twoPsiRad = 2.0 * psiRad;
                    double fourPsiRad = 4.0 * psiRad;
                    double sin2Psi = Math.sin(twoPsiRad);
                    double piSinPhi = 0.25 * this.capK2_ * (2.0 * psiRad + this.onePlusAMinusHalfB_ * sin2Psi + this.halfAPlusB_ * (sin4Psi = Math.sin(fourPsiRad)) + this.halfB_ * (sin6Psi = Math.sin(6.0 * psiRad)));
                    double sinPhi = piSinPhi * 0.3183098861837907;
                    if (Math.abs(sinPhi) > 1.0) break;
                    phiRad = Math.asin(sinPhi);
                    double cosPsi = Math.cos(psiRad);
                    double cos2Psi = Math.cos(twoPsiRad);
                    double cos4Psi = Math.cos(fourPsiRad);
                    double r = Math.sqrt(1.0 + this.capA_ * cos2Psi + this.capB_ * cos4Psi);
                    xFactor = Math.PI / (this.kC_ * r * cosPsi);
                }
                if (phiRad > 1.5707963267948966) break;
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.invRS_ * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.psiMaxRad_ < 1.0E-5) {
            ProjGraphicUtils.drawRectBorder(g2d, this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
        } else {
            super.drawBorderLines(g2d);
        }
    }

    private void initIntermediateParams() {
        LOGGER.trace("psiMax_ {}", (Object)this.psiMax_);
        this.psiMaxRad_ = Math.toRadians(this.psiMax_);
        this.aPlusB_ = this.capA_ + this.capB_;
        this.halfAPlusB_ = 0.5 * this.aPlusB_;
        this.halfB_ = 0.5 * this.capB_;
        this.onePlusAMinusHalfB_ = 1.0 + this.capA_ - this.halfB_;
        if (Math.abs(this.psiMax_) < 1.0E-5) {
            this.capK_ = Math.sqrt(this.alpha_ * 0.3183098861837907);
            this.capC_ = 1.0E-5;
        } else {
            double twoPsiMaxRad = 2.0 * this.psiMaxRad_;
            double fourPsiMaxRad = 4.0 * this.psiMaxRad_;
            double sixPsiMaxRad = 6.0 * this.psiMaxRad_;
            this.capK2_ = Math.PI * 4 / (2.0 * this.psiMaxRad_ + this.onePlusAMinusHalfB_ * Math.sin(twoPsiMaxRad) + this.halfAPlusB_ * Math.sin(fourPsiMaxRad) + this.halfB_ * Math.sin(sixPsiMaxRad));
            this.capK_ = Math.sqrt(this.capK2_);
            LOGGER.trace("capK2_ {}, capK_ {}", (Object)this.capK2_, (Object)this.capK_);
            double c2term = (1.0 + this.capA_ * Math.cos(twoPsiMaxRad) + this.capB_ * Math.cos(fourPsiMaxRad)) / (1.0 + this.aPlusB_);
            if (c2term > 0.0) {
                double c2 = this.alpha_ * Math.sin(this.psiMaxRad_) * Math.sqrt(c2term);
                this.capC_ = Math.sqrt(c2);
            } else {
                LOGGER.warn("BAD PARAMETER COMBINATION");
                LOGGER.warn("Getting square root of a negative while calculating param C.");
                LOGGER.warn("Setting C to a small value.");
                LOGGER.warn("Map, if any is drawn, will be almost 0 width.");
                this.capC_ = 1.0E-5;
            }
            LOGGER.trace("capC_ {}", (Object)this.capC_);
        }
        this.invK_ = 1.0 / this.capK_;
        this.cOverK_ = this.capC_ * this.invK_;
        this.kOverC_ = this.capK_ / this.capC_;
        this.kC_ = this.capK_ * this.capC_;
        this.initLookupTables();
        if (LOGGER.isTraceEnabled()) {
            double rr2 = 1.0 + this.capA_ * 1.0 + this.capB_ * 1.0;
            double rr = Math.sqrt(rr2);
            double x0 = this.kC_ * rr * 1.0;
            rr2 = 1.0 + this.capA_ * Math.cos(2.0 * this.psiMaxRad_) + this.capB_ * Math.cos(4.0 * this.psiMaxRad_);
            rr = Math.sqrt(rr2);
            double y90 = this.kOverC_ * rr * Math.sin(this.psiMaxRad_);
            if (Double.isNaN(x0) || Double.isNaN(y90)) {
                LOGGER.trace("x0 {}, y90 {}", (Object)x0, (Object)y90);
            } else {
                LOGGER.trace("x0 {}, y90 {}, ratio {}", x0, y90, x0 / y90);
            }
        }
    }

    private void initLookupTables() {
        int i;
        this.phiLUT_ = new double[301];
        this.yLUT_ = new double[301];
        this.psiLUT_ = new double[301];
        double invSteps = 0.0033333333333333335;
        double maxX = 0.0;
        this.psiRadOfMaxX_ = 0.0;
        for (i = 0; i < 301; ++i) {
            this.phiLUT_[i] = 0.0;
        }
        for (i = 0; i < 301; ++i) {
            double sin6Psi;
            double sin4Psi;
            double sin2Psi;
            double piSinPhi;
            double sinPhi;
            double psiRad = this.psiMaxRad_ * (double)i * 0.0033333333333333335;
            double twoPsiRad = 2.0 * psiRad;
            double fourPsiRad = 4.0 * psiRad;
            double sixPsiRad = 6.0 * psiRad;
            double phiRad = i == 0 ? 0.0 : (i == 300 ? 1.5707963267948966 : (Math.abs(sinPhi = (piSinPhi = 0.25 * this.capK2_ * (twoPsiRad + this.onePlusAMinusHalfB_ * (sin2Psi = Math.sin(twoPsiRad)) + this.halfAPlusB_ * (sin4Psi = Math.sin(fourPsiRad)) + this.halfB_ * (sin6Psi = Math.sin(sixPsiRad)))) * 0.3183098861837907) > 1.0 ? (sinPhi > 0.0 ? 1.5707963267948966 : -1.5707963267948966) : Math.asin(sinPhi)));
            double sinPsi = Math.sin(psiRad);
            double cosPsi = Math.cos(psiRad);
            double cos2Psi = Math.cos(twoPsiRad);
            double cos4Psi = Math.cos(fourPsiRad);
            double r2 = 1.0 + this.capA_ * cos2Psi + this.capB_ * cos4Psi;
            double r = Math.sqrt(r2);
            double y = this.kOverC_ * r * sinPsi;
            if (i > 0 && (y < this.yLUT_[i - 1] || phiRad < this.phiLUT_[i - 1])) {
                LOGGER.warn("FOLDING GRATICULE.");
                LOGGER.warn("Unexpected/undesired results may occur.");
                this.yLUT_[i] = 0.0;
                this.phiLUT_[i] = 0.0;
                this.psiLUT_[i] = psiRad;
                break;
            }
            double xPi = this.kC_ * r * cosPsi;
            if (xPi > maxX) {
                maxX = xPi;
                this.psiRadOfMaxX_ = psiRad;
            }
            this.yLUT_[i] = y;
            this.phiLUT_[i] = phiRad;
            this.psiLUT_[i] = psiRad;
        }
        for (i = 300; i > 0; --i) {
            if (!(this.phiLUT_[i] > 0.0)) continue;
            this.lutCount_ = i;
            break;
        }
        LOGGER.trace("lutCount_ {}", (Object)this.lutCount_);
    }

    private double getPsiForPhi(double phiRad) {
        double psiRad = this.approximatePsiFromTable(phiRad, this.phiLUT_);
        if (Double.isNaN(psiRad)) {
            return Double.NaN;
        }
        double piSinPhi = Math.PI * Math.sin(phiRad);
        int i = 0;
        while (true) {
            double cos6Psi;
            double cos4Psi;
            double sin6Psi;
            double sin4Psi;
            double twoPsiRad = 2.0 * psiRad;
            double fourPsiRad = 4.0 * psiRad;
            double sixPsiRad = 6.0 * psiRad;
            double sin2Psi = Math.sin(twoPsiRad);
            double numerator = 0.25 * this.capK2_ * (twoPsiRad + this.onePlusAMinusHalfB_ * sin2Psi + this.halfAPlusB_ * (sin4Psi = Math.sin(fourPsiRad)) + this.halfB_ * (sin6Psi = Math.sin(sixPsiRad))) - piSinPhi;
            if (Math.abs(numerator) < 1.0E-14) break;
            double cos2Psi = Math.cos(twoPsiRad);
            double denominator = 0.5 * this.capK2_ * (1.0 + this.onePlusAMinusHalfB_ * cos2Psi + this.aPlusB_ * (cos4Psi = Math.cos(fourPsiRad)) + 3.0 * this.halfB_ * (cos6Psi = Math.cos(sixPsiRad)));
            double deltaPsiRad = numerator / denominator;
            if (Double.isNaN(deltaPsiRad) || Double.isInfinite(deltaPsiRad) || i++ > 33) {
                return Double.NaN;
            }
            psiRad -= deltaPsiRad;
        }
        return psiRad;
    }

    private double getPsiForY(double y) {
        double psiRad = this.approximatePsiFromTable(y, this.yLUT_);
        if (Double.isNaN(psiRad)) {
            return Double.NaN;
        }
        int i = 0;
        while (true) {
            double scaledY;
            double cos4Psi;
            double twoPsiRad = 2.0 * psiRad;
            double sinPsi = Math.sin(psiRad);
            double sin2Psi = Math.sin(twoPsiRad);
            double cos2Psi = Math.cos(twoPsiRad);
            double r2 = 1.0 + this.capA_ * cos2Psi + this.capB_ * (cos4Psi = Math.cos(2.0 * twoPsiRad));
            double numerator = r2 * sinPsi * sinPsi - (scaledY = y * this.cOverK_) * scaledY;
            if (Math.abs(numerator) < 1.0E-14) break;
            double denominator = sin2Psi * (1.0 - this.capA_ + 2.0 * this.capB_ + (2.0 * this.capA_ - 4.0 * this.capB_) * cos2Psi + 3.0 * this.capB_ * cos4Psi);
            double deltaPsiRad = numerator / denominator;
            if (Double.isNaN(deltaPsiRad) || Double.isInfinite(deltaPsiRad) || i++ > 33) {
                return Double.NaN;
            }
            psiRad -= deltaPsiRad;
        }
        return psiRad;
    }

    private double approximatePsiFromTable(double v, double[] vtable) {
        int imid;
        double absV = Math.abs(v);
        int imin = 0;
        int imax = this.lutCount_;
        while ((imid = (imin + imax) / 2) != imin) {
            if (absV > vtable[imid]) {
                imin = imid;
                continue;
            }
            imax = imid;
        }
        try {
            double v1 = vtable[imin];
            double v2 = vtable[imin + 1];
            double w = (absV - v1) / (v2 - v1);
            double psi1 = this.psiLUT_[imin];
            double psi2 = this.psiLUT_[imin + 1];
            double psi0 = w * (psi2 - psi1) + psi1;
            return v < 0.0 ? -psi0 : psi0;
        }
        catch (Exception exc) {
            LOGGER.debug("approximatePsiFromTable error for absV = {}, imin = {}", (Object)absV, (Object)imin);
            return Double.NaN;
        }
    }
}

