/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray1D;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.graphics.GPrintable;
import gov.nasa.giss.panoply.action.PanCancelAnimationAction;
import gov.nasa.giss.panoply.action.PanCenterPlotControlsAction;
import gov.nasa.giss.panoply.action.PanExportAnimationAction;
import gov.nasa.giss.panoply.action.PanExportGridAction;
import gov.nasa.giss.panoply.action.PanExportKmzAction;
import gov.nasa.giss.panoply.action.PanToggleControlsWindoidAction;
import gov.nasa.giss.panoply.action.PanTogglePseudoPaletteAction;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanLonLatPlot;
import gov.nasa.giss.panoply.plot.PanPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotUtils;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import gov.nasa.giss.panoply.plotui.PanAnimationWindoid;
import gov.nasa.giss.panoply.plotui.PanArrayControls;
import gov.nasa.giss.panoply.plotui.PanArrayDataPanel;
import gov.nasa.giss.panoply.plotui.PanContourControls;
import gov.nasa.giss.panoply.plotui.PanControlsPanel;
import gov.nasa.giss.panoply.plotui.PanGridControls1D;
import gov.nasa.giss.panoply.plotui.PanGridControlsCC;
import gov.nasa.giss.panoply.plotui.PanGridControlsLL;
import gov.nasa.giss.panoply.plotui.PanLabelControls;
import gov.nasa.giss.panoply.plotui.PanLayoutControls;
import gov.nasa.giss.panoply.plotui.PanLonLatAlphaControls;
import gov.nasa.giss.panoply.plotui.PanLonLatMapControls;
import gov.nasa.giss.panoply.plotui.PanLonLatNumberlayControls;
import gov.nasa.giss.panoply.plotui.PanLonLatOverlayControls;
import gov.nasa.giss.panoply.plotui.PanLonLatShadingControls;
import gov.nasa.giss.panoply.plotui.PanLonLatTrajectoryControls;
import gov.nasa.giss.panoply.plotui.PanPlotControlsMeta;
import gov.nasa.giss.panoply.plotui.PanPlotDropTargetListener;
import gov.nasa.giss.panoply.plotui.PanPlotGlass;
import gov.nasa.giss.panoply.plotui.PanPlotHolder;
import gov.nasa.giss.panoply.plotui.PanPlotMouseListener;
import gov.nasa.giss.panoply.plotui.PanPlotMouseListenerLonLat;
import gov.nasa.giss.panoply.plotui.PanPlotScrollPane;
import gov.nasa.giss.panoply.plotui.PanPlotTabbedPane;
import gov.nasa.giss.panoply.plotui.PanPlotUnifiedPseudoPalette;
import gov.nasa.giss.panoply.plotui.PanPlotWindoid;
import gov.nasa.giss.panoply.plotui.PanPlotWindoidSingle;
import gov.nasa.giss.panoply.plotui.PanPlotWindoidUnified;
import gov.nasa.giss.panoply.plotui.PanScaleControlsCC;
import gov.nasa.giss.panoply.plotui.PanStrokeControls1D;
import gov.nasa.giss.panoply.plotui.PanVectorControls;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.ui.PanContentPanel;
import gov.nasa.giss.panoply.ui.PanDisplayFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.panoply.util.PanPlotControlsID;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanQuitWatcher;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.SlowMessage;
import gov.nasa.giss.ui.event.PaletteEvent;
import gov.nasa.giss.ui.event.PaletteListener;
import gov.nasa.giss.ui.menu.GissMenu;
import gov.nasa.giss.ui.windoid.Windoid;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanPlotFrame
extends PanDisplayFrame
implements Printable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ControlsLayout ctrlsLayout_;
    public static final int MAX_VIS_PLOTS = 8;
    private static int frameCount_;
    private final PanPlotMeta pmeta_;
    private final PanPlotType ptype_;
    private final PanData data_;
    private PanPlot plot_;
    private PanPlotHolder plotHolder_;
    private JPanel overHolder_;
    private PanPlotScrollPane plotSP_;
    private JPanel contentBox_;
    private PanPlotTabbedPane tabPane_;
    private PanArrayDataPanel[] adataPanels_ = new PanArrayDataPanel[2];
    private final Hashtable<PanPlotControlsID, PanControlsPanel> cPanels_ = new Hashtable(20);
    private final Hashtable<PanPlotControlsID, PanPlotWindoid> cWindoids_ = new Hashtable(20);
    private PanPlotWindoidUnified unifiedWindoid_;
    private PanPlotUnifiedPseudoPalette pseudoP_;
    private PseudoPaletteAdapter pseudoPA_;
    private static boolean appInForeground_;
    private PanPlotMouseListener mouseAdapter_;
    private static boolean controlsEnabled_;
    private boolean animating_;
    private ArrayList<Action> hiddenActions_;
    private static Windoid animationWindoid_;
    private boolean closing_;

    public PanPlotFrame(PanPlotMeta pmeta) {
        super("Plot Frame");
        Objects.requireNonNull(pmeta, "Plot meta object cannot be null.");
        this.setResizable(false);
        pmeta.setFrame(this);
        this.pmeta_ = pmeta;
        this.ptype_ = pmeta.getType();
        this.data_ = pmeta.getData();
        this.plot_ = pmeta.getPlot();
        if (this.data_ == null) {
            throw new RuntimeException("Data object is null. This might be due to a memory error.");
        }
        if (this.plot_ == null) {
            throw new RuntimeException("Plot object is null.");
        }
        this.setNameAndTitle();
        LOGGER.trace("createPlotHolder");
        this.createPlotHolder();
        LOGGER.trace("createLayout");
        this.createLayout();
        LOGGER.trace("createMenuBar");
        this.createMenuBar();
        LOGGER.trace("createControls");
        this.createControls();
        this.assembleControls();
        LOGGER.trace("refreshPrivate");
        this.refreshPrivate();
        LOGGER.trace("attachListeners");
        this.attachListeners();
        LOGGER.trace("attachAltActions");
        this.attachAltActions();
        LOGGER.trace("attachGlass");
        this.attachGlass();
        this.setDefaultCloseOperation(0);
        this.resizeToFitDisplay();
        this.setMinimumSize(new Dimension(540, 570));
        Rectangle rr = GuiUtils.getActiveScreenBounds();
        Dimension psize = this.getPreferredSize();
        if (rr == null) {
            this.setLocation(25, 25);
        } else if (PlatformUtils.isMacintosh()) {
            this.setLocation(rr.x + (rr.width - psize.width) / 2, rr.y + 20 + (rr.height - psize.height) / 4);
        } else {
            this.setLocation(rr.x + (rr.width - psize.width) / 2, rr.y + (rr.height - psize.height) / 4);
        }
    }

    private void setNameAndTitle() {
        this.setName("plot frame #" + frameCount_++);
        String vname = this.data_.getArray(0).getShortName().replace(' ', '_');
        String dname = this.data_.getArray(0).getDataset().getNameRoot().replace(' ', '_');
        if (vname.length() > 28) {
            vname = vname.substring(0, 28);
        }
        if (dname.length() > 42) {
            dname = dname.substring(0, 42);
        }
        for (int ix = 1; ix < 9999; ++ix) {
            StringBuilder sb = new StringBuilder(vname).append(" in ").append(dname);
            if (ix > 1) {
                sb.append(' ').append(ix);
            }
            String ftitle = sb.toString();
            boolean matched = false;
            for (PanPlotFrame frame : PanPlotFrame.getAllPlotFrames()) {
                if (!frame.isVisible() || !frame.getTitle().equalsIgnoreCase(ftitle)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            this.setTitle(ftitle);
            break;
        }
    }

    private void createPlotHolder() {
        this.plotHolder_ = new PanPlotHolder(this.pmeta_);
        this.mouseAdapter_ = this.ptype_.isLonLatMap() ? new PanPlotMouseListenerLonLat(this, this.pmeta_) : new PanPlotMouseListener(this);
        this.plotHolder_.setRequestFocusEnabled(true);
        this.plotHolder_.addMouseListener(this.mouseAdapter_);
        this.plotHolder_.addMouseMotionListener(this.mouseAdapter_);
        this.plotHolder_.addKeyListener(this.mouseAdapter_);
        this.overHolder_ = new JPanel();
        this.overHolder_.setLayout(null);
        this.overHolder_.setOpaque(false);
        this.overHolder_.setBorder(null);
        this.overHolder_.add(this.plotHolder_);
        this.plotHolder_.setLocation(0, 0);
        this.plotSP_ = new PanPlotScrollPane(this.overHolder_);
        PanPlotDropTargetListener pdtl = new PanPlotDropTargetListener(this, this.plotSP_);
        new DropTarget(this.plotHolder_, pdtl);
    }

    private void createLayout() {
        this.tabPane_ = new PanPlotTabbedPane(this);
        this.tabPane_.setLowerBorder(false);
        this.tabPane_.addTab("Plot", this.plotSP_);
        this.updateArrayDataPanel(0);
        this.contentBox_ = new PanContentPanel(4);
        this.contentBox_.setLayout(new BoxLayout(this.contentBox_, 1));
        this.contentBox_.add(this.tabPane_);
        this.contentBox_.add(this.statusBar_);
        this.getContentPane().add(this.contentBox_);
    }

    private void createMenuBar() {
        AbstractAction a;
        PanMenuBar mbar = new PanMenuBar(this);
        this.setPanMenuBar(mbar);
        GissMenu fileMenu = mbar.getMenuForName("file-menu");
        GissMenu viewMenu = mbar.getMenuForName("view-menu");
        if (this.ptype_.isLonLatMap()) {
            a = new PanExportKmzAction(this);
            fileMenu.getItemForName("export-kmz").setAction(a);
            a.setEnabled(true);
            this.pmeta_.putAction("export-kmz", a);
        }
        a = new PanExportAnimationAction(this);
        fileMenu.getItemForName("export-animation").setAction(a);
        a = new PanCenterPlotControlsAction(this);
        viewMenu.getItemForName("center-plot-controls").setAction(a);
        a.setEnabled(true);
    }

    private void createControls() {
        PanMenuBar mbar = this.getPanMenuBar();
        PanPreferences prefs = PanPreferences.getSharedInstance();
        PanPlotControlsID cid = PanPlotControlsID.ARRAYS;
        PanControlsPanel cc = new PanArrayControls(this.pmeta_, mbar);
        this.cPanels_.put(cid, cc);
        cid = PanPlotControlsID.LAYOUT;
        cc = new PanLayoutControls(this.pmeta_, mbar);
        this.cPanels_.put(cid, cc);
        if (!this.ptype_.isLinePlot()) {
            cid = PanPlotControlsID.SCALE;
            cc = new PanScaleControlsCC(this.pmeta_, mbar);
            this.cPanels_.put(cid, cc);
        }
        if (this.ptype_.isLonLatTrajectory()) {
            cid = PanPlotControlsID.TRAJECTORY;
            cc = new PanLonLatTrajectoryControls(this.pmeta_, mbar);
            this.cPanels_.put(cid, cc);
        }
        if (this.ptype_.isLonLatMap()) {
            cid = PanPlotControlsID.MAP;
            cc = new PanLonLatMapControls(this.pmeta_, mbar);
            this.cPanels_.put(cid, cc);
            cid = PanPlotControlsID.GRID;
            cc = new PanGridControlsLL(this.pmeta_, mbar);
            this.cPanels_.put(cid, cc);
            cid = PanPlotControlsID.OVERLAYS;
            cc = new PanLonLatOverlayControls(this.pmeta_, mbar);
            this.cPanels_.put(cid, cc);
            cid = PanPlotControlsID.SHADING;
            cc = new PanLonLatShadingControls(this.pmeta_, mbar);
            this.cPanels_.put(cid, cc);
        } else if (this.ptype_.isColorContour()) {
            cid = PanPlotControlsID.GRID;
            cc = new PanGridControlsCC(this.pmeta_, mbar);
            this.cPanels_.put(cid, cc);
        }
        if (this.ptype_.isLinePlot()) {
            cid = PanPlotControlsID.GRID;
            cc = new PanGridControls1D(this.pmeta_, mbar);
            this.cPanels_.put(cid, cc);
            cid = PanPlotControlsID.STROKE;
            cc = new PanStrokeControls1D(this.pmeta_, mbar);
            this.cPanels_.put(cid, cc);
        }
        if (this.ptype_.isColorContour()) {
            cid = PanPlotControlsID.CONTOURS;
            cc = new PanContourControls(this.pmeta_, mbar);
            this.cPanels_.put(cid, cc);
        }
        if (this.ptype_.supportsVectorPlots()) {
            cid = PanPlotControlsID.VECTORS;
            cc = new PanVectorControls(this.pmeta_, mbar);
            this.cPanels_.put(cid, cc);
        }
        cid = PanPlotControlsID.LABELS;
        cc = new PanLabelControls(this.pmeta_, mbar);
        this.cPanels_.put(cid, cc);
        if (this.ptype_.isLonLatColorContour() && prefs.getBoolean("beta:numberlays")) {
            cid = PanPlotControlsID.NUMBERLAY;
            cc = new PanLonLatNumberlayControls(this.pmeta_, mbar);
            this.cPanels_.put(cid, cc);
        }
        if (this.ptype_.isLonLatMap() && prefs.getBoolean("beta:underlays")) {
            cid = PanPlotControlsID.ALPHA;
            cc = new PanLonLatAlphaControls(this.pmeta_, mbar);
            this.cPanels_.put(cid, cc);
        }
    }

    private void assembleControls() {
        PanMenuBar mbar = this.getPanMenuBar();
        GissMenu wmenu = mbar.getMenuForName("window-menu");
        GissMenu viewMenu = mbar.getMenuForName("view-menu");
        switch (ctrlsLayout_) {
            case PSEUDO_PALETTE: {
                this.pseudoP_ = new PanPlotUnifiedPseudoPalette(this, this.cPanels_);
                this.overHolder_.add(this.pseudoP_);
                this.pseudoP_.setLocation(10, 10);
                this.pseudoP_.setSize(this.pseudoP_.getPreferredSize());
                this.overHolder_.setComponentZOrder(this.pseudoP_, 0);
                LOGGER.trace("usp:size {}", (Object)this.pseudoP_.getSize());
                PanTogglePseudoPaletteAction aac = new PanTogglePseudoPaletteAction(this);
                viewMenu.getItemForName("toggle-pseudo-palette").setAction(aac);
                aac.setEnabled(true);
                break;
            }
            case UNIFIED_WINDOID: {
                PanPlotControlsID cid = PanPlotControlsID.UNIFIED;
                this.unifiedWindoid_ = new PanPlotWindoidUnified(this, this.cPanels_);
                this.cWindoids_.put(cid, this.unifiedWindoid_);
                PanToggleControlsWindoidAction a = new PanToggleControlsWindoidAction(this, cid);
                wmenu.getItemForName(cid.getActionKey()).setAction(a);
                a.setEnabled(true);
                break;
            }
            default: {
                Enumeration<PanPlotControlsID> cpKeys = this.cPanels_.keys();
                while (cpKeys.hasMoreElements()) {
                    PanPlotControlsID cid = cpKeys.nextElement();
                    PanControlsPanel cc = this.cPanels_.get(cid);
                    PanPlotWindoidSingle ww = new PanPlotWindoidSingle(cid, this, cc);
                    this.cWindoids_.put(cid, ww);
                    PanToggleControlsWindoidAction a = new PanToggleControlsWindoidAction(this, cid);
                    wmenu.getItemForName(cid.getActionKey()).setAction(a);
                    a.setEnabled(true);
                }
                break block0;
            }
        }
    }

    private void attachListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (PanPlotFrame.this.needsResizeToFitDisplay()) {
                    PanPlotFrame.this.resizeToFitDisplay();
                }
            }
        });
        if (this.pseudoP_ != null) {
            this.pseudoPA_ = new PseudoPaletteAdapter();
            this.pseudoP_.addComponentListener(this.pseudoPA_);
        }
    }

    private void attachAltActions() {
        InputMap im = this.getRootPane().getInputMap(2);
        ActionMap am = this.getRootPane().getActionMap();
        AbstractAction a = new PanCancelAnimationAction(this);
        PanGuiUtils.attachKeyStrokeAction(a, "cancel-animation-esc", im, am);
        PanGuiUtils.attachKeyStrokeAction(a, "cancel-animation-period", im, am);
        if (!PanUtils.isDevo()) {
            a = new PanExportGridAction(this);
            PanGuiUtils.attachKeyStrokeAction(a, "export-plotted-grid", im, am);
        }
    }

    private void attachGlass() {
        PanPlotGlass glass = new PanPlotGlass(this);
        this.setGlassPane(glass);
        glass.setVisible(false);
    }

    public PanPlotMeta getMeta() {
        return this.pmeta_;
    }

    public PanData getData() {
        return this.data_;
    }

    public PanPlot getPlot() {
        return this.plot_;
    }

    public PanPlotHolder getPlotHolder() {
        return this.plotHolder_;
    }

    public PanPlotTabbedPane getTabbedPane() {
        return this.tabPane_;
    }

    @Override
    public void setVisible(boolean vis) {
        if (this.animating_) {
            this.animating_ = false;
        }
        super.setVisible(vis);
        if (!vis) {
            PanQuitWatcher.quitIfNone();
        }
    }

    public void replacePlot(PanPlot newplot) {
        LOGGER.trace("old plot bounds {}", (Object)this.plot_.getBounds());
        this.plotHolder_.detach(this.plot_);
        this.plot_ = newplot;
        this.plotHolder_.attach(this.plot_);
        EventQueue.invokeLater(() -> {
            this.plot_.setNeedsRepaint();
            this.resizeToFitDisplay();
            this.plotHolder_.repaint();
            LOGGER.trace("new plot bounds {}", (Object)this.plot_.getBounds());
        });
    }

    public static void setAppInForeground(boolean inForeground) {
        appInForeground_ = inForeground;
    }

    public ControlsLayout getControlsLayout() {
        return ctrlsLayout_;
    }

    public PanControlsPanel getControlsPanel(PanPlotControlsID cid) {
        return this.cPanels_.get(cid);
    }

    public PanPlotWindoid getControlsWindoid(PanPlotControlsID cid) {
        if (ctrlsLayout_ == ControlsLayout.PSEUDO_PALETTE) {
            return null;
        }
        return this.cWindoids_.get(cid);
    }

    public PanPlotUnifiedPseudoPalette getPseudoPalette() {
        if (ctrlsLayout_ == ControlsLayout.PSEUDO_PALETTE) {
            return this.pseudoP_;
        }
        return null;
    }

    public static void setControlWindoidsEnabled(boolean enabled) {
        controlsEnabled_ = enabled;
    }

    public void setWindoidsVisible(boolean vis) {
        boolean animating = PanPlotFrame.isAnimationInProgress();
        if (animating) {
            animationWindoid_.setVisible(vis);
        } else {
            if (ctrlsLayout_ == ControlsLayout.PSEUDO_PALETTE) {
                if (this.pseudoP_ != null) {
                    this.pseudoP_.setVisible(vis);
                }
            } else {
                this.setControlWindoidsVisible(vis);
            }
            if (animationWindoid_ != null) {
                animationWindoid_.setVisible(false);
            }
        }
    }

    public void setControlWindoidsVisible(boolean vis) {
        if (vis && !appInForeground_) {
            return;
        }
        if (vis && !controlsEnabled_) {
            return;
        }
        EventQueue.invokeLater(() -> {
            if (ctrlsLayout_ == ControlsLayout.PSEUDO_PALETTE) {
                if (this.pseudoP_ != null) {
                    this.pseudoP_.setVisible(vis);
                }
            } else {
                Set<PanPlotControlsID> keys = this.cWindoids_.keySet();
                for (PanPlotControlsID key : keys) {
                    this.cWindoids_.get(key).setVisibleIfMetaTrue(vis);
                }
            }
            this.refresh();
        });
    }

    public boolean areControlsVisible(PanPlotControlsID cid) {
        if (ctrlsLayout_ == ControlsLayout.PSEUDO_PALETTE) {
            return false;
        }
        PanPlotWindoid cww = this.cWindoids_.get(cid);
        if (cww == null) {
            return false;
        }
        boolean vis = cww.isVisible();
        return vis;
    }

    public void setControlsVisible(PanPlotControlsID cid, boolean vis) {
        if (ctrlsLayout_ == ControlsLayout.PSEUDO_PALETTE) {
            return;
        }
        PanPlotWindoid cww = this.cWindoids_.get(cid);
        if (cww == null) {
            LOGGER.debug("{} windoid is null", (Object)cid);
        } else {
            cww.setVisibleAndSetMeta(vis);
            if (vis) {
                cww.toFront();
            }
        }
    }

    public void addVariable(NcVariable ncv) {
        boolean animating = PanPlotFrame.isAnimationInProgress();
        if (animating) {
            LOGGER.warn("Cannot add a var while animating.");
        }
        try {
            NcArray nca = PanPlotUtils.createCompatibleArray(ncv, this.pmeta_);
            this.addArray(nca);
        }
        catch (NcException exc) {
            String errmsg = exc.toString().replaceFirst(".*Exception\\: ", "");
            SlowMessage.show((Component)this, "Data Error", new StringBuilder("There was an error preparing the data: ").append(errmsg));
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            SlowMessage.show((Component)this, "Data Error", "Variable appears to be incompatible with the plot.");
        }
        this.refreshPrivate();
    }

    public void addArray(NcArray nca) {
        this.toFront();
        if (this.data_.getArray(1) == null) {
            this.setArray(1, nca);
        } else {
            this.showReplaceArrayDialog(nca);
        }
    }

    private void setArray(int vindex, NcArray nca) {
        this.toFront();
        if (this.ptype_ == PanPlotType.HORZ_LINE || this.ptype_ == PanPlotType.VERT_LINE) {
            NcArray1D nca1D = (NcArray1D)nca;
            NcArray1D nca1D0 = (NcArray1D)this.data_.getArray(0);
            boolean equal = nca1D.getAxis().equals(nca1D0.getAxis());
            if (!equal) {
                SlowMessage.show((Component)this, "Plot Warning", "The new variable's axis does not appear to be the same as the plot's axis. The combination will be canceled.");
                return;
            }
        } else if (this.ptype_ != PanPlotType.LON_LAT && !this.ptype_.isLonLatZonal() && !this.ptype_.isLonLatTrajectory()) {
            NcArray2D nca2D = (NcArray2D)nca;
            NcArray2D nca2D0 = (NcArray2D)this.data_.getArray(0);
            if (this.ptype_ == PanPlotType.LAT_VERT || this.ptype_ == PanPlotType.LON_VERT || this.ptype_ == PanPlotType.TIME_VERT) {
                boolean compat = nca2D.getYAxis().isCompatible(nca2D0.getYAxis());
                boolean equal = nca2D.getYAxis().equals(nca2D0.getYAxis());
                if (!compat && !equal) {
                    SlowMessage.show((Component)this, "Plot Warning", "The variable's vertical axis does not appear to be compatible with the plot's vertical axis. The combination will be canceled.");
                    return;
                }
            } else if (this.ptype_ == PanPlotType.LAT_TIME || this.ptype_ == PanPlotType.LON_TIME) {
                boolean compat = nca2D.getYAxis().isCompatible(nca2D0.getYAxis());
                boolean equal = nca2D.getYAxis().equals(nca2D0.getYAxis());
                if (!compat && !equal) {
                    SlowMessage.show((Component)this, "Plot Warning", "The variable's time axis does not appear to be compatible with the plot's time axis. The combination will be canceled.");
                    return;
                }
            } else if (this.ptype_ == PanPlotType.TIME_LAT || this.ptype_ == PanPlotType.TIME_VERT) {
                boolean compat = nca2D.getXAxis().isCompatible(nca2D0.getXAxis());
                boolean equal = nca2D.getXAxis().equals(nca2D0.getXAxis());
                if (!compat && !equal) {
                    SlowMessage.show((Component)this, "Plot Warning", "The variable's time axis does not appear to be compatible with the plot's time axis. The combination will be canceled.");
                    return;
                }
            } else {
                LOGGER.trace("Did not match any plot types.");
            }
        }
        if (vindex < 0 || vindex > 1) {
            LOGGER.warn("Cannot set array at index {}", (Object)vindex);
            return;
        }
        LOGGER.trace("{}", (Object)vindex);
        this.pmeta_.setNcArray(vindex, nca, null);
    }

    public final void updateArrayDataPanel(int idx) {
        int tabIndex = idx + 1;
        if (this.adataPanels_[idx] != null) {
            this.tabPane_.removeTabAt(tabIndex);
        }
        this.adataPanels_[idx] = new PanArrayDataPanel(this.ptype_, this.data_, idx);
        this.adataPanels_[idx].setName("Array " + tabIndex);
        this.tabPane_.add((Component)this.adataPanels_[idx], tabIndex);
        Component c = this.cPanels_.get(PanPlotControlsID.ARRAYS);
        if (c != null) {
            ((PanArrayControls)c).updateSlicePanel(idx);
        }
        this.refreshActions();
        this.refreshPrivate();
        this.tabPane_.repaint();
        this.tabPane_.refresh();
    }

    public static boolean isAnimationInProgress() {
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof PanPlotFrame) || !((PanPlotFrame)frame).isAnimating()) continue;
            return true;
        }
        return false;
    }

    public boolean isAnimating() {
        return this.animating_;
    }

    public void setAnimating(boolean animating) {
        if (animating && PanPlotFrame.isAnimationInProgress()) {
            LOGGER.info("An animation is already in progress.");
        }
        EventQueue.invokeLater(() -> {
            if (this.closing_) {
                return;
            }
            LOGGER.trace("animating {}", (Object)animating);
            this.animating_ = animating;
            if (this.pseudoP_ != null) {
                this.pseudoP_.setVisible(!animating);
            }
            if (animating) {
                if (animationWindoid_ == null) {
                    animationWindoid_ = new PanAnimationWindoid(this);
                }
                Dimension wsize = animationWindoid_.getSize();
                Rectangle rr = this.getBounds();
                int dx = (rr.width - wsize.width) / 2;
                int dy = (rr.height - wsize.height) / 2 + 100;
                animationWindoid_.setLocation(rr.x + dx, rr.y + dy);
                animationWindoid_.setVisible(true);
            } else {
                if (animationWindoid_ != null) {
                    animationWindoid_.setVisible(false);
                }
                this.repaint();
            }
            this.enableActions(!animating);
            this.getPanMenuBar().refresh();
        });
    }

    private void enableActions(boolean enable) {
        Action a;
        if (enable) {
            if (this.hiddenActions_ == null) {
                return;
            }
            for (Action a2 : this.hiddenActions_) {
                if (a2 == null) continue;
                a2.setEnabled(true);
            }
            return;
        }
        this.hiddenActions_ = new ArrayList(75);
        PanMenuBar mbar = this.getPanMenuBar();
        if (mbar == null) {
            LOGGER.warn("mbar is null!");
            return;
        }
        GissMenu fileMenu = mbar.getMenuForName("file-menu");
        JMenuItem jmi = fileMenu.getItemForName("close-windoid");
        this.hiddenActions_.add(jmi.getAction());
        jmi = fileMenu.getItemForName("save-image");
        this.hiddenActions_.add(jmi.getAction());
        jmi = fileMenu.getItemForName("save-image-as");
        this.hiddenActions_.add(jmi.getAction());
        jmi = fileMenu.getItemForName("export-cl-script");
        this.hiddenActions_.add(jmi.getAction());
        Action a3 = fileMenu.getItemForName("export-kmz").getAction();
        if (a3 != null && a3.isEnabled()) {
            this.hiddenActions_.add(a3);
        }
        jmi = fileMenu.getItemForName("export-animation");
        this.hiddenActions_.add(jmi.getAction());
        jmi = fileMenu.getItemForName("print");
        this.hiddenActions_.add(jmi.getAction());
        GissMenu viewMenu = mbar.getMenuForName("view-menu");
        for (Component c : viewMenu.getMenuComponents()) {
            JMenuItem jmi2;
            if (!(c instanceof JMenuItem) || c instanceof JMenu || c instanceof JSeparator || (a = (jmi2 = (JMenuItem)c).getAction()) == null || !a.isEnabled()) continue;
            this.hiddenActions_.add(a);
        }
        GissMenu plotMenu = mbar.getMenuForName("plot-menu");
        for (Component c : plotMenu.getMenuComponents()) {
            if (c instanceof JMenu) {
                JMenu submenu = (JMenu)c;
                for (Component cc : submenu.getMenuComponents()) {
                    Action a4;
                    if (!(cc instanceof JMenuItem) || c instanceof JSeparator || (a4 = ((JMenuItem)cc).getAction()) == null || !a4.isEnabled()) continue;
                    this.hiddenActions_.add(a4);
                }
                continue;
            }
            if (!(c instanceof JMenuItem) || c instanceof JSeparator || (a = ((JMenuItem)c).getAction()) == null || !a.isEnabled()) continue;
            this.hiddenActions_.add(a);
        }
        GissMenu windowMenu = mbar.getMenuForName("window-menu");
        for (PanPlotControlsID cid : PanPlotControlsID.values()) {
            Action a5;
            JMenuItem jmi3 = windowMenu.getItemForName(cid.getActionKey());
            if (jmi3 == null || (a5 = jmi3.getAction()) == null || !a5.isEnabled()) continue;
            this.hiddenActions_.add(a5);
        }
        for (Action a6 : this.hiddenActions_) {
            a6.setEnabled(false);
        }
    }

    private void showReplaceArrayDialog(NcArray nca) {
        EventQueue.invokeLater(() -> {
            Object[] options = new String[]{"Replace Var 2", "Replace Var 1", "Cancel"};
            int choice = JOptionPane.showOptionDialog(this, "This plot already has two variables assigned\nto it. Should I replace one?", null, 1, 3, null, options, options[0]);
            if (choice == 0) {
                this.setArray(1, nca);
            } else if (choice == 1) {
                this.setArray(0, nca);
            } else if (choice == 2) {
                // empty if block
            }
            this.refreshActions();
        });
    }

    @Override
    public final void resizeToFitDisplay() {
        PanPlotGlass glass = (PanPlotGlass)this.getGlassPane();
        if (glass != null) {
            glass.setVisible(false);
            glass.setContentType(PanPlotGlass.ContentType.NONE);
        }
        Dimension psize = this.pmeta_.getLayout().getDimension("size.pixels");
        this.plotHolder_.setPreferredSize(null);
        Dimension phsize = this.plotHolder_.getPreferredSize();
        Insets vpins = this.plotSP_.getViewportBorder().getBorderInsets(this.plotSP_.getViewport());
        Dimension vpsize = new Dimension(vpins.left + phsize.width + vpins.right, vpins.top + phsize.height + vpins.bottom);
        Rectangle rr = this.isVisible() ? GuiUtils.getFrameScreenBounds(this) : GuiUtils.getActiveScreenBounds();
        Insets ins = this.isVisible() ? GuiUtils.getFrameScreenInsets(this) : GuiUtils.getActiveScreenInsets();
        int insW = Math.max(24, ins.left + ins.right);
        int insH = Math.max(24, ins.top + ins.bottom);
        int availW = rr.width - insW - 100;
        int availH = rr.height - insH - 150;
        Dimension dpsize = new Dimension(0, 0);
        for (PanArrayDataPanel panel : this.adataPanels_) {
            if (panel == null) continue;
            Dimension ddx = panel.getPreferredSize();
            dpsize.width = Math.max(dpsize.width, ddx.width);
            dpsize.height = Math.max(dpsize.height, ddx.height);
        }
        Dimension spsize = new Dimension(vpsize.width, vpsize.height);
        spsize.width = Math.min(spsize.width, availW);
        spsize.height = Math.min(spsize.height, availH);
        spsize.width = Math.max(spsize.width, dpsize.width);
        spsize.height = Math.max(spsize.height, dpsize.height);
        this.plotSP_.setMinimumSize(spsize);
        this.plotSP_.setMaximumSize(spsize);
        this.plotSP_.setPreferredSize(spsize);
        if (phsize.width < spsize.width - vpins.left - vpins.right) {
            phsize.width = spsize.width - vpins.left - vpins.right;
        }
        if (phsize.height < spsize.height - vpins.top - vpins.bottom) {
            phsize.height = spsize.height - vpins.top - vpins.bottom;
        }
        this.overHolder_.setPreferredSize(phsize);
        this.plotHolder_.setPreferredSize(phsize);
        this.plotHolder_.setBounds(0, 0, phsize.width, phsize.height);
        int pleft = (phsize.width - psize.width) / 2;
        int ptop = (phsize.height - psize.height) / 2;
        this.plot_.setLocation(pleft, ptop);
        this.contentBox_.invalidate();
        this.contentBox_.validate();
        this.pack();
        if (this.pseudoPA_ != null) {
            this.pseudoPA_.checkPseudoLocation();
        }
        this.repaint();
    }

    @Override
    public void refresh() {
        this.refreshActions();
        this.refreshPrivate();
        boolean animating = PanPlotFrame.isAnimationInProgress();
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof PanPlotFrame)) continue;
            ((PanPlotFrame)frame).enableActions(!animating);
        }
        super.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refreshActions() {
        PanPlotFrame panPlotFrame = this;
        synchronized (panPlotFrame) {
            PanMenuBar mbar = this.getPanMenuBar();
            if (mbar == null) {
                return;
            }
            JMenuItem jmi = mbar.getItemForName("plot-menu", "link-dimensions");
            Action a = jmi.getAction();
            if (a != null) {
                Component c = this.cPanels_.get(PanPlotControlsID.ARRAYS);
                if (c != null) {
                    a.setEnabled(((PanArrayControls)c).canLinkDimensions());
                } else {
                    a.setEnabled(false);
                }
            }
        }
    }

    private void refreshPrivate() {
        GissMenu viewMenu;
        Action a;
        PanMenuBar mbar;
        this.getPreferredSize();
        if (this.tabPane_ != null) {
            this.tabPane_.refresh();
        }
        if (this.adataPanels_[0] != null) {
            this.adataPanels_[0].refresh();
        }
        if (this.adataPanels_[1] != null) {
            this.adataPanels_[1].refresh();
        }
        if ((mbar = this.getPanMenuBar()) != null && (a = (viewMenu = mbar.getMenuForName("view-menu")).getItemForName("show-array-2").getAction()) != null) {
            boolean enabled = this.adataPanels_[1] != null;
            a.setEnabled(enabled);
        }
        if (this.plot_ instanceof PanLonLatPlot && !this.animating_) {
            PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
            try {
                PanActionHash actionHash = this.pmeta_.getActionHash();
                actionHash.setEnabled("export-kmz", true);
                actionHash.setEnabled("zoom-plot-in", projmeta.canZoomIn());
                actionHash.setEnabled("zoom-plot-out", projmeta.canZoomOut());
                actionHash.setEnabled("swap-xbounds", false);
                actionHash.setEnabled("include-axes", false);
            }
            catch (Exception exc) {
                LOGGER.trace("WTF. Oops, pardon my language. Exception: {}", (Object)exc.getMessage());
            }
        }
    }

    @Override
    public void close() {
        if (this.closing_) {
            return;
        }
        this.closing_ = true;
        if (this.animating_ && animationWindoid_ != null) {
            animationWindoid_.setVisible(false);
            animationWindoid_.dispose();
            animationWindoid_ = null;
        }
        this.animating_ = false;
        if (this.unifiedWindoid_ != null) {
            this.unifiedWindoid_.setVisible(false);
            this.unifiedWindoid_.dispose();
            this.unifiedWindoid_ = null;
        } else {
            for (PanPlotControlsID cid : this.cWindoids_.keySet()) {
                PanPlotWindoid cw = this.cWindoids_.get(cid);
                if (cw == null) continue;
                cw.setVisible(false);
                cw.dispose();
            }
            this.cWindoids_.clear();
        }
        if (this.contentBox_ != null) {
            this.contentBox_.removeAll();
        }
        if (this.mouseAdapter_ != null) {
            this.mouseAdapter_.flush();
        }
        if (this.plotHolder_ != null) {
            this.plotHolder_.flush();
        }
        if (this.overHolder_ != null) {
            this.overHolder_.removeAll();
        }
        if (this.plotSP_ != null) {
            this.plotSP_.removeAll();
        }
        if (this.pmeta_ != null) {
            this.pmeta_.flush();
        }
        if (this.tabPane_ != null) {
            this.tabPane_.removeAll();
        }
        if (this.plot_ != null) {
            this.plot_.flush();
        }
        this.removeAll();
        this.contentBox_ = null;
        this.mouseAdapter_ = null;
        this.plotHolder_ = null;
        this.plotSP_ = null;
        this.adataPanels_[0] = null;
        this.adataPanels_[1] = null;
        this.plot_ = null;
        for (WindowListener windowListener : this.getWindowListeners()) {
            this.removeWindowListener(windowListener);
        }
        for (EventListener eventListener : this.getWindowFocusListeners()) {
            this.removeWindowFocusListener((WindowFocusListener)eventListener);
        }
        this.setPanMenuBar(null);
        this.dispose();
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        double scaleY = pf.getImageableWidth() / (double)this.plot_.getHeight();
        double scaleX = pf.getImageableHeight() / (double)this.plot_.getWidth();
        double scale = Math.min(scaleY, scaleX);
        double tranX = 0.5 * (pf.getImageableWidth() + scale * (double)this.plot_.getHeight());
        g2d.translate(pf.getImageableX() + tranX, pf.getImageableY());
        g2d.rotate(1.5707963267948966);
        g2d.scale(scale, scale);
        this.plot_.print(g2d);
        return 0;
    }

    @Override
    public GPrintable getPrintable() {
        return this.plot_;
    }

    public static PanPlotFrame[] getAllPlotFrames() {
        ArrayList<PanPlotFrame> fList = new ArrayList<PanPlotFrame>(20);
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof PanPlotFrame) || !frame.isVisible()) continue;
            fList.add((PanPlotFrame)frame);
        }
        fList.sort((frame1, frame2) -> frame1.getTitle().compareTo(frame2.getTitle()));
        return fList.toArray(new PanPlotFrame[0]);
    }

    public static int countVisibleFrames() {
        int count = 0;
        for (Frame f : Frame.getFrames()) {
            if (!(f instanceof PanPlotFrame) || !f.isVisible()) continue;
            ++count;
        }
        return count;
    }

    static {
        appInForeground_ = true;
        controlsEnabled_ = true;
        ctrlsLayout_ = PanPlotControlsMeta.isFloating() ? (PanPlotControlsMeta.isUnified() ? ControlsLayout.UNIFIED_WINDOID : ControlsLayout.MULTIPLE_WINDOIDS) : ControlsLayout.PSEUDO_PALETTE;
    }

    private class PseudoPaletteAdapter
    extends ComponentAdapter
    implements PaletteListener {
        PseudoPaletteAdapter() {
            PanPlotFrame.this.pseudoP_.addPaletteListener(this);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (!PanPlotFrame.this.isVisible()) {
                return;
            }
            this.checkPseudoLocation();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (!PanPlotFrame.this.isVisible()) {
                return;
            }
            this.checkPseudoLocation();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.checkPseudoLocation();
        }

        @Override
        public void paletteStateChanged(PaletteEvent e) {
            if (e == null) {
                LOGGER.trace("{}", (Object)e);
            } else {
                LOGGER.trace("{}", (Object)e.getID());
            }
            PanPlotFrame.this.getPanMenuBar().refresh();
            LOGGER.trace("done");
        }

        private void checkPseudoLocation() {
            Point pt = PanPlotFrame.this.pseudoP_.getLocation();
            Insets dsIns = PanPlotFrame.this.pseudoP_.getDropShadowInsets();
            int tbh = PanPlotFrame.this.pseudoP_.getTitlebarHeight();
            int pww = PanPlotFrame.this.pseudoP_.getWidth() - dsIns.left - dsIns.right;
            int sbw = Math.max(15, PanPlotFrame.this.plotSP_.getVerticalScrollBar().getWidth());
            int sbh = Math.max(15, PanPlotFrame.this.plotSP_.getHorizontalScrollBar().getHeight());
            Insets vpins = PanPlotFrame.this.plotSP_.getViewportBorder().getBorderInsets(PanPlotFrame.this.plotSP_.getViewport());
            int maxx = PanPlotFrame.this.plotSP_.getWidth() - sbw;
            int maxy = PanPlotFrame.this.plotSP_.getHeight() - sbh - vpins.top;
            boolean moveback = false;
            if (pt.x < 1 - dsIns.left) {
                pt.x = 1 - dsIns.left;
                moveback = true;
            }
            if (pt.x > maxx - pww) {
                pt.x = maxx - pww - 1;
                moveback = true;
            }
            if (pt.y < 1 - dsIns.top) {
                pt.y = 1 - dsIns.top;
                moveback = true;
            }
            if (pt.y > maxy - dsIns.bottom - tbh) {
                pt.y = maxy - dsIns.bottom - tbh;
                moveback = true;
            }
            if (moveback) {
                PanPlotFrame.this.pseudoP_.setLocation(pt);
            }
        }
    }

    public static enum ControlsLayout {
        MULTIPLE_WINDOIDS,
        UNIFIED_WINDOID,
        PSEUDO_PALETTE;

    }
}

