/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import gov.nasa.giss.panoply.prefs.PanExtraPrefsNode;
import gov.nasa.giss.panoply.util.PanPlotType;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanSavedSettings
extends PanExtraPrefsNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String name_;
    private PanPlotType ptype_;
    private final Hashtable<String, Object> settings_ = new Hashtable(50);
    private LocalDate calDate_;

    public PanSavedSettings(String name, PanPlotMeta pmeta) {
        this.name_ = name;
        this.ptype_ = pmeta.getType();
        this.initFromMeta(pmeta);
    }

    public PanSavedSettings(String name, PanSavedSettings pss) {
        this.name_ = name;
        this.ptype_ = pss.getPlotType();
        this.calDate_ = pss.getDate();
        ArrayList<String> keys = new ArrayList<String>(pss.keySet());
        for (String pkey : keys) {
            Object pvalue = pss.get(pkey);
            this.settings_.put(pkey, pvalue);
        }
    }

    public PanSavedSettings(Element group) {
        this.initFromXml(group);
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public void setName(String name) {
        this.name_ = name;
    }

    public LocalDate getDate() {
        return this.calDate_;
    }

    public String getDateString(boolean withDashes) {
        try {
            return withDashes ? this.calDate_.format(DateTimeFormatter.ISO_LOCAL_DATE) : this.calDate_.format(DateTimeFormatter.BASIC_ISO_DATE);
        }
        catch (Exception exc) {
            return "\u2014";
        }
    }

    public int size() {
        return this.settings_.size();
    }

    public boolean containsKey(String key) {
        return this.settings_.containsKey(key);
    }

    public Object get(String key) {
        return this.settings_.get(key);
    }

    public void remove(String key) {
        this.settings_.remove(key);
    }

    public PanPlotType getPlotType() {
        return this.ptype_;
    }

    public List<String> keySet() {
        Object[] keys = this.settings_.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        return new ArrayList<Object>(Arrays.asList(keys));
    }

    private void initFromMeta(PanPlotMeta pmeta) {
        Objects.requireNonNull(pmeta, "Plot meta object cannot be null.");
        this.calDate_ = LocalDate.now();
        for (String pkey : pmeta.keySet()) {
            if (pkey == null) {
                LOGGER.trace("Encountered null key");
                continue;
            }
            if (pkey.equals("ptype") || pkey.startsWith("beta")) continue;
            Object pvalue = pmeta.get(pkey);
            if (pvalue == null) {
                this.settings_.put(pkey, "null");
                continue;
            }
            this.settings_.put(pkey, pvalue);
        }
        if (this.ptype_.isLonLatMap()) {
            PanProjectionMeta projmeta = pmeta.getProjectionMeta();
            for (int i = 0; i < 5; ++i) {
                String k = "proj.xparam." + (i + 1);
                Object s = projmeta.getXParamValue(i);
                if (s == null) continue;
                this.settings_.put(k, s);
            }
        }
    }

    private void initFromXml(Element group) {
        try {
            this.name_ = group.getAttribute("name").getValue();
        }
        catch (Exception exc) {
            throw new RuntimeException("Unable to read settings group name.");
        }
        if (this.name_ == null) {
            throw new RuntimeException("Settings group has no name.");
        }
        String typeStr = null;
        try {
            typeStr = group.getAttribute("ptype").getValue();
        }
        catch (Exception exc) {
            throw new RuntimeException("Unable to read settings group plot type.");
        }
        if (typeStr == null) {
            throw new RuntimeException("Settings group has no plot type.");
        }
        this.ptype_ = PanPlotType.matching(typeStr);
        if (this.ptype_ == null) {
            throw new RuntimeException(String.format("No plot type matches '%s'.", typeStr));
        }
        try {
            String date = group.getAttribute("date").getValue();
            String ys = date.substring(0, 4);
            String ms = date.substring(4, 6);
            String ds = date.substring(6, 8);
            if (ms.charAt(0) == '0') {
                ms = ms.substring(1, 2);
            }
            if (ds.charAt(0) == '0') {
                ds = ds.substring(1, 2);
            }
            int yy = Integer.parseInt(ys);
            int mm = Integer.parseInt(ms);
            int dd = Integer.parseInt(ds);
            this.calDate_ = LocalDate.of(yy, mm, dd);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Element child : group.getChildren()) {
            String childName = child.getName();
            if ("property".equals(childName)) {
                this.readProperty(child);
                continue;
            }
            LOGGER.warn("Ignoring tag {}.", (Object)childName);
        }
    }

    private void readProperty(Element child) {
        String pkey = null;
        String pvalue = null;
        try {
            pkey = child.getAttribute("key").getValue();
        }
        catch (Exception exc) {
            LOGGER.warn("Unable to parse a setting 'key' property.");
            return;
        }
        if (pkey == null) {
            LOGGER.warn("Setting property has no key.");
            return;
        }
        try {
            pvalue = child.getAttribute("value").getValue();
        }
        catch (Exception exc) {
            LOGGER.warn("Unable to parse a setting 'value' property.");
            return;
        }
        if (pkey == null) {
            LOGGER.warn("Setting property has no value.");
            return;
        }
        this.settings_.put(pkey, pvalue);
    }

    final void write(Element parent) {
        Element gex = new Element("group");
        gex.setAttribute("name", this.getName());
        gex.setAttribute("ptype", this.getPlotType().name());
        gex.setAttribute("date", this.getDateString(false));
        ArrayList<String> keys = new ArrayList<String>(this.settings_.keySet());
        Collections.sort(keys);
        for (String pkey : keys) {
            Object pvalue = this.settings_.get(pkey);
            Element ex = new Element("property");
            ex.setAttribute("key", pkey);
            try {
                ex.setAttribute("value", pvalue.toString());
            }
            catch (Exception exc) {
                LOGGER.error("Exception writing setting {}, {}", (Object)pkey, (Object)exc.toString());
            }
            gex.addContent(ex);
        }
        parent.addContent(gex);
    }

    public int compareByType(PanSavedSettings o) {
        String type2;
        String type1 = this.ptype_.name();
        int tcompare = type1.compareTo(type2 = o.getPlotType().name());
        if (tcompare > 0) {
            return 1;
        }
        if (tcompare < 0) {
            return -1;
        }
        return this.compareByName(o);
    }

    public int compareByName(PanSavedSettings o) {
        return this.name_.compareTo(o.getName());
    }

    public int compareByDate(PanSavedSettings o) {
        String type2;
        String type1 = this.getDateString(false);
        int tcompare = type1.compareTo(type2 = o.getDateString(false));
        if (tcompare > 0) {
            return 1;
        }
        if (tcompare < 0) {
            return -1;
        }
        return this.compareByName(o);
    }

    public PanSavedSettings getCopy() {
        return new PanSavedSettings(this.getName() + " copy", this);
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public Object getObject() {
        return null;
    }
}

