/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.clut;

import gov.nasa.giss.graphics.clut.ColorTableEvent;
import gov.nasa.giss.graphics.clut.ColorTableListener;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;

public abstract class AbstractColorTable {
    private static final String PATH_SEP = System.getProperty("file.separator");
    protected static final Color UNDEFINED_COLOR = Color.LIGHT_GRAY;
    private URL url_;
    private String fname_;
    private String fext_;
    private int size_;
    private int maxSize_;
    private int maxIndex_;
    private boolean fixedSize_ = true;
    private Color[] colors_;
    private Color minOutlierColor_;
    private Color maxOutlierColor_;
    private Color nanColor_;
    private double rangeMin_ = Double.NaN;
    private double rangeMax_ = Double.NaN;
    private final ArrayList<ColorTableListener> listeners_ = new ArrayList(12);

    protected AbstractColorTable() {
    }

    protected void initiateFixedSizeArray(int size) {
        this.size_ = size;
        this.colors_ = new Color[size];
        this.maxIndex_ = size - 1;
        this.fixedSize_ = true;
        this.maxSize_ = this.size_;
    }

    protected void initiateVariableSizeArray(int size, int maxSize) {
        this.initiateFixedSizeArray(size);
        this.fixedSize_ = false;
        this.maxSize_ = maxSize;
    }

    public URL getURL() {
        return this.url_;
    }

    public void setURL(URL url) {
        this.url_ = Objects.requireNonNull(url, "URL cannot be null.");
        this.setName(url.getFile());
    }

    public String getName() {
        return this.fname_;
    }

    public void setName(String s) {
        this.fname_ = s;
        int lastSeparator = s.lastIndexOf(PATH_SEP);
        int lastSlash = s.lastIndexOf(47);
        if (lastSlash > lastSeparator) {
            lastSeparator = lastSlash;
        }
        this.fname_ = s.substring(lastSeparator + 1);
        int lastDot = this.fname_.lastIndexOf(46);
        this.fext_ = lastDot > -1 ? this.fname_.substring(lastDot + 1).toLowerCase() : null;
    }

    public String getType() {
        return this.fext_;
    }

    public void setType(String str) {
        Objects.requireNonNull(str, "Type cannot be null");
        this.fext_ = str.toLowerCase();
    }

    public String toString() {
        return this.getName();
    }

    public boolean canSave() {
        return false;
    }

    public boolean saveAs(File f) throws IOException {
        return false;
    }

    public abstract AbstractColorTable copy() throws IOException;

    public int getColorCount() {
        return this.size_;
    }

    public boolean hasOutlierColors() {
        return this.minOutlierColor_ != null && this.maxOutlierColor_ != null;
    }

    public Color getColorAt(int index) {
        if (index < 0 || index > this.size_) {
            throw new IndexOutOfBoundsException("Color index " + index + " is out of range.");
        }
        return this.colors_[index];
    }

    public Color getColorAt(int index, boolean flipped) {
        if (index < 0 || index > this.size_) {
            throw new IndexOutOfBoundsException("Color index " + index + " is out of range.");
        }
        if (flipped) {
            return this.colors_[this.maxIndex_ - index];
        }
        return this.colors_[index];
    }

    public void setColorAt(int index, Color c) {
        if (index < 0 || index >= this.size_) {
            throw new IllegalArgumentException("Bad color table entry number");
        }
        this.colors_[index] = c;
        this.fireTableChanged("Color " + index + " changed.");
    }

    public int getRgbAt(int index) {
        return this.getRgbAt(index, false);
    }

    public int getRgbAt(int index, boolean flipped) {
        if (index < 0 || index > this.size_) {
            throw new IndexOutOfBoundsException("Color index " + index + " is out of range.");
        }
        if (flipped) {
            return this.colors_[this.maxIndex_ - index].getRGB();
        }
        return this.colors_[index].getRGB();
    }

    public float[] getHsbAt(int index, boolean flipped) {
        if (index < 0 || index > this.size_) {
            throw new IndexOutOfBoundsException("Color index " + index + " is out of range.");
        }
        Color c = flipped ? this.colors_[this.maxIndex_ - index] : this.colors_[index];
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        return hsb;
    }

    public boolean canInsertColor() {
        if (this.fixedSize_) {
            return false;
        }
        return this.size_ < this.maxSize_;
    }

    public void insertColorAt(int index, Color c) {
        int i;
        if (this.fixedSize_) {
            throw new IllegalArgumentException("Color table format does not allow for insertions.");
        }
        if (index < 0 || index > this.size_) {
            throw new IndexOutOfBoundsException("Color index " + index + " is out of range.");
        }
        if (this.maxSize_ > -1 && this.size_ >= this.maxSize_) {
            throw new IllegalArgumentException("Cannot add any more colors.");
        }
        ++this.size_;
        Color[] newArray = new Color[this.size_];
        for (i = 0; i < index; ++i) {
            newArray[i] = this.colors_[i];
        }
        newArray[index] = c;
        for (i = index + 1; i < this.size_; ++i) {
            newArray[i] = this.colors_[i - 1];
        }
        this.maxIndex_ = this.size_ - 1;
        this.colors_ = newArray;
        this.fireTableChanged("Color inserted at index " + index + ".");
    }

    public boolean canDeleteColor() {
        if (this.fixedSize_) {
            return false;
        }
        return this.size_ > 0;
    }

    public Color deleteColorAt(int index) {
        int i;
        if (this.fixedSize_) {
            throw new IllegalArgumentException("Color table format does not allow for deletions.");
        }
        if (index < 0 || index >= this.size_) {
            throw new IndexOutOfBoundsException("Color index " + index + " is out of range.");
        }
        if (this.size_ < 2) {
            throw new IllegalArgumentException("Cannot delete last remaining color.");
        }
        --this.size_;
        Color[] newArray = new Color[this.size_];
        Color victim = this.colors_[index];
        for (i = 0; i < index; ++i) {
            newArray[i] = this.colors_[i];
        }
        for (i = index; i < this.size_; ++i) {
            newArray[i] = this.colors_[i + 1];
        }
        this.maxIndex_ = this.size_ - 1;
        this.colors_ = newArray;
        return victim;
    }

    public Color getMinOutlierColor() {
        if (this.minOutlierColor_ != null) {
            return this.minOutlierColor_;
        }
        return this.colors_[0];
    }

    public int getMinOutlierRgb() {
        if (this.minOutlierColor_ != null) {
            return this.minOutlierColor_.getRGB();
        }
        return this.colors_[0].getRGB();
    }

    public Color getMinOutlierColor(boolean flipped) {
        if (flipped) {
            return this.getMaxOutlierColor();
        }
        return this.getMinOutlierColor();
    }

    public int getMinOutlierRgb(boolean flipped) {
        if (flipped) {
            return this.getMaxOutlierRgb();
        }
        return this.getMinOutlierRgb();
    }

    public void setMinOutlierColor(Color c) {
        this.minOutlierColor_ = c;
        this.fireTableChanged("Min outlier color set.");
    }

    public Color getMaxOutlierColor() {
        if (this.maxOutlierColor_ != null) {
            return this.maxOutlierColor_;
        }
        return this.colors_[this.maxIndex_];
    }

    public int getMaxOutlierRgb() {
        if (this.maxOutlierColor_ != null) {
            return this.maxOutlierColor_.getRGB();
        }
        return this.colors_[this.maxIndex_].getRGB();
    }

    public Color getMaxOutlierColor(boolean flipped) {
        if (flipped) {
            return this.getMinOutlierColor();
        }
        return this.getMaxOutlierColor();
    }

    public int getMaxOutlierRgb(boolean flipped) {
        if (flipped) {
            return this.getMinOutlierRgb();
        }
        return this.getMaxOutlierRgb();
    }

    public void setMaxOutlierColor(Color c) {
        this.maxOutlierColor_ = c;
        this.fireTableChanged("Max outlier color set.");
    }

    public boolean hasNanColor() {
        return this.nanColor_ != null;
    }

    public Color getNanColor() {
        return this.nanColor_;
    }

    public void setNanColor(Color c) {
        this.nanColor_ = c;
    }

    public int getNanRGB() {
        if (this.nanColor_ != null) {
            return this.nanColor_.getRGB();
        }
        return 0;
    }

    public boolean hasRangeLimits() {
        return !Double.isNaN(this.rangeMin_) && !Double.isNaN(this.rangeMax_);
    }

    public double getRangeMinimum() {
        return this.rangeMin_;
    }

    public void setRangeMinimum(double d) {
        this.rangeMin_ = d;
        this.fireTableChanged("Range minimum set.");
    }

    public double getRangeMaximum() {
        return this.rangeMax_;
    }

    public void setRangeMaximum(double d) {
        this.rangeMax_ = d;
        this.fireTableChanged("Range maximum set.");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractColorTable)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return ((AbstractColorTable)obj).getURL().equals(this.getURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColorTableListener(ColorTableListener ll) {
        ArrayList<ColorTableListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            this.listeners_.add(ll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeColorTableListener(ColorTableListener ll) {
        ArrayList<ColorTableListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            this.listeners_.remove(ll);
        }
    }

    public synchronized void removeColorTableListeners() {
        this.listeners_.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void fireTableChanged(String msg) {
        ColorTableEvent e = new ColorTableEvent(this, msg);
        ArrayList<ColorTableListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            int isize = this.listeners_.size();
            if (isize > 0) {
                for (int i = isize - 1; i >= 0; --i) {
                    this.listeners_.get(i).colorTableChanged(e);
                }
            }
        }
    }
}

