/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.Interruption;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InterruptedPseudocylindric
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int PROPERTIES = 0x1000008;
    private Interruption interruption_ = Interruption.UNINT;
    private final ProjListParameter interruptParam_;
    protected double cylindricLatLimit_;

    public InterruptedPseudocylindric(String name, int properties, int width, int height, int xmargin, int ymargin, double widthFactor, double heightFactor) {
        super(name, properties, width, height, xmargin, ymargin, widthFactor, heightFactor);
        if (!this.hasProperty(8) || !this.hasProperty(0x1000000)) {
            throw new IllegalArgumentException("Subclassed projection does not specify INTERRUPTED & PSEUDOCYLINDRIC properties.");
        }
        this.interruptParam_ = new ProjListParameter("Scheme for interruption lobes/gores", "Format", Interruption.class, 0);
        this.addParameter(this.interruptParam_);
    }

    @Override
    public void setCenter(double lon, double lat) {
        if (this.interruption_ == null || this.interruption_ == Interruption.UNINT) {
            super.setCenter(lon, 0.0);
        } else {
            super.setCenter(this.interruption_.getCenterLongitude(), 0.0);
        }
    }

    public ProjListParameter getInterruptionParameter() {
        return this.interruptParam_;
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.interruptParam_)) {
            this.setInterruption(this.interruptParam_.getIndex());
        } else {
            LOGGER.trace("Param not handled by InterruptedPseudocylindric, Perhaps a subclass does so.");
        }
        this.autoscale();
        if (!this.isRecenterableLon()) {
            this.setCenter(999.0, 0.0);
        }
    }

    private void setInterruption(int choice) {
        this.interruption_ = Interruption.values()[choice];
    }

    public boolean isInterrupted() {
        return this.interruption_ != Interruption.UNINT;
    }

    @Override
    public boolean isRecenterableLon() {
        return !this.isInterrupted();
    }

    @Override
    public boolean isRecenterableLat() {
        return false;
    }

    @Override
    public boolean canLabelGrid() {
        return !this.isInterrupted();
    }

    protected double getLongitudeForX(double x, double xFactorAtLat, double xFactorAtEq, boolean north) {
        double clon;
        double cx;
        double dclon;
        if (this.isRecenterableLon()) {
            double lambdaRad = x * xFactorAtLat;
            if (Math.abs(lambdaRad) > Math.PI) {
                return Double.NaN;
            }
            return this.lambdaC_ + Math.toDegrees(lambdaRad);
        }
        double elon = Math.toDegrees(x * xFactorAtEq);
        if (Math.abs(elon) > 180.0) {
            return Double.NaN;
        }
        double[] gore = this.getGore(elon += this.lambdaC_, north ? 1.0 : -1.0);
        double dlon1 = gore[1] - gore[0];
        double dlon2 = gore[2] - gore[1];
        if (dlon1 < 0.0) {
            dlon1 += 360.0;
        }
        if (dlon2 < 0.0) {
            dlon2 += 360.0;
        }
        if ((dclon = Math.toDegrees((x - (cx = this.lonToLambdaRad(clon = gore[1]) / xFactorAtEq)) * xFactorAtLat)) + dlon1 < 0.0) {
            return Double.NaN;
        }
        if (dclon - dlon2 > 0.0) {
            return Double.NaN;
        }
        return dclon + clon;
    }

    protected double[][][] getGores() {
        return this.interruption_.getGores();
    }

    protected double[] getGore(double lon, double lat) {
        double[][] hemigores;
        double nlon = MapUtils.normalizeMP180(lon);
        double[] gore = null;
        double[][] dArray = hemigores = lat >= 0.0 ? this.getGores()[0] : this.getGores()[1];
        if (hemigores.length == 1) {
            gore = new double[]{hemigores[0][0], hemigores[0][1], hemigores[0][2]};
        } else {
            for (int i = 0; i < hemigores.length; ++i) {
                boolean wraps;
                boolean bl = wraps = hemigores[i][2] < hemigores[i][0];
                if (wraps) {
                    if (!(nlon >= hemigores[i][0]) && !(nlon <= hemigores[i][2])) continue;
                    gore = new double[]{hemigores[i][0], hemigores[i][1], hemigores[i][2]};
                    break;
                }
                if (!(nlon >= hemigores[i][0]) || !(nlon <= hemigores[i][2])) continue;
                gore = new double[]{hemigores[i][0], hemigores[i][1], hemigores[i][2]};
                break;
            }
            if (gore == null) {
                gore = new double[]{hemigores[0][0], hemigores[0][1], hemigores[0][2]};
            }
        }
        if (gore[1] < gore[0]) {
            gore[1] = gore[1] + 360.0;
        }
        if (gore[2] <= gore[0]) {
            gore[2] = gore[2] + 360.0;
        }
        if (nlon < gore[0]) {
            gore[0] = gore[0] - 360.0;
            gore[1] = gore[1] - 360.0;
            gore[2] = gore[2] - 360.0;
        } else if (nlon > gore[2]) {
            gore[0] = gore[0] + 360.0;
            gore[1] = gore[1] + 360.0;
            gore[2] = gore[2] + 360.0;
        }
        return gore;
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.isInterrupted()) {
            this.drawBorderLinesInterrupted(g2d);
        } else {
            this.drawBorderLinesUninterrupted(g2d);
        }
    }

    protected void drawBorderLinesUninterrupted(Graphics2D g2d) {
        try {
            double leftLon = this.lambdaC_ - 179.99999;
            double rightLon = this.lambdaC_ + 179.99999;
            if (this.cylindricLatLimit_ > 0.0) {
                Point2D.Double dotWN = this.transformLL2XY(leftLon, this.cylindricLatLimit_);
                Point2D.Double dotWS = this.transformLL2XY(leftLon, -this.cylindricLatLimit_);
                Point2D.Double dotEN = this.transformLL2XY(rightLon, this.cylindricLatLimit_);
                Point2D.Double dotES = this.transformLL2XY(rightLon, -this.cylindricLatLimit_);
                GraphicUtils.drawLine(g2d, dotWN, dotWS);
                GraphicUtils.drawLine(g2d, dotEN, dotES);
            }
            this.drawMeridianCurve(g2d, leftLon, 90.0, this.cylindricLatLimit_, 90.0);
            this.drawMeridianCurve(g2d, leftLon, 90.0, -this.cylindricLatLimit_, -90.0);
            this.drawMeridianCurve(g2d, rightLon, 90.0, this.cylindricLatLimit_, 90.0);
            this.drawMeridianCurve(g2d, rightLon, 90.0, -this.cylindricLatLimit_, -90.0);
            Point2D.Double dot1 = this.transformLL2XY(this.lambdaC_ + 179.99999, 90.0);
            Point2D.Double dot2 = this.transformLL2XY(this.lambdaC_ - 179.99999, 90.0);
            if (dot1.x != dot2.x) {
                Path2D.Double polePath = new Path2D.Double();
                dot1 = this.transformLL2XY(leftLon, 89.99999);
                dot2 = this.transformLL2XY(rightLon, 89.99999);
                polePath.moveTo(dot1.x, dot1.y);
                polePath.lineTo(dot2.x, dot2.y);
                dot1 = this.transformLL2XY(leftLon, -89.99999);
                dot2 = this.transformLL2XY(rightLon, -89.99999);
                polePath.moveTo(dot1.x, dot1.y);
                polePath.lineTo(dot2.x, dot2.y);
                g2d.draw(polePath);
            }
        }
        catch (Exception exc) {
            LOGGER.trace("Exc drawing uninterrupted border: {}", (Object)exc.getClass().getSimpleName());
        }
    }

    protected void drawBorderLinesInterrupted(Graphics2D g2d) {
        Point2D.Double dot2;
        int ii;
        double[][] north = this.getGores()[0];
        double[][] south = this.getGores()[1];
        boolean hasPoleLine = false;
        Point2D.Double dot1 = this.transformLL2XY(north[0][0], 90.0);
        Point2D.Double dot22 = this.transformLL2XY(north[0][2], 90.0);
        double diff = Math.abs(dot1.x - dot22.x);
        hasPoleLine = diff > 1.0E-5;
        Path2D.Double polePath = new Path2D.Double();
        for (ii = 0; ii < north.length; ++ii) {
            if (ii == 0 || this.cylindricLatLimit_ == 0.0) {
                this.drawMeridianCurve(g2d, north[ii][0] + 1.0E-5, 90.0, 0.0, 90.0);
            } else {
                this.drawMeridianCurve(g2d, north[ii][0] + 1.0E-5, 90.0, this.cylindricLatLimit_, 90.0);
            }
            if (ii == north.length - 1 || this.cylindricLatLimit_ == 0.0) {
                this.drawMeridianCurve(g2d, north[ii][2] - 1.0E-5, 90.0, 0.0, 90.0);
            } else {
                this.drawMeridianCurve(g2d, north[ii][2] - 1.0E-5, 90.0, this.cylindricLatLimit_, 90.0);
            }
            if (!hasPoleLine) continue;
            Point2D.Double dot12 = this.transformLL2XY(north[ii][0] + 1.0E-5, 89.99999);
            dot2 = this.transformLL2XY(north[ii][2] - 1.0E-5, 89.99999);
            polePath.moveTo(dot12.x, dot12.y);
            polePath.lineTo(dot2.x, dot2.y);
        }
        for (ii = 0; ii < south.length; ++ii) {
            if (ii == 0 || this.cylindricLatLimit_ == 0.0) {
                this.drawMeridianCurve(g2d, south[ii][0] + 1.0E-5, 90.0, -90.0, 0.0);
            } else {
                this.drawMeridianCurve(g2d, south[ii][0] + 1.0E-5, 90.0, -90.0, -this.cylindricLatLimit_);
            }
            if (ii == south.length - 1 || this.cylindricLatLimit_ == 0.0) {
                this.drawMeridianCurve(g2d, south[ii][2] - 1.0E-5, 90.0, -90.0, 0.0);
            } else {
                this.drawMeridianCurve(g2d, south[ii][2] - 1.0E-5, 90.0, -90.0, -this.cylindricLatLimit_);
            }
            if (!hasPoleLine) continue;
            Point2D.Double dot13 = this.transformLL2XY(south[ii][0] + 1.0E-5, -89.99999);
            dot2 = this.transformLL2XY(south[ii][2] - 1.0E-5, -89.99999);
            polePath.moveTo(dot13.x, dot13.y);
            polePath.lineTo(dot2.x, dot2.y);
        }
        if (hasPoleLine) {
            g2d.draw(polePath);
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (this.isInterrupted()) {
            this.drawParallelInterrupted(g2d, lat);
        } else {
            this.drawParallelUninterrupted(g2d, lat, label);
        }
    }

    private void drawParallelUninterrupted(Graphics2D g2d, double lat, String label) {
        double llon = this.lambdaC_ - 179.99999;
        double rlon = this.lambdaC_ + 179.99999;
        Point2D.Double dot1 = this.transformLL2XY(llon, lat);
        Point2D.Double dot2 = this.transformLL2XY(rlon, lat);
        if (label == null || label.length() == 0) {
            GraphicUtils.drawLine(g2d, dot1, dot2);
            return;
        }
        Graphics2D g2x = (Graphics2D)g2d.create();
        FontMetrics fm = g2x.getFontMetrics();
        int w = fm.stringWidth(label);
        int des = fm.getDescent();
        int fh = fm.getHeight();
        int fh2 = fh / 2;
        int fh4 = fh / 4;
        float labelx = (float)(dot2.x - (double)fh2 - (double)w);
        g2x.drawString(label, labelx, (float)(dot1.y + (double)fh2 - (double)(0.5f * (float)des)));
        Shape oldclip = g2x.getClip();
        if (oldclip == null) {
            oldclip = this.getMarginRectClose();
        }
        Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, dot1.y - (double)fh2, w + fh2, fh);
        Area clipArea = new Area(oldclip);
        Area textArea = new Area(textRect);
        clipArea.subtract(textArea);
        g2x.setClip(clipArea);
        GraphicUtils.drawLine(g2x, dot1, dot2);
        g2x.dispose();
    }

    private void drawParallelInterrupted(Graphics2D g2d, double lat) {
        if (lat == 0.0 || Math.abs(lat) <= this.cylindricLatLimit_) {
            double llon = this.lambdaC_ - 179.99999;
            double rlon = this.lambdaC_ + 179.99999;
            Point2D.Double dot1 = this.transformLL2XY(llon, lat);
            Point2D.Double dot2 = this.transformLL2XY(rlon, lat);
            if (dot1 == null) {
                LOGGER.debug("Leftmost dot is null for lat {}, lon {}", (Object)lat, (Object)llon);
                return;
            }
            if (dot2 == null) {
                LOGGER.debug("Rightmost dot is null for lat {}, lon {}", (Object)lat, (Object)rlon);
                return;
            }
            GraphicUtils.drawLine(g2d, dot1, dot2);
            return;
        }
        Path2D.Double path = new Path2D.Double();
        if (lat > 0.0) {
            double[][] north = this.getGores()[0];
            for (int ii = 0; ii < north.length; ++ii) {
                Point2D.Double dot1 = this.transformLL2XY(north[ii][0] + 1.0E-5, lat);
                Point2D.Double dot2 = this.transformLL2XY(north[ii][2] - 1.0E-5, lat);
                if (dot1 == null || dot2 == null) continue;
                path.moveTo(dot1.x, dot1.y);
                path.lineTo(dot2.x, dot2.y);
            }
        } else {
            double[][] south = this.getGores()[1];
            for (int ii = 0; ii < south.length; ++ii) {
                Point2D.Double dot1 = this.transformLL2XY(south[ii][0] + 1.0E-5, lat);
                Point2D.Double dot2 = this.transformLL2XY(south[ii][2] - 1.0E-5, lat);
                if (dot1 == null || dot2 == null) continue;
                path.moveTo(dot1.x, dot1.y);
                path.lineTo(dot2.x, dot2.y);
            }
        }
        g2d.draw(path);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (absLambda > 179.99999) {
            return;
        }
        if (this.isInterrupted()) {
            this.drawMeridianInterrupted(g2d, lon, maxLat);
        } else {
            if (label == null || label.length() == 0) {
                this.drawMeridianUninterrupted(g2d, lon, maxLat);
                return;
            }
            Point2D.Double dot1 = this.transformLL2XY(lon, -62.0);
            Point2D.Double dot2 = this.transformLL2XY(lon, -64.5);
            if (dot1 == null || dot2 == null) {
                return;
            }
            double xave = 0.5 * (dot1.x + dot2.x);
            float ybot = (float)dot2.y;
            FontMetrics fm = g2d.getFontMetrics();
            int w = fm.stringWidth(label);
            int des = fm.getDescent();
            int fh = fm.getHeight();
            int fh2 = fh / 2;
            int fh4 = fh / 4;
            float labelx = (float)(xave - 0.5 * (double)w);
            g2d.drawString(label, labelx, ybot - (float)des);
            Graphics2D g2x = (Graphics2D)g2d.create();
            Shape oldclip = g2x.getClip();
            if (oldclip == null) {
                oldclip = this.getMarginRectClose();
            }
            Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, ybot - (float)fh, w + fh2, fh);
            Area clipArea = new Area(oldclip);
            Area textArea = new Area(textRect);
            clipArea.subtract(textArea);
            g2x.setClip(clipArea);
            this.drawMeridianUninterrupted(g2x, lon, maxLat);
            g2x.dispose();
        }
    }

    protected void drawMeridianUninterrupted(Graphics2D g2d, double lon, double maxLat) {
        Point2D.Double dotEq = this.transformLL2XY(lon, 0.0);
        Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
        Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
        if (Math.abs(dotN.x - dotS.x) < 1.0E-5 && Math.abs(dotN.x - dotEq.x) < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
            return;
        }
        if (this.cylindricLatLimit_ > 0.0) {
            dotN = this.transformLL2XY(lon, this.cylindricLatLimit_);
            dotS = this.transformLL2XY(lon, -this.cylindricLatLimit_);
            this.drawMeridianCurve(g2d, lon, maxLat, -90.0, -this.cylindricLatLimit_);
            GraphicUtils.drawLine(g2d, dotS, dotN);
            this.drawMeridianCurve(g2d, lon, maxLat, this.cylindricLatLimit_, 90.0);
        } else {
            this.drawMeridianCurve(g2d, lon, maxLat, -90.0, 90.0);
        }
    }

    protected void drawMeridianInterrupted(Graphics2D g2d, double lon, double maxLat) {
        this.drawMeridianInterrupted(g2d, lon, maxLat, true, true, true);
    }

    private void drawMeridianInterrupted(Graphics2D g2d, double lon, double maxLat, boolean drawNorth, boolean drawSouth, boolean skipIfBorder) {
        Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
        Point2D.Double dotEq = this.transformLL2XY(lon, 0.0);
        Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
        if (dotN == null) {
            LOGGER.debug("Got null NP dot for lon {}", (Object)lon);
            return;
        }
        if (dotEq == null) {
            LOGGER.debug("Got null EQ dot for lon {}", (Object)lon);
            return;
        }
        if (dotS == null) {
            LOGGER.debug("Got null SP dot for lon {}", (Object)lon);
            return;
        }
        if (drawNorth && drawSouth && Math.abs(dotN.x - dotS.x) < 1.0E-5 && Math.abs(dotN.x - dotEq.x) < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
            return;
        }
        for (int i = 0; i < 2; ++i) {
            if (i == 0 && !drawNorth || i == 1 && !drawSouth) continue;
            if (i == 0) {
                if (Math.abs(dotN.x - dotEq.x) < 1.0E-5) {
                    GraphicUtils.drawLine(g2d, dotN, dotEq);
                    continue;
                }
            } else if (Math.abs(dotS.x - dotEq.x) < 1.0E-5) {
                GraphicUtils.drawLine(g2d, dotEq, dotS);
                continue;
            }
            if (this.cylindricLatLimit_ > 0.0) {
                if (i == 0) {
                    Point2D.Double dotNx = this.transformLL2XY(lon, this.cylindricLatLimit_);
                    GraphicUtils.drawLine(g2d, dotEq, dotNx);
                } else {
                    Point2D.Double dotSx = this.transformLL2XY(lon, -this.cylindricLatLimit_);
                    GraphicUtils.drawLine(g2d, dotSx, dotEq);
                }
            }
            double[] gore = i == 0 ? this.getGore(lon, 45.0) : this.getGore(lon, -45.0);
            double llon = gore[0];
            double rlon = gore[2];
            if (skipIfBorder) {
                double dleft = MapUtils.normalizeMP180(lon - llon);
                double dright = MapUtils.normalizeMP180(lon - rlon);
                if (Math.abs(dleft) < 1.0E-5 || Math.abs(dright) < 1.0E-5) continue;
            }
            if (i == 0) {
                this.drawMeridianCurve(g2d, lon, maxLat, this.cylindricLatLimit_, 90.0);
                continue;
            }
            this.drawMeridianCurve(g2d, lon, maxLat, -this.cylindricLatLimit_, -90.0);
        }
    }

    private void drawMeridianCurve(Graphics2D g2d, double lon, double maxLat, double fromLat, double toLat) {
        Point2D.Double pt;
        double latSouth = Math.max(-maxLat, Math.min(fromLat, toLat));
        double latNorth = Math.min(maxLat, Math.max(fromLat, toLat));
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>(1000);
        double lat = latSouth;
        while (lat < latNorth) {
            pt = this.transformLL2XY(lon, lat);
            if (pt == null) {
                LOGGER.trace("null pt at LL {},{}", (Object)lon, (Object)lat);
            }
            pts.add(pt);
            if (Math.abs(lat) > 89.0) {
                lat += 0.1;
                continue;
            }
            if (Math.abs(lat) > 85.0) {
                lat += 0.25;
                continue;
            }
            lat += 0.4;
        }
        pt = this.transformLL2XY(lon, latNorth);
        pts.add(pt);
        try {
            ProjGraphicUtils.drawBezier(g2d, pts);
        }
        catch (Exception exc) {
            LOGGER.warn("Exception drawing meridian {}, btw {} and {}", lon, fromLat, toLat);
        }
    }
}

