/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.math;

import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Circles {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static Point2D.Double[] getIntersectionPoints(double x0, double y0, double r0, double x1, double y1, double r1) {
        if (x0 == x1 && y0 == y1 && r0 == r1) {
            return new Point2D.Double[0];
        }
        double dx = x1 - x0;
        double dy = y1 - y0;
        double dSq = dx * dx + dy * dy;
        double dd = Math.sqrt(dSq);
        if (dd > r0 + r1) {
            return new Point2D.Double[0];
        }
        if (dd < Math.abs(r1 - r0)) {
            return new Point2D.Double[0];
        }
        double r0Sq = r0 * r0;
        double aa = (r0Sq - r1 * r1 + dSq) / (2.0 * dd);
        double hSq = r0Sq - aa * aa;
        double hh = Math.sqrt(hSq);
        double aOverD = aa / dd;
        double hOverD = hh / dd;
        double x2 = x0 + (x1 - x0) * aOverD;
        double y2 = y0 + (y1 - y0) * aOverD;
        double x3a = x2 + (y1 - y0) * hOverD;
        double x3b = x2 - (y1 - y0) * hOverD;
        double y3a = y2 - (x1 - x0) * hOverD;
        double y3b = y2 + (x1 - x0) * hOverD;
        Point2D.Double p3a = new Point2D.Double(x3a, y3a);
        Point2D.Double p3b = new Point2D.Double(x3b, y3b);
        return new Point2D.Double[]{p3a, p3b};
    }

    public static Point2D.Double getCenter(Point2D.Double dot1, Point2D.Double dot2, Point2D.Double dot3) {
        return Circles.getCenter(dot1.x, dot1.y, dot2.x, dot2.y, dot3.x, dot3.y);
    }

    public static Point2D.Double getCenter(double x1, double y1, double x2, double y2, double x3, double y3) {
        if (x1 == x2 && y1 == y2) {
            throw new IllegalArgumentException("Coordinate pairs 1 and 2 are the same.");
        }
        if (x1 == x3 && y1 == y3) {
            throw new IllegalArgumentException("Coordinate pairs 1 and 3 are the same.");
        }
        if (x2 == x3 && y2 == y3) {
            throw new IllegalArgumentException("Coordinate pairs 2 and 3 are the same.");
        }
        double ltest = Math.abs(x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2));
        if (ltest < 1.0E-9) {
            if (x2 > x1 && x2 > x3 || x2 < x1 && x2 < x3) {
                throw new IllegalArgumentException("Coordinate pairs are all on the same line, but not in order.");
            }
            return null;
        }
        double dd = 2.0 * (x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2));
        if (dd == 0.0) {
            return null;
        }
        double x0 = ((x1 * x1 + y1 * y1) * (y2 - y3) + (x2 * x2 + y2 * y2) * (y3 - y1) + (x3 * x3 + y3 * y3) * (y1 - y2)) / dd;
        double y0 = ((x1 * x1 + y1 * y1) * (x3 - x2) + (x2 * x2 + y2 * y2) * (x1 - x3) + (x3 * x3 + y3 * y3) * (x2 - x1)) / dd;
        return new Point2D.Double(x0, y0);
    }

    public static Arc2D.Double getArc(double x1, double y1, double x2, double y2, double x3, double y3) {
        double a1;
        Point2D.Double dot0 = Circles.getCenter(x1, y1, x2, y2, x3, y3);
        if (dot0 == null) {
            return null;
        }
        double x0 = dot0.x;
        double y0 = dot0.y;
        double dx1 = x1 - x0;
        double dy1 = y1 - y0;
        double dx2 = x2 - x0;
        double dy2 = y2 - y0;
        double dx3 = x3 - x0;
        double dy3 = y3 - y0;
        double rr = Math.sqrt(dx1 * dx1 + dy1 * dy1);
        double a2 = Math.toDegrees(Math.atan2(-dy2, dx2));
        double a3 = Math.toDegrees(Math.atan2(-dy3, dx3));
        for (a1 = Math.toDegrees(Math.atan2(-dy1, dx1)); a1 < 0.0; a1 += 360.0) {
        }
        while (a2 < 0.0) {
            a2 += 360.0;
        }
        while (a3 < 0.0) {
            a3 += 360.0;
        }
        while (a2 < a1) {
            a2 += 360.0;
        }
        while (a3 < a1) {
            a3 += 360.0;
        }
        double aa = 0.0;
        aa = a3 > a2 ? a3 - a1 : a3 - a1 - 360.0;
        Arc2D.Double arc = new Arc2D.Double();
        arc.setArcByCenter(x0, y0, rr, a1, aa, 0);
        return arc;
    }

    private Circles() {
    }
}

