/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanPlotUnifiedPseudoPalette;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanTogglePseudoPaletteAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final PanPlotFrame pframe_;
    private double last_;

    public PanTogglePseudoPaletteAction(PanPlotFrame pframe) {
        this.pframe_ = pframe;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        long now = System.currentTimeMillis();
        if ((double)now - this.last_ < 200.0) {
            LOGGER.debug("Too soon, {}; probable double-fire; do nothing", (Object)((double)now - this.last_));
        } else {
            LOGGER.trace("toggling");
            PanPlotUnifiedPseudoPalette upp = this.pframe_.getPseudoPalette();
            upp.setExpanded(!upp.isExpanded());
        }
        this.last_ = now;
        this.pframe_.getPanMenuBar().refresh();
    }
}

