/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.text.PrintfFormat;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.lang.invoke.MethodHandles;
import java.text.AttributedString;
import java.text.DecimalFormatSymbols;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanStringUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PrintfFormat PFORMAT_10G = new PrintfFormat("%.10g");
    private static final Pattern ONE_TIMES_TEN_PATTERN = Pattern.compile("\\D1\u00d710");

    public static final boolean isNoneString(String str) {
        return "none".equalsIgnoreCase(str) || "<none>".equalsIgnoreCase(str) || "<null>".equalsIgnoreCase(str) || "".equals(str) || str == null;
    }

    public static AttributedString convertENotationToSuperscript(String instr, Graphics2D g2d) {
        return PanStringUtils.convertENotationToSuperscript(instr, g2d.getFont());
    }

    public static AttributedString convertENotationToSuperscript(String instr, Font font) {
        int patternIdx;
        Matcher matcher;
        Object outstr;
        Objects.requireNonNull(instr, "String cannot be null.");
        if (instr == null || instr.length() < 1) {
            AttributedString astr = new AttributedString("");
            astr.addAttribute(TextAttribute.FAMILY, font.getFontName());
            astr.addAttribute(TextAttribute.SIZE, Float.valueOf(font.getSize2D()));
            return astr;
        }
        if (!instr.matches(".*[Ee][\\+\\-]\\d.*")) {
            AttributedString astr = new AttributedString(instr);
            astr.addAttribute(TextAttribute.FAMILY, font.getFontName());
            astr.addAttribute(TextAttribute.SIZE, Float.valueOf(font.getSize2D()));
            return astr;
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        char decimalChar = dfs.getDecimalSeparator();
        char minusChar = dfs.getMinusSign();
        boolean negExp = false;
        int eindex = instr.indexOf("E+");
        if (eindex < 0) {
            eindex = instr.indexOf("e+");
        }
        if (eindex < 0) {
            eindex = instr.indexOf("E-");
            negExp = true;
        }
        if (eindex < 0) {
            eindex = instr.indexOf("e-");
            negExp = true;
        }
        int superBegins = -1;
        int superLength = -1;
        if (eindex < 0) {
            outstr = instr;
            superBegins = -1;
        } else {
            String str1 = instr.substring(0, eindex);
            String str2 = instr.substring(eindex + 2);
            if (str2.startsWith("00")) {
                str2 = str2.substring(2);
            } else if (str2.startsWith("0")) {
                str2 = str2.substring(1);
            }
            superLength = str2.length() == 0 ? 0 : (str2.matches("\\d\\d\\d.*") ? 3 : (str2.matches("\\d\\d.*") ? 2 : (str2.matches("\\d.*") ? 1 : 0)));
            if (superLength > 0) {
                superBegins = eindex + 3;
                if (negExp) {
                    outstr = str1 + "\u00d710" + minusChar + str2;
                    ++superLength;
                } else if (superLength == 1 && str2.startsWith("2")) {
                    outstr = str1 + "\u00d7100";
                    superLength = -1;
                } else if (superLength == 1 && str2.startsWith("1")) {
                    outstr = str1 + "\u00d710";
                    superLength = -1;
                } else {
                    outstr = str1 + "\u00d710" + str2;
                }
            } else {
                outstr = str1;
                superBegins = -1;
                superLength = -1;
            }
        }
        int oneTimesIdx = ((String)outstr).indexOf("1\u00d7");
        if (oneTimesIdx == 0) {
            outstr = ((String)outstr).substring(2);
            superBegins -= 2;
        } else if (oneTimesIdx > 0 && (matcher = ONE_TIMES_TEN_PATTERN.matcher((CharSequence)outstr)).find() && (patternIdx = matcher.start()) == oneTimesIdx - 1 && ((String)outstr).charAt(oneTimesIdx - 1) != decimalChar) {
            outstr = new StringBuilder((String)outstr).delete(oneTimesIdx, oneTimesIdx + 2).toString();
            if (superBegins > 0 && superLength > 0) {
                superBegins -= 2;
            }
        }
        AttributedString astr = new AttributedString((String)outstr);
        astr.addAttribute(TextAttribute.FAMILY, font.getFontName());
        astr.addAttribute(TextAttribute.SIZE, Float.valueOf(font.getSize2D()));
        if (superBegins > 0 && superLength > 0) {
            astr.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, superBegins, superBegins + superLength);
        }
        return astr;
    }

    public static AttributedString convertCaretNotationToSuperscript(String str, Graphics2D g2d) {
        return PanStringUtils.convertCaretNotationToSuperscript(str, g2d.getFont());
    }

    public static AttributedString convertCaretNotationToSuperscript(String instr, Font font) {
        Object outstr;
        Objects.requireNonNull(instr, "String cannot be null.");
        if (instr.length() < 1) {
            return new AttributedString("");
        }
        boolean negExp = false;
        int eindex = instr.indexOf(94);
        if (instr.indexOf("^-") == eindex) {
            negExp = true;
        }
        int superBegins = -1;
        int superLength = -1;
        if (eindex < 0) {
            outstr = instr;
            superBegins = -1;
        } else {
            String str2;
            String str1 = instr.substring(0, eindex);
            String string = str2 = negExp ? instr.substring(eindex + 2) : instr.substring(eindex + 1);
            if (str2.matches("\\d\\d\\d.*")) {
                superLength = 3;
            } else if (str2.matches("\\d\\d.*")) {
                superLength = 2;
            } else if (str2.matches("\\d.*")) {
                superLength = 1;
            }
            if (superLength > 0) {
                superBegins = eindex;
                if (negExp) {
                    outstr = str1 + "-" + str2;
                    ++superLength;
                } else {
                    outstr = str1 + str2;
                }
            } else {
                outstr = instr;
                superBegins = -1;
                superLength = -1;
            }
        }
        AttributedString astr = new AttributedString((String)outstr);
        astr.addAttribute(TextAttribute.FAMILY, font.getFontName());
        astr.addAttribute(TextAttribute.SIZE, Float.valueOf(font.getSize2D()));
        if (superBegins > 0 && superLength > 0) {
            astr.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, superBegins, superBegins + superLength);
        }
        return astr;
    }

    public static AttributedString getSuperscriptedE(double power, Graphics2D g2d) {
        return PanStringUtils.getSuperscriptedE(power, g2d.getFont());
    }

    public static AttributedString getSuperscriptedE(double power, Font font) {
        String expo = PFORMAT_10G.sprintfx(power);
        if (expo.endsWith(".0") || expo.endsWith(",0")) {
            expo = expo.substring(0, expo.length() - 2);
        }
        if ("0".equals(expo)) {
            return new AttributedString("1");
        }
        if ("1".equals(expo)) {
            return new AttributedString("\u212f");
        }
        Object estr = "\u212f" + expo;
        estr = ((String)estr).replaceAll("\\b", "");
        AttributedString astr = new AttributedString((String)estr);
        int strLen = ((String)estr).length();
        if (strLen > 1) {
            astr.addAttribute(TextAttribute.FAMILY, font.getFontName());
            astr.addAttribute(TextAttribute.SIZE, Float.valueOf(font.getSize2D()));
            astr.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, 1, strLen);
        }
        return astr;
    }

    private PanStringUtils() {
    }
}

