/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jspecify.annotations.Nullable;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ParameterNameDiscoverer;

public class KotlinReflectionParameterNameDiscoverer
implements ParameterNameDiscoverer {
    @Override
    public @Nullable String @Nullable [] getParameterNames(Method method) {
        if (KotlinDetector.isKotlinType(method.getDeclaringClass())) {
            try {
                KFunction function = ReflectJvmMapping.getKotlinFunction((Method)method);
                return function != null ? this.getParameterNames(function.getParameters()) : null;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public @Nullable String @Nullable [] getParameterNames(Constructor<?> ctor) {
        if (!ctor.getDeclaringClass().isEnum() && KotlinDetector.isKotlinType(ctor.getDeclaringClass())) {
            try {
                KFunction function = ReflectJvmMapping.getKotlinFunction(ctor);
                if (function != null) {
                    return this.getParameterNames(function.getParameters());
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    private @Nullable String @Nullable [] getParameterNames(List<KParameter> parameters) {
        String[] parameterNames;
        for (String parameterName : parameterNames = (String[])parameters.stream().filter(p -> KParameter.Kind.VALUE.equals((Object)p.getKind()) || KParameter.Kind.EXTENSION_RECEIVER.equals((Object)p.getKind())).map(p -> KParameter.Kind.EXTENSION_RECEIVER.equals((Object)p.getKind()) ? "$receiver" : p.getName()).toArray(String[]::new)) {
            if (parameterName != null) continue;
            return null;
        }
        return parameterNames;
    }
}

