/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper;

import com.ghostchu.peerbanhelper.wrapper.BanMetadata;
import com.ghostchu.peerbanhelper.wrapper.PeerAddress;
import inet.ipaddr.IPAddress;
import inet.ipaddr.format.util.AssociativeAddressTrie;
import inet.ipaddr.format.util.DualIPv4v6AssociativeTries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
public class BanList {
    private final DualIPv4v6AssociativeTries<BanMetadata> delegate = new DualIPv4v6AssociativeTries();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    @NotNull
    public Map<IPAddress, BanMetadata> toMap() {
        HashMap<IPAddress, BanMetadata> map = new HashMap<IPAddress, BanMetadata>();
        try {
            this.lock.readLock().lock();
            this.delegate.forEach(ip -> map.put((IPAddress)ip, (BanMetadata)this.delegate.get(ip)));
        }
        finally {
            this.lock.readLock().unlock();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BanMetadata add(@NotNull PeerAddress address, @NotNull BanMetadata metadata) {
        try {
            this.lock.writeLock().lock();
            BanMetadata banMetadata = (BanMetadata)this.delegate.put(address.getAddress().toPrefixBlock(), (Object)metadata);
            return banMetadata;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Nullable
    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, BanMetadata> remove(@NotNull PeerAddress address) {
        return this.remove(address.getAddress());
    }

    @Nullable
    public AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, BanMetadata> remove(@NotNull IPAddress address) {
        try {
            this.lock.writeLock().lock();
            AssociativeAddressTrie.AssociativeTrieNode associativeTrieNode = this.delegate.removeElementsContainedBy(address);
            return associativeTrieNode;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int size() {
        try {
            this.lock.readLock().lock();
            int n = this.delegate.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @NotNull
    public DualIPv4v6AssociativeTries<BanMetadata> copy() {
        try {
            this.lock.writeLock().lock();
            DualIPv4v6AssociativeTries dualIPv4v6AssociativeTries = this.delegate.clone();
            return dualIPv4v6AssociativeTries;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void directAccess(boolean writeLock, @NotNull Consumer<DualIPv4v6AssociativeTries<BanMetadata>> consumer) {
        try {
            if (writeLock) {
                this.lock.writeLock().lock();
            } else {
                this.lock.readLock().lock();
            }
            consumer.accept(this.delegate);
        }
        finally {
            if (writeLock) {
                this.lock.writeLock().unlock();
            } else {
                this.lock.readLock().unlock();
            }
        }
    }

    @NotNull
    public Set<IPAddress> copyKeySet() {
        HashSet<IPAddress> ipAddresses = new HashSet<IPAddress>();
        try {
            this.lock.readLock().lock();
            this.delegate.forEach(ipAddresses::add);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return ipAddresses;
    }

    @NotNull
    public List<IPAddress> copyValues() {
        ArrayList<IPAddress> ipAddresses = new ArrayList<IPAddress>();
        try {
            this.lock.readLock().lock();
            this.delegate.forEach(ipAddresses::add);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return ipAddresses;
    }

    public boolean contains(@NotNull PeerAddress address) {
        try {
            this.lock.readLock().lock();
            boolean bl = this.delegate.elementContains(address.getAddress());
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean contains(@NotNull IPAddress address) {
        try {
            this.lock.readLock().lock();
            boolean bl = this.delegate.elementContains(address);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BanMetadata get(@NotNull PeerAddress address) {
        try {
            this.lock.readLock().lock();
            AssociativeAddressTrie.AssociativeTrieNode obj = this.delegate.elementsContaining(address.getAddress());
            BanMetadata banMetadata = obj == null ? null : (BanMetadata)obj.getValue();
            return banMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BanMetadata get(@NotNull IPAddress address) {
        try {
            this.lock.readLock().lock();
            AssociativeAddressTrie.AssociativeTrieNode obj = this.delegate.elementsContaining(address);
            BanMetadata banMetadata = obj == null ? null : (BanMetadata)obj.getValue();
            return banMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void addAll(@NotNull Map<IPAddress, BanMetadata> map) {
        try {
            this.lock.writeLock().lock();
            map.forEach((? super K k, ? super V v) -> this.delegate.put(k.toPrefixBlock(), v));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void forEach(@NotNull BiConsumer<? super IPAddress, ? super BanMetadata> action) {
        try {
            this.lock.readLock().lock();
            this.delegate.forEach(ip -> {
                BanMetadata value = (BanMetadata)this.delegate.get(ip);
                action.accept((IPAddress)ip, value);
            });
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void reset() {
        try {
            this.lock.writeLock().lock();
            this.delegate.getIPv4Trie().clear();
            this.delegate.getIPv6Trie().clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readStream(@NotNull Consumer<Stream<AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, BanMetadata>>> streamConsumer) {
        try {
            this.lock.readLock().lock();
            Spliterator spliterator = Spliterators.spliteratorUnknownSize(this.delegate.nodeIterator(false), 0);
            Stream stream = StreamSupport.stream(spliterator, false);
            streamConsumer.accept(stream);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

