# required by configure_package_config_file()

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was SimGearConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/SimGear" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)

find_dependency(ZLIB)
find_dependency(LibLZMA)
find_dependency(Threads)
find_dependency(CURL)

# OSG
if (NOT SIMGEAR_HEADLESS)
  # this does a find_package on OpenSceneGraph,
  # then creates imported targets for OSG
  include(${CMAKE_CURRENT_LIST_DIR}/CreateOSGImportedTargets.cmake)
endif()

set(SIMGEAR_HEADLESS OFF)
set(SIMGEAR_SOUND ON)
set(USE_AEONWAVE FALSE)
set(SG_SOUND_USES_OPENALSOFT OFF)

set(ENABLE_ASAN OFF)
set(SIMGEAR_SHARED ON)

# SSE/SSE2 support

set(ENABLE_SIMD On)

# CycloneDDS support
set(SG_HAVE_DDS )
if(SG_HAVE_DDS)
    find_dependency(CycloneDDS)
endif()


if (SIMGEAR_SOUND)
  # find the sound dependency
  if (USE_AEONWAVE)
    find_dependency(AAX)
  elseif(SG_SOUND_USES_OPENALSOFT)
    # must force CONFIG mode when using OpenAL soft, to avoid picking
    # the CMake supplied FindOpenAL and hence defaults to the system
    # framework on macOS
    find_dependency(OpenAL CONFIG)
  else()
    find_dependency(OpenAL)
  endif()
endif()

# OpenRTI support
set(ENABLE_RTI OFF)
if(ENABLE_RTI)
    find_dependency(PkgConfig)
    if(PKG_CONFIG_FOUND)
      pkg_check_modules(RTI IMPORTED_TARGET hla-rti13)
    endif(PKG_CONFIG_FOUND)
endif(ENABLE_RTI)

# Alternative terrain engine based on pagedLOD

set(ENABLE_GDAL OFF)
if (ENABLE_GDAL)
  find_dependency(GDAL)
endif()

include("${CMAKE_CURRENT_LIST_DIR}/SimGearTargets.cmake")

check_required_components(SimGear)

