/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.tile.Tile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Immutable;
import yairm210.purity.annotations.Pure;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b \n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0003J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0007J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\nH\u0007J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0007J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0007H\u0007J\u001a\u0010\u0017\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\u0018\u001a\u00020\u0007H\u0007J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0007J \u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0007H\u0007J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0007J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005H\u0007J\u0010\u0010$\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0005H\u0007J\u0010\u0010%\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0005H\u0007J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\nH\u0007J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0007J.\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050+2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u000200H\u0007J&\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050+2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\n2\u0006\u0010/\u001a\u000200H\u0007J\u0018\u00102\u001a\u00020\n2\u0006\u0010,\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u0005H\u0007J(\u00102\u001a\u00020\n2\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\nH\u0007J\u0010\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\nH\u0007J\u0010\u0010?\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\nH\u0007J\u0018\u0010@\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010A\u001a\u00020BH\u0007J\u0018\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020\n2\u0006\u0010E\u001a\u00020\nH\u0007J\u0016\u0010F\u001a\u00020\n2\u0006\u0010D\u001a\u00020\n2\u0006\u0010E\u001a\u00020\nJ\u0016\u0010G\u001a\u00020\n2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020IR\"\u00108\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0005098\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b:\u0010\u0003R\"\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0005098\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b>\u0010\u0003\u00a8\u0006K"}, d2={"Lcom/unciv/logic/map/HexMath;", "", "<init>", "()V", "getVectorForAngle", "Lcom/badlogic/gdx/math/Vector2;", "angle", "", "getVectorByClockHour", "hour", "", "getNumberOfTilesInHexagon", "size", "getHexagonalRadiusForArea", "numberOfTiles", "getLatitude", "vector", "getLongitude", "hexFromLatLong", "latitude", "longitude", "worldFromLatLong", "tileRadius", "getEquivalentRectangularSize", "ratio", "getEquivalentHexagonalRadius", "width", "height", "getUnwrappedNearestTo", "unwrapHexCoord", "staticHexCoord", "longitudinalRadius", "hex2WorldCoords", "hexCoord", "world2HexCoords", "worldCoord", "getRow", "getColumn", "getTileCoordsFromColumnRow", "column", "row", "roundHexCoords", "getVectorsAtDistance", "", "origin", "distance", "maxDistance", "worldWrap", "", "getVectorsInDistance", "getDistance", "destination", "originX", "originY", "destinationX", "destinationY", "clockPositionToHexVectorMap", "", "getClockPositionToHexVectorMap$annotations", "getClockPositionToHexVector", "clockPosition", "clockPositionToWorldVectorMap", "getClockPositionToWorldVectorMap$annotations", "getClockPositionToWorldVector", "getDistanceFromEdge", "mapParameters", "Lcom/unciv/logic/map/MapParameters;", "getZeroBasedIndex", "x", "y", "mapRelativePositionToPositiveIntRedblob", "tilesAndNeighborUniqueIndex", "tile", "Lcom/unciv/logic/map/tile/Tile;", "neighbor", "core"})
public final class HexMath {
    @NotNull
    public static final HexMath INSTANCE = new HexMath();
    @NotNull
    private static final Map<Integer, Vector2> clockPositionToHexVectorMap;
    @NotNull
    private static final Map<Integer, Vector2> clockPositionToWorldVectorMap;

    private HexMath() {
    }

    @Pure
    @NotNull
    public final Vector2 getVectorForAngle(float angle) {
        return new Vector2((float)Math.sin(angle), (float)Math.cos(angle));
    }

    @Pure
    private final Vector2 getVectorByClockHour(int hour2) {
        return this.getVectorForAngle((float)(Math.PI * 2 * (double)((float)hour2 / 12.0f)));
    }

    @Pure
    public final int getNumberOfTilesInHexagon(int size) {
        if (size < 0) {
            return 0;
        }
        return 1 + 6 * size * (size + 1) / 2;
    }

    @Pure
    public final float getHexagonalRadiusForArea(int numberOfTiles) {
        return numberOfTiles < 1 ? 0.0f : ((float)Math.sqrt(12.0f * (float)numberOfTiles - (float)3) - (float)3) / (float)6;
    }

    @Readonly
    public final float getLatitude(@NotNull Vector2 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        return vector.x + vector.y;
    }

    @Readonly
    public final float getLongitude(@NotNull Vector2 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        return vector.x - vector.y;
    }

    @Pure
    @NotNull
    public final Vector2 hexFromLatLong(float latitude, float longitude) {
        float y = (latitude - longitude) / 2.0f;
        float x = longitude + y;
        return new Vector2(x, y);
    }

    @Readonly
    @NotNull
    public final Vector2 worldFromLatLong(@NotNull Vector2 vector, float tileRadius) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        float x = vector.x * tileRadius * 1.5f * -1.0f;
        float y = vector.y * tileRadius * (float)Math.sqrt(3.0f) * 0.5f;
        return new Vector2(x, y);
    }

    @Pure
    @NotNull
    public final Vector2 getEquivalentRectangularSize(int size, float ratio) {
        if (size < 0) {
            Vector2 vector2 = Vector2.Zero;
            Intrinsics.checkNotNullExpressionValue(vector2, "Zero");
            return vector2;
        }
        int nTiles = this.getNumberOfTilesInHexagon(size);
        float width = (float)Math.rint((float)Math.sqrt((float)nTiles / ratio));
        float height = (float)Math.rint(width * ratio);
        return new Vector2(width, height);
    }

    public static /* synthetic */ Vector2 getEquivalentRectangularSize$default(HexMath hexMath, int n, float f, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = 0.65f;
        }
        return hexMath.getEquivalentRectangularSize(n, f);
    }

    @Pure
    public final int getEquivalentHexagonalRadius(int width, int height) {
        return MathKt.roundToInt(this.getHexagonalRadiusForArea(width * height));
    }

    @Readonly
    @NotNull
    public final Vector2 getUnwrappedNearestTo(@NotNull Vector2 unwrapHexCoord, @NotNull Vector2 staticHexCoord, float longitudinalRadius) {
        Intrinsics.checkNotNullParameter(unwrapHexCoord, "unwrapHexCoord");
        Intrinsics.checkNotNullParameter(staticHexCoord, "staticHexCoord");
        float referenceLong = this.getLongitude(staticHexCoord);
        float toWrapLat = this.getLatitude(unwrapHexCoord);
        float toWrapLong = this.getLongitude(unwrapHexCoord);
        float f = toWrapLong - referenceLong + longitudinalRadius;
        float f2 = longitudinalRadius * 2.0f;
        float f3 = f % f2;
        return this.hexFromLatLong(toWrapLat, (!(f3 == 0.0f) && !(Math.signum(f3) == Math.signum(f2)) ? f3 + f2 : f3) - longitudinalRadius + referenceLong);
    }

    @Readonly
    @NotNull
    public final Vector2 hex2WorldCoords(@NotNull Vector2 hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        Vector2 xVector = this.getVectorByClockHour(10);
        xVector.scl((float)Math.sqrt(3.0) * hexCoord.x);
        Vector2 yVector = this.getVectorByClockHour(2);
        yVector.scl((float)Math.sqrt(3.0) * hexCoord.y);
        Vector2 vector2 = xVector.add(yVector);
        Intrinsics.checkNotNullExpressionValue(vector2, "add(...)");
        return vector2;
    }

    @Readonly
    @NotNull
    public final Vector2 world2HexCoords(@NotNull Vector2 worldCoord) {
        Intrinsics.checkNotNullParameter(worldCoord, "worldCoord");
        Vector2 D = this.getVectorByClockHour(10);
        D.scl((float)Math.sqrt(3.0));
        Vector2 A = this.getVectorByClockHour(2);
        A.scl((float)Math.sqrt(3.0));
        float den = D.x * A.y - D.y * A.x;
        float x = (worldCoord.x * A.y - worldCoord.y * A.x) / den;
        float y = (worldCoord.y * D.x - worldCoord.x * D.y) / den;
        return new Vector2(x, y);
    }

    @Readonly
    public final int getRow(@NotNull Vector2 hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        return (int)(hexCoord.x / (float)2 + hexCoord.y / (float)2);
    }

    @Readonly
    public final int getColumn(@NotNull Vector2 hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        return (int)(hexCoord.y - hexCoord.x);
    }

    @Pure
    @NotNull
    public final Vector2 getTileCoordsFromColumnRow(int column, int row) {
        int twoRows = row * 2;
        if (Math.abs(column) % 2 == 1) {
            ++twoRows;
        }
        return new Vector2((twoRows - column) / 2, (twoRows + column) / 2);
    }

    @Readonly
    @NotNull
    public final Vector2 roundHexCoords(@NotNull Vector2 hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        return HexMath.roundHexCoords$cubic2HexCoords(HexMath.roundHexCoords$roundCubicCoords(HexMath.roundHexCoords$hex2CubicCoords(hexCoord)));
    }

    @Readonly
    @NotNull
    public final List<Vector2> getVectorsAtDistance(@NotNull Vector2 origin2, int distance, int maxDistance, boolean worldWrap) {
        int i;
        Intrinsics.checkNotNullParameter(origin2, "origin");
        List vectors = new ArrayList();
        if (distance == 0) {
            return CollectionsKt.listOf(origin2.cpy());
        }
        Vector2 current = origin2.cpy();
        current.sub(distance, distance);
        for (i = 0; i < distance; ++i) {
            ((Collection)vectors).add(current.cpy());
            Collection collection = vectors;
            Intrinsics.checkNotNull(current);
            collection.add(HexMath.getVectorsAtDistance$getVectorOnOtherSideOfClock(origin2, current));
            current.add(1.0f, 0.0f);
        }
        for (i = 0; i < distance; ++i) {
            ((Collection)vectors).add(current.cpy());
            if (!worldWrap || distance != maxDistance) {
                Collection collection = vectors;
                Intrinsics.checkNotNull(current);
                collection.add(HexMath.getVectorsAtDistance$getVectorOnOtherSideOfClock(origin2, current));
            }
            current.add(1.0f, 1.0f);
        }
        for (i = 0; i < distance; ++i) {
            ((Collection)vectors).add(current.cpy());
            if (!worldWrap || distance != maxDistance || i != 0) {
                Collection collection = vectors;
                Intrinsics.checkNotNull(current);
                collection.add(HexMath.getVectorsAtDistance$getVectorOnOtherSideOfClock(origin2, current));
            }
            current.add(0.0f, 1.0f);
        }
        return vectors;
    }

    @Readonly
    @NotNull
    public final List<Vector2> getVectorsInDistance(@NotNull Vector2 origin2, int distance, boolean worldWrap) {
        Intrinsics.checkNotNullParameter(origin2, "origin");
        List hexesToReturn = new ArrayList();
        int i = 0;
        if (i <= distance) {
            while (true) {
                CollectionsKt.addAll((Collection)hexesToReturn, (Iterable)this.getVectorsAtDistance(origin2, i, distance, worldWrap));
                if (i == distance) break;
                ++i;
            }
        }
        return hexesToReturn;
    }

    @Pure
    public final int getDistance(@NotNull Vector2 origin2, @NotNull Vector2 destination) {
        Intrinsics.checkNotNullParameter(origin2, "origin");
        Intrinsics.checkNotNullParameter(destination, "destination");
        return this.getDistance((int)origin2.x, (int)origin2.y, (int)destination.x, (int)destination.y);
    }

    @Pure
    public final int getDistance(int originX, int originY, int destinationX, int destinationY) {
        int relativeX = originX - destinationX;
        int relativeY = originY - destinationY;
        return relativeX * relativeY >= 0 ? Math.max(Math.abs(relativeX), Math.abs(relativeY)) : Math.abs(relativeX) + Math.abs(relativeY);
    }

    @Immutable
    private static /* synthetic */ void getClockPositionToHexVectorMap$annotations() {
    }

    @Pure
    @NotNull
    public final Vector2 getClockPositionToHexVector(int clockPosition) {
        Vector2 vector2 = clockPositionToHexVectorMap.get(clockPosition);
        if (vector2 == null) {
            Vector2 vector22 = Vector2.Zero;
            vector2 = vector22;
            Intrinsics.checkNotNullExpressionValue(vector22, "Zero");
        }
        return vector2;
    }

    @Immutable
    private static /* synthetic */ void getClockPositionToWorldVectorMap$annotations() {
    }

    @Pure
    @NotNull
    public final Vector2 getClockPositionToWorldVector(int clockPosition) {
        Vector2 vector2 = clockPositionToWorldVectorMap.get(clockPosition);
        if (vector2 == null) {
            Vector2 vector22 = Vector2.Zero;
            vector2 = vector22;
            Intrinsics.checkNotNullExpressionValue(vector22, "Zero");
        }
        return vector2;
    }

    @Readonly
    public final int getDistanceFromEdge(@NotNull Vector2 vector, @NotNull MapParameters mapParameters) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        Intrinsics.checkNotNullParameter(mapParameters, "mapParameters");
        int x = (int)vector.x;
        int y = (int)vector.y;
        if (Intrinsics.areEqual(mapParameters.getShape(), "Rectangular")) {
            int height = mapParameters.getMapSize().getHeight();
            int width = mapParameters.getMapSize().getWidth();
            int left = mapParameters.getWorldWrap() ? Integer.MAX_VALUE : width / 2 - (x - y);
            int right = mapParameters.getWorldWrap() ? Integer.MAX_VALUE : (width - 1) / 2 - (y - x);
            int top = height / 2 - (x + y) / 2;
            int bottom = (x + y - 1) / 2 + (height - 1) / 2;
            int[] nArray = new int[]{right, top, bottom};
            return ComparisonsKt.minOf(left, nArray);
        }
        int radius = mapParameters.getMapSize().getRadius();
        if (!mapParameters.getWorldWrap()) {
            Vector2 vector2 = Vector2.Zero;
            Intrinsics.checkNotNullExpressionValue(vector2, "Zero");
            return radius - this.getDistance(vector, vector2);
        }
        if (MathKt.getSign(x) == MathKt.getSign(y)) {
            Vector2 vector2 = Vector2.Zero;
            Intrinsics.checkNotNullExpressionValue(vector2, "Zero");
            return radius - this.getDistance(vector, vector2);
        }
        if (x > 0) {
            return Math.min(this.getDistance(vector, new Vector2(radius, 0.0f)), this.getDistance(vector, new Vector2(0.0f, -((float)radius))));
        }
        return Math.min(this.getDistance(vector, new Vector2(1.0f, radius)), this.getDistance(vector, new Vector2(-((float)radius), -1.0f)));
    }

    @Pure
    public final int getZeroBasedIndex(int x, int y) {
        int n;
        if (x == 0 && y == 0) {
            return 0;
        }
        int ring = this.getDistance(0, 0, x, y);
        int ringStart = 1 + 6 * ring * (ring - 1) / 2;
        int n2 = ring;
        if (n2 == y) {
            n = 0 + x;
        } else if (n2 == x) {
            n = ring + 1 + y;
        } else if (n2 == -x) {
            n = 2 * ring + 1 - y;
        } else if (n2 == -y) {
            n = 3 * ring + 2 - x;
        } else if (n2 == x - y) {
            n = 4 * ring + 2 + x - 1;
        } else if (n2 == y - x) {
            n = 5 * ring + 1 + y - 1;
        } else {
            throw new Exception("How???");
        }
        int positionInRing = n;
        return ringStart + positionInRing;
    }

    public final int mapRelativePositionToPositiveIntRedblob(int x, int y) {
        if (x == 0 && y == 0) {
            return 0;
        }
        int ring = this.getDistance(0, 0, x, y);
        int ringStart = 1 + 6 * ring * (ring - 1) / 2;
        Vector2 vector2 = Vector2.Zero;
        Intrinsics.checkNotNullExpressionValue(vector2, "Zero");
        List<Vector2> vectorsInRing = this.getVectorsAtDistance(vector2, ring, ring, false);
        int positionInRing = vectorsInRing.indexOf(new Vector2(x, y));
        return ringStart + positionInRing;
    }

    public final int tilesAndNeighborUniqueIndex(@NotNull Tile tile, @NotNull Tile neighbor) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(neighbor, "neighbor");
        return tile.getZeroBasedIndex() * 6 + tile.getTileMap().getNeighborTileClockPosition(tile, neighbor) / 2 - 1;
    }

    @Readonly
    private static final Vector3 roundHexCoords$roundCubicCoords(Vector3 cubicCoords) {
        float rx = (float)Math.rint(cubicCoords.x);
        float ry = (float)Math.rint(cubicCoords.y);
        float rz = (float)Math.rint(cubicCoords.z);
        float deltaX = Math.abs(rx - cubicCoords.x);
        float deltaY = Math.abs(ry - cubicCoords.y);
        float deltaZ = Math.abs(rz - cubicCoords.z);
        if (deltaX > deltaY && deltaX > deltaZ) {
            rx = -ry - rz;
        } else if (deltaY > deltaZ) {
            ry = -rx - rz;
        } else {
            rz = -rx - ry;
        }
        return new Vector3(rx, ry, rz);
    }

    @Readonly
    private static final Vector3 roundHexCoords$hex2CubicCoords(Vector2 hexCoord) {
        return new Vector3(hexCoord.y - hexCoord.x, hexCoord.x, -hexCoord.y);
    }

    @Readonly
    private static final Vector2 roundHexCoords$cubic2HexCoords(Vector3 cubicCoord) {
        return new Vector2(cubicCoord.y, -cubicCoord.z);
    }

    @Readonly
    private static final Vector2 getVectorsAtDistance$getVectorOnOtherSideOfClock(Vector2 $origin, Vector2 vector) {
        Vector2 vec = $origin.cpy();
        vec.scl(2.0f);
        vec.sub(vector);
        Intrinsics.checkNotNull(vec);
        return vec;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(0, new Vector2(1.0f, 1.0f)), TuplesKt.to(12, new Vector2(1.0f, 1.0f)), TuplesKt.to(2, new Vector2(0.0f, 1.0f)), TuplesKt.to(4, new Vector2(-1.0f, 0.0f)), TuplesKt.to(6, new Vector2(-1.0f, -1.0f)), TuplesKt.to(8, new Vector2(0.0f, -1.0f)), TuplesKt.to(10, new Vector2(1.0f, 0.0f))};
        clockPositionToHexVectorMap = MapsKt.mapOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to(2, INSTANCE.hex2WorldCoords(new Vector2(0.0f, -1.0f))), TuplesKt.to(4, INSTANCE.hex2WorldCoords(new Vector2(1.0f, 0.0f))), TuplesKt.to(6, INSTANCE.hex2WorldCoords(new Vector2(1.0f, 1.0f))), TuplesKt.to(8, INSTANCE.hex2WorldCoords(new Vector2(0.0f, 1.0f))), TuplesKt.to(10, INSTANCE.hex2WorldCoords(new Vector2(-1.0f, 0.0f))), TuplesKt.to(12, INSTANCE.hex2WorldCoords(new Vector2(-1.0f, -1.0f)))};
        clockPositionToWorldVectorMap = MapsKt.mapOf(pairArray);
    }
}

