/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.map.HexMath;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.MapGenerationRandomness;
import com.unciv.logic.map.mapgenerator.Perlin;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 =2\u00020\u0001:\u0001=B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J;\u0010\u0018\u001a\u00020\u00122#\b\u0002\u0010\u0019\u001a\u001d\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u000e0\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120 H\u0002J\b\u0010!\u001a\u00020\u0012H\u0002J\b\u0010\"\u001a\u00020\u0012H\u0002J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0002J\b\u0010%\u001a\u00020\u0012H\u0002J\b\u0010&\u001a\u00020\u0012H\u0002J\b\u0010'\u001a\u00020\u0012H\u0002J\b\u0010(\u001a\u00020\u0012H\u0002J\b\u0010)\u001a\u00020\u0012H\u0002J\b\u0010*\u001a\u00020\u0012H\u0002J\b\u0010+\u001a\u00020\u0012H\u0002J\u001a\u0010,\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010-\u001a\u00020\u0010H\u0002J \u0010.\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u000eH\u0002J\u0018\u00101\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u000eH\u0002J \u00102\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u000eH\u0002J\u0010\u00104\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u00105\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J@\u00106\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00107\u001a\u00020\u00102\b\b\u0002\u00108\u001a\u0002092\b\b\u0002\u0010:\u001a\u00020\u00102\b\b\u0002\u0010;\u001a\u00020\u00102\b\b\u0002\u0010<\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapLandmassGenerator;", "", "tileMap", "Lcom/unciv/logic/map/TileMap;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "randomness", "Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;", "<init>", "(Lcom/unciv/logic/map/TileMap;Lcom/unciv/models/ruleset/Ruleset;Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;)V", "landTerrainName", "", "waterTerrainName", "landOnlyMod", "", "waterThreshold", "", "generateLand", "", "generateFlatEarthExtraWater", "spawnLandOrWater", "tile", "Lcom/unciv/logic/map/tile/Tile;", "elevation", "retryLoweringWaterLevel", "predicate", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "waterPercent", "function", "Lkotlin/Function0;", "createPerlin", "createFractal", "createLakes", "createSmallContinents", "createArchipelago", "createPangaea", "createInnerSea", "createContinentAndIslands", "createTwoContinents", "createThreeContinents", "createFourCorners", "getEllipticContinent", "percentOfMap", "getContinentAndIslandsTransform", "isNorth", "isLatitude", "getTwoContinentsTransform", "getThreeContinentsTransform", "isEastWest", "getFourCornersTransform", "getOceanEdgesTransform", "getRidgedPerlinNoise", "seed", "nOctaves", "", "persistence", "lacunarity", "scale", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMapLandmassGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapLandmassGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapLandmassGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,453:1\n1788#2,4:454\n1788#2,4:458\n*S KotlinDebug\n*F\n+ 1 MapLandmassGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapLandmassGenerator\n*L\n106#1:454,4\n181#1:458,4\n*E\n"})
public final class MapLandmassGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TileMap tileMap;
    @NotNull
    private final MapGenerationRandomness randomness;
    @NotNull
    private final String landTerrainName;
    @NotNull
    private final String waterTerrainName;
    private final boolean landOnlyMod;
    private double waterThreshold;

    public MapLandmassGenerator(@NotNull TileMap tileMap, @NotNull Ruleset ruleset, @NotNull MapGenerationRandomness randomness) {
        String string;
        MapLandmassGenerator mapLandmassGenerator;
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        Intrinsics.checkNotNullParameter(randomness, "randomness");
        this.tileMap = tileMap;
        this.randomness = randomness;
        this.landTerrainName = Companion.getInitializationTerrain$core(ruleset, TerrainType.Land);
        MapLandmassGenerator mapLandmassGenerator2 = this;
        try {
            mapLandmassGenerator = mapLandmassGenerator2;
            string = Companion.getInitializationTerrain$core(ruleset, TerrainType.Water);
        }
        catch (Exception exception2) {
            mapLandmassGenerator = mapLandmassGenerator2;
            string = this.landTerrainName;
        }
        mapLandmassGenerator.waterTerrainName = string;
        this.landOnlyMod = Intrinsics.areEqual(this.waterTerrainName, this.landTerrainName);
    }

    public final void generateLand() {
        if (this.landOnlyMod) {
            for (Tile tile : this.tileMap.getValues()) {
                tile.setBaseTerrain(this.landTerrainName);
            }
            return;
        }
        this.waterThreshold = this.tileMap.getMapParameters().getWaterThreshold();
        switch (this.tileMap.getMapParameters().getType()) {
            case "Pangaea": {
                this.createPangaea();
                break;
            }
            case "Inner Sea": {
                this.createInnerSea();
                break;
            }
            case "Continent and Islands": {
                this.createContinentAndIslands();
                break;
            }
            case "Two Continents": {
                this.createTwoContinents();
                break;
            }
            case "Three Continents": {
                this.createThreeContinents();
                break;
            }
            case "Four Corners": {
                this.createFourCorners();
                break;
            }
            case "Archipelago": {
                this.createArchipelago();
                break;
            }
            case "Perlin": {
                this.createPerlin();
                break;
            }
            case "Fractal": {
                this.createFractal();
                break;
            }
            case "Lakes": {
                this.createLakes();
                break;
            }
            case "Small Continents": {
                this.createSmallContinents();
            }
        }
        if (Intrinsics.areEqual(this.tileMap.getMapParameters().getShape(), "Flat Earth Hexagonal")) {
            this.generateFlatEarthExtraWater();
        }
    }

    private final void generateFlatEarthExtraWater() {
        for (Tile tile : this.tileMap.getValues()) {
            boolean isEdgeTile;
            boolean isCenterTile = tile.getLatitude() == 0.0f && tile.getLongitude() == 0.0f;
            boolean bl = isEdgeTile = SequencesKt.count(tile.getNeighbors()) < 6;
            if (!isCenterTile && !isEdgeTile) continue;
            tile.setBaseTerrain(this.waterTerrainName);
            Iterator<Tile> iterator2 = tile.getNeighbors().iterator();
            while (iterator2.hasNext()) {
                Tile neighbor = iterator2.next();
                neighbor.setBaseTerrain(this.waterTerrainName);
                Iterator<Tile> iterator3 = neighbor.getNeighbors().iterator();
                while (iterator3.hasNext()) {
                    Tile neighbor2 = iterator3.next();
                    neighbor2.setBaseTerrain(this.waterTerrainName);
                    if (!isCenterTile) continue;
                    Iterator<Tile> iterator4 = neighbor2.getNeighbors().iterator();
                    while (iterator4.hasNext()) {
                        Tile neighbor3 = iterator4.next();
                        neighbor3.setBaseTerrain(this.waterTerrainName);
                    }
                }
            }
        }
    }

    private final void spawnLandOrWater(Tile tile, double elevation) {
        tile.setBaseTerrain(elevation < this.waterThreshold ? this.waterTerrainName : this.landTerrainName);
    }

    private final void retryLoweringWaterLevel(Function1<? super Float, Boolean> predicate, Function0<Unit> function) {
        int retries = 0;
        while (++retries <= 30) {
            int n;
            function.invoke();
            Iterable $this$count$iv = this.tileMap.getValues();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Tile it = (Tile)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getBaseTerrain(), this.waterTerrainName) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            float waterPercent = (float)n / (float)this.tileMap.getValues().size();
            if (this.waterThreshold < -1.0 || predicate.invoke(Float.valueOf(waterPercent)).booleanValue()) break;
            this.waterThreshold -= 0.02 * (double)RangesKt.coerceAtLeast(waterPercent / 0.7f, 1.0f) * (double)((float)Math.pow(retries, 0.5f));
        }
    }

    static /* synthetic */ void retryLoweringWaterLevel$default(MapLandmassGenerator mapLandmassGenerator, Function1 function1, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = MapLandmassGenerator::retryLoweringWaterLevel$lambda$0;
        }
        mapLandmassGenerator.retryLoweringWaterLevel(function1, function0);
    }

    private final void createPerlin() {
        double elevationSeed = this.randomness.getRNG().nextInt();
        for (Tile tile : this.tileMap.getValues()) {
            double elevation = MapGenerationRandomness.getPerlinNoise$default(this.randomness, tile, elevationSeed, 0, 0.0, 0.0, 0.0, 60, null);
            this.spawnLandOrWater(tile, elevation);
        }
    }

    private final void createFractal() {
        MapLandmassGenerator.retryLoweringWaterLevel$default(this, null, () -> MapLandmassGenerator.createFractal$lambda$0(this), 1, null);
    }

    private final void createLakes() {
        double elevationSeed = this.randomness.getRNG().nextInt();
        for (Tile tile : this.tileMap.getValues()) {
            double elevation = 0.3 - MapLandmassGenerator.getRidgedPerlinNoise$default(this, tile, elevationSeed, 0, 0.7, 1.5, 0.0, 36, null);
            this.spawnLandOrWater(tile, elevation);
        }
    }

    private final void createSmallContinents() {
        double elevationSeed = this.randomness.getRNG().nextInt();
        this.waterThreshold += 0.25;
        MapLandmassGenerator.retryLoweringWaterLevel$default(this, null, () -> MapLandmassGenerator.createSmallContinents$lambda$0(this, elevationSeed), 1, null);
    }

    private final void createArchipelago() {
        double elevationSeed = this.randomness.getRNG().nextInt();
        this.waterThreshold += 0.25;
        for (Tile tile : this.tileMap.getValues()) {
            double elevation = MapLandmassGenerator.getRidgedPerlinNoise$default(this, tile, elevationSeed, 0, 0.0, 0.0, 0.0, 60, null);
            this.spawnLandOrWater(tile, elevation);
        }
    }

    private final void createPangaea() {
        int largeContinentThreshold = RangesKt.coerceAtLeast(RangesKt.coerceAtMost(25, this.tileMap.getValues().size() / 4), (int)Math.pow(this.tileMap.getValues().size(), 0.333f));
        this.retryLoweringWaterLevel(arg_0 -> MapLandmassGenerator.createPangaea$lambda$0(this, largeContinentThreshold, arg_0), () -> MapLandmassGenerator.createPangaea$lambda$1(this));
        this.tileMap.assignContinents(TileMap.AssignContinentsMode.Clear);
    }

    private final void createInnerSea() {
        double elevationSeed = this.randomness.getRNG().nextInt();
        for (Tile tile : this.tileMap.getValues()) {
            double elevation = MapGenerationRandomness.getPerlinNoise$default(this.randomness, tile, elevationSeed, 0, 0.0, 0.0, 0.0, 60, null);
            this.spawnLandOrWater(tile, elevation -= this.getEllipticContinent(tile, 0.6) * 0.3);
        }
    }

    private final void createContinentAndIslands() {
        boolean isNorth;
        boolean bl = isNorth = this.randomness.getRNG().nextDouble() < 0.5;
        boolean isLatitude = Intrinsics.areEqual(this.tileMap.getMapParameters().getShape(), "Hexagonal") || Intrinsics.areEqual(this.tileMap.getMapParameters().getShape(), "Flat Earth Hexagonal") ? this.randomness.getRNG().nextDouble() > 0.5 : (this.tileMap.getMapParameters().getMapSize().getHeight() > this.tileMap.getMapParameters().getMapSize().getWidth() ? true : (this.tileMap.getMapParameters().getMapSize().getWidth() > this.tileMap.getMapParameters().getMapSize().getHeight() ? false : this.randomness.getRNG().nextDouble() > 0.5));
        double elevationSeed = this.randomness.getRNG().nextInt();
        for (Tile tile : this.tileMap.getValues()) {
            double elevation = MapGenerationRandomness.getPerlinNoise$default(this.randomness, tile, elevationSeed, 0, 0.0, 0.0, 0.0, 60, null);
            elevation = (elevation + this.getContinentAndIslandsTransform(tile, isNorth, isLatitude)) / 2.0;
            this.spawnLandOrWater(tile, elevation);
        }
    }

    private final void createTwoContinents() {
        boolean isLatitude = Intrinsics.areEqual(this.tileMap.getMapParameters().getShape(), "Hexagonal") || Intrinsics.areEqual(this.tileMap.getMapParameters().getShape(), "Flat Earth Hexagonal") ? this.randomness.getRNG().nextDouble() > 0.5 : (this.tileMap.getMapParameters().getMapSize().getHeight() > this.tileMap.getMapParameters().getMapSize().getWidth() ? true : (this.tileMap.getMapParameters().getMapSize().getWidth() > this.tileMap.getMapParameters().getMapSize().getHeight() ? false : this.randomness.getRNG().nextDouble() > 0.5));
        double elevationSeed = this.randomness.getRNG().nextInt();
        for (Tile tile : this.tileMap.getValues()) {
            double elevation = MapGenerationRandomness.getPerlinNoise$default(this.randomness, tile, elevationSeed, 0, 0.0, 0.0, 0.0, 60, null);
            elevation = (elevation + this.getTwoContinentsTransform(tile, isLatitude)) / 2.0;
            this.spawnLandOrWater(tile, elevation);
        }
    }

    private final void createThreeContinents() {
        boolean isNorth = this.randomness.getRNG().nextDouble() < 0.5;
        boolean isEastWest = Intrinsics.areEqual(this.tileMap.getMapParameters().getShape(), "Flat Earth Hexagonal") && this.randomness.getRNG().nextDouble() > 0.5;
        double elevationSeed = this.randomness.getRNG().nextInt();
        for (Tile tile : this.tileMap.getValues()) {
            double elevation = MapGenerationRandomness.getPerlinNoise$default(this.randomness, tile, elevationSeed, 0, 0.0, 0.0, 0.0, 60, null);
            elevation = (elevation + this.getThreeContinentsTransform(tile, isNorth, isEastWest)) / 2.0;
            this.spawnLandOrWater(tile, elevation);
        }
    }

    private final void createFourCorners() {
        double elevationSeed = this.randomness.getRNG().nextInt();
        for (Tile tile : this.tileMap.getValues()) {
            double elevation = MapGenerationRandomness.getPerlinNoise$default(this.randomness, tile, elevationSeed, 0, 0.0, 0.0, 0.0, 60, null);
            elevation = elevation / (double)2 + this.getFourCornersTransform(tile) / (double)2;
            this.spawnLandOrWater(tile, elevation);
        }
    }

    private final double getEllipticContinent(Tile tile, double percentOfMap) {
        double randomScale = this.randomness.getRNG().nextDouble();
        double ratio = percentOfMap + 0.1 * this.randomness.getRNG().nextDouble();
        double a = ratio * (double)this.tileMap.getMaxLongitude();
        double b = ratio * (double)this.tileMap.getMaxLatitude();
        float x = tile.getLongitude();
        float y = tile.getLatitude();
        double distanceFactor = (double)(x * x) / (a * a) + (double)(y * y) / (b * b) + (double)((float)Math.pow(x + y, 2)) / Math.pow(a + b, 2);
        return Math.min(0.3, 1.0 - (5.0 * distanceFactor * distanceFactor + randomScale) / 3.0);
    }

    static /* synthetic */ double getEllipticContinent$default(MapLandmassGenerator mapLandmassGenerator, Tile tile, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.85;
        }
        return mapLandmassGenerator.getEllipticContinent(tile, d);
    }

    private final double getContinentAndIslandsTransform(Tile tile, boolean isNorth, boolean isLatitude) {
        float factor;
        double randomScale = this.randomness.getRNG().nextDouble();
        float longitudeFactor = Math.abs(tile.getLongitude()) / this.tileMap.getMaxLongitude();
        float latitudeFactor = Math.abs(tile.getLatitude()) / this.tileMap.getMaxLatitude();
        if (isLatitude) {
            if (isNorth && tile.getLatitude() < 0.0f || !isNorth && tile.getLatitude() > 0.0f) {
                latitudeFactor = 0.2f;
            }
        } else if (isNorth && tile.getLongitude() < 0.0f || !isNorth && tile.getLongitude() > 0.0f) {
            longitudeFactor = 0.2f;
        }
        float f = factor = isLatitude ? latitudeFactor : longitudeFactor;
        if (this.tileMap.getMapParameters().getWorldWrap()) {
            factor = Math.min(factor, (this.tileMap.getMaxLongitude() - Math.abs(tile.getLongitude())) / this.tileMap.getMaxLongitude()) * 1.1f;
        }
        return Math.min(0.2, -1.0 + (5.0 * (double)((float)Math.pow(factor, 0.6f)) + randomScale) / 3.0);
    }

    private final double getTwoContinentsTransform(Tile tile, boolean isLatitude) {
        float factor;
        double randomScale = this.randomness.getRNG().nextDouble();
        float latitudeFactor = Math.abs(tile.getLatitude()) / this.tileMap.getMaxLatitude();
        float longitudeFactor = Math.abs(tile.getLongitude()) / this.tileMap.getMaxLongitude();
        float f = factor = isLatitude ? latitudeFactor : longitudeFactor;
        if (this.tileMap.getMapParameters().getWorldWrap()) {
            factor = Math.min(longitudeFactor, (this.tileMap.getMaxLongitude() - Math.abs(tile.getLongitude())) / this.tileMap.getMaxLongitude()) * 1.5f;
        }
        return Math.min(0.2, -1.0 + (5.0 * (double)((float)Math.pow(factor, 0.6f)) + randomScale) / 3.0);
    }

    private final double getThreeContinentsTransform(Tile tile, boolean isNorth, boolean isEastWest) {
        float sizeReductionFactor;
        double randomScale = this.randomness.getRNG().nextDouble();
        float longitudeFactor = Math.abs(tile.getLongitude()) / this.tileMap.getMaxLongitude();
        float latitudeFactor = Math.abs(tile.getLatitude()) / this.tileMap.getMaxLatitude();
        float f = sizeReductionFactor = Intrinsics.areEqual(this.tileMap.getMapParameters().getShape(), "Flat Earth Hexagonal") ? 3.0f : 2.0f;
        if (isEastWest) {
            if (isNorth && tile.getLongitude() < 0.0f || !isNorth && tile.getLongitude() > 0.0f) {
                latitudeFactor = Math.max(0.0f, this.tileMap.getMaxLatitude() - Math.abs(tile.getLatitude() * sizeReductionFactor)) / this.tileMap.getMaxLatitude();
            }
        } else if (isNorth && tile.getLatitude() < 0.0f || !isNorth && tile.getLatitude() > 0.0f) {
            longitudeFactor = Math.max(0.0f, this.tileMap.getMaxLongitude() - Math.abs(tile.getLongitude() * sizeReductionFactor)) / this.tileMap.getMaxLongitude();
        }
        float factor = Math.min(longitudeFactor, latitudeFactor);
        if (this.tileMap.getMapParameters().getWorldWrap()) {
            factor = Math.min(factor, (this.tileMap.getMaxLongitude() - Math.abs(tile.getLongitude())) / this.tileMap.getMaxLongitude()) * 1.5f;
        }
        return Math.min(0.2, -1.0 + (5.0 * (double)((float)Math.pow(factor, 0.5f)) + randomScale) / 3.0);
    }

    private final double getFourCornersTransform(Tile tile) {
        double randomScale = this.randomness.getRNG().nextDouble();
        float longitudeFactor = Math.abs(tile.getLongitude()) / this.tileMap.getMaxLongitude();
        float latitudeFactor = Math.abs(tile.getLatitude()) / this.tileMap.getMaxLatitude();
        float factor = (float)Math.sqrt(longitudeFactor * latitudeFactor) / 1.5f;
        if (this.tileMap.getMapParameters().getWorldWrap()) {
            factor = Math.min(factor, (this.tileMap.getMaxLongitude() - Math.abs(tile.getLongitude())) / this.tileMap.getMaxLongitude()) * 1.5f;
        }
        float shouldBeWater = 1.0f - factor;
        return 1.0 - (5.0 * (double)shouldBeWater * (double)shouldBeWater + randomScale) / 3.0;
    }

    private final double getOceanEdgesTransform(Tile tile) {
        float maxX = this.tileMap.getMaxLongitude();
        float maxY = this.tileMap.getMaxLatitude();
        float x = tile.getLongitude();
        float y = tile.getLatitude();
        double elevationOffset = 0.0;
        float xdistanceratio = Math.abs(x) / maxX;
        float ydistanceratio = Math.abs(y) / maxY;
        if (Intrinsics.areEqual(this.tileMap.getMapParameters().getShape(), "Hexagonal") || Intrinsics.areEqual(this.tileMap.getMapParameters().getShape(), "Flat Earth Hexagonal")) {
            double startdropoffratio = 0.8;
            float xdrsquared = xdistanceratio * xdistanceratio;
            float ydrsquared = ydistanceratio * ydistanceratio;
            float distancefromcenter = (float)Math.sqrt(xdrsquared + ydrsquared);
            double distanceoffset = 0.0;
            if ((double)distancefromcenter > startdropoffratio) {
                double dropoffdistance = (double)distancefromcenter - startdropoffratio;
                double normalizationDivisor = 1.0 - startdropoffratio;
                distanceoffset = dropoffdistance / normalizationDivisor;
            }
            elevationOffset -= distanceoffset * 0.35;
        } else {
            double xoffset = 0.0;
            double xstartdropoffratio = 0.8;
            if ((double)xdistanceratio > xstartdropoffratio) {
                double xdropoffdistance = (double)xdistanceratio - xstartdropoffratio;
                double xnormalizationdivisor = 1.0 - xstartdropoffratio;
                xoffset = xdropoffdistance / xnormalizationdivisor;
            }
            double yoffset = 0.0;
            double ystartdropoffratio = 0.76;
            if ((double)ydistanceratio > ystartdropoffratio) {
                double ydropoffdistance = (double)ydistanceratio - ystartdropoffratio;
                double ynormalizationdivisor = 1.0 - ystartdropoffratio;
                yoffset = ydropoffdistance / ynormalizationdivisor;
            }
            elevationOffset -= xoffset * 0.33;
            elevationOffset -= yoffset * 0.35;
        }
        return Math.max(elevationOffset, -0.35);
    }

    private final double getRidgedPerlinNoise(Tile tile, double seed, int nOctaves, double persistence, double lacunarity, double scale) {
        Vector2 worldCoords = HexMath.INSTANCE.hex2WorldCoords(tile.getPosition());
        return Perlin.INSTANCE.ridgedNoise3d(worldCoords.x, worldCoords.y, seed, nOctaves, persistence, lacunarity, scale);
    }

    static /* synthetic */ double getRidgedPerlinNoise$default(MapLandmassGenerator mapLandmassGenerator, Tile tile, double d, int n, double d2, double d3, double d4, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 10;
        }
        if ((n2 & 8) != 0) {
            d2 = 0.5;
        }
        if ((n2 & 0x10) != 0) {
            d3 = 2.0;
        }
        if ((n2 & 0x20) != 0) {
            d4 = 10.0;
        }
        return mapLandmassGenerator.getRidgedPerlinNoise(tile, d, n, d2, d3, d4);
    }

    private static final boolean retryLoweringWaterLevel$lambda$0(float it) {
        return it <= 0.7f;
    }

    private static final Unit createFractal$lambda$0(MapLandmassGenerator this$0) {
        double elevationSeed = this$0.randomness.getRNG().nextInt();
        for (Tile tile : this$0.tileMap.getValues()) {
            float maxdim = Math.max(this$0.tileMap.getMaxLatitude(), this$0.tileMap.getMaxLongitude());
            double ratio = (double)maxdim / 32.0;
            if (Intrinsics.areEqual(this$0.tileMap.getMapParameters().getShape(), "Hexagonal") || Intrinsics.areEqual(this$0.tileMap.getMapParameters().getShape(), "Flat Earth Hexagonal")) {
                ratio *= 0.5;
            }
            double elevation = MapGenerationRandomness.getPerlinNoise$default(this$0.randomness, tile, elevationSeed, 0, 0.8, 1.5, ratio * 30.0, 4, null);
            this$0.spawnLandOrWater(tile, elevation += this$0.getOceanEdgesTransform(tile));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createSmallContinents$lambda$0(MapLandmassGenerator this$0, double $elevationSeed) {
        for (Tile tile : this$0.tileMap.getValues()) {
            double elevation = MapLandmassGenerator.getRidgedPerlinNoise$default(this$0, tile, $elevationSeed, 0, 0.0, 0.0, 22.0, 28, null);
            this$0.spawnLandOrWater(tile, elevation += this$0.getOceanEdgesTransform(tile));
        }
        return Unit.INSTANCE;
    }

    private static final boolean createPangaea$lambda$0(MapLandmassGenerator this$0, int $largeContinentThreshold, float waterPercent) {
        int n;
        Collection<Integer> collection = this$0.tileMap.getContinentSizes().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$count$iv = collection;
        boolean $i$f$count = false;
        if (((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Integer it = (Integer)element$iv;
                boolean bl = false;
                if (!(it > $largeContinentThreshold) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int largeContinents = n;
        return largeContinents == 1 && waterPercent <= 0.7f;
    }

    private static final Unit createPangaea$lambda$1(MapLandmassGenerator this$0) {
        double elevationSeed = this$0.randomness.getRNG().nextInt();
        for (Tile tile : this$0.tileMap.getValues()) {
            double elevation = MapGenerationRandomness.getPerlinNoise$default(this$0.randomness, tile, elevationSeed, 0, 0.0, 0.0, 0.0, 60, null);
            elevation = elevation * (double)0.75f + MapLandmassGenerator.getEllipticContinent$default(this$0, tile, 0.0, 2, null) / (double)4;
            this$0.spawnLandOrWater(tile, elevation);
            tile.setTerrainTransients();
        }
        this$0.tileMap.assignContinents(TileMap.AssignContinentsMode.Reassign);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapLandmassGenerator$Companion;", "", "<init>", "()V", "getInitializationTerrain", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "type", "Lcom/unciv/models/ruleset/tile/TerrainType;", "getInitializationTerrain$core", "core"})
    @SourceDebugExtension(value={"SMAP\nMapLandmassGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapLandmassGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapLandmassGenerator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,453:1\n295#2,2:454\n*S KotlinDebug\n*F\n+ 1 MapLandmassGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapLandmassGenerator$Companion\n*L\n36#1:454,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final String getInitializationTerrain$core(@NotNull Ruleset ruleset, @NotNull TerrainType type) {
            block4: {
                Intrinsics.checkNotNullParameter(ruleset, "ruleset");
                Intrinsics.checkNotNullParameter((Object)type, "type");
                v0 = ruleset.getTerrains().values();
                Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
                $this$firstOrNull$iv = v0;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (Terrain)element$iv;
                    $i$a$-firstOrNull-MapLandmassGenerator$Companion$getInitializationTerrain$1 = false;
                    if (it.getType() != type) ** GOTO lbl-1000
                    Intrinsics.checkNotNull(it);
                    if (!IHasUniques.hasUnique$default(it, UniqueType.NoNaturalGeneration, null, 2, null)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            if ((v3 = (Terrain)v2) == null || (v3 = v3.getName()) == null) {
                throw new Exception("Cannot create map - no " + (Object)type + " terrains found!");
            }
            return v3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

