/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.widgets;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.input.KeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/unciv/ui/components/widgets/LanguageTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "language", "", "percentComplete", "", "<init>", "(Ljava/lang/String;I)V", "getLanguage", "()Ljava/lang/String;", "getPercentComplete", "()I", "baseColor", "Lcom/badlogic/gdx/graphics/Color;", "darkBaseColor", "update", "", "chosenLanguage", "Companion", "core"})
public final class LanguageTable
extends Table {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String language;
    private final int percentComplete;
    @NotNull
    private final Color baseColor;
    @NotNull
    private final Color darkBaseColor;

    public LanguageTable(@NotNull String language, int percentComplete) {
        Intrinsics.checkNotNullParameter(language, "language");
        this.language = language;
        this.percentComplete = percentComplete;
        this.baseColor = BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor();
        this.darkBaseColor = Scene2dExtensionsKt.darken(this.baseColor, 0.5f);
        this.pad(10.0f);
        this.defaults().pad(10.0f);
        this.left();
        if (ImageGetter.INSTANCE.imageExists("FlagIcons/" + this.language)) {
            this.add((Actor)ImageGetter.getImage$default(ImageGetter.INSTANCE, "FlagIcons/" + this.language, null, 2, null)).size(40.0f);
        }
        String spaceSplitLang = StringsKt.replace$default(this.language, "_", " ", false, 4, null);
        this.add((Actor)Scene2dExtensionsKt.toLabel(spaceSplitLang + " (" + this.percentComplete + "%)"));
        this.update("");
        this.setTouchable(Touchable.enabled);
        this.pack();
    }

    @NotNull
    public final String getLanguage() {
        return this.language;
    }

    public final int getPercentComplete() {
        return this.percentComplete;
    }

    public final void update(@NotNull String chosenLanguage) {
        Intrinsics.checkNotNullParameter(chosenLanguage, "chosenLanguage");
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "LanguagePickerScreen/LanguageTable", null, Intrinsics.areEqual(chosenLanguage, this.language) ? this.baseColor : this.darkBaseColor, 2, null));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nJD\u0010\u000b\u001a\u00020\f*\u00020\r2\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\f0\u0013\u00a8\u0006\u0014"}, d2={"Lcom/unciv/ui/components/widgets/LanguageTable$Companion;", "", "<init>", "()V", "addLanguageTables", "Ljava/util/ArrayList;", "Lcom/unciv/ui/components/widgets/LanguageTable;", "Lkotlin/collections/ArrayList;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "expectedWidth", "", "addLanguageKeyShortcuts", "", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "languageTables", "getSelection", "Lkotlin/Function0;", "", "action", "Lkotlin/Function1;", "core"})
    @SourceDebugExtension(value={"SMAP\nLanguageTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageTable.kt\ncom/unciv/ui/components/widgets/LanguageTable$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n126#2:117\n153#2,3:118\n1869#3,2:121\n1563#3:123\n1634#3,3:124\n774#3:127\n865#3,2:128\n360#3,7:130\n*S KotlinDebug\n*F\n+ 1 LanguageTable.kt\ncom/unciv/ui/components/widgets/LanguageTable$Companion\n*L\n76#1:117\n76#1:118,3\n84#1:121,2\n107#1:123\n107#1:124,3\n99#1:127\n99#1:128,2\n102#1:130,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ArrayList<LanguageTable> addLanguageTables(@NotNull Table $this$addLanguageTables, float expectedWidth) {
            void $this$mapTo$iv$iv;
            Comparator $this$map$iv;
            Intrinsics.checkNotNullParameter($this$addLanguageTables, "<this>");
            ArrayList<LanguageTable> languageTables = new ArrayList<LanguageTable>();
            FormattedLine translationDisclaimer = new FormattedLine("Please note that translations are a community-based work in progress and are INCOMPLETE! The percentage shown is how much of the language is translated in-game. If you want to help translating the game into your language, click here.", "https://yairm210.github.io/Unciv/Other/Translating/", null, null, 0.0f, 15, 0, 0, 0.0f, null, false, false, false, false, 16348, null);
            $this$addLanguageTables.add((Actor)MarkupRenderer.render$default(MarkupRenderer.INSTANCE, CollectionsKt.listOf(translationDisclaimer), expectedWidth, 0.0f, null, null, 28, null)).pad(5.0f).row();
            Table tableLanguages = new Table();
            tableLanguages.defaults().uniformX().fillX().pad(10.0f);
            String systemLanguage = Locale.getDefault().getDisplayLanguage(Locale.ENGLISH);
            HashMap<String, Integer> languageCompletionPercentage = UncivGame.Companion.getCurrent().getTranslations().getPercentCompleteOfLanguages();
            Map map2 = languageCompletionPercentage;
            ArrayList<LanguageTable> arrayList = languageTables;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator3.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new LanguageTable((String)it.getKey(), Intrinsics.areEqual(it.getKey(), "English") ? 100 : ((Number)it.getValue()).intValue()));
            }
            $this$map$iv = new Comparator(){

                public final int compare(T a, T b) {
                    LanguageTable it = (LanguageTable)a;
                    boolean bl = false;
                    boolean bl2 = !Intrinsics.areEqual(it.getLanguage(), "English");
                    it = (LanguageTable)b;
                    Comparable comparable = Boolean.valueOf(bl2);
                    bl = false;
                    return ComparisonsKt.compareValues(comparable, !Intrinsics.areEqual(it.getLanguage(), "English"));
                }
            };
            $this$map$iv = new Comparator($this$map$iv, systemLanguage){
                final /* synthetic */ Comparator $this_thenBy;
                final /* synthetic */ String $systemLanguage$inlined;
                {
                    this.$this_thenBy = $receiver;
                    this.$systemLanguage$inlined = string;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        LanguageTable it = (LanguageTable)a;
                        boolean bl = false;
                        boolean bl2 = !Intrinsics.areEqual(it.getLanguage(), this.$systemLanguage$inlined);
                        it = (LanguageTable)b;
                        Comparable comparable = Boolean.valueOf(bl2);
                        bl = false;
                        n = ComparisonsKt.compareValues(comparable, !Intrinsics.areEqual(it.getLanguage(), this.$systemLanguage$inlined));
                    }
                    return n;
                }
            };
            arrayList.addAll(CollectionsKt.sortedWith((List)destination$iv$iv, new Comparator($this$map$iv){
                final /* synthetic */ Comparator $this_thenByDescending;
                {
                    this.$this_thenByDescending = $receiver;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenByDescending.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        LanguageTable it = (LanguageTable)b;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getPercentComplete());
                        it = (LanguageTable)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        n = ComparisonsKt.compareValues(comparable2, it.getPercentComplete());
                    }
                    return n;
                }
            }));
            Iterable $this$forEach$iv = languageTables;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LanguageTable it = (LanguageTable)element$iv;
                boolean bl = false;
                tableLanguages.add((Actor)it).row();
            }
            $this$addLanguageTables.add((Actor)tableLanguages).row();
            return languageTables;
        }

        /*
         * WARNING - void declaration
         */
        public final void addLanguageKeyShortcuts(@NotNull Actor $this$addLanguageKeyShortcuts, @NotNull ArrayList<LanguageTable> languageTables, @NotNull Function0<String> getSelection, @NotNull Function1<? super String, Unit> action2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter($this$addLanguageKeyShortcuts, "<this>");
            Intrinsics.checkNotNullParameter(languageTables, "languageTables");
            Intrinsics.checkNotNullParameter(getSelection, "getSelection");
            Intrinsics.checkNotNullParameter(action2, "action");
            Iterable $this$map$iv = languageTables;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LanguageTable languageTable = (LanguageTable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Character.valueOf(StringsKt.first(it.getLanguage())));
            }
            Set letters = CollectionsKt.toSet((List)destination$iv$iv);
            Iterator iterator2 = letters.iterator();
            while (iterator2.hasNext()) {
                char letter = ((Character)iterator2.next()).charValue();
                ActivationExtensionsKt.getKeyShortcuts($this$addLanguageKeyShortcuts).add(new KeyShortcutDispatcher.KeyShortcut(KeyboardBinding.None, new KeyCharAndCode(letter), 0), () -> Companion.addLanguageKeyShortcuts$lambda$3(letter, languageTables, action2, getSelection));
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final void addLanguageKeyShortcuts$activation(ArrayList<LanguageTable> $languageTables, Function1<? super String, Unit> $action, Function0<String> $getSelection, char letter) {
            int n;
            List candidates;
            block5: {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = $languageTables;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    LanguageTable it = (LanguageTable)element$iv$iv;
                    boolean bl = false;
                    if (!(StringsKt.first(it.getLanguage()) == letter)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                candidates = (List)destination$iv$iv;
                if (candidates.isEmpty()) {
                    return;
                }
                if (candidates.size() == 1) {
                    $action.invoke(((LanguageTable)CollectionsKt.first(candidates)).getLanguage());
                    return;
                }
                List $this$indexOfFirst$iv = candidates;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    LanguageTable it = (LanguageTable)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual(it.getLanguage(), $getSelection.invoke())) {
                        n = index$iv;
                        break block5;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int currentIndex = n;
            LanguageTable newSelection = (LanguageTable)candidates.get((currentIndex + 1) % candidates.size());
            $action.invoke(newSelection.getLanguage());
        }

        private static final Unit addLanguageKeyShortcuts$lambda$3(char $letter, ArrayList $languageTables, Function1 $action, Function0 $getSelection) {
            com.unciv.ui.components.widgets.LanguageTable$Companion.addLanguageKeyShortcuts$activation($languageTables, $action, $getSelection, $letter);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

