/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.diplomacyscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SplitPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyFunctions;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.trade.Trade;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.MusicController;
import com.unciv.ui.audio.MusicMood;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.tilegroups.InfluenceTable;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.RecreateOnResize;
import com.unciv.ui.screens.diplomacyscreen.CityStateDiplomacyTable;
import com.unciv.ui.screens.diplomacyscreen.LeaderIntroTable;
import com.unciv.ui.screens.diplomacyscreen.MajorCivDiplomacyTable;
import com.unciv.ui.screens.diplomacyscreen.TradeTable;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0003IJKB1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\u001c\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0002J\u0017\u0010\"\u001a\u00020!2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0011H\u0002J\u0015\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b(J\u0015\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b+J\u0010\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u0002002\u0006\u0010-\u001a\u00020.H\u0002J\u0015\u00101\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.H\u0000\u00a2\u0006\u0002\b2J\u0015\u00103\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.H\u0000\u00a2\u0006\u0002\b4J\u001d\u00105\u001a\u0002062\u0006\u00107\u001a\u00020.2\u0006\u0010'\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b8J\u0010\u00109\u001a\u0002002\u0006\u0010'\u001a\u00020\u0004H\u0002J%\u0010:\u001a\u00020!2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010;\u001a\u0002002\u0006\u0010<\u001a\u000200H\u0000\u00a2\u0006\u0002\b=J\u0015\u0010>\u001a\u0002062\u0006\u0010?\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b@J\r\u0010A\u001a\u00020BH\u0000\u00a2\u0006\u0002\bCJ\u0018\u0010D\u001a\u00020!2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020FH\u0016J\b\u0010H\u001a\u00020\u0001H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "Lcom/unciv/ui/screens/basescreen/RecreateOnResize;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "selectCiv", "selectTrade", "Lcom/unciv/logic/trade/Trade;", "showTrade", "", "<init>", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/logic/trade/Trade;Z)V", "getViewingCiv$core", "()Lcom/unciv/logic/civilization/Civilization;", "highlightColor", "Lcom/badlogic/gdx/graphics/Color;", "leftSideTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "leftSideScroll", "Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen$ScrollPaneWithMinSize;", "highlightedCivButton", "highlightBackground", "Lcom/badlogic/gdx/scenes/scene2d/utils/NinePatchDrawable;", "rightSideTable", "getRightSideTable$core", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "closeButton", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "isNotPlayersTurn", "isNotPlayersTurn$core", "getCivilopediaRuleset", "Lcom/unciv/models/ruleset/Ruleset;", "positionCloseButton", "", "updateLeftSideTable", "updateLeftSideTable$core", "highlightCiv", "civButton", "updateRightSide", "otherCiv", "updateRightSide$core", "setTrade", "Lcom/unciv/ui/screens/diplomacyscreen/TradeTable;", "setTrade$core", "getHumanRelationshipColor", "otherCivDiplomacyManager", "Lcom/unciv/logic/civilization/diplomacy/DiplomacyManager;", "getHumanRelationshipText", "", "getHumanRelationshipTable", "getHumanRelationshipTable$core", "getRelationshipTable", "getRelationshipTable$core", "getDeclareWarButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "diplomacyManager", "getDeclareWarButton$core", "getDeclareWarButtonText", "setRightSideFlavorText", "flavorText", "response", "setRightSideFlavorText$core", "getGoToOnMapButton", "civilization", "getGoToOnMapButton$core", "getTradeColumnsWidth", "", "getTradeColumnsWidth$core", "resize", "width", "", "height", "recreate", "Companion", "ScrollPaneWithMinSize", "SplitPaneCenteringLeftSide", "core"})
@SourceDebugExtension(value={"SMAP\nDiplomacyScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiplomacyScreen.kt\ncom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,407:1\n774#2:408\n865#2,2:409\n1563#2:411\n1634#2,3:412\n*S KotlinDebug\n*F\n+ 1 DiplomacyScreen.kt\ncom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen\n*L\n334#1:408\n334#1:409,2\n338#1:411\n338#1:412,3\n*E\n"})
public final class DiplomacyScreen
extends BaseScreen
implements RecreateOnResize {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Civilization viewingCiv;
    @Nullable
    private final Civilization selectCiv;
    @Nullable
    private final Trade selectTrade;
    private final boolean showTrade;
    @NotNull
    private final Color highlightColor;
    @NotNull
    private final Table leftSideTable;
    @NotNull
    private final ScrollPaneWithMinSize leftSideScroll;
    @Nullable
    private Table highlightedCivButton;
    @NotNull
    private final NinePatchDrawable highlightBackground;
    @NotNull
    private final Table rightSideTable;
    @NotNull
    private final Group closeButton;
    private static final float nationIconSize = 100.0f;
    private static final float nationIconPad = 10.0f;
    private static final float closeButtonSize = 50.0f;
    private static final float closeButtonPad = 10.0f;

    /*
     * WARNING - void declaration
     */
    public DiplomacyScreen(@NotNull Civilization viewingCiv, @Nullable Civilization selectCiv, @Nullable Trade selectTrade, boolean showTrade) {
        void $this$rightSideTable_u24lambda_u240;
        Table $this$leftSideTable_u24lambda_u240;
        Table table2;
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        this.viewingCiv = viewingCiv;
        this.selectCiv = selectCiv;
        this.selectTrade = selectTrade;
        this.showTrade = showTrade;
        Color color = BaseScreen.Companion.getClearColor().cpy().lerp(BaseScreen.Companion.getSkin().getColor("color"), 0.333f);
        Intrinsics.checkNotNullExpressionValue(color, "lerp(...)");
        this.highlightColor = color;
        Table table3 = table2 = new Table();
        DiplomacyScreen diplomacyScreen = this;
        boolean bl = false;
        $this$leftSideTable_u24lambda_u240.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "DiplomacyScreen/LeftSide", null, BaseScreen.Companion.getClearColor(), 2, null));
        diplomacyScreen.leftSideTable = table2;
        this.leftSideScroll = new ScrollPaneWithMinSize();
        this.highlightBackground = SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "DiplomacyScreen/SelectedCiv", null, this.highlightColor, 2, null);
        $this$leftSideTable_u24lambda_u240 = table2 = new Table();
        diplomacyScreen = this;
        boolean bl2 = false;
        $this$rightSideTable_u24lambda_u240.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "DiplomacyScreen/RightSide", null, this.highlightColor, 2, null));
        diplomacyScreen.rightSideTable = table2;
        this.closeButton = Scene2dExtensionsKt.getCloseButton$default(50.0f, 0.0f, null, null, () -> DiplomacyScreen.closeButton$lambda$0(this), 14, null);
        SplitPaneCenteringLeftSide splitPane = new SplitPaneCenteringLeftSide();
        splitPane.setSplitAmount(RangesKt.coerceAtLeast(0.2f, this.leftSideScroll.getPrefWidth() / this.getStage().getWidth()));
        this.updateLeftSideTable$core(this.selectCiv);
        splitPane.setFillParent(true);
        this.getStage().addActor(splitPane);
        this.positionCloseButton();
        this.getStage().addActor(this.closeButton);
        if (this.selectCiv != null) {
            if (this.showTrade) {
                TradeTable tradeTable = this.setTrade$core(this.selectCiv);
                if (this.selectTrade != null) {
                    tradeTable.getTradeLogic$core().getCurrentTrade().set(this.selectTrade);
                }
                tradeTable.getOfferColumnsTable$core().update();
            } else {
                this.updateRightSide$core(this.selectCiv);
            }
        }
    }

    public /* synthetic */ DiplomacyScreen(Civilization civilization, Civilization civilization2, Trade trade, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            civilization2 = null;
        }
        if ((n & 4) != 0) {
            trade = null;
        }
        if ((n & 8) != 0) {
            bl = trade != null;
        }
        this(civilization, civilization2, trade, bl);
    }

    @NotNull
    public final Civilization getViewingCiv$core() {
        return this.viewingCiv;
    }

    @NotNull
    public final Table getRightSideTable$core() {
        return this.rightSideTable;
    }

    public final boolean isNotPlayersTurn$core() {
        return !GUI.INSTANCE.isAllowedChangeState();
    }

    @Override
    @NotNull
    public Ruleset getCivilopediaRuleset() {
        return this.viewingCiv.getGameInfo().getRuleset();
    }

    private final void positionCloseButton() {
        this.closeButton.setPosition(this.getStage().getWidth() - 10.0f, this.getStage().getHeight() - 10.0f, 18);
    }

    public final void updateLeftSideTable$core(@Nullable Civilization selectCiv) {
        this.leftSideTable.clear();
        this.leftSideTable.add().padBottom(10.0f).row();
        float selectCivY = 0.0f;
        Iterator iterator2 = DiplomacyFunctions.getKnownCivsSorted$default(this.viewingCiv.getDiplomacyFunctions(), false, false, 3, null).iterator();
        while (iterator2.hasNext()) {
            Table table2;
            Actor actor;
            Object object;
            DiplomacyManager diplomacy;
            Civilization civ = (Civilization)iterator2.next();
            if (Intrinsics.areEqual(civ, selectCiv)) {
                selectCivY = this.leftSideTable.getPrefHeight();
            }
            Portrait civIndicator = ImageGetter.INSTANCE.getNationPortrait(civ.getNation(), 100.0f);
            Intrinsics.checkNotNull(civ.getDiplomacyManager(this.viewingCiv));
            RelationshipLevel relationLevel = diplomacy.relationshipLevel();
            if (civ.isCityState() && relationLevel == RelationshipLevel.Ally) {
                Object $this$updateLeftSideTable_u24lambda_u240 = object = Scene2dExtensionsKt.surroundWithCircle$default(ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Star", null, 2, null), 30.0f, false, relationLevel.getColor(), null, 10, null);
                boolean bl = false;
                ((IconCircleGroup)$this$updateLeftSideTable_u24lambda_u240).getActor().setColor(Color.GOLD);
                actor = (Actor)object;
            } else {
                object = civ.isHuman() && this.viewingCiv.isHuman() ? this.getHumanRelationshipColor(diplomacy) : (diplomacy.getDiplomaticStatus() == DiplomaticStatus.DefensivePact ? Color.PURPLE : (civ.isAtWarWith(this.viewingCiv) ? Color.RED : relationLevel.getColor()));
                Intrinsics.checkNotNull(object);
                actor = ImageGetter.INSTANCE.getCircle((Color)object, Float.valueOf(30.0f));
            }
            Actor relationshipIcon = actor;
            civIndicator.addActor(relationshipIcon);
            if (civ.isCityState()) {
                IconCircleGroup iconCircleGroup;
                Nation nation = civ.getGameInfo().getRuleset().getNations().get(civ.getCivName());
                Intrinsics.checkNotNull(nation);
                Color innerColor = nation.getInnerColor();
                IconCircleGroup $this$updateLeftSideTable_u24lambda_u241 = iconCircleGroup = Scene2dExtensionsKt.surroundWithCircle$default(ImageGetter.getImage$default(ImageGetter.INSTANCE, "CityStateIcons/" + civ.getCityStateType().getName(), null, 2, null), 35.0f, false, innerColor, null, 10, null);
                boolean bl = false;
                $this$updateLeftSideTable_u24lambda_u241.getActor().setColor(ImageGetter.INSTANCE.getCHARCOAL());
                IconCircleGroup typeIcon = iconCircleGroup;
                civIndicator.addActor(typeIcon);
                typeIcon.setY((float)Math.floor(civIndicator.getHeight() - typeIcon.getHeight()));
                typeIcon.setX((float)Math.floor(civIndicator.getWidth() - typeIcon.getWidth()));
            }
            if (civ.isCityState() && civ.getQuestManager().haveQuestsFor(this.viewingCiv)) {
                Actor actor2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Quest", null, 2, null);
                Color color = Color.GOLDENROD;
                Intrinsics.checkNotNullExpressionValue(color, "GOLDENROD");
                IconCircleGroup questIcon = Scene2dExtensionsKt.surroundWithCircle$default(actor2, 30.0f, false, color, null, 10, null);
                civIndicator.addActor(questIcon);
                questIcon.setX((float)Math.floor(civIndicator.getWidth() - questIcon.getWidth()));
            }
            Label civNameLabel = Scene2dExtensionsKt.toLabel$default(civ.getCivName(), null, 0, 0, true, 7, null);
            Table $this$updateLeftSideTable_u24lambda_u242 = table2 = new Table();
            boolean bl = false;
            $this$updateLeftSideTable_u24lambda_u242.defaults().pad(10.0f);
            $this$updateLeftSideTable_u24lambda_u242.add((Actor)civIndicator).row();
            $this$updateLeftSideTable_u24lambda_u242.add((Actor)civNameLabel).row();
            ActivationExtensionsKt.onClick($this$updateLeftSideTable_u24lambda_u242, () -> DiplomacyScreen.updateLeftSideTable$lambda$2$0(this, civ, $this$updateLeftSideTable_u24lambda_u242));
            if (Intrinsics.areEqual(civ, selectCiv)) {
                this.highlightCiv($this$updateLeftSideTable_u24lambda_u242);
            }
            Table civButton = table2;
            this.leftSideTable.add((Actor)civButton).padBottom(10.0f).growX().row();
        }
        if (!(selectCivY == 0.0f)) {
            this.leftSideScroll.layout();
            this.leftSideScroll.setScrollY(selectCivY + (120.0f - this.getStage().getHeight()) / (float)2);
            this.leftSideScroll.updateVisualScroll();
        }
    }

    private final void highlightCiv(Table civButton) {
        Table table2 = this.highlightedCivButton;
        if (table2 != null) {
            table2.setBackground((Drawable)null);
        }
        civButton.setBackground(this.highlightBackground);
        this.highlightedCivButton = civButton;
    }

    public final void updateRightSide$core(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        this.rightSideTable.clear();
        UncivGame.Companion.getCurrent().getMusicController().chooseTrack(otherCiv.getCivName(), MusicMood.INSTANCE.peaceOrWar(this.viewingCiv.isAtWarWith(otherCiv)), MusicTrackChooserFlags.Companion.getSetSelectNation());
        this.rightSideTable.add((Actor)new AutoScrollPane((Actor)(otherCiv.isCityState() ? new CityStateDiplomacyTable(this).getCityStateDiplomacyTable(otherCiv) : new MajorCivDiplomacyTable(this).getMajorCivDiplomacyTable(otherCiv)), null, 2, null)).height(this.getStage().getHeight());
    }

    @NotNull
    public final TradeTable setTrade$core(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        this.rightSideTable.clear();
        TradeTable tradeTable = new TradeTable(this.viewingCiv, otherCiv, this);
        this.rightSideTable.add((Actor)tradeTable);
        return tradeTable;
    }

    private final Color getHumanRelationshipColor(DiplomacyManager otherCivDiplomacyManager) {
        Color color;
        if (otherCivDiplomacyManager.getDiplomaticStatus() == DiplomaticStatus.DefensivePact) {
            Color color2 = Color.CYAN;
            color = color2;
            Intrinsics.checkNotNullExpressionValue(color2, "CYAN");
        } else if (otherCivDiplomacyManager.hasFlag(DiplomacyFlags.DeclarationOfFriendship)) {
            Color color3 = Color.GREEN;
            color = color3;
            Intrinsics.checkNotNullExpressionValue(color3, "GREEN");
        } else if (otherCivDiplomacyManager.getDiplomaticStatus() == DiplomaticStatus.War) {
            Color color4 = Color.RED;
            color = color4;
            Intrinsics.checkNotNullExpressionValue(color4, "RED");
        } else {
            color = RelationshipLevel.Neutral.getColor();
        }
        return color;
    }

    private final String getHumanRelationshipText(DiplomacyManager otherCivDiplomacyManager) {
        return otherCivDiplomacyManager.getDiplomaticStatus() == DiplomaticStatus.DefensivePact ? "Defensive Pact" : (otherCivDiplomacyManager.hasFlag(DiplomacyFlags.DeclarationOfFriendship) ? "Friend" : (otherCivDiplomacyManager.getDiplomaticStatus() == DiplomaticStatus.War ? "Enemy" : "Neutral"));
    }

    @NotNull
    public final Table getHumanRelationshipTable$core(@NotNull DiplomacyManager otherCivDiplomacyManager) {
        Intrinsics.checkNotNullParameter(otherCivDiplomacyManager, "otherCivDiplomacyManager");
        Table relationshipTable = new Table();
        Color relationshipColor = this.getHumanRelationshipColor(otherCivDiplomacyManager);
        String relationshipText = this.getHumanRelationshipText(otherCivDiplomacyManager);
        relationshipTable.add((Actor)Scene2dExtensionsKt.toLabel("{Our relationship}: "));
        relationshipTable.add((Actor)Scene2dExtensionsKt.toLabel$default(relationshipText, relationshipColor, 0, 0, false, 14, null)).row();
        return relationshipTable;
    }

    @NotNull
    public final Table getRelationshipTable$core(@NotNull DiplomacyManager otherCivDiplomacyManager) {
        Color color;
        Intrinsics.checkNotNullParameter(otherCivDiplomacyManager, "otherCivDiplomacyManager");
        Table relationshipTable = new Table();
        int opinionOfUs = otherCivDiplomacyManager.getCivInfo().isCityState() ? (int)otherCivDiplomacyManager.getInfluence() : (int)otherCivDiplomacyManager.opinionOfOtherCiv();
        relationshipTable.add((Actor)Scene2dExtensionsKt.toLabel("{Our relationship}: "));
        RelationshipLevel relationshipLevel = otherCivDiplomacyManager.relationshipLevel();
        String relationshipText = TranslationsKt.tr$default(relationshipLevel.name(), false, false, 3, null) + " (" + opinionOfUs + ')';
        switch (WhenMappings.$EnumSwitchMapping$0[relationshipLevel.ordinal()]) {
            case 1: {
                color = Color.WHITE;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                color = Color.GREEN;
                break;
            }
            case 5: {
                color = Color.YELLOW;
                break;
            }
            default: {
                color = Color.RED;
            }
        }
        Color relationshipColor = color;
        Intrinsics.checkNotNull(relationshipColor);
        relationshipTable.add((Actor)Scene2dExtensionsKt.toLabel$default(relationshipText, relationshipColor, 0, 0, false, 14, null)).row();
        if (otherCivDiplomacyManager.getCivInfo().isCityState()) {
            relationshipTable.add((Actor)new InfluenceTable(otherCivDiplomacyManager.getInfluence(), relationshipLevel, 200.0f, 10.0f)).colspan(2).pad(5.0f);
        }
        return relationshipTable;
    }

    @NotNull
    public final TextButton getDeclareWarButton$core(@NotNull DiplomacyManager diplomacyManager, @NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(diplomacyManager, "diplomacyManager");
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        TextButton declareWarButton = Scene2dExtensionsKt.toTextButton$default("Declare war", BaseScreen.Companion.getSkin().get("negative", TextButton.TextButtonStyle.class), false, 2, null);
        int turnsToPeaceTreaty = diplomacyManager.turnsToPeaceTreaty();
        if (turnsToPeaceTreaty > 0) {
            Scene2dExtensionsKt.disable(declareWarButton);
            declareWarButton.setText(declareWarButton.getText() + " (" + TranslationsKt.tr(turnsToPeaceTreaty) + "\u23f3)");
        }
        ActivationExtensionsKt.onClick(declareWarButton, () -> DiplomacyScreen.getDeclareWarButton$lambda$0(this, otherCiv, diplomacyManager));
        if (this.isNotPlayersTurn$core()) {
            Scene2dExtensionsKt.disable(declareWarButton);
        }
        return declareWarButton;
    }

    /*
     * WARNING - void declaration
     */
    private final String getDeclareWarButtonText(Civilization otherCiv) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean bl;
        DiplomacyManager otherCivDiploManager;
        void $this$filterTo$iv$iv;
        ArrayList messageLines = new ArrayList();
        ((Collection)messageLines).add("Declare war on [" + otherCiv.getCivName() + "]?");
        Collection<DiplomacyManager> collection = otherCiv.getDiplomacy().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            otherCivDiploManager = (DiplomacyManager)element$iv$iv;
            bl = false;
            if (!(!Intrinsics.areEqual(otherCivDiploManager.otherCiv(), this.viewingCiv) && otherCivDiploManager.getDiplomaticStatus() == DiplomaticStatus.DefensivePact && !otherCivDiploManager.otherCiv().isAtWarWith(this.viewingCiv))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            otherCivDiploManager = (DiplomacyManager)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            bl = false;
            collection2.add(it.otherCiv());
        }
        List otherCivDefensivePactList = (List)destination$iv$iv;
        for (Civilization civ : otherCivDefensivePactList) {
            ((Collection)messageLines).add(this.viewingCiv.knows(civ) ? '[' + civ.getCivName() + "] will also join them in the war" : "[An unknown civilization] will also join them in the war");
        }
        for (Object object : this.viewingCiv.getDiplomacy().values()) {
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            DiplomacyManager civDiploManager = (DiplomacyManager)object;
            if (Intrinsics.areEqual(civDiploManager.otherCiv(), otherCiv) || civDiploManager.getDiplomaticStatus() != DiplomaticStatus.DefensivePact || otherCivDefensivePactList.contains(civDiploManager.otherCiv())) continue;
            ((Collection)messageLines).add("This will cancel your defensive pact with [" + civDiploManager.getOtherCivName() + ']');
        }
        return CollectionsKt.joinToString$default(messageLines, "\n", null, null, 0, null, DiplomacyScreen::getDeclareWarButtonText$lambda$2, 30, null);
    }

    public final void setRightSideFlavorText$core(@NotNull Civilization otherCiv, @NotNull String flavorText, @NotNull String response2) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        Intrinsics.checkNotNullParameter(flavorText, "flavorText");
        Intrinsics.checkNotNullParameter(response2, "response");
        Table diplomacyTable = new Table();
        diplomacyTable.defaults().pad(10.0f);
        diplomacyTable.add((Actor)new LeaderIntroTable(otherCiv, null, 2, null));
        Scene2dExtensionsKt.addSeparator$default(diplomacyTable, null, 0, 0.0f, 7, null);
        diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel(flavorText)).row();
        TextButton responseButton = Scene2dExtensionsKt.toTextButton$default(response2, null, false, 3, null);
        ActivationExtensionsKt.onActivation(responseButton, () -> DiplomacyScreen.setRightSideFlavorText$lambda$0(this, otherCiv));
        ActivationExtensionsKt.getKeyShortcuts(responseButton).add(KeyCharAndCode.Companion.getSPACE());
        diplomacyTable.add((Actor)responseButton);
        this.rightSideTable.clear();
        this.rightSideTable.add((Actor)diplomacyTable);
    }

    @NotNull
    public final TextButton getGoToOnMapButton$core(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "civilization");
        TextButton goToOnMapButton = Scene2dExtensionsKt.toTextButton$default("Go to on map", null, false, 3, null);
        ActivationExtensionsKt.onClick(goToOnMapButton, () -> DiplomacyScreen.getGoToOnMapButton$lambda$0(civilization));
        return goToOnMapButton;
    }

    public final float getTradeColumnsWidth$core() {
        return (this.getStage().getWidth() * 0.8f - 3.0f) / (float)2;
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        this.positionCloseButton();
    }

    @Override
    @NotNull
    public BaseScreen recreate() {
        return new DiplomacyScreen(this.viewingCiv, this.selectCiv, this.selectTrade, this.showTrade);
    }

    private static final Unit closeButton$lambda$0(DiplomacyScreen this$0) {
        UncivGame.popScreen$default(this$0.getGame(), false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit updateLeftSideTable$lambda$2$0(DiplomacyScreen this$0, Civilization $civ, Table $this_apply) {
        this$0.updateRightSide$core($civ);
        this$0.highlightCiv($this_apply);
        return Unit.INSTANCE;
    }

    private static final Unit getDeclareWarButton$lambda$0(DiplomacyScreen this$0, Civilization $otherCiv, DiplomacyManager $diplomacyManager) {
        Popup.open$default(new ConfirmPopup(this$0, this$0.getDeclareWarButtonText($otherCiv), "Declare war", false, null, () -> DiplomacyScreen.getDeclareWarButton$lambda$0$0($diplomacyManager, this$0, $otherCiv), 24, null), false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit getDeclareWarButton$lambda$0$0(DiplomacyManager $diplomacyManager, DiplomacyScreen this$0, Civilization $otherCiv) {
        DiplomacyManager.declareWar$default($diplomacyManager, null, 1, null);
        this$0.setRightSideFlavorText$core($otherCiv, $otherCiv.getNation().getAttacked(), "Very well.");
        this$0.updateLeftSideTable$core($otherCiv);
        MusicController music = UncivGame.Companion.getCurrent().getMusicController();
        music.chooseTrack($otherCiv.getCivName(), "War", MusicTrackChooserFlags.Companion.getSetSpecific());
        music.playVoice($otherCiv.getCivName() + ".attacked");
        return Unit.INSTANCE;
    }

    private static final CharSequence getDeclareWarButtonText$lambda$2(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return '{' + it + '}';
    }

    private static final Unit setRightSideFlavorText$lambda$0(DiplomacyScreen this$0, Civilization $otherCiv) {
        this$0.updateRightSide$core($otherCiv);
        return Unit.INSTANCE;
    }

    private static final Unit getGoToOnMapButton$lambda$0(Civilization $civilization) {
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().resetToWorldScreen();
        WorldMapHolder worldMapHolder = worldScreen.getMapHolder();
        City city = Civilization.getCapital$default($civilization, false, 1, null);
        Intrinsics.checkNotNull(city);
        WorldMapHolder.setCenterPosition$default(worldMapHolder, city.getLocation(), false, false, null, 10, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen$Companion;", "", "<init>", "()V", "nationIconSize", "", "nationIconPad", "closeButtonSize", "closeButtonPad", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen$ScrollPaneWithMinSize;", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "<init>", "(Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;)V", "getMinWidth", "", "getPrefWidth", "core"})
    private final class ScrollPaneWithMinSize
    extends AutoScrollPane {
        public ScrollPaneWithMinSize() {
            super((Actor)DiplomacyScreen.this.leftSideTable, null, 2, null);
        }

        @Override
        public float getMinWidth() {
            return 110.0f;
        }

        @Override
        public float getPrefWidth() {
            return this.getMinWidth() + 20.0f;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen$SplitPaneCenteringLeftSide;", "Lcom/badlogic/gdx/scenes/scene2d/ui/SplitPane;", "<init>", "(Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;)V", "lastSplitAmount", "", "getLastSplitAmount", "()F", "setLastSplitAmount", "(F)V", "validate", "", "core"})
    private final class SplitPaneCenteringLeftSide
    extends SplitPane {
        private float lastSplitAmount;

        public SplitPaneCenteringLeftSide() {
            super((Actor)DiplomacyScreen.this.leftSideScroll, (Actor)DiplomacyScreen.this.getRightSideTable$core(), false, BaseScreen.Companion.getSkin());
            this.lastSplitAmount = this.getSplitAmount();
        }

        public final float getLastSplitAmount() {
            return this.lastSplitAmount;
        }

        public final void setLastSplitAmount(float f) {
            this.lastSplitAmount = f;
        }

        @Override
        public void validate() {
            super.validate();
            if (this.getSplitAmount() == this.lastSplitAmount) {
                return;
            }
            this.lastSplitAmount = this.getSplitAmount();
            DiplomacyScreen.this.leftSideScroll.setScrollPercentX(0.5f);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RelationshipLevel.values().length];
            try {
                nArray[RelationshipLevel.Neutral.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Favorable.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Friend.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Ally.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Afraid.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

