/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.map.HexMath;
import com.unciv.models.ruleset.nation.NationKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.ClickableCircle;
import com.unciv.ui.components.widgets.ShadowedLabel;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.popups.AnimatedMenuPopup;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ@\u0010\t\u001a\u00020\n2.\u0010\u000b\u001a*\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fj\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e`\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsDiagramGroup;", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "undefeatedCivs", "", "Lcom/unciv/logic/civilization/Civilization;", "freeSize", "", "<init>", "(Ljava/util/List;F)V", "onCivClicked", "", "civLines", "Ljava/util/HashMap;", "", "", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "Lkotlin/collections/HashMap;", "name", "DiagramLegendPopup", "core"})
@SourceDebugExtension(value={"SMAP\nGlobalPoliticsDiagramGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalPoliticsDiagramGroup.kt\ncom/unciv/ui/screens/overviewscreen/GlobalPoliticsDiagramGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,177:1\n1869#2,2:178\n1869#2,2:188\n1869#2,2:191\n536#3:180\n521#3,6:181\n216#4:187\n217#4:190\n*S KotlinDebug\n*F\n+ 1 GlobalPoliticsDiagramGroup.kt\ncom/unciv/ui/screens/overviewscreen/GlobalPoliticsDiagramGroup\n*L\n121#1:178,2\n129#1:188,2\n133#1:191,2\n128#1:180\n128#1:181,6\n129#1:187\n129#1:190\n*E\n"})
public final class GlobalPoliticsDiagramGroup
extends Group {
    public GlobalPoliticsDiagramGroup(@NotNull List<Civilization> undefeatedCivs, float freeSize) {
        Intrinsics.checkNotNullParameter(undefeatedCivs, "undefeatedCivs");
        this.setSize(freeSize, freeSize);
        ClickableCircle clickableArea = new ClickableCircle(freeSize / 1.25f - 25.0f);
        ActivationExtensionsKt.onActivation(clickableArea, () -> GlobalPoliticsDiagramGroup._init_$lambda$0(this));
        Scene2dExtensionsKt.center((Actor)clickableArea, this);
        this.addActor(clickableArea);
        HashMap civGroups = new HashMap();
        HashMap civLines = new HashMap();
        int civCount = ((Collection)undefeatedCivs).size();
        Iterator<Object> iterator2 = ((Iterable)undefeatedCivs).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            Civilization civ = (Civilization)iterator2.next();
            Portrait civGroup = ImageGetter.INSTANCE.getNationPortrait(civ.getNation(), 30.0f);
            Vector2 vector = HexMath.INSTANCE.getVectorForAngle((float)Math.PI * 2 * (float)i / (float)civCount);
            Scene2dExtensionsKt.center((Actor)civGroup, this);
            civGroup.moveBy(vector.x * freeSize / 2.25f, vector.y * freeSize / 2.25f);
            civGroup.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onClick(civGroup, () -> GlobalPoliticsDiagramGroup._init_$lambda$1(this, civLines, civ));
            UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, civGroup, civ.getCivName(), 0.0f, false, 0, 12, false, null, 110, null);
            ((Map)civGroups).put(civ.getCivName(), civGroup);
            this.addActor(civGroup);
        }
        for (Civilization civ : undefeatedCivs) {
            if (civ.isDefeated()) continue;
            Iterator<DiplomacyManager> iterator3 = civ.getDiplomacy().values().iterator();
            while (iterator3.hasNext()) {
                DiplomacyManager diplomacy;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                Civilization otherCiv = diplomacy.otherCiv();
                if (!undefeatedCivs.contains(otherCiv) || otherCiv.isDefeated()) continue;
                Object v = civGroups.get(civ.getCivName());
                Intrinsics.checkNotNull(v);
                Actor civGroup = (Actor)v;
                Object v2 = civGroups.get(diplomacy.getOtherCivName());
                Intrinsics.checkNotNull(v2);
                Actor otherCivGroup = (Actor)v2;
                Image statusLine = ImageGetter.INSTANCE.getLine(civGroup.getX() + civGroup.getWidth() / (float)2, civGroup.getY() + civGroup.getHeight() / (float)2, otherCivGroup.getX() + otherCivGroup.getWidth() / (float)2, otherCivGroup.getY() + otherCivGroup.getHeight() / (float)2, 2.0f);
                statusLine.setColor(diplomacy.getDiplomaticStatus() == DiplomaticStatus.War ? Color.RED : (diplomacy.getDiplomaticStatus() == DiplomaticStatus.DefensivePact && !civ.isCityState() && !otherCiv.isCityState() ? Color.PURPLE : (civ.isHuman() && otherCiv.isHuman() && diplomacy.hasModifier(DiplomaticModifiers.DeclarationOfFriendship) ? RelationshipLevel.Friend.getColor() : (civ.isCityState() && Intrinsics.areEqual(civ.getAllyCivName(), diplomacy.getOtherCivName()) || otherCiv.isCityState() && Intrinsics.areEqual(otherCiv.getAllyCivName(), civ.getCivName()) ? RelationshipLevel.Ally.getColor() : diplomacy.relationshipLevel().getColor()))));
                if (!civLines.containsKey(civ.getCivName())) {
                    ((Map)civLines).put(civ.getCivName(), (Set)new LinkedHashSet());
                }
                Object v3 = civLines.get(civ.getCivName());
                Intrinsics.checkNotNull(v3);
                ((Set)v3).add(statusLine);
                this.addActorAt(0, statusLine);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onCivClicked(HashMap<String, Set<Actor>> civLines, String name) {
        Iterable $this$forEach$iv;
        Set<Actor> set = civLines.get(name);
        if (set == null) {
            return;
        }
        Set<Actor> selectedLines = set;
        boolean atLeastOneLineVisible = false;
        boolean allAreLinesInvisible = true;
        Iterator<Set<Actor>> iterator2 = civLines.values().iterator();
        while (iterator2.hasNext()) {
            Set<Actor> lines2;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (Intrinsics.areEqual(lines2, selectedLines) || lines2.isEmpty()) continue;
            boolean visibility = ((Actor)CollectionsKt.first((Iterable)lines2)).isVisible();
            atLeastOneLineVisible = atLeastOneLineVisible || visibility;
            boolean bl = allAreLinesInvisible = allAreLinesInvisible && visibility;
            if (!atLeastOneLineVisible || allAreLinesInvisible) continue;
            Iterable $this$forEach$iv2 = selectedLines;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                Actor it = (Actor)element$iv;
                boolean bl2 = false;
                it.setVisible(!it.isVisible());
            }
            return;
        }
        if (((Actor)CollectionsKt.first((Iterable)selectedLines)).isVisible()) {
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = civLines;
            boolean $i$f$filter = false;
            Map visibility = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator3.next();
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it.getKey(), name))) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator4 = $this$forEach$iv.entrySet().iterator();
            while (iterator4.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator4.next();
                boolean bl = false;
                Iterable $this$forEach$iv3 = (Iterable)it.getValue();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv3) {
                    Actor line = (Actor)element$iv2;
                    boolean bl3 = false;
                    line.setVisible(!line.isVisible());
                }
            }
        } else {
            $this$forEach$iv = selectedLines;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Actor it = (Actor)element$iv;
                boolean bl = false;
                it.setVisible(!it.isVisible());
            }
        }
    }

    private static final Unit _init_$lambda$0(GlobalPoliticsDiagramGroup this$0) {
        Stage stage = this$0.getStage();
        Intrinsics.checkNotNullExpressionValue(stage, "getStage(...)");
        new DiagramLegendPopup(stage, (Actor)this$0);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(GlobalPoliticsDiagramGroup this$0, HashMap $civLines, Civilization $civ) {
        this$0.onCivClicked($civLines, $civ.getCivName());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b*\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsDiagramGroup$DiagramLegendPopup;", "Lcom/unciv/ui/popups/AnimatedMenuPopup;", "stage", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "diagram", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "<init>", "(Lcom/badlogic/gdx/scenes/scene2d/Stage;Lcom/badlogic/gdx/scenes/scene2d/Actor;)V", "createContentTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "addLegendRow", "", "text", "", "color", "Lcom/badlogic/gdx/graphics/Color;", "Companion", "core"})
    private static final class DiagramLegendPopup
    extends AnimatedMenuPopup {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static final float lineWidth = 3.0f;
        public static final float lowContrastWidth = 4.0f;
        public static final float lineLength = 120.0f;

        public DiagramLegendPopup(@NotNull Stage stage, @NotNull Actor diagram) {
            Intrinsics.checkNotNullParameter(stage, "stage");
            Intrinsics.checkNotNullParameter(diagram, "diagram");
            super(stage, DiagramLegendPopup.Companion.getCenterInStageCoordinates(diagram));
            this.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onActivation(this, () -> DiagramLegendPopup._init_$lambda$0(this));
        }

        @Override
        @NotNull
        public Table createContentTable() {
            Table legend = new Table();
            legend.setBackground(ImageGetter.INSTANCE.getDrawable("OtherIcons/Politics-diagram-bg"));
            legend.add((Actor)new ShadowedLabel("Diagram line colors", 24, null, null, false, 0.0f, 60, null)).colspan(2).row();
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color, "RED");
            this.addLegendRow(legend, "War", color);
            Object object = RelationshipLevel.getEntries().iterator();
            while (object.hasNext()) {
                RelationshipLevel level = (RelationshipLevel)((Object)object.next());
                this.addLegendRow(legend, level.name(), level.getColor());
            }
            Color color2 = Color.PURPLE;
            Intrinsics.checkNotNullExpressionValue(color2, "PURPLE");
            this.addLegendRow(legend, "Defensive Pact", color2);
            Table table2 = super.createContentTable();
            Intrinsics.checkNotNull(table2);
            Object $this$createContentTable_u24lambda_u240 = object = table2;
            boolean bl = false;
            ((Table)$this$createContentTable_u24lambda_u240).add((Actor)legend).grow();
            return object;
        }

        public final void addLegendRow(@NotNull Table $this$addLegendRow, @NotNull String text2, @NotNull Color color) {
            Intrinsics.checkNotNullParameter($this$addLegendRow, "<this>");
            Intrinsics.checkNotNullParameter(text2, "text");
            Intrinsics.checkNotNullParameter(color, "color");
            Color color2 = Color.DARK_GRAY;
            Intrinsics.checkNotNullExpressionValue(color2, "DARK_GRAY");
            float contrast = (float)NationKt.getContrastRatio(color2, color);
            float width = 3.0f + 1.0f / RangesKt.coerceAtLeast(contrast, 1.0f);
            Image line = ImageGetter.INSTANCE.getLine(0.0f, width / (float)2, 120.0f, width / (float)2, width);
            line.setColor(color);
            $this$addLegendRow.add((Actor)line).size(120.0f, width).padTop(5.0f);
            $this$addLegendRow.add((Actor)new ShadowedLabel(text2, 0, null, null, false, 0.0f, 62, null)).padLeft(5.0f).padTop(10.0f).row();
        }

        private static final Unit _init_$lambda$0(DiagramLegendPopup this$0) {
            this$0.close();
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsDiagramGroup$DiagramLegendPopup$Companion;", "", "<init>", "()V", "getCenterInStageCoordinates", "Lcom/badlogic/gdx/math/Vector2;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "lineWidth", "", "lowContrastWidth", "lineLength", "core"})
        public static final class Companion {
            private Companion() {
            }

            private final Vector2 getCenterInStageCoordinates(Actor $this$getCenterInStageCoordinates) {
                Vector2 vector2 = $this$getCenterInStageCoordinates.localToStageCoordinates(new Vector2($this$getCenterInStageCoordinates.getWidth() / (float)2, $this$getCenterInStageCoordinates.getHeight() / (float)2));
                Intrinsics.checkNotNullExpressionValue(vector2, "localToStageCoordinates(...)");
                return vector2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

