/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.worldmap;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.unciv.UncivGame;
import com.unciv.logic.automation.unit.CityLocationTileRanker;
import com.unciv.logic.battle.AttackableTile;
import com.unciv.logic.battle.TargetHelper;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.MapPathing;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Spy;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.tilegroups.WorldTileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayerOverlay;
import com.unciv.ui.screens.worldscreen.unit.UnitTable;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\t\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/unciv/ui/screens/worldscreen/worldmap/WorldMapTileUpdater;", "", "<init>", "()V", "updateTiles", "", "Lcom/unciv/ui/screens/worldscreen/worldmap/WorldMapHolder;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "updateTilesForSelectedUnit", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "updateTilesForSelectedSpy", "spy", "Lcom/unciv/models/Spy;", "updateBombardableTilesForSelectedCity", "city", "Lcom/unciv/logic/city/City;", "core"})
@SourceDebugExtension(value={"SMAP\nWorldMapTileUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldMapTileUpdater.kt\ncom/unciv/ui/screens/worldscreen/worldmap/WorldMapTileUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,269:1\n1869#2,2:270\n774#2:272\n865#2,2:273\n785#2:275\n796#2:276\n1878#2,2:277\n797#2,2:279\n1880#2:281\n799#2:282\n1563#2:283\n1634#2,3:284\n774#2:287\n865#2,2:288\n1669#2,8:290\n622#3:298\n1321#3,2:299\n1255#3,2:301\n*S KotlinDebug\n*F\n+ 1 WorldMapTileUpdater.kt\ncom/unciv/ui/screens/worldscreen/worldmap/WorldMapTileUpdater\n*L\n24#1:270,2\n106#1:272\n106#1:273,2\n188#1:275\n188#1:276\n188#1:277,2\n188#1:279,2\n188#1:281\n188#1:282\n190#1:283\n190#1:284,3\n218#1:287\n218#1:288,2\n219#1:290,8\n240#1:298\n240#1:299,2\n213#1:301,2\n*E\n"})
public final class WorldMapTileUpdater {
    @NotNull
    public static final WorldMapTileUpdater INSTANCE = new WorldMapTileUpdater();

    private WorldMapTileUpdater() {
    }

    public final void updateTiles(@NotNull WorldMapHolder $this$updateTiles, @NotNull Civilization viewingCiv) {
        Group group;
        Intrinsics.checkNotNullParameter($this$updateTiles, "<this>");
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        if ($this$updateTiles.isMapRevealEnabled(viewingCiv)) {
            Collection<WorldTileGroup> collection = $this$updateTiles.getTileGroups().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorldTileGroup it = (WorldTileGroup)element$iv;
                boolean bl = false;
                Tile.setExplored$default(it.getTile(), viewingCiv, true, null, 4, null);
                it.setForceVisible(true);
            }
        }
        LocalUniqueCache uniqueCache = new LocalUniqueCache(true);
        Iterator<WorldTileGroup> $i$f$forEach = $this$updateTiles.getTileGroups().values().iterator();
        while ($i$f$forEach.hasNext()) {
            WorldTileGroup tileGroup;
            Intrinsics.checkNotNullExpressionValue($i$f$forEach.next(), "next(...)");
            tileGroup.update(viewingCiv, uniqueCache);
        }
        UnitTable unitTable = $this$updateTiles.getWorldScreen$core().getBottomUnitTable$core();
        if (unitTable.getSelectedSpy() != null) {
            Spy spy = unitTable.getSelectedSpy();
            Intrinsics.checkNotNull(spy);
            this.updateTilesForSelectedSpy($this$updateTiles, spy);
        } else if (unitTable.getSelectedCity() != null) {
            City city = unitTable.getSelectedCity();
            Intrinsics.checkNotNull(city);
            City city2 = city;
            this.updateBombardableTilesForSelectedCity($this$updateTiles, city2);
            if (unitTable.getSelectedUnitIsConnectingRoad()) {
                this.updateTilesForSelectedUnit($this$updateTiles, unitTable.getSelectedUnits().get(0));
            }
        } else if (unitTable.getSelectedUnit() != null) {
            for (MapUnit unit : unitTable.getSelectedUnits()) {
                this.updateTilesForSelectedUnit($this$updateTiles, unit);
            }
        } else if (!((Collection)$this$updateTiles.getUnitActionOverlays$core()).isEmpty()) {
            $this$updateTiles.removeUnitActionOverlay();
        }
        if ((group = (WorldTileGroup)((Map)$this$updateTiles.getTileGroups()).get($this$updateTiles.getSelectedTile$core())) != null && (group = group.getLayerOverlay()) != null) {
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            TileLayerOverlay.showHighlight$default((TileLayerOverlay)group, color, 0.0f, 2, null);
        }
        $this$updateTiles.zoom($this$updateTiles.getScaleX());
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final void updateTilesForSelectedUnit(WorldMapHolder $this$updateTilesForSelectedUnit, MapUnit unit) {
        v0 = $this$updateTilesForSelectedUnit.getTileGroups().get(unit.getTile());
        if (v0 == null) {
            return;
        }
        tileGroup = v0;
        if (!unit.getBaseUnit().getMovesLikeAirUnits()) {
            tileGroup.getLayerUnitFlag().selectFlag(unit);
        }
        if (unit.isMilitary()) {
            var4_4 = $this$updateTilesForSelectedUnit.getTileGroups().values().iterator();
            while (var4_4.hasNext()) {
                Intrinsics.checkNotNullExpressionValue(var4_4.next(), "next(...)");
                group.getLayerMisc().dimPopulation(true);
                shownImprovement = group.getTile().getShownImprovement(unit.getCiv());
                if (shownImprovement == null || Intrinsics.areEqual(shownImprovement, "Barbarian encampment")) continue;
                v1 = unit.getCiv().getGameInfo().getRuleset().getTileImprovements().get(shownImprovement);
                Intrinsics.checkNotNull(v1);
                if (v1.isAncientRuinsEquivalent(unit.getCache().getState())) continue;
                group.getLayerImprovement().dimImprovement(true);
            }
        }
        if ($this$updateTilesForSelectedUnit.getWorldScreen$core().getBottomUnitTable$core().getSelectedUnitIsSwapping()) {
            unitSwappableTiles = unit.getMovement().getUnitSwappableTiles();
            swapUnitsTileOverlayColor = Color.PURPLE;
            shownImprovement = unitSwappableTiles.iterator();
            while (shownImprovement.hasNext()) {
                tile = shownImprovement.next();
                v2 = $this$updateTilesForSelectedUnit.getTileGroups().get(tile);
                Intrinsics.checkNotNull(v2);
                v3 = v2.getLayerOverlay();
                Intrinsics.checkNotNull(swapUnitsTileOverlayColor);
                v3.showHighlight(swapUnitsTileOverlayColor, UncivGame.Companion.getCurrent().getSettings().getSingleTapMove() != false ? 0.7f : 0.3f);
            }
            return;
        }
        if ($this$updateTilesForSelectedUnit.getWorldScreen$core().getBottomUnitTable$core().getSelectedUnitIsConnectingRoad()) {
            if (unit.getCurrentTile().getRuleset().getRoadImprovement() == null) {
                return;
            }
            $this$filter$iv = unit.getCiv().getGameInfo().getTileMap().getTileList();
            $i$f$filter = false;
            tile = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Tile)element$iv$iv;
                $i$a$-filter-WorldMapTileUpdater$updateTilesForSelectedUnit$validTiles$1 = false;
                if (!MapPathing.INSTANCE.isValidRoadPathTile(unit.getCiv(), it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            validTiles = (List)destination$iv$iv;
            connectRoadTileOverlayColor = Color.RED;
            for (Object tile : validTiles) {
                v4 = $this$updateTilesForSelectedUnit.getTileGroups().get(tile);
                Intrinsics.checkNotNull(v4);
                v5 = v4.getLayerOverlay();
                Intrinsics.checkNotNull(connectRoadTileOverlayColor);
                v5.showHighlight(connectRoadTileOverlayColor, 0.3f);
            }
            if ($this$updateTilesForSelectedUnit.getUnitConnectRoadPaths$core().containsKey(unit)) {
                v6 = $this$updateTilesForSelectedUnit.getUnitConnectRoadPaths$core().get(unit);
                Intrinsics.checkNotNull(v6);
                for (Object tile : v6) {
                    v7 = $this$updateTilesForSelectedUnit.getTileGroups().get(tile);
                    Intrinsics.checkNotNull(v7);
                    v8 = v7.getLayerOverlay();
                    v9 = Color.ORANGE;
                    Intrinsics.checkNotNullExpressionValue(v9, "ORANGE");
                    v8.showHighlight(v9, 0.8f);
                }
            }
            return;
        }
        isAirUnit = unit.getBaseUnit().getMovesLikeAirUnits();
        moveTileOverlayColor = unit.isPreparingParadrop() != false ? Color.BLUE : Color.WHITE;
        tilesInMoveRange = UnitMovement.getReachableTilesInCurrentTurn$default(unit.getMovement(), false, 1, null);
        nukeBlastRadius = unit.isNuclearWeapon() != false && $this$updateTilesForSelectedUnit.getSelectedTile$core() != null && Intrinsics.areEqual($this$updateTilesForSelectedUnit.getSelectedTile$core(), unit.getTile()) == false ? unit.getNukeBlastRadius() : -1;
        destination$iv$iv = tilesInMoveRange.iterator();
        while (destination$iv$iv.hasNext()) {
            block39: {
                tile = (Tile)destination$iv$iv.next();
                Intrinsics.checkNotNull($this$updateTilesForSelectedUnit.getTileGroups().get(tile));
                if (!isAirUnit || unit.isPreparingAirSweep()) break block39;
                if (nukeBlastRadius < 0) ** GOTO lbl-1000
                v10 = $this$updateTilesForSelectedUnit.getSelectedTile$core();
                Intrinsics.checkNotNull(v10);
                if (tile.aerialDistanceTo(v10) <= nukeBlastRadius) {
                    v11 = group.getLayerMisc();
                    v12 = Color.FIREBRICK;
                    Intrinsics.checkNotNullExpressionValue(v12, "FIREBRICK");
                    v11.overlayTerrain(v12, 0.6f);
                } else if (tile.aerialDistanceTo(unit.getTile()) <= unit.getRange()) {
                    v13 = group.getLayerMisc();
                    v14 = Color.RED;
                    Intrinsics.checkNotNullExpressionValue(v14, "RED");
                    v13.overlayTerrain(v14);
                } else if (tile.isExplored($this$updateTilesForSelectedUnit.getWorldScreen$core().getViewingCiv()) && tile.aerialDistanceTo(unit.getTile()) <= unit.getRange() * 2) {
                    v15 = group.getLayerMisc();
                    element$iv$iv = UnitMovement.canMoveTo$default(unit.getMovement(), (Tile)tile, false, false, false, 14, null) != false ? Color.WHITE : Color.BLUE;
                    Intrinsics.checkNotNull(element$iv$iv);
                    v15.overlayTerrain(element$iv$iv);
                }
            }
            if (!UnitMovement.canMoveTo$default(unit.getMovement(), (Tile)tile, false, false, false, 14, null) && (!unit.getMovement().isUnknownTileWeShouldAssumeToBePassable((Tile)tile) || unit.getBaseUnit().getMovesLikeAirUnits())) continue;
            if (UncivGame.Companion.getCurrent().getSettings().getUseCirclesToIndicateMovableTiles()) {
                alpha = UncivGame.Companion.getCurrent().getSettings().getSingleTapMove() != false ? 0.7f : 0.3f;
                v16 = group.getLayerOverlay();
                Intrinsics.checkNotNull(moveTileOverlayColor);
                v16.showHighlight(moveTileOverlayColor, alpha);
                continue;
            }
            v17 = group.getLayerMisc();
            Intrinsics.checkNotNull(moveTileOverlayColor);
            v17.overlayTerrain(moveTileOverlayColor, 0.4f);
        }
        if (unit.getCache().getCannotMove() && isAirUnit && !unit.isPreparingAirSweep()) {
            tilesInAttackRange = unit.getTile().getTilesInDistanceRange(new IntRange(1, unit.getRange()));
            tile = tilesInAttackRange.iterator();
            while (tile.hasNext()) {
                tile = (Tile)tile.next();
                v18 = $this$updateTilesForSelectedUnit.getTileGroups().get(tile);
                Intrinsics.checkNotNull(v18);
                v19 = v18.getLayerOverlay();
                v20 = Color.RED;
                Intrinsics.checkNotNullExpressionValue(v20, "RED");
                v19.showHighlight(v20, 0.3f);
            }
        }
        if ($this$updateTilesForSelectedUnit.getUnitMovementPaths$core().containsKey(unit)) {
            v21 = $this$updateTilesForSelectedUnit.getUnitMovementPaths$core().get(unit);
            Intrinsics.checkNotNull(v21);
            v22 = v21.iterator();
            Intrinsics.checkNotNullExpressionValue(v22, "iterator(...)");
            tilesInAttackRange = v22;
            while (tilesInAttackRange.hasNext()) {
                v23 = tilesInAttackRange.next();
                Intrinsics.checkNotNullExpressionValue(v23, "next(...)");
                tile = (Tile)v23;
                v24 = $this$updateTilesForSelectedUnit.getTileGroups().get(tile);
                Intrinsics.checkNotNull(v24);
                v25 = v24.getLayerOverlay();
                v26 = Color.SKY;
                Intrinsics.checkNotNullExpressionValue(v26, "SKY");
                v25.showHighlight(v26, 0.8f);
            }
        }
        if (unit.isAutomatingRoadConnection()) {
            if (unit.getAutomatedRoadConnectionPath() == null) {
                return;
            }
            v27 = unit.getAutomatedRoadConnectionPath();
            Intrinsics.checkNotNull(v27);
            currTileIndex = v27.indexOf(unit.getCurrentTile().getPosition());
            if (currTileIndex != -1) {
                v28 = unit.getAutomatedRoadConnectionPath();
                Intrinsics.checkNotNull(v28);
                $this$filterIndexed$iv = v28;
                $i$f$filterIndexed = false;
                it = $this$filterIndexed$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIndexedTo = false;
                $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
                $i$f$forEachIndexed = false;
                index$iv$iv$iv = 0;
                var18_48 = $this$forEachIndexed$iv$iv$iv.iterator();
                while (var18_48.hasNext()) {
                    item$iv$iv$iv = var18_48.next();
                    if ((var20_51 = index$iv$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    var21_52 = item$iv$iv$iv;
                    index$iv$iv = var20_51;
                    $i$a$-forEachIndexed-CollectionsKt___CollectionsKt$filterIndexedTo$1$iv$iv = false;
                    (Vector2)element$iv$iv;
                    index = index$iv$iv;
                    $i$a$-filterIndexed-WorldMapTileUpdater$updateTilesForSelectedUnit$futureTiles$1 = false;
                    if (!(index > currTileIndex)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIndexed$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterIndexedTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    index$iv$iv$iv = (Vector2)item$iv$iv;
                    var26_57 = destination$iv$iv;
                    $i$a$-map-WorldMapTileUpdater$updateTilesForSelectedUnit$futureTiles$2 = false;
                    var26_57.add($this$updateTilesForSelectedUnit.getTileMap$core().get((Vector2)tilePos));
                }
                futureTiles = (List)destination$iv$iv;
                for (Tile tile : futureTiles) {
                    v29 = $this$updateTilesForSelectedUnit.getTileGroups().get(tile);
                    Intrinsics.checkNotNull(v29);
                    v30 = v29.getLayerOverlay();
                    v31 = Color.ORANGE;
                    Intrinsics.checkNotNullExpressionValue(v31, "ORANGE");
                    v30.showHighlight(v31, UncivGame.Companion.getCurrent().getSettings().getSingleTapMove() != false ? 0.7f : 0.3f);
                }
            }
        }
        if (unit.isMoving()) {
            v32 = $this$updateTilesForSelectedUnit.getTileGroups().get(unit.getMovementDestination());
            Intrinsics.checkNotNull(v32);
            v33 = v32.getLayerOverlay();
            v34 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(v34, "WHITE");
            v33.showHighlight(v34, 0.7f);
        }
        if (unit.isMilitary()) {
            if (nukeBlastRadius >= 0) {
                v35 = $this$updateTilesForSelectedUnit.getSelectedTile$core();
                Intrinsics.checkNotNull(v35);
                v36 = SequencesKt.toList(SequencesKt.map(SequencesKt.filter(v35.getTilesInDistance(nukeBlastRadius), (Function1<Tile, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, updateTilesForSelectedUnit$lambda$3(com.unciv.logic.map.mapunit.MapUnit com.unciv.logic.map.tile.Tile ), (Lcom/unciv/logic/map/tile/Tile;)Ljava/lang/Boolean;)((MapUnit)unit)), (Function1<Tile, AttackableTile>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, updateTilesForSelectedUnit$lambda$4(com.unciv.logic.map.mapunit.MapUnit com.unciv.logic.map.tile.Tile ), (Lcom/unciv/logic/map/tile/Tile;)Lcom/unciv/logic/battle/AttackableTile;)((MapUnit)unit)));
            } else {
                futureTiles = TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, unit, UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null), null, false, 12, null);
                $i$f$filter = false;
                tile = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (AttackableTile)element$iv$iv;
                    $i$a$-filter-WorldMapTileUpdater$updateTilesForSelectedUnit$attackableTiles$3 = false;
                    if (!it.getTileToAttack().isVisible(unit.getCiv())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$distinctBy = false;
                set$iv = new HashSet<Tile>();
                list$iv = new ArrayList<T>();
                $i$f$filterTo = $this$distinctBy$iv.iterator();
                while ($i$f$filterTo.hasNext()) {
                    e$iv = $i$f$filterTo.next();
                    it = (AttackableTile)e$iv;
                    $i$a$-distinctBy-WorldMapTileUpdater$updateTilesForSelectedUnit$attackableTiles$4 = false;
                    key$iv = it.getTileToAttack();
                    if (!set$iv.add(key$iv)) continue;
                    list$iv.add(e$iv);
                }
                v36 = list$iv;
            }
            attackableTiles = v36;
            for (AttackableTile attackableTile : attackableTiles) {
                Intrinsics.checkNotNull($this$updateTilesForSelectedUnit.getTileGroups().get(attackableTile.getTileToAttack()));
                TileLayerOverlay.showHighlight$default(tileGroupToAttack.getLayerOverlay(), Scene2dExtensionsKt.colorFromRGB(237, 41, 57), 0.0f, 2, null);
                tileGroupToAttack.getLayerOverlay().showCrosshair(Intrinsics.areEqual(attackableTile.getTileToAttackFrom(), unit.getCurrentTile()) == false ? 0.5f : 1.0f);
                if (!Intrinsics.areEqual(attackableTile.getTileToAttack(), $this$updateTilesForSelectedUnit.getSelectedTile$core())) continue;
                v37 = $this$updateTilesForSelectedUnit.getTileGroups().get(attackableTile.getTileToAttackFrom());
                Intrinsics.checkNotNull(v37);
                v38 = v37.getLayerOverlay();
                v39 = Color.SKY;
                Intrinsics.checkNotNullExpressionValue(v39, "SKY");
                v38.showHighlight(v39, 0.7f);
            }
        }
        if (MapUnit.hasUnique$default(unit, UniqueType.FoundCity, null, false, 6, null) && UncivGame.Companion.getCurrent().getSettings().getShowSettlersSuggestedCityLocations()) {
            $this$sortedByDescending$iv = SequencesKt.filter(MapsKt.asSequence((Map)CityLocationTileRanker.INSTANCE.getBestTilesToFoundCity(unit, 5, 50.0f).getTileRankMap()), (Function1<Map.Entry, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, updateTilesForSelectedUnit$lambda$7(com.unciv.logic.map.mapunit.MapUnit java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/lang/Boolean;)((MapUnit)unit));
            $i$f$sortedByDescending = false;
            $this$forEach$iv = SequencesKt.take(SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)b;
                    boolean bl = false;
                    Comparable comparable = (Float)it.getValue();
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Float)it.getValue()));
                }
            }), 3);
            $i$f$forEach = false;
            var10_25 = $this$forEach$iv.iterator();
            while (var10_25.hasNext()) {
                element$iv = var10_25.next();
                it = element$iv;
                $i$a$-forEach-WorldMapTileUpdater$updateTilesForSelectedUnit$3 = false;
                v40 = $this$updateTilesForSelectedUnit.getTileGroups().get(it.getKey());
                Intrinsics.checkNotNull(v40);
                v40.getLayerOverlay().showGoodCityLocationIndicator();
            }
        }
    }

    private final void updateTilesForSelectedSpy(WorldMapHolder $this$updateTilesForSelectedSpy, Spy spy) {
        Iterator<Object> iterator2 = $this$updateTilesForSelectedSpy.getTileGroups().values().iterator();
        while (iterator2.hasNext()) {
            WorldTileGroup group;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            group.getLayerOverlay().reset();
            if (!group.getTile().isCityCenter()) {
                group.getLayerImprovement().dimImprovement(true);
            }
            group.getLayerCityButton().moveDown();
        }
        iterator2 = $this$updateTilesForSelectedSpy.getWorldScreen$core().getGameInfo().getCities().iterator();
        while (iterator2.hasNext()) {
            City city = (City)iterator2.next();
            if (!spy.canMoveTo(city)) continue;
            WorldTileGroup worldTileGroup = $this$updateTilesForSelectedSpy.getTileGroups().get(city.getCenterTile());
            Intrinsics.checkNotNull(worldTileGroup);
            TileLayerOverlay tileLayerOverlay = worldTileGroup.getLayerOverlay();
            Color color = Color.CYAN;
            Intrinsics.checkNotNullExpressionValue(color, "CYAN");
            tileLayerOverlay.showHighlight(color, 0.7f);
        }
    }

    private final void updateBombardableTilesForSelectedCity(WorldMapHolder $this$updateBombardableTilesForSelectedCity, City city) {
        if (!city.canBombard()) {
            return;
        }
        Iterator<Tile> iterator2 = TargetHelper.INSTANCE.getBombardableTiles(city).iterator();
        while (iterator2.hasNext()) {
            WorldTileGroup group;
            Tile attackableTile = iterator2.next();
            Intrinsics.checkNotNull($this$updateBombardableTilesForSelectedCity.getTileGroups().get(attackableTile));
            TileLayerOverlay.showHighlight$default(group.getLayerOverlay(), Scene2dExtensionsKt.colorFromRGB(237, 41, 57), 0.0f, 2, null);
            TileLayerOverlay.showCrosshair$default(group.getLayerOverlay(), 0.0f, 1, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean updateTilesForSelectedUnit$lambda$3(MapUnit $unit, Tile targetTile) {
        Intrinsics.checkNotNullParameter(targetTile, "targetTile");
        if (targetTile.isVisible($unit.getCiv())) {
            Sequence<MapUnit> $this$any$iv = targetTile.getUnits();
            boolean $i$f$any = false;
            Iterator<MapUnit> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                MapUnit element$iv;
                MapUnit it = element$iv = iterator2.next();
                boolean bl = false;
                if (!it.isInvisible($unit.getCiv())) {
                    return true;
                }
                boolean bl2 = false;
                if (!bl2) continue;
                return true;
            }
            boolean bl = false;
            if (bl) return true;
        }
        if (!targetTile.isCityCenter()) return false;
        if (!$unit.getCiv().hasExplored(targetTile)) return false;
        return true;
    }

    private static final AttackableTile updateTilesForSelectedUnit$lambda$4(MapUnit $unit, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new AttackableTile($unit.getTile(), it, 1.0f, null);
    }

    private static final boolean updateTilesForSelectedUnit$lambda$7(MapUnit $unit, Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ((Tile)it.getKey()).isExplored($unit.getCiv());
    }
}

