/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization;

import com.unciv.logic.city.City;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.map.HexCoord;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/unciv/logic/civilization/CityAction;", "Lcom/unciv/logic/civilization/NotificationAction;", "city", "Lcom/unciv/logic/map/HexCoord;", "<init>", "(Lcom/unciv/logic/map/HexCoord;)V", "execute", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "Companion", "core"})
public final class CityAction
implements NotificationAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HexCoord city;

    public CityAction(@NotNull HexCoord city) {
        Intrinsics.checkNotNullParameter(city, "city");
        this.city = city;
    }

    public /* synthetic */ CityAction(HexCoord hexCoord, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            hexCoord = HexCoord.Companion.getZero();
        }
        this(hexCoord);
    }

    @Override
    public void execute(@NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        City city = worldScreen.getMapHolder().getTileMap$core().get(this.city).getCity();
        if (city == null) {
            return;
        }
        City cityObject = city;
        if (Intrinsics.areEqual(cityObject.getCiv(), worldScreen.getViewingCiv())) {
            worldScreen.getGame().pushScreen(new CityScreen(cityObject, null, null, null, 14, null));
        }
    }

    public CityAction() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/unciv/logic/civilization/CityAction$Companion;", "", "<init>", "()V", "withLocation", "", "Lcom/unciv/logic/civilization/NotificationAction;", "city", "Lcom/unciv/logic/city/City;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<NotificationAction> withLocation(@NotNull City city) {
            Intrinsics.checkNotNullParameter(city, "city");
            NotificationAction[] notificationActionArray = new NotificationAction[]{new LocationAction(city.getLocation()), new CityAction(city.getLocation())};
            return CollectionsKt.listOf(notificationActionArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

