/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.multiplayer.chat;

import com.badlogic.gdx.Gdx;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.multiplayer.chat.Chat;
import com.unciv.logic.multiplayer.chat.Response;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.chat.ChatButton;
import com.unciv.ui.screens.worldscreen.chat.ChatPopup;
import com.unciv.utils.StringExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0012J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0017J\u0011\u0010\u001a\u001a\r\u0012\t\u0012\u00070\u0017\u00a2\u0006\u0002\b\u001c0\u001bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!J \u0010\"\u001a\u00020\u001e2\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001e0$J\u0018\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u00172\b\b\u0002\u0010'\u001a\u00020\u0017R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/unciv/logic/multiplayer/chat/ChatStore;", "", "<init>", "()V", "chatPopup", "Lcom/unciv/ui/screens/worldscreen/chat/ChatPopup;", "getChatPopup", "()Lcom/unciv/ui/screens/worldscreen/chat/ChatPopup;", "setChatPopup", "(Lcom/unciv/ui/screens/worldscreen/chat/ChatPopup;)V", "hasGlobalMessage", "", "getHasGlobalMessage", "()Z", "setHasGlobalMessage", "(Z)V", "gameIdToChat", "", "Ljava/util/UUID;", "Lcom/unciv/logic/multiplayer/chat/Chat;", "globalMessages", "Ljava/util/Queue;", "Lkotlin/Pair;", "", "getChatByGameId", "gameId", "getGameIds", "", "Lkotlin/jvm/internal/EnhancedNullability;", "clear", "", "relayChatMessage", "incomingChatMsg", "Lcom/unciv/logic/multiplayer/chat/Response$Chat;", "pollGlobalMessages", "action", "Lkotlin/Function2;", "relayGlobalMessage", "message", "civName", "core"})
@SourceDebugExtension(value={"SMAP\nChatStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatStore.kt\ncom/unciv/logic/multiplayer/chat/ChatStore\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n382#2,7:138\n1563#3:145\n1634#3,3:146\n*S KotlinDebug\n*F\n+ 1 ChatStore.kt\ncom/unciv/logic/multiplayer/chat/ChatStore\n*L\n68#1:138,7\n71#1:145\n71#1:146,3\n*E\n"})
public final class ChatStore {
    @NotNull
    public static final ChatStore INSTANCE = new ChatStore();
    @Nullable
    private static ChatPopup chatPopup;
    private static boolean hasGlobalMessage;
    @NotNull
    private static Map<UUID, Chat> gameIdToChat;
    @NotNull
    private static Queue<Pair<String, String>> globalMessages;

    private ChatStore() {
    }

    @Nullable
    public final ChatPopup getChatPopup() {
        return chatPopup;
    }

    public final void setChatPopup(@Nullable ChatPopup chatPopup) {
        ChatStore.chatPopup = chatPopup;
    }

    public final boolean getHasGlobalMessage() {
        return hasGlobalMessage;
    }

    public final void setHasGlobalMessage(boolean bl) {
        hasGlobalMessage = bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Chat getChatByGameId(@NotNull UUID gameId) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(gameId, "gameId");
        Map<UUID, Chat> map2 = gameIdToChat;
        UUID key$iv = gameId;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Chat answer$iv = new Chat(gameId);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Chat)object;
    }

    @NotNull
    public final Chat getChatByGameId(@NotNull String gameId) {
        Intrinsics.checkNotNullParameter(gameId, "gameId");
        UUID uUID = UUID.fromString(gameId);
        Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
        return this.getChatByGameId(uUID);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getGameIds() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = gameIdToChat.keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void uuid;
            UUID uUID = (UUID)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(uuid.toString());
        }
        return (List)destination$iv$iv;
    }

    public final void clear() {
        gameIdToChat = new LinkedHashMap();
        globalMessages = new LinkedList();
    }

    public final void relayChatMessage(@NotNull Response.Chat incomingChatMsg) {
        Intrinsics.checkNotNullParameter(incomingChatMsg, "incomingChatMsg");
        Gdx.app.postRunnable(() -> ChatStore.relayChatMessage$lambda$0(incomingChatMsg));
    }

    public final void pollGlobalMessages(@NotNull Function2<? super String, ? super String, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, "action");
        Gdx.app.postRunnable(() -> ChatStore.pollGlobalMessages$lambda$0(action2));
    }

    public final void relayGlobalMessage(@NotNull String message, @NotNull String civName) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(civName, "civName");
        Gdx.app.postRunnable(() -> ChatStore.relayGlobalMessage$lambda$0(civName, message));
    }

    public static /* synthetic */ void relayGlobalMessage$default(ChatStore chatStore, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "System";
        }
        chatStore.relayGlobalMessage(string, string2);
    }

    private static final void relayChatMessage$lambda$0(Response.Chat $incomingChatMsg) {
        block7: {
            Object chat;
            block8: {
                UUID uUID;
                block6: {
                    if ($incomingChatMsg.getGameId() != null && !StringsKt.isBlank($incomingChatMsg.getGameId())) break block6;
                    INSTANCE.relayGlobalMessage($incomingChatMsg.getMessage(), $incomingChatMsg.getCivName());
                    break block7;
                }
                try {
                    uUID = UUID.fromString($incomingChatMsg.getGameId());
                }
                catch (Throwable throwable) {
                    return;
                }
                UUID gameId = uUID;
                Object object = chatPopup;
                if (object == null || (object = ((ChatPopup)object).getChat()) == null) {
                    Intrinsics.checkNotNull(gameId);
                    object = INSTANCE.getChatByGameId(gameId);
                }
                chat = object;
                ((Chat)chat).addMessage($incomingChatMsg.getCivName(), $incomingChatMsg.getMessage());
                Object object2 = chatPopup;
                if (gameId.equals(object2 != null && (object2 = ((ChatPopup)object2).getChat()) != null ? ((Chat)object2).getGameId() : null)) {
                    ChatPopup chatPopup = ChatStore.chatPopup;
                    if (chatPopup != null) {
                        ChatPopup.addMessage$default(chatPopup, $incomingChatMsg.getCivName(), $incomingChatMsg.getMessage(), null, false, 12, null);
                    }
                }
                if (chatPopup != null || Intrinsics.areEqual($incomingChatMsg.getCivName(), "System")) break block7;
                Object object3 = UncivGame.Companion.getCurrent().getWorldScreen();
                if (gameId.equals(object3 != null && (object3 = ((WorldScreen)object3).getGameInfo()) != null && (object3 = ((GameInfo)object3).getGameId()) != null ? StringExtensionsKt.toUUIDOrNull((String)object3) : null)) break block8;
                int n = ((Chat)chat).getUnreadCount();
                ((Chat)chat).setUnreadCount(n + 1);
                break block7;
            }
            Object object = UncivGame.Companion.getCurrent().getWorldScreen();
            if (Intrinsics.areEqual(object != null && (object = ((WorldScreen)object).getGameInfo()) != null ? ((GameInfo)object).getCurrentPlayer() : null, $incomingChatMsg.getCivName())) break block7;
            int n = ((Chat)chat).getUnreadCount();
            ((Chat)chat).setUnreadCount(n + 1);
            Object object4 = UncivGame.Companion.getCurrent().getWorldScreen();
            if (object4 != null && (object4 = ((WorldScreen)object4).getChatButton$core()) != null) {
                ((ChatButton)object4).triggerChatIndication();
            }
        }
    }

    private static final void pollGlobalMessages$lambda$0(Function2 $action) {
        while (!((Collection)globalMessages).isEmpty()) {
            Pair<String, String> item = globalMessages.poll();
            $action.invoke(item.getFirst(), item.getSecond());
        }
    }

    private static final void relayGlobalMessage$lambda$0(String $civName, String $message) {
        if (!Intrinsics.areEqual($civName, "System")) {
            Object object;
            hasGlobalMessage = chatPopup == null;
            if (hasGlobalMessage && (object = UncivGame.Companion.getCurrent().getWorldScreen()) != null && (object = ((WorldScreen)object).getChatButton$core()) != null) {
                ((ChatButton)object).triggerChatIndication();
            }
        }
        ChatPopup chatPopup = ChatStore.chatPopup;
        if (chatPopup != null) {
            ChatPopup.addMessage$default(chatPopup, $civName, $message, "one time", false, 8, null);
        } else {
            globalMessages.add(new Pair<String, String>($civName, $message));
        }
    }

    static {
        Map map2 = Collections.synchronizedMap(new LinkedHashMap());
        Intrinsics.checkNotNullExpressionValue(map2, "synchronizedMap(...)");
        gameIdToChat = map2;
        globalMessages = new LinkedList();
    }
}

