/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.objectdescriptions;

import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stats;
import com.unciv.ui.objectdescriptions.DescriptionHelpersKt;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/objectdescriptions/ResourceDescriptions;", "", "<init>", "()V", "getCivilopediaTextLines", "", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "resource", "Lcom/unciv/models/ruleset/tile/TileResource;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "core"})
@SourceDebugExtension(value={"SMAP\nResourceDescriptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceDescriptions.kt\ncom/unciv/ui/objectdescriptions/ResourceDescriptions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1869#2,2:114\n774#2:116\n865#2:117\n1761#2,3:118\n866#2:121\n1869#2,2:122\n774#2:124\n865#2:125\n1761#2,3:126\n866#2:129\n1869#2,2:130\n774#2:132\n865#2,2:133\n1869#2,2:135\n774#2:137\n865#2,2:138\n1869#2,2:140\n774#2:142\n865#2,2:143\n1869#2,2:145\n*S KotlinDebug\n*F\n+ 1 ResourceDescriptions.kt\ncom/unciv/ui/objectdescriptions/ResourceDescriptions\n*L\n36#1:114,2\n50#1:116\n50#1:117\n51#1:118,3\n50#1:121\n58#1:122,2\n64#1:124\n64#1:125\n65#1:126,3\n64#1:129\n72#1:130,2\n77#1:132\n77#1:133,2\n82#1:135,2\n87#1:137\n87#1:138,2\n92#1:140,2\n97#1:142\n97#1:143,2\n103#1:145,2\n*E\n"})
public final class ResourceDescriptions {
    @NotNull
    public static final ResourceDescriptions INSTANCE = new ResourceDescriptions();

    private ResourceDescriptions() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FormattedLine> getCivilopediaTextLines(@NotNull TileResource resource, @NotNull Ruleset ruleset) {
        void $this$filterTo$iv$iv;
        Iterable element$iv8;
        Iterator $this$filterTo$iv$iv2;
        Iterable element$iv22;
        Iterator $this$filterTo$iv$iv3;
        Iterable element$iv32;
        Object element$iv$iv;
        Iterator $this$filterTo$iv$iv4;
        void $this$filter$iv;
        Object element$iv42;
        Object element$iv$iv2;
        Iterator $this$filterTo$iv$iv5;
        void $this$filter$iv2;
        Object element$iv5;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(resource, "resource");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        ArrayList textList = new ArrayList();
        ((Collection)textList).add(new FormattedLine(resource.getResourceType().name() + " resource", null, null, null, 0.0f, 0, 4, 0, 0.0f, resource.getResourceType().getColor(), false, false, false, false, 15806, null));
        ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        DescriptionHelpersKt.uniquesToCivilopediaTextLines$default(resource, textList, null, false, null, 14, null);
        if (!((Stats)resource).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(resource.cloneStats().toString(), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if (!((charSequence = (CharSequence)resource.getRevealedBy()) == null || charSequence.length() == 0)) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("Revealed by:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Collection collection = textList;
            String string = resource.getRevealedBy();
            Intrinsics.checkNotNull(string);
            collection.add(new FormattedLine(string, "Technology/" + resource.getRevealedBy(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
        }
        if (!((Collection)resource.getTerrainsCanBeFoundOn()).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            if (resource.getTerrainsCanBeFoundOn().size() == 1) {
                String terrainName = resource.getTerrainsCanBeFoundOn().get(0);
                ((Collection)textList).add(new FormattedLine("{Can be found on} {" + terrainName + '}', "Terrain/" + terrainName, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            } else {
                ((Collection)textList).add(new FormattedLine("{Can be found on}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
                Iterable $this$forEach$iv = resource.getTerrainsCanBeFoundOn();
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv5 = iterator2.next();
                    String it = (String)element$iv5;
                    boolean bl = false;
                    ((Collection)textList).add(new FormattedLine(it, "Terrain/" + it, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
                }
            }
        }
        for (String improvement : resource.getImprovements()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("Improved by [" + improvement + ']', "Improvement/" + improvement, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            if (resource.getImprovementStats() == null) continue;
            Stats stats = resource.getImprovementStats();
            Intrinsics.checkNotNull(stats);
            if (stats.isEmpty()) continue;
            ((Collection)textList).add(new FormattedLine("{Bonus stats for improvement}: " + resource.getImprovementStats(), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        Collection<TileImprovement> collection = ruleset.getTileImprovements().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable improvement = collection;
        boolean $i$f$filter = false;
        element$iv5 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator3 = $this$filterTo$iv$iv5.iterator();
        while (iterator3.hasNext()) {
            boolean bl;
            block28: {
                element$iv$iv2 = iterator3.next();
                TileImprovement improvement2 = (TileImprovement)element$iv$iv2;
                boolean bl2 = false;
                Iterable $this$any$iv = improvement2.getUniqueObjects();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv6 : $this$any$iv) {
                        Unique unique = (Unique)element$iv6;
                        boolean bl3 = false;
                        if (!(unique.getType() == UniqueType.ProvidesResources && Intrinsics.areEqual(unique.getParams().get(1), resource.getName()))) continue;
                        bl = true;
                        break block28;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List improvementsThatProvideThis = (List)destination$iv$iv;
        if (!((Collection)improvementsThatProvideThis).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{Improvements that provide this resource}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = improvementsThatProvideThis;
            boolean $i$f$forEach = false;
            for (Object element$iv42 : $this$forEach$iv) {
                TileImprovement it = (TileImprovement)element$iv42;
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        Collection<Building> collection2 = ruleset.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Iterable $i$f$forEach = collection2;
        boolean $i$f$filter2 = false;
        element$iv42 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        element$iv$iv2 = $this$filterTo$iv$iv4.iterator();
        while (element$iv$iv2.hasNext()) {
            boolean bl;
            block29: {
                element$iv$iv = element$iv$iv2.next();
                Building building = (Building)element$iv$iv;
                boolean bl4 = false;
                Iterable $this$any$iv = building.getUniqueObjects();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv7 : $this$any$iv) {
                        Unique unique = (Unique)element$iv7;
                        boolean bl5 = false;
                        if (!(unique.getType() == UniqueType.ProvidesResources && Intrinsics.areEqual(unique.getParams().get(1), resource.getName()))) continue;
                        bl = true;
                        break block29;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List buildingsThatProvideThis = (List)destination$iv$iv2;
        if (!((Collection)buildingsThatProvideThis).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{Buildings that provide this resource}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = buildingsThatProvideThis;
            boolean $i$f$forEach2 = false;
            for (Iterable element$iv32 : $this$forEach$iv) {
                Building it = (Building)element$iv32;
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        Collection<Building> collection3 = ruleset.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection3, "<get-values>(...)");
        Iterable $this$filter$iv3 = collection3;
        boolean $i$f$filter3 = false;
        element$iv32 = $this$filter$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        element$iv$iv = $this$filterTo$iv$iv3.iterator();
        while (element$iv$iv.hasNext()) {
            Object element$iv$iv3 = element$iv$iv.next();
            Building it = (Building)element$iv$iv3;
            boolean bl = false;
            if (!it.getResourceRequirementsPerTurn(GameContext.Companion.getIgnoreConditionals()).containsKey(resource.getName())) continue;
            destination$iv$iv3.add(element$iv$iv3);
        }
        List buildingsThatConsumeThis = (List)destination$iv$iv3;
        if (!((Collection)buildingsThatConsumeThis).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{Buildings that consume this resource}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = buildingsThatConsumeThis;
            boolean $i$f$forEach3 = false;
            for (Iterable element$iv22 : $this$forEach$iv) {
                Building it = (Building)element$iv22;
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        Collection<BaseUnit> collection4 = ruleset.getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection4, "<get-values>(...)");
        Iterable $this$filter$iv4 = collection4;
        boolean $i$f$filter4 = false;
        element$iv22 = $this$filter$iv4;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo4 = false;
        Iterator element$iv$iv3 = $this$filterTo$iv$iv2.iterator();
        while (element$iv$iv3.hasNext()) {
            Object element$iv$iv4 = element$iv$iv3.next();
            BaseUnit it = (BaseUnit)element$iv$iv4;
            boolean bl = false;
            if (!it.getResourceRequirementsPerTurn(GameContext.Companion.getIgnoreConditionals()).containsKey(resource.getName())) continue;
            destination$iv$iv4.add(element$iv$iv4);
        }
        List unitsThatConsumeThis = (List)destination$iv$iv4;
        if (!((Collection)unitsThatConsumeThis).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{Units that consume this resource}: ", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = unitsThatConsumeThis;
            boolean $i$f$forEach4 = false;
            for (Iterable element$iv8 : $this$forEach$iv) {
                BaseUnit it = (BaseUnit)((Object)element$iv8);
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        Collection<Building> collection5 = ruleset.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection5, "<get-values>(...)");
        Iterable $this$filter$iv5 = collection5;
        boolean $i$f$filter5 = false;
        element$iv8 = $this$filter$iv5;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterTo5 = false;
        for (Object element$iv$iv5 : $this$filterTo$iv$iv) {
            Building it = (Building)element$iv$iv5;
            boolean bl = false;
            List<String> list2 = it.getRequiredNearbyImprovedResources();
            boolean bl6 = list2 != null ? list2.contains(resource.getName()) : false;
            if (!bl6) continue;
            destination$iv$iv5.add(element$iv$iv5);
        }
        List buildingsRequiringThis = (List)destination$iv$iv5;
        if (!((Collection)buildingsRequiringThis).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{Buildings that require this resource improved near the city}: ", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = buildingsRequiringThis;
            boolean $i$f$forEach5 = false;
            for (Object element$iv9 : $this$forEach$iv) {
                Building it = (Building)element$iv9;
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        CollectionsKt.addAll((Collection)textList, Belief.Companion.getCivilopediaTextMatching$default(Belief.Companion, resource.getName(), ruleset, false, 4, null));
        return textList;
    }
}

