vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO chenjunfu2/NBT_CPP
    REF "v${VERSION}"
    HEAD_REF master
    SHA512 7356b4954107b62c7d97d0fb87112d571530333d26e087d2121e665b79970b9c7eb75bd62cf65e617a87dc399361fc1c7a383b30d68b954c44223b0d41401f79
)

# install
file(INSTALL "${SOURCE_PATH}/include/nbt_cpp/"
     DESTINATION "${CURRENT_PACKAGES_DIR}/include/nbt_cpp"
     FILES_MATCHING
     PATTERN "*.hpp"
     PATTERN "*.h"
     PATTERN "vcpkg_config.h" EXCLUDE
)

# vcpkg_config
set(CONFIG_HEADER_CONTENT "#pragma once\n\n")
set(CONFIG_HEADER_CONTENT "${CONFIG_HEADER_CONTENT}//Auto-generated by vcpkg - DO NOT EDIT\n\n")

if("zlib" IN_LIST FEATURES)
    set(CONFIG_HEADER_CONTENT "${CONFIG_HEADER_CONTENT}//use zlib\n")
    set(CONFIG_HEADER_CONTENT "${CONFIG_HEADER_CONTENT}#define CJF2_NBT_CPP_USE_ZLIB\n\n")
endif()

if("xxhash" IN_LIST FEATURES)
    set(CONFIG_HEADER_CONTENT "${CONFIG_HEADER_CONTENT}//use xxhash\n")
    set(CONFIG_HEADER_CONTENT "${CONFIG_HEADER_CONTENT}#define CJF2_NBT_CPP_USE_XXHASH\n\n")
endif()

file(WRITE "${CURRENT_PACKAGES_DIR}/include/nbt_cpp/vcpkg_config.h" "${CONFIG_HEADER_CONTENT}")

# copyright
file(INSTALL "${SOURCE_PATH}/LICENSE" DESTINATION "${CURRENT_PACKAGES_DIR}/share/${PORT}" RENAME copyright)
