/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.core;

import apdu4j.core.AsynchronousBIBO;
import apdu4j.core.BIBO;
import apdu4j.core.BIBOException;
import java.util.concurrent.ExecutionException;

public class BlockingBIBO
implements BIBO {
    private final AsynchronousBIBO wrapped;

    public BlockingBIBO(AsynchronousBIBO bibo) {
        this.wrapped = bibo;
    }

    @Override
    public byte[] transceive(byte[] bytes) throws BIBOException {
        try {
            return this.wrapped.transmit(bytes).get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof BIBOException) {
                throw (BIBOException)e.getCause();
            }
            throw new BIBOException("Failed to get response: " + e.getCause().getMessage(), e.getCause());
        }
        catch (InterruptedException e) {
            throw new BIBOException("Failed waiting for response: " + e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        this.wrapped.close();
    }
}

