function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

var isUrl_1;
var hasRequiredIsUrl;

function requireIsUrl () {
	if (hasRequiredIsUrl) return isUrl_1;
	hasRequiredIsUrl = 1;
	/**
	 * Expose `isUrl`.
	 */

	isUrl_1 = isUrl;

	/**
	 * RegExps.
	 * A URL must match #1 and then at least one of #2/#3.
	 * Use two levels of REs to avoid REDOS.
	 */

	var protocolAndDomainRE = /^(?:\w+:)?\/\/(\S+)$/;

	var localhostDomainRE = /^localhost[\:?\d]*(?:[^\:?\d]\S*)?$/;
	var nonLocalhostDomainRE = /^[^\s\.]+\.\S{2,}$/;

	/**
	 * Loosely validate a URL `string`.
	 *
	 * @param {String} string
	 * @return {Boolean}
	 */

	function isUrl(string){
	  if (typeof string !== 'string') {
	    return false;
	  }

	  var match = string.match(protocolAndDomainRE);
	  if (!match) {
	    return false;
	  }

	  var everythingAfterProtocol = match[1];
	  if (!everythingAfterProtocol) {
	    return false;
	  }

	  if (localhostDomainRE.test(everythingAfterProtocol) ||
	      nonLocalhostDomainRE.test(everythingAfterProtocol)) {
	    return true;
	  }

	  return false;
	}
	return isUrl_1;
}

var isUrlExports = requireIsUrl();
const index = /*@__PURE__*/getDefaultExportFromCjs(isUrlExports);

export { index as default };
