/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.forge;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.DependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.UnsupportedInstallationException;
import org.jackhuang.hmcl.download.VersionMismatchException;
import org.jackhuang.hmcl.download.forge.ForgeInstallProfile;
import org.jackhuang.hmcl.download.forge.ForgeNewInstallProfile;
import org.jackhuang.hmcl.download.forge.ForgeNewInstallTask;
import org.jackhuang.hmcl.download.forge.ForgeOldInstallTask;
import org.jackhuang.hmcl.download.forge.ForgeRemoteVersion;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public final class ForgeInstallTask
extends Task<Version> {
    private final DefaultDependencyManager dependencyManager;
    private final Version version;
    private Path installer;
    private final ForgeRemoteVersion remote;
    private FileDownloadTask dependent;
    private Task<Version> dependency;

    public ForgeInstallTask(DefaultDependencyManager dependencyManager, Version version, ForgeRemoteVersion remoteVersion) {
        this.dependencyManager = dependencyManager;
        this.version = version;
        this.remote = remoteVersion;
        this.setSignificance(Task.TaskSignificance.MODERATE);
    }

    @Override
    public boolean doPreExecute() {
        return true;
    }

    @Override
    public void preExecute() throws Exception {
        this.installer = Files.createTempFile("forge-installer", ".jar", new FileAttribute[0]);
        this.dependent = new FileDownloadTask(this.dependencyManager.getDownloadProvider().injectURLsWithCandidates(this.remote.getUrls()), this.installer.toFile(), null);
        this.dependent.setCacheRepository(this.dependencyManager.getCacheRepository());
        this.dependent.setCaching(true);
        this.dependent.addIntegrityCheckHandler(FileDownloadTask.ZIP_INTEGRITY_CHECK_HANDLER);
    }

    @Override
    public boolean doPostExecute() {
        return true;
    }

    @Override
    public void postExecute() throws Exception {
        Files.deleteIfExists(this.installer);
        this.setResult(this.dependency.getResult());
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return Collections.singleton(this.dependent);
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return Collections.singleton(this.dependency);
    }

    @Override
    public void execute() throws IOException, VersionMismatchException, UnsupportedInstallationException {
        String originalMainClass = this.version.resolve(this.dependencyManager.getGameRepository()).getMainClass();
        if (GameVersionNumber.compare("1.13", this.remote.getGameVersion()) <= 0 && !LibraryAnalyzer.FORGE_OPTIFINE_MAIN.contains(originalMainClass)) {
            throw new UnsupportedInstallationException(1);
        }
        this.dependency = ForgeInstallTask.detectForgeInstallerType(this.dependencyManager, this.version, this.installer) ? new ForgeNewInstallTask(this.dependencyManager, this.version, this.remote.getSelfVersion(), this.installer) : new ForgeOldInstallTask(this.dependencyManager, this.version, this.remote.getSelfVersion(), this.installer);
    }

    public static boolean detectForgeInstallerType(DependencyManager dependencyManager, Version version, Path installer) throws IOException, VersionMismatchException {
        Optional<String> gameVersion = dependencyManager.getGameRepository().getGameVersion(version);
        if (!gameVersion.isPresent()) {
            throw new IOException();
        }
        try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(installer);){
            String installProfileText = FileUtils.readText(fs.getPath("install_profile.json", new String[0]));
            Map installProfile = JsonUtils.fromNonNullJson(installProfileText, Map.class);
            if (installProfile.containsKey("spec")) {
                ForgeNewInstallProfile profile = JsonUtils.fromNonNullJson(installProfileText, ForgeNewInstallProfile.class);
                if (!gameVersion.get().equals(profile.getMinecraft())) {
                    throw new VersionMismatchException(profile.getMinecraft(), gameVersion.get());
                }
                boolean bl = true;
                return bl;
            }
            if (installProfile.containsKey("install") && installProfile.containsKey("versionInfo")) {
                ForgeInstallProfile profile = JsonUtils.fromNonNullJson(installProfileText, ForgeInstallProfile.class);
                if (!gameVersion.get().equals(profile.getInstall().getMinecraft())) {
                    throw new VersionMismatchException(profile.getInstall().getMinecraft(), gameVersion.get());
                }
                boolean bl = false;
                return bl;
            }
            throw new IOException();
        }
    }

    public static Task<Version> install(DefaultDependencyManager dependencyManager, Version version, Path installer) throws IOException, VersionMismatchException {
        Optional<String> gameVersion = dependencyManager.getGameRepository().getGameVersion(version);
        if (!gameVersion.isPresent()) {
            throw new IOException();
        }
        try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(installer);){
            String installProfileText = FileUtils.readText(fs.getPath("install_profile.json", new String[0]));
            Map installProfile = JsonUtils.fromNonNullJson(installProfileText, Map.class);
            if (installProfile.containsKey("spec")) {
                ForgeNewInstallProfile profile = JsonUtils.fromNonNullJson(installProfileText, ForgeNewInstallProfile.class);
                if (!gameVersion.get().equals(profile.getMinecraft())) {
                    throw new VersionMismatchException(profile.getMinecraft(), gameVersion.get());
                }
                ForgeNewInstallTask forgeNewInstallTask = new ForgeNewInstallTask(dependencyManager, version, ForgeInstallTask.modifyVersion(gameVersion.get(), profile.getVersion()), installer);
                return forgeNewInstallTask;
            }
            if (installProfile.containsKey("install") && installProfile.containsKey("versionInfo")) {
                ForgeInstallProfile profile = JsonUtils.fromNonNullJson(installProfileText, ForgeInstallProfile.class);
                if (!gameVersion.get().equals(profile.getInstall().getMinecraft())) {
                    throw new VersionMismatchException(profile.getInstall().getMinecraft(), gameVersion.get());
                }
                ForgeOldInstallTask forgeOldInstallTask = new ForgeOldInstallTask(dependencyManager, version, ForgeInstallTask.modifyVersion(gameVersion.get(), profile.getInstall().getPath().getVersion().replaceAll("(?i)forge", "")), installer);
                return forgeOldInstallTask;
            }
            throw new IOException();
        }
    }

    private static String modifyVersion(String gameVersion, String version) {
        return StringUtils.removeSuffix(StringUtils.removePrefix(StringUtils.removeSuffix(StringUtils.removePrefix(version.replace(gameVersion, "").trim(), "-"), "-"), "_"), "_");
    }
}

