/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.animation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.value.WritableValue;
import javafx.util.Duration;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.animation.AnimationHandler;
import org.jackhuang.hmcl.ui.animation.AnimationProducer;
import org.jetbrains.annotations.Nullable;

public enum ContainerAnimations implements AnimationProducer
{
    NONE{

        @Override
        public void init(AnimationHandler c) {
            c.getPreviousNode().setTranslateX(0.0);
            c.getPreviousNode().setTranslateY(0.0);
            c.getPreviousNode().setScaleX(1.0);
            c.getPreviousNode().setScaleY(1.0);
            c.getPreviousNode().setOpacity(1.0);
            c.getCurrentNode().setTranslateX(0.0);
            c.getCurrentNode().setTranslateY(0.0);
            c.getCurrentNode().setScaleX(1.0);
            c.getCurrentNode().setScaleY(1.0);
            c.getCurrentNode().setOpacity(1.0);
        }

        @Override
        public List<KeyFrame> animate(AnimationHandler c) {
            return Collections.emptyList();
        }
    }
    ,
    FADE{

        @Override
        public void init(AnimationHandler c) {
            c.getPreviousNode().setTranslateX(0.0);
            c.getPreviousNode().setTranslateY(0.0);
            c.getPreviousNode().setScaleX(1.0);
            c.getPreviousNode().setScaleY(1.0);
            c.getPreviousNode().setOpacity(1.0);
            c.getCurrentNode().setTranslateX(0.0);
            c.getCurrentNode().setTranslateY(0.0);
            c.getCurrentNode().setScaleX(1.0);
            c.getCurrentNode().setScaleY(1.0);
            c.getCurrentNode().setOpacity(0.0);
        }

        @Override
        public List<KeyFrame> animate(AnimationHandler c) {
            return Arrays.asList(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)c.getPreviousNode().opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getCurrentNode().opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(c.getDuration(), new KeyValue[]{new KeyValue((WritableValue)c.getPreviousNode().opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getCurrentNode().opacityProperty(), (Object)1, Interpolator.EASE_BOTH)}));
        }
    }
    ,
    FADE_IN{

        @Override
        public void init(AnimationHandler c) {
            c.getCurrentNode().setTranslateX(0.0);
            c.getCurrentNode().setTranslateY(0.0);
            c.getCurrentNode().setScaleX(1.0);
            c.getCurrentNode().setScaleY(1.0);
            c.getCurrentNode().setOpacity(0.0);
        }

        @Override
        public List<KeyFrame> animate(AnimationHandler c) {
            return Arrays.asList(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().opacityProperty(), (Object)0, FXUtils.SINE)}), new KeyFrame(c.getDuration(), new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().opacityProperty(), (Object)1, FXUtils.SINE)}));
        }
    }
    ,
    FADE_OUT{

        @Override
        public void init(AnimationHandler c) {
            c.getCurrentNode().setTranslateX(0.0);
            c.getCurrentNode().setTranslateY(0.0);
            c.getCurrentNode().setScaleX(1.0);
            c.getCurrentNode().setScaleY(1.0);
            c.getCurrentNode().setOpacity(1.0);
        }

        @Override
        public List<KeyFrame> animate(AnimationHandler c) {
            return Arrays.asList(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().opacityProperty(), (Object)1, FXUtils.SINE)}), new KeyFrame(c.getDuration(), new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().opacityProperty(), (Object)0, FXUtils.SINE)}));
        }
    }
    ,
    ZOOM_IN{

        @Override
        public void init(AnimationHandler c) {
            c.getPreviousNode().setTranslateX(0.0);
            c.getPreviousNode().setTranslateY(0.0);
            c.getPreviousNode().setScaleX(1.0);
            c.getPreviousNode().setScaleY(1.0);
            c.getPreviousNode().setOpacity(1.0);
            c.getCurrentNode().setTranslateX(0.0);
            c.getCurrentNode().setTranslateY(0.0);
        }

        @Override
        public List<KeyFrame> animate(AnimationHandler c) {
            return Arrays.asList(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)c.getPreviousNode().scaleXProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().scaleYProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().opacityProperty(), (Object)1, Interpolator.EASE_BOTH)}), new KeyFrame(c.getDuration(), new KeyValue[]{new KeyValue((WritableValue)c.getPreviousNode().scaleXProperty(), (Object)4, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().scaleYProperty(), (Object)4, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}));
        }
    }
    ,
    ZOOM_OUT{

        @Override
        public void init(AnimationHandler c) {
            c.getPreviousNode().setTranslateX(0.0);
            c.getPreviousNode().setTranslateY(0.0);
            c.getPreviousNode().setScaleX(1.0);
            c.getPreviousNode().setScaleY(1.0);
            c.getPreviousNode().setOpacity(1.0);
            c.getCurrentNode().setTranslateX(0.0);
            c.getCurrentNode().setTranslateY(0.0);
        }

        @Override
        public List<KeyFrame> animate(AnimationHandler c) {
            return Arrays.asList(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)c.getPreviousNode().scaleXProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().scaleYProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().opacityProperty(), (Object)1, Interpolator.EASE_BOTH)}), new KeyFrame(c.getDuration(), new KeyValue[]{new KeyValue((WritableValue)c.getPreviousNode().scaleXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().scaleYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}));
        }
    }
    ,
    SWIPE_LEFT{

        @Override
        public void init(AnimationHandler c) {
            c.getPreviousNode().setScaleX(1.0);
            c.getPreviousNode().setScaleY(1.0);
            c.getPreviousNode().setOpacity(0.0);
            c.getPreviousNode().setTranslateX(0.0);
            c.getCurrentNode().setScaleX(1.0);
            c.getCurrentNode().setScaleY(1.0);
            c.getCurrentNode().setOpacity(1.0);
            c.getCurrentNode().setTranslateX(c.getCurrentRoot().getWidth());
        }

        @Override
        public List<KeyFrame> animate(AnimationHandler c) {
            return Arrays.asList(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().translateXProperty(), (Object)c.getCurrentRoot().getWidth(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().translateXProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(c.getDuration(), new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().translateXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().translateXProperty(), (Object)(-c.getCurrentRoot().getWidth()), Interpolator.EASE_BOTH)}));
        }
    }
    ,
    SWIPE_RIGHT{

        @Override
        public void init(AnimationHandler c) {
            c.getPreviousNode().setScaleX(1.0);
            c.getPreviousNode().setScaleY(1.0);
            c.getPreviousNode().setOpacity(0.0);
            c.getPreviousNode().setTranslateX(0.0);
            c.getCurrentNode().setScaleX(1.0);
            c.getCurrentNode().setScaleY(1.0);
            c.getCurrentNode().setOpacity(1.0);
            c.getCurrentNode().setTranslateX(-c.getCurrentRoot().getWidth());
        }

        @Override
        public List<KeyFrame> animate(AnimationHandler c) {
            return Arrays.asList(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().translateXProperty(), (Object)(-c.getCurrentRoot().getWidth()), Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().translateXProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(c.getDuration(), new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().translateXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().translateXProperty(), (Object)c.getCurrentRoot().getWidth(), Interpolator.EASE_BOTH)}));
        }
    }
    ,
    SWIPE_LEFT_FADE_SHORT{

        @Override
        public void init(AnimationHandler c) {
            c.getPreviousNode().setScaleX(1.0);
            c.getPreviousNode().setScaleY(1.0);
            c.getPreviousNode().setOpacity(0.0);
            c.getPreviousNode().setTranslateX(0.0);
            c.getCurrentNode().setScaleX(1.0);
            c.getCurrentNode().setScaleY(1.0);
            c.getCurrentNode().setOpacity(1.0);
            c.getCurrentNode().setTranslateX(c.getCurrentRoot().getWidth());
        }

        @Override
        public List<KeyFrame> animate(AnimationHandler c) {
            return Arrays.asList(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().translateXProperty(), (Object)50, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().translateXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getCurrentNode().opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().opacityProperty(), (Object)1, Interpolator.EASE_BOTH)}), new KeyFrame(c.getDuration(), new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().translateXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().translateXProperty(), (Object)-50, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getCurrentNode().opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}));
        }
    }
    ,
    SWIPE_RIGHT_FADE_SHORT{

        @Override
        public void init(AnimationHandler c) {
            c.getPreviousNode().setScaleX(1.0);
            c.getPreviousNode().setScaleY(1.0);
            c.getPreviousNode().setOpacity(0.0);
            c.getPreviousNode().setTranslateX(0.0);
            c.getCurrentNode().setScaleX(1.0);
            c.getCurrentNode().setScaleY(1.0);
            c.getCurrentNode().setOpacity(1.0);
            c.getCurrentNode().setTranslateX(c.getCurrentRoot().getWidth());
        }

        @Override
        public List<KeyFrame> animate(AnimationHandler c) {
            return Arrays.asList(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().translateXProperty(), (Object)-50, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().translateXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getCurrentNode().opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().opacityProperty(), (Object)1, Interpolator.EASE_BOTH)}), new KeyFrame(c.getDuration(), new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().translateXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().translateXProperty(), (Object)50, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getCurrentNode().opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}));
        }
    };

    private ContainerAnimations opposite;

    @Override
    public abstract void init(AnimationHandler var1);

    @Override
    public abstract List<KeyFrame> animate(AnimationHandler var1);

    @Override
    @Nullable
    public ContainerAnimations opposite() {
        return this.opposite;
    }

    static {
        ContainerAnimations.NONE.opposite = NONE;
        ContainerAnimations.FADE.opposite = FADE;
        ContainerAnimations.SWIPE_LEFT.opposite = SWIPE_RIGHT;
        ContainerAnimations.SWIPE_RIGHT.opposite = SWIPE_LEFT;
        ContainerAnimations.FADE_IN.opposite = FADE_OUT;
        ContainerAnimations.FADE_OUT.opposite = FADE_IN;
        ContainerAnimations.ZOOM_IN.opposite = ZOOM_OUT;
        ContainerAnimations.ZOOM_OUT.opposite = ZOOM_IN;
    }
}

