/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.effects.JFXDepthManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.SVGPath;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.mod.server.ServerModpackManifest;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.download.DownloadPage;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class ModpackSelectionPage
extends VBox
implements WizardPage {
    private final WizardController controller;

    public ModpackSelectionPage(WizardController controller) {
        this.controller = controller;
        Label title = new Label(I18n.i18n("install.modpack"));
        title.setPadding(new Insets(8.0));
        this.getStyleClass().add((Object)"jfx-list-view");
        this.setMaxSize(400.0, 150.0);
        this.setSpacing(8.0);
        this.getChildren().setAll((Object[])new Node[]{title, this.createButton("local", this::onChooseLocalFile), this.createButton("remote", this::onChooseRemoteFile), this.createButton("repository", this::onChooseRepository)});
        Optional<File> filePath = Lang.tryCast(controller.getSettings().get("MODPACK_FILE"), File.class);
        if (filePath.isPresent()) {
            controller.getSettings().put("MODPACK_FILE", filePath.get());
            Platform.runLater(controller::onNext);
        }
        FXUtils.applyDragListener((Node)this, ModpackHelper::isFileModpackByExtension, modpacks -> {
            File modpack = (File)modpacks.get(0);
            controller.getSettings().put("MODPACK_FILE", modpack);
            controller.onNext();
        });
    }

    private JFXButton createButton(String type, Runnable action) {
        JFXButton button = new JFXButton();
        button.getStyleClass().add((Object)"card");
        button.setStyle("-fx-cursor: HAND;");
        button.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        button.setOnAction(e -> action.run());
        BorderPane graphic = new BorderPane();
        graphic.setMouseTransparent(true);
        graphic.setLeft((Node)new TwoLineListItem(I18n.i18n("modpack.choose." + type), I18n.i18n("modpack.choose." + type + ".detail")));
        SVGPath arrow = new SVGPath();
        arrow.setContent(SVG.ARROW_FORWARD.getPath());
        BorderPane.setAlignment((Node)arrow, (Pos)Pos.CENTER);
        graphic.setRight((Node)arrow);
        button.setGraphic((Node)graphic);
        JFXDepthManager.setDepth((Node)button, 1);
        return button;
    }

    private void onChooseLocalFile() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle(I18n.i18n("modpack.choose"));
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("modpack"), new String[]{"*.zip", "*.mrpack"}));
        File selectedFile = chooser.showOpenDialog((Window)Controllers.getStage());
        if (selectedFile == null) {
            Platform.runLater(this.controller::onEnd);
            return;
        }
        this.controller.getSettings().put("MODPACK_FILE", selectedFile);
        this.controller.onNext();
    }

    private void onChooseRemoteFile() {
        Controllers.prompt(I18n.i18n("modpack.choose.remote.tooltip"), (urlString, resolve, reject) -> {
            try {
                URL url = new URL((String)urlString);
                if (urlString.endsWith("server-manifest.json")) {
                    Controllers.taskDialog(new GetTask(url).whenComplete(Schedulers.javafx(), (result, e) -> {
                        ServerModpackManifest manifest = JsonUtils.fromMaybeMalformedJson(result, ServerModpackManifest.class);
                        if (manifest == null) {
                            reject.accept(I18n.i18n("modpack.type.server.malformed"));
                        } else if (e == null) {
                            resolve.run();
                            this.controller.getSettings().put("MODPACK_SERVER_MANIFEST", manifest);
                            this.controller.onNext();
                        } else {
                            reject.accept(e.getMessage());
                        }
                    }).executor(true), I18n.i18n("message.downloading"), TaskCancellationAction.NORMAL);
                } else {
                    Path modpack = Files.createTempFile("modpack", ".zip", new FileAttribute[0]);
                    resolve.run();
                    Controllers.taskDialog(new FileDownloadTask(url, modpack.toFile(), null).whenComplete(Schedulers.javafx(), e -> {
                        if (e == null) {
                            resolve.run();
                            this.controller.getSettings().put("MODPACK_FILE", modpack.toFile());
                            this.controller.onNext();
                        } else {
                            reject.accept(e.getMessage());
                        }
                    }).executor(true), I18n.i18n("message.downloading"), TaskCancellationAction.NORMAL);
                }
            }
            catch (IOException e2) {
                reject.accept(e2.getMessage());
            }
        });
    }

    public void onChooseRepository() {
        String modPackName = (String)this.controller.getSettings().get("MODPACK_NAME");
        DownloadPage downloadPage = new DownloadPage(modPackName);
        downloadPage.showModpackDownloads();
        Controllers.navigate((Node)downloadPage);
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
    }

    @Override
    public String getTitle() {
        return I18n.i18n("modpack.task.install");
    }
}

