/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.upgrade;

import java.io.IOException;
import java.util.LinkedHashMap;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.upgrade.IntegrityChecker;
import org.jackhuang.hmcl.upgrade.RemoteVersion;
import org.jackhuang.hmcl.upgrade.UpdateChannel;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class UpdateChecker {
    private static final ObjectProperty<RemoteVersion> latestVersion = new SimpleObjectProperty();
    private static final BooleanBinding outdated = Bindings.createBooleanBinding(() -> {
        RemoteVersion latest = (RemoteVersion)latestVersion.get();
        if (latest == null || UpdateChecker.isDevelopmentVersion(Metadata.VERSION)) {
            return false;
        }
        if (latest.isForce() || Metadata.isNightly() || latest.getChannel() == UpdateChannel.NIGHTLY || latest.getChannel() != UpdateChannel.getChannel()) {
            return !latest.getVersion().equals(Metadata.VERSION);
        }
        return VersionNumber.compare(Metadata.VERSION, latest.getVersion()) < 0;
    }, (Observable[])new Observable[]{latestVersion});
    private static final ReadOnlyBooleanWrapper checkingUpdate = new ReadOnlyBooleanWrapper(false);

    private UpdateChecker() {
    }

    public static void init() {
        UpdateChecker.requestCheckUpdate(UpdateChannel.getChannel(), ConfigHolder.config().isAcceptPreviewUpdate());
    }

    public static RemoteVersion getLatestVersion() {
        return (RemoteVersion)latestVersion.get();
    }

    public static ReadOnlyObjectProperty<RemoteVersion> latestVersionProperty() {
        return latestVersion;
    }

    public static boolean isOutdated() {
        return outdated.get();
    }

    public static ObservableBooleanValue outdatedProperty() {
        return outdated;
    }

    public static boolean isCheckingUpdate() {
        return checkingUpdate.get();
    }

    public static ReadOnlyBooleanProperty checkingUpdateProperty() {
        return checkingUpdate.getReadOnlyProperty();
    }

    private static RemoteVersion checkUpdate(UpdateChannel channel, boolean preview) throws IOException {
        if (!IntegrityChecker.DISABLE_SELF_INTEGRITY_CHECK && !IntegrityChecker.isSelfVerified()) {
            throw new IOException("Self verification failed");
        }
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("version", Metadata.VERSION);
        query.put("channel", preview ? channel.channelName + "-preview" : channel.channelName);
        String url = NetworkUtils.withQuery(Metadata.HMCL_UPDATE_URL, query);
        return RemoteVersion.fetch(channel, preview, url);
    }

    private static boolean isDevelopmentVersion(String version) {
        return version.contains("@") || version.contains("SNAPSHOT");
    }

    public static void requestCheckUpdate(UpdateChannel channel, boolean preview) {
        Platform.runLater(() -> {
            if (UpdateChecker.isCheckingUpdate()) {
                return;
            }
            checkingUpdate.set(true);
            Lang.thread(() -> {
                RemoteVersion result = null;
                try {
                    result = UpdateChecker.checkUpdate(channel, preview);
                    Logger.LOG.info("Latest version (" + (Object)((Object)channel) + ", preview=" + preview + ") is " + result);
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to check for update", e);
                }
                RemoteVersion finalResult = result;
                Platform.runLater(() -> {
                    checkingUpdate.set(false);
                    if (finalResult != null) {
                        latestVersion.set((Object)finalResult);
                    }
                });
            }, "Update Checker", true);
        });
    }
}

