/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.task;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import javafx.application.Platform;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public final class Schedulers {
    @Nullable
    private static final Function<String, ExecutorService> NEW_VIRTUAL_THREAD_PER_TASK_EXECUTOR;

    private Schedulers() {
    }

    public static ExecutorService newVirtualThreadPerTaskExecutor(String name) {
        if (NEW_VIRTUAL_THREAD_PER_TASK_EXECUTOR == null) {
            return null;
        }
        return NEW_VIRTUAL_THREAD_PER_TASK_EXECUTOR.apply(name);
    }

    public static ExecutorService io() {
        return Holder.IO_EXECUTOR;
    }

    public static Executor javafx() {
        return Platform::runLater;
    }

    public static Executor defaultScheduler() {
        return ForkJoinPool.commonPool();
    }

    public static void shutdown() {
        Logger.LOG.info("Shutting down executor services.");
    }

    static {
        if (Runtime.version().feature() >= 21) {
            try {
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                Class<?> vtBuilderCls = Class.forName("java.lang.Thread$Builder$OfVirtual");
                MethodHandle ofVirtualHandle = lookup.findStatic(Thread.class, "ofVirtual", MethodType.methodType(vtBuilderCls));
                MethodHandle setNameHandle = lookup.findVirtual(vtBuilderCls, "name", MethodType.methodType(vtBuilderCls, String.class, Long.TYPE));
                MethodHandle toFactoryHandle = lookup.findVirtual(vtBuilderCls, "factory", MethodType.methodType(ThreadFactory.class));
                MethodHandle newThreadPerTaskExecutorFactory = lookup.findStatic(Executors.class, "newThreadPerTaskExecutor", MethodType.methodType(ExecutorService.class, ThreadFactory.class));
                NEW_VIRTUAL_THREAD_PER_TASK_EXECUTOR = name -> {
                    try {
                        Object virtualThreadBuilder = ofVirtualHandle.invoke();
                        setNameHandle.invoke(virtualThreadBuilder, (String)name, 1L);
                        ThreadFactory threadFactory = toFactoryHandle.invoke(virtualThreadBuilder);
                        return newThreadPerTaskExecutorFactory.invokeExact(threadFactory);
                    }
                    catch (Throwable e) {
                        throw new AssertionError("Unreachable", e);
                    }
                };
            }
            catch (Throwable e) {
                throw new AssertionError("Unreachable", e);
            }
        } else {
            NEW_VIRTUAL_THREAD_PER_TASK_EXECUTOR = null;
        }
    }

    private static final class Holder {
        private static final ExecutorService IO_EXECUTOR;

        private Holder() {
        }

        static {
            ExecutorService vtExecutor = Schedulers.newVirtualThreadPerTaskExecutor("IO");
            IO_EXECUTOR = vtExecutor != null ? vtExecutor : Executors.newCachedThreadPool(Lang.counterThreadFactory("IO", true));
        }
    }
}

