/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.annotations.SerializedName;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.Observable;
import javafx.beans.property.ListProperty;
import javafx.beans.property.MapProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SetProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import org.jackhuang.hmcl.util.TypeUtils;
import org.jackhuang.hmcl.util.gson.RawPreservingProperty;

public abstract class ObservableField<T> {
    protected final String serializedName;
    protected final List<String> alternateNames;
    protected final VarHandle varHandle;

    public static <T> ObservableField<T> of(MethodHandles.Lookup lookup, Field field) {
        VarHandle varHandle;
        List<String> alternateNames;
        String name;
        SerializedName serializedName = field.getAnnotation(SerializedName.class);
        if (serializedName == null) {
            name = field.getName();
            alternateNames = List.of();
        } else {
            name = serializedName.value();
            alternateNames = List.of(serializedName.alternate());
        }
        try {
            varHandle = lookup.unreflectVarHandle(field);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        if (ObservableList.class.isAssignableFrom(field.getType())) {
            Type listType = TypeUtils.getSupertype(field.getGenericType(), field.getType(), List.class);
            if (!(listType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("Cannot resolve the list type of " + field.getName());
            }
            return new CollectionField(name, alternateNames, varHandle, listType, listType);
        }
        if (ObservableSet.class.isAssignableFrom(field.getType())) {
            Type setType = TypeUtils.getSupertype(field.getGenericType(), field.getType(), Set.class);
            if (!(setType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("Cannot resolve the set type of " + field.getName());
            }
            ParameterizedType listType = TypeUtils.newParameterizedTypeWithOwner(null, List.class, ((ParameterizedType)setType).getActualTypeArguments()[0]);
            return new CollectionField(name, alternateNames, varHandle, setType, listType);
        }
        if (ObservableMap.class.isAssignableFrom(field.getType())) {
            Type mapType = TypeUtils.getSupertype(field.getGenericType(), field.getType(), Map.class);
            if (!(mapType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("Cannot resolve the map type of " + field.getName());
            }
            return new MapField(name, alternateNames, varHandle, mapType);
        }
        if (Property.class.isAssignableFrom(field.getType())) {
            Type propertyType = TypeUtils.getSupertype(field.getGenericType(), field.getType(), Property.class);
            if (!(propertyType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("Cannot resolve the element type of " + field.getName());
            }
            Type elementType = ((ParameterizedType)propertyType).getActualTypeArguments()[0];
            return new PropertyField(name, alternateNames, varHandle, elementType);
        }
        throw new IllegalArgumentException("Field " + field.getName() + " is not a property or observable collection");
    }

    private ObservableField(String serializedName, List<String> alternateNames, VarHandle varHandle) {
        this.serializedName = serializedName;
        this.alternateNames = alternateNames;
        this.varHandle = varHandle;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public List<String> getAlternateNames() {
        return this.alternateNames;
    }

    public Observable get(T value) {
        return this.varHandle.get(value);
    }

    public abstract void serialize(JsonObject var1, T var2, JsonSerializationContext var3);

    public abstract void deserialize(T var1, JsonElement var2, JsonDeserializationContext var3);

    private static final class CollectionField<T>
    extends ObservableField<T> {
        private final Type collectionType;
        private final Type listType;

        CollectionField(String serializedName, List<String> alternate, VarHandle varHandle, Type collectionType, Type listType) {
            super(serializedName, alternate, varHandle);
            this.collectionType = collectionType;
            this.listType = listType;
        }

        @Override
        public void serialize(JsonObject result, T value, JsonSerializationContext context) {
            result.add(this.getSerializedName(), context.serialize(this.get(value), this.collectionType));
        }

        @Override
        public void deserialize(T value, JsonElement element, JsonDeserializationContext context) {
            List deserialized = (List)context.deserialize(element, this.listType);
            Observable fieldValue = this.get(value);
            if (fieldValue instanceof ListProperty) {
                ((ListProperty)fieldValue).set((Object)FXCollections.observableList((List)deserialized));
            } else if (fieldValue instanceof ObservableList) {
                ((ObservableList)fieldValue).setAll((Collection)deserialized);
            } else if (fieldValue instanceof SetProperty) {
                ((SetProperty)fieldValue).set((Object)FXCollections.observableSet(new HashSet(deserialized)));
            } else if (fieldValue instanceof ObservableSet) {
                ObservableSet set = (ObservableSet)fieldValue;
                set.clear();
                set.addAll((Collection)deserialized);
            } else {
                throw new JsonParseException("Unsupported field type: " + String.valueOf(fieldValue.getClass()));
            }
        }
    }

    private static final class MapField<T>
    extends ObservableField<T> {
        private final Type mapType;

        MapField(String serializedName, List<String> alternate, VarHandle varHandle, Type mapType) {
            super(serializedName, alternate, varHandle);
            this.mapType = mapType;
        }

        @Override
        public void serialize(JsonObject result, T value, JsonSerializationContext context) {
            result.add(this.getSerializedName(), context.serialize(this.get(value), this.mapType));
        }

        @Override
        public void deserialize(T config, JsonElement element, JsonDeserializationContext context) {
            Map deserialized = (Map)context.deserialize(element, this.mapType);
            ObservableMap map = this.varHandle.get(config);
            if (map instanceof MapProperty) {
                ((MapProperty)map).set((Object)FXCollections.observableMap((Map)deserialized));
            } else {
                map.clear();
                map.putAll(deserialized);
            }
        }
    }

    private static final class PropertyField<T>
    extends ObservableField<T> {
        private final Type elementType;

        PropertyField(String serializedName, List<String> alternate, VarHandle varHandle, Type elementType) {
            super(serializedName, alternate, varHandle);
            this.elementType = elementType;
        }

        @Override
        public void serialize(JsonObject result, T value, JsonSerializationContext context) {
            RawPreservingProperty rawPreserving;
            JsonElement rawJson;
            Property property = (Property)this.get(value);
            if (property instanceof RawPreservingProperty && (rawJson = (rawPreserving = (RawPreservingProperty)property).getRawJson()) != null) {
                result.add(this.getSerializedName(), rawJson);
                return;
            }
            JsonElement serialized = context.serialize(property.getValue(), this.elementType);
            if (serialized != null && !serialized.isJsonNull()) {
                result.add(this.getSerializedName(), serialized);
            }
        }

        @Override
        public void deserialize(T value, JsonElement element, JsonDeserializationContext context) {
            Property property = (Property)this.get(value);
            try {
                property.setValue(context.deserialize(element, this.elementType));
            }
            catch (Throwable e) {
                if (property instanceof RawPreservingProperty) {
                    ((RawPreservingProperty)property).setRawJson(element);
                }
                throw e;
            }
        }
    }
}

