/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import java.io.File;
import java.util.List;
import org.jackhuang.hmcl.util.Lang;

public interface ModAdviser {
    public static final List<String> MODPACK_BLACK_LIST = Lang.immutableListOf("regex:(.*?)\\.log", "regex:.*\\.dat_old$", "regex:.*\\.old$", "regex:.*\\.BakaCoreInfo$", "regex:.*-natives", "usernamecache.json", "usercache.json", "launcher_profiles.json", "launcher.pack.lzma", "launcher_accounts.json", "launcher_cef_log.txt", "launcher_log.txt", "launcher_msa_credentials.bin", "launcher_settings.json", "launcher_ui_state.json", "realms_persistence.json", "webcache2", "treatment_tags.json", "clientId.txt", "PCL.ini", "backup", "pack.json", "launcher.jar", "cache", "modpack.cfg", "log4j2.xml", "hmclversion.cfg", "manifest.json", "minecraftinstance.json", ".curseclient", "modrinth.index.json", ".fabric", ".mixin.out", ".optifine", "jars", "logs", "versions", "assets", "libraries", "crash-reports", "NVIDIA", "AMD", "screenshots", "natives", "native", "$native", "$natives", "server-resource-packs", "command_history.txt", "downloads", "essential", "asm", "backups", "TCNodeTracker", "CustomDISkins", "data", "CustomSkinLoader/caches", "debug", ".replay_cache", "replay_recordings", "replay_videos", "irisUpdateInfo.json", "modernfix", "modtranslations", "schematics", "journeymap/data", "mods/.connector");
    public static final List<String> MODPACK_SUGGESTED_BLACK_LIST = Lang.immutableListOf("fonts", "saves", "servers.dat", "options.txt", "blueprints", "optionsof.txt", "journeymap", "optionsshaders.txt", "mods" + File.separator + "VoxelMods");

    public ModSuggestion advise(String var1, boolean var2);

    public static ModSuggestion suggestMod(String fileName, boolean isDirectory) {
        if (ModAdviser.match(MODPACK_BLACK_LIST, fileName, isDirectory)) {
            return ModSuggestion.HIDDEN;
        }
        if (ModAdviser.match(MODPACK_SUGGESTED_BLACK_LIST, fileName, isDirectory)) {
            return ModSuggestion.NORMAL;
        }
        return ModSuggestion.SUGGESTED;
    }

    public static boolean match(List<String> l, String fileName, boolean isDirectory) {
        for (String s : l) {
            if (!(isDirectory ? fileName.startsWith(s + File.separator) : (s.startsWith("regex:") ? fileName.matches(s.substring("regex:".length())) : fileName.equals(s)))) continue;
            return true;
        }
        return false;
    }

    public static enum ModSuggestion {
        SUGGESTED,
        NORMAL,
        HIDDEN;

    }
}

