/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.jackhuang.hmcl.game.Argument;
import org.jackhuang.hmcl.game.Arguments;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.StringArgument;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.game.VersionProvider;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.jackhuang.hmcl.util.versioning.VersionRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LibraryAnalyzer
implements Iterable<LibraryMark> {
    private Version version;
    private final Map<String, Pair<Library, String>> libraries;
    public static final String VANILLA_MAIN = "net.minecraft.client.main.Main";
    public static final String LAUNCH_WRAPPER_MAIN = "net.minecraft.launchwrapper.Launch";
    public static final String MOD_LAUNCHER_MAIN = "cpw.mods.modlauncher.Launcher";
    public static final String BOOTSTRAP_LAUNCHER_MAIN = "cpw.mods.bootstraplauncher.BootstrapLauncher";
    public static final String FORGE_BOOTSTRAP_MAIN = "net.minecraftforge.bootstrap.ForgeBootstrap";
    public static final Set<String> FORGE_OPTIFINE_MAIN = new HashSet<String>(Lang.immutableListOf("net.minecraft.client.main.Main", "net.minecraft.launchwrapper.Launch", "cpw.mods.modlauncher.Launcher", "cpw.mods.bootstraplauncher.BootstrapLauncher", "net.minecraftforge.bootstrap.ForgeBootstrap"));
    public static final VersionRange<VersionNumber> FORGE_OPTIFINE_BROKEN_RANGE = VersionNumber.between("48.0.0", "49.0.50");
    public static final String[] FORGE_TWEAKERS = new String[]{"net.minecraftforge.legacy._1_5_2.LibraryFixerTweaker", "cpw.mods.fml.common.launcher.FMLTweaker", "net.minecraftforge.fml.common.launcher.FMLTweaker"};
    public static final String[] OPTIFINE_TWEAKERS = new String[]{"optifine.OptiFineTweaker", "optifine.OptiFineForgeTweaker"};
    public static final String LITELOADER_TWEAKER = "com.mumfrey.liteloader.launch.LiteLoaderTweaker";

    private LibraryAnalyzer(Version version, Map<String, Pair<Library, String>> libraries) {
        this.version = version;
        this.libraries = libraries;
    }

    public Optional<String> getVersion(LibraryType type) {
        return this.getVersion(type.getPatchId());
    }

    public Optional<String> getVersion(String type) {
        return Optional.ofNullable(this.libraries.get(type)).map(Pair::getValue);
    }

    public Optional<Library> getLibrary(LibraryType type) {
        return Optional.ofNullable(this.libraries.get(type.getPatchId())).map(Pair::getKey);
    }

    public LibraryMark.LibraryStatus getLibraryStatus(String type) {
        return this.version.hasPatch(type) ? LibraryMark.LibraryStatus.CLEAR : LibraryMark.LibraryStatus.JUST_EXISTED;
    }

    @Override
    @NotNull
    public Iterator<LibraryMark> iterator() {
        return new Iterator<LibraryMark>(){
            Iterator<Map.Entry<String, Pair<Library, String>>> impl;
            {
                this.impl = LibraryAnalyzer.this.libraries.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.impl.hasNext();
            }

            @Override
            public LibraryMark next() {
                Map.Entry<String, Pair<Library, String>> entry = this.impl.next();
                return new LibraryMark(entry.getKey(), entry.getValue().getValue(), LibraryAnalyzer.this.getLibraryStatus(entry.getKey()));
            }
        };
    }

    public boolean has(LibraryType type) {
        return this.has(type.getPatchId());
    }

    public boolean has(String type) {
        return this.libraries.containsKey(type);
    }

    public boolean hasModLoader() {
        return this.libraries.keySet().stream().map(LibraryType::fromPatchId).filter(Objects::nonNull).anyMatch(LibraryType::isModLoader);
    }

    public boolean hasModLauncher() {
        return MOD_LAUNCHER_MAIN.equals(this.version.getMainClass()) || this.version.getPatches().stream().anyMatch(patch -> MOD_LAUNCHER_MAIN.equals(patch.getMainClass()));
    }

    private Version removingMatchedLibrary(Version version, String libraryId) {
        LibraryType type = LibraryType.fromPatchId(libraryId);
        if (type == null) {
            return version;
        }
        ArrayList<Library> libraries = new ArrayList<Library>();
        List<Library> rawLibraries = version.getLibraries();
        for (Library library : rawLibraries) {
            if (type.matchLibrary(library, rawLibraries)) continue;
            libraries.add(library);
        }
        return version.setLibraries(libraries);
    }

    public LibraryAnalyzer removeLibrary(String libraryId) {
        if (!this.has(libraryId)) {
            return this;
        }
        this.version = this.removingMatchedLibrary(this.version, libraryId).setPatches(this.version.getPatches().stream().filter(patch -> !libraryId.equals(patch.getId())).map(patch -> this.removingMatchedLibrary((Version)patch, libraryId)).collect(Collectors.toList()));
        return this;
    }

    public Version build() {
        return this.version;
    }

    public static LibraryAnalyzer analyze(Version version, String gameVersion) {
        if (version.getInheritsFrom() != null) {
            throw new IllegalArgumentException("LibraryAnalyzer can only analyze independent game version");
        }
        HashMap<String, Pair<Library, String>> libraries = new HashMap<String, Pair<Library, String>>();
        if (gameVersion != null) {
            libraries.put(LibraryType.MINECRAFT.getPatchId(), Pair.pair(null, gameVersion));
        }
        List<Library> rawLibraries = version.resolve(null).getLibraries();
        block0: for (Library library : rawLibraries) {
            for (LibraryType type : LibraryType.values()) {
                if (!type.matchLibrary(library, rawLibraries)) continue;
                libraries.put(type.getPatchId(), Pair.pair(library, type.patchVersion(version, library.getVersion())));
                continue block0;
            }
        }
        for (Version patch : version.getPatches()) {
            if (patch.isHidden()) continue;
            libraries.put(patch.getId(), Pair.pair(null, patch.getVersion()));
        }
        return new LibraryAnalyzer(version, libraries);
    }

    public static boolean isModded(VersionProvider provider, Version version) {
        Version resolvedVersion = version.resolve(provider);
        String mainClass = resolvedVersion.getMainClass();
        return mainClass != null && (LAUNCH_WRAPPER_MAIN.equals(mainClass) || mainClass.startsWith("net.minecraftforge") || mainClass.startsWith("net.fabricmc") || mainClass.startsWith("org.quiltmc") || mainClass.startsWith("cpw.mods"));
    }

    public Set<ModLoaderType> getModLoaders() {
        return Arrays.stream(LibraryType.values()).filter(LibraryType::isModLoader).filter(this::has).map(LibraryType::getModLoaderType).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static enum LibraryType {
        MINECRAFT(true, "game", "^$", "^$", null),
        FABRIC(true, "fabric", "net\\.fabricmc", "fabric-loader", ModLoaderType.FABRIC),
        FABRIC_API(true, "fabric-api", "net\\.fabricmc", "fabric-api", null),
        FORGE(true, "forge", "net\\.minecraftforge", "(forge|fmlloader)", ModLoaderType.FORGE){
            private final Pattern FORGE_VERSION_MATCHER = Pattern.compile("^([0-9.]+)-(?<forge>[0-9.]+)(-([0-9.]+))?$");

            @Override
            protected String patchVersion(Version gameVersion, String libraryVersion) {
                Matcher matcher = this.FORGE_VERSION_MATCHER.matcher(libraryVersion);
                if (matcher.find()) {
                    return matcher.group("forge");
                }
                return super.patchVersion(gameVersion, libraryVersion);
            }

            @Override
            protected boolean matchLibrary(Library library, List<Library> libraries) {
                for (Library l : libraries) {
                    if (!NEO_FORGE.matchLibrary(l, libraries)) continue;
                    return false;
                }
                return super.matchLibrary(library, libraries);
            }
        }
        ,
        NEO_FORGE(true, "neoforge", "net\\.neoforged\\.fancymodloader", "(core|loader)", ModLoaderType.NEO_FORGED){
            private final Pattern NEO_FORGE_VERSION_MATCHER = Pattern.compile("^([0-9.]+)-(?<forge>[0-9.]+)(-([0-9.]+))?$");

            @Override
            protected String patchVersion(Version gameVersion, String libraryVersion) {
                String res = this.scanVersion(gameVersion);
                if (res != null) {
                    return res;
                }
                for (Version patch : gameVersion.getPatches()) {
                    res = this.scanVersion(patch);
                    if (res == null) continue;
                    return res;
                }
                Matcher matcher = this.NEO_FORGE_VERSION_MATCHER.matcher(libraryVersion);
                if (matcher.find()) {
                    return matcher.group("forge");
                }
                return super.patchVersion(gameVersion, libraryVersion);
            }

            private String scanVersion(Version version) {
                Optional<Arguments> optArgument = version.getArguments();
                if (!optArgument.isPresent()) {
                    return null;
                }
                List<Argument> gameArguments = optArgument.get().getGame();
                if (gameArguments == null) {
                    return null;
                }
                for (int i = 0; i < gameArguments.size() - 1; ++i) {
                    String argumentValue;
                    Argument argument = gameArguments.get(i);
                    if (!(argument instanceof StringArgument) || !"--fml.neoForgeVersion".equals(argumentValue = ((StringArgument)argument).getArgument()) && !"--fml.forgeVersion".equals(argumentValue)) continue;
                    Argument next = gameArguments.get(i + 1);
                    if (next instanceof StringArgument) {
                        return ((StringArgument)next).getArgument();
                    }
                    return null;
                }
                return null;
            }
        }
        ,
        LITELOADER(true, "liteloader", "com\\.mumfrey", "liteloader", ModLoaderType.LITE_LOADER),
        OPTIFINE(false, "optifine", "(net\\.)?optifine", "^(?!.*launchwrapper).*$", null),
        QUILT(true, "quilt", "org\\.quiltmc", "quilt-loader", ModLoaderType.QUILT),
        QUILT_API(true, "quilt-api", "org\\.quiltmc", "quilt-api", null),
        BOOTSTRAP_LAUNCHER(false, "", "cpw\\.mods", "bootstraplauncher", null);

        private final boolean modLoader;
        private final String patchId;
        private final Pattern group;
        private final Pattern artifact;
        private final ModLoaderType modLoaderType;
        private static final Map<String, LibraryType> PATCH_ID_MAP;

        private LibraryType(@Language(value="RegExp") boolean modLoader, @Language(value="RegExp") String patchId, String group, String artifact, ModLoaderType modLoaderType) {
            this.modLoader = modLoader;
            this.patchId = patchId;
            this.group = Pattern.compile(group);
            this.artifact = Pattern.compile(artifact);
            this.modLoaderType = modLoaderType;
        }

        public boolean isModLoader() {
            return this.modLoader;
        }

        public String getPatchId() {
            return this.patchId;
        }

        public ModLoaderType getModLoaderType() {
            return this.modLoaderType;
        }

        public static LibraryType fromPatchId(String patchId) {
            return PATCH_ID_MAP.get(patchId);
        }

        protected boolean matchLibrary(Library library, List<Library> libraries) {
            return this.group.matcher(library.getGroupId()).matches() && this.artifact.matcher(library.getArtifactId()).matches();
        }

        protected String patchVersion(Version gameVersion, String libraryVersion) {
            return libraryVersion;
        }

        static {
            PATCH_ID_MAP = new HashMap<String, LibraryType>();
            for (LibraryType type : LibraryType.values()) {
                PATCH_ID_MAP.put(type.getPatchId(), type);
            }
        }
    }

    public static final class LibraryMark {
        private final String libraryId;
        private final String libraryVersion;
        private final LibraryStatus status;

        private LibraryMark(@NotNull String libraryId, @Nullable String libraryVersion, LibraryStatus status) {
            this.libraryId = libraryId;
            this.libraryVersion = libraryVersion;
            this.status = status;
        }

        @NotNull
        public String getLibraryId() {
            return this.libraryId;
        }

        @Nullable
        public String getLibraryVersion() {
            return this.libraryVersion;
        }

        public LibraryStatus getStatus() {
            return this.status;
        }

        public static enum LibraryStatus {
            CLEAR,
            UNSURE,
            JUST_EXISTED;

        }
    }
}

