/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import javafx.beans.binding.Bindings;
import javafx.beans.binding.NumberBinding;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Skin;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import org.jackhuang.hmcl.util.Lang;

public class FloatScrollBarSkin
implements Skin<ScrollBar> {
    private ScrollBar scrollBar;
    private Region group;
    private Rectangle track = new Rectangle();
    private Rectangle thumb = new Rectangle();

    public FloatScrollBarSkin(final ScrollBar scrollBar) {
        this.scrollBar = scrollBar;
        scrollBar.setPrefHeight(1.0E-18);
        scrollBar.setPrefWidth(1.0E-18);
        this.group = new Region(){
            Point2D dragStart;
            double preDragThumbPos;
            NumberBinding range;
            NumberBinding position;
            {
                this.range = Bindings.subtract((ObservableNumberValue)scrollBar.maxProperty(), (ObservableNumberValue)scrollBar.minProperty());
                this.position = Bindings.divide((ObservableNumberValue)Bindings.subtract((ObservableNumberValue)scrollBar.valueProperty(), (ObservableNumberValue)scrollBar.minProperty()), (ObservableNumberValue)this.range);
                this.getChildren().addAll((Object[])new Node[]{FloatScrollBarSkin.this.track, FloatScrollBarSkin.this.thumb});
                FloatScrollBarSkin.this.track.setManaged(false);
                FloatScrollBarSkin.this.track.getStyleClass().add((Object)"track");
                FloatScrollBarSkin.this.thumb.setManaged(false);
                FloatScrollBarSkin.this.thumb.getStyleClass().add((Object)"thumb");
                scrollBar.orientationProperty().addListener(obs -> this.setup());
                this.setup();
                FloatScrollBarSkin.this.thumb.setOnMousePressed(me -> {
                    if (me.isSynthesized()) {
                        me.consume();
                        return;
                    }
                    if (FloatScrollBarSkin.this.getSkinnable().getMax() > FloatScrollBarSkin.this.getSkinnable().getMin()) {
                        this.dragStart = FloatScrollBarSkin.this.thumb.localToParent(me.getX(), me.getY());
                        double clampedValue = Lang.clamp(FloatScrollBarSkin.this.getSkinnable().getMin(), FloatScrollBarSkin.this.getSkinnable().getValue(), FloatScrollBarSkin.this.getSkinnable().getMax());
                        this.preDragThumbPos = (clampedValue - FloatScrollBarSkin.this.getSkinnable().getMin()) / (FloatScrollBarSkin.this.getSkinnable().getMax() - FloatScrollBarSkin.this.getSkinnable().getMin());
                        me.consume();
                    }
                });
                FloatScrollBarSkin.this.thumb.setOnMouseDragged(me -> {
                    if (me.isSynthesized()) {
                        me.consume();
                        return;
                    }
                    if (FloatScrollBarSkin.this.getSkinnable().getMax() > FloatScrollBarSkin.this.getSkinnable().getMin()) {
                        if (this.trackLength() > this.thumbLength()) {
                            double newValue;
                            Point2D cur = FloatScrollBarSkin.this.thumb.localToParent(me.getX(), me.getY());
                            if (this.dragStart == null) {
                                this.dragStart = FloatScrollBarSkin.this.thumb.localToParent(me.getX(), me.getY());
                            }
                            double dragPos = FloatScrollBarSkin.this.getSkinnable().getOrientation() == Orientation.VERTICAL ? cur.getY() - this.dragStart.getY() : cur.getX() - this.dragStart.getX();
                            double position = this.preDragThumbPos + dragPos / (this.trackLength() - this.thumbLength());
                            if (!FloatScrollBarSkin.this.getSkinnable().isFocused() && FloatScrollBarSkin.this.getSkinnable().isFocusTraversable()) {
                                FloatScrollBarSkin.this.getSkinnable().requestFocus();
                            }
                            if (!Double.isNaN(newValue = position * (FloatScrollBarSkin.this.getSkinnable().getMax() - FloatScrollBarSkin.this.getSkinnable().getMin()) + FloatScrollBarSkin.this.getSkinnable().getMin())) {
                                FloatScrollBarSkin.this.getSkinnable().setValue(Lang.clamp(FloatScrollBarSkin.this.getSkinnable().getMin(), newValue, FloatScrollBarSkin.this.getSkinnable().getMax()));
                            }
                        }
                        me.consume();
                    }
                });
            }

            private double trackLength() {
                return FloatScrollBarSkin.this.getSkinnable().getOrientation() == Orientation.VERTICAL ? FloatScrollBarSkin.this.track.getHeight() : FloatScrollBarSkin.this.track.getWidth();
            }

            private double thumbLength() {
                return FloatScrollBarSkin.this.getSkinnable().getOrientation() == Orientation.VERTICAL ? FloatScrollBarSkin.this.thumb.getHeight() : FloatScrollBarSkin.this.thumb.getWidth();
            }

            private void setup() {
                FloatScrollBarSkin.this.track.widthProperty().unbind();
                FloatScrollBarSkin.this.track.heightProperty().unbind();
                if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
                    FloatScrollBarSkin.this.track.relocate(0.0, -5.0);
                    FloatScrollBarSkin.this.track.widthProperty().bind((ObservableValue)scrollBar.widthProperty());
                    FloatScrollBarSkin.this.track.setHeight(5.0);
                } else {
                    FloatScrollBarSkin.this.track.relocate(-5.0, 0.0);
                    FloatScrollBarSkin.this.track.setWidth(5.0);
                    FloatScrollBarSkin.this.track.heightProperty().bind((ObservableValue)scrollBar.heightProperty());
                }
                FloatScrollBarSkin.this.thumb.xProperty().unbind();
                FloatScrollBarSkin.this.thumb.yProperty().unbind();
                FloatScrollBarSkin.this.thumb.widthProperty().unbind();
                FloatScrollBarSkin.this.thumb.heightProperty().unbind();
                if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
                    FloatScrollBarSkin.this.thumb.relocate(0.0, -5.0);
                    FloatScrollBarSkin.this.thumb.widthProperty().bind((ObservableValue)Bindings.max((int)20, (ObservableNumberValue)scrollBar.visibleAmountProperty().divide((ObservableNumberValue)this.range).multiply((ObservableNumberValue)scrollBar.widthProperty())));
                    FloatScrollBarSkin.this.thumb.setHeight(5.0);
                    FloatScrollBarSkin.this.thumb.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)scrollBar.widthProperty(), (ObservableNumberValue)FloatScrollBarSkin.this.thumb.widthProperty()).multiply((ObservableNumberValue)this.position));
                } else {
                    FloatScrollBarSkin.this.thumb.relocate(-5.0, 0.0);
                    FloatScrollBarSkin.this.thumb.setWidth(5.0);
                    FloatScrollBarSkin.this.thumb.heightProperty().bind((ObservableValue)Bindings.max((int)20, (ObservableNumberValue)scrollBar.visibleAmountProperty().divide((ObservableNumberValue)this.range).multiply((ObservableNumberValue)scrollBar.heightProperty())));
                    FloatScrollBarSkin.this.thumb.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)scrollBar.heightProperty(), (ObservableNumberValue)FloatScrollBarSkin.this.thumb.heightProperty()).multiply((ObservableNumberValue)this.position));
                }
            }

            protected double computeMaxWidth(double height) {
                if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
                    return Double.MAX_VALUE;
                }
                return 5.0;
            }

            protected double computeMaxHeight(double width) {
                if (scrollBar.getOrientation() == Orientation.VERTICAL) {
                    return Double.MAX_VALUE;
                }
                return 5.0;
            }
        };
    }

    public void dispose() {
        this.scrollBar = null;
        this.group = null;
    }

    public Node getNode() {
        return this.group;
    }

    public ScrollBar getSkinnable() {
        return this.scrollBar;
    }
}

