/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.scene.control.TextInputControl;

public final class Validator
extends ValidatorBase {
    private final Predicate<String> validator;

    public static Consumer<Predicate<String>> addTo(JFXTextField control) {
        return Validator.addTo(control, null);
    }

    public static Consumer<Predicate<String>> addTo(JFXTextField control, String message) {
        return predicate -> {
            Validator validator = new Validator(message, (Predicate<String>)predicate);
            InvalidationListener listener = any -> control.validate();
            validator.getProperties().put((Object)validator, (Object)listener);
            control.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(listener));
            control.getValidators().add((Object)validator);
        };
    }

    public Validator(Predicate<String> validator) {
        this.validator = validator;
    }

    public Validator(String message, Predicate<String> validator) {
        this(validator);
        this.setMessage(message);
    }

    @Override
    protected void eval() {
        if (this.srcControl.get() instanceof TextInputControl) {
            String text = ((TextInputControl)this.srcControl.get()).getText();
            this.hasErrors.set(!this.validator.test(text));
        }
    }
}

