/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.forge;

import java.net.URI;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.forge.ForgeRemoteVersion;
import org.jackhuang.hmcl.download.forge.ForgeVersion;
import org.jackhuang.hmcl.download.forge.ForgeVersionRoot;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class ForgeVersionList
extends VersionList<ForgeRemoteVersion> {
    private final DownloadProvider downloadProvider;
    public static final URI FORGE_LIST = URI.create("https://hmcl-dev.github.io/metadata/forge/");

    public ForgeVersionList(DownloadProvider downloadProvider) {
        this.downloadProvider = downloadProvider;
    }

    @Override
    public boolean hasType() {
        return false;
    }

    private static String toLookupVersion(String gameVersion) {
        return "1.7.10-pre4".equals(gameVersion) ? "1.7.10_pre4" : gameVersion;
    }

    private static String fromLookupVersion(String lookupVersion) {
        return "1.7.10_pre4".equals(lookupVersion) ? "1.7.10-pre4" : lookupVersion;
    }

    @Override
    public Task<?> refreshAsync() {
        return new GetTask(FORGE_LIST).thenGetJsonAsync(ForgeVersionRoot.class).thenAcceptAsync(root -> {
            this.lock.writeLock().lock();
            try {
                if (root == null) {
                    return;
                }
                this.versions.clear();
                for (Map.Entry<String, int[]> entry : root.getGameVersions().entrySet()) {
                    String gameVersion = ForgeVersionList.fromLookupVersion(VersionNumber.normalize(entry.getKey()));
                    for (int v : entry.getValue()) {
                        ForgeVersion version = root.getNumber().get(v);
                        if (version == null) continue;
                        String jar = null;
                        for (String[] file : version.getFiles()) {
                            if (file.length <= 1 || !"installer".equals(file[1])) continue;
                            String classifier = version.getGameVersion() + "-" + version.getVersion() + (String)(StringUtils.isNotBlank(version.getBranch()) ? "-" + version.getBranch() : "");
                            String fileName = root.getArtifact() + "-" + classifier + "-" + file[1] + "." + file[0];
                            jar = root.getWebPath() + classifier + "/" + fileName;
                        }
                        if (jar == null) continue;
                        this.versions.put(gameVersion, new ForgeRemoteVersion(ForgeVersionList.toLookupVersion(version.getGameVersion()), version.getVersion(), version.getModified() > 0L ? Instant.ofEpochSecond(version.getModified()) : null, Collections.singletonList(jar)));
                    }
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }
}

