/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.terracotta;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.task.DownloadException;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.terracotta.TerracottaMetadata;
import org.jackhuang.hmcl.terracotta.TerracottaState;
import org.jackhuang.hmcl.terracotta.provider.ITerracottaProvider;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.InvocationDispatcher;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.platform.SystemUtils;
import org.jackhuang.hmcl.util.tree.TarFileTree;
import org.jetbrains.annotations.Nullable;

public final class TerracottaManager {
    private static final AtomicReference<TerracottaState> STATE_V = new AtomicReference<TerracottaState.Bootstrap>(TerracottaState.Bootstrap.INSTANCE);
    private static final ReadOnlyObjectWrapper<TerracottaState> STATE = new ReadOnlyObjectWrapper((Object)STATE_V.getPlain());
    private static final InvocationDispatcher<TerracottaState> STATE_D = InvocationDispatcher.runOn(Platform::runLater, arg_0 -> STATE.set(arg_0));

    private TerracottaManager() {
    }

    public static ReadOnlyObjectProperty<TerracottaState> stateProperty() {
        return STATE.getReadOnlyProperty();
    }

    public static boolean validate(Path file) {
        return FileUtils.getName(file).equalsIgnoreCase(TerracottaMetadata.PACKAGE_NAME);
    }

    public static TerracottaState.Preparing install(@Nullable Path file) {
        TerracottaState.Preparing it;
        TerracottaState.Preparing preparing;
        FXUtils.checkFxUserThread();
        TerracottaState state = STATE_V.get();
        if (!(state instanceof TerracottaState.Uninitialized || state instanceof TerracottaState.Preparing && (preparing = (TerracottaState.Preparing)state).hasInstallFence() || state instanceof TerracottaState.Fatal && ((TerracottaState.Fatal)state).isRecoverable())) {
            return null;
        }
        if (file != null && !FileUtils.getName(file).equalsIgnoreCase(TerracottaMetadata.PACKAGE_NAME)) {
            return null;
        }
        preparing = state instanceof TerracottaState.Preparing ? (it = (TerracottaState.Preparing)state) : new TerracottaState.Preparing(new ReadOnlyDoubleWrapper(-1.0));
        Task.supplyAsync(Schedulers.io(), () -> file != null ? TarFileTree.open(file) : null).thenComposeAsync(Schedulers.javafx(), tree -> TerracottaManager.getProvider().install(preparing, (TarFileTree)tree).whenComplete(exception -> {
            if (tree != null) {
                tree.close();
            }
            if (exception != null) {
                throw exception;
            }
        })).whenComplete(exception -> {
            if (exception == null) {
                try {
                    TerracottaMetadata.removeLegacyVersionFiles();
                }
                catch (IOException e) {
                    Logger.LOG.warning("Unable to remove legacy terracotta files.", e);
                }
                TerracottaState.Launching launching = new TerracottaState.Launching();
                if (TerracottaManager.compareAndSet(preparing, launching)) {
                    TerracottaManager.launch(launching);
                }
            } else if (exception instanceof ITerracottaProvider.ArchiveFileMissingException) {
                Logger.LOG.warning("Cannot install terracotta from local package.", exception);
                TerracottaManager.compareAndSet(preparing, new TerracottaState.Fatal(TerracottaState.Fatal.Type.INSTALL));
            } else if (exception instanceof DownloadException) {
                TerracottaManager.compareAndSet(preparing, new TerracottaState.Fatal(TerracottaState.Fatal.Type.NETWORK));
            } else {
                TerracottaManager.compareAndSet(preparing, new TerracottaState.Fatal(TerracottaState.Fatal.Type.INSTALL));
            }
        }).start();
        return TerracottaManager.setState(preparing);
    }

    private static ITerracottaProvider getProvider() {
        ITerracottaProvider provider = TerracottaMetadata.PROVIDER;
        if (provider == null) {
            throw new AssertionError((Object)"Terracotta Provider must NOT be null.");
        }
        return provider;
    }

    public static TerracottaState recover(@Nullable Path file) {
        FXUtils.checkFxUserThread();
        TerracottaState state = STATE_V.get();
        if (!(state instanceof TerracottaState.Fatal) || !((TerracottaState.Fatal)state).isRecoverable()) {
            return null;
        }
        try {
            return switch (TerracottaManager.getProvider().status()) {
                default -> throw new IncompatibleClassChangeError();
                case ITerracottaProvider.Status.NOT_EXIST, ITerracottaProvider.Status.LEGACY_VERSION -> TerracottaManager.install(file);
                case ITerracottaProvider.Status.READY -> {
                    TerracottaState.Launching launching = TerracottaManager.setState(new TerracottaState.Launching());
                    TerracottaManager.launch(launching);
                    yield launching;
                }
            };
        }
        catch (IOException | NullPointerException e) {
            Logger.LOG.warning("Cannot determine Terracotta state.", e);
            return TerracottaManager.setState(new TerracottaState.Fatal(TerracottaState.Fatal.Type.UNKNOWN));
        }
    }

    private static void launch(TerracottaState.Launching state) {
        Task.supplyAsync(() -> {
            Path path = Files.createTempDirectory(String.format("hmcl-terracotta-%d", ThreadLocalRandom.current().nextLong()), new FileAttribute[0]).resolve("http").toAbsolutePath();
            ManagedProcess process = new ManagedProcess(new ProcessBuilder(TerracottaManager.getProvider().ofCommandLine(path)));
            process.pumpInputStream(SystemUtils::onLogLine);
            process.pumpErrorStream(SystemUtils::onLogLine);
            long exitTime = -1L;
            while (true) {
                if (Files.exists(path, new LinkOption[0])) {
                    JsonObject object = JsonUtils.fromNonNullJson(Files.readString(path), JsonObject.class);
                    return object.get("port").getAsInt();
                }
                if (process.isRunning()) continue;
                if (exitTime == -1L) {
                    exitTime = System.currentTimeMillis();
                    continue;
                }
                if (System.currentTimeMillis() - exitTime >= 10000L) break;
            }
            throw new IllegalStateException("Process has exited for 10s.");
        }).whenComplete(Schedulers.javafx(), (port, exception) -> {
            TerracottaState next = exception == null ? new TerracottaState.Unknown((int)port) : new TerracottaState.Fatal(TerracottaState.Fatal.Type.TERRACOTTA);
            TerracottaManager.compareAndSet(state, next);
        }).start();
    }

    public static Task<String> exportLogs() {
        TerracottaState terracottaState = STATE_V.get();
        if (terracottaState instanceof TerracottaState.PortSpecific) {
            TerracottaState.PortSpecific portSpecific = (TerracottaState.PortSpecific)terracottaState;
            return new GetTask(URI.create(String.format("http://127.0.0.1:%d/log?fetch=true", portSpecific.port))).setSignificance(Task.TaskSignificance.MINOR);
        }
        return Task.completed(null);
    }

    public static TerracottaState.Waiting setWaiting() {
        TerracottaState state = STATE_V.get();
        if (state instanceof TerracottaState.PortSpecific) {
            TerracottaState.PortSpecific portSpecific = (TerracottaState.PortSpecific)state;
            new GetTask(URI.create(String.format("http://127.0.0.1:%d/state/ide", portSpecific.port))).setSignificance(Task.TaskSignificance.MINOR).start();
            return new TerracottaState.Waiting(-1, -1, null);
        }
        return null;
    }

    private static String getPlayerName() {
        Account account = Accounts.getSelectedAccount();
        return account != null ? account.getCharacter() : I18n.i18n("terracotta.player_anonymous");
    }

    public static TerracottaState.HostScanning setScanning() {
        TerracottaState state = STATE_V.get();
        if (state instanceof TerracottaState.PortSpecific) {
            TerracottaState.PortSpecific portSpecific = (TerracottaState.PortSpecific)state;
            new GetTask(NetworkUtils.toURI(String.format("http://127.0.0.1:%d/state/scanning?player=%s", portSpecific.port, TerracottaManager.getPlayerName()))).setSignificance(Task.TaskSignificance.MINOR).start();
            return new TerracottaState.HostScanning(-1, -1, null);
        }
        return null;
    }

    public static Task<TerracottaState.GuestStarting> setGuesting(String room) {
        TerracottaState state = STATE_V.get();
        if (state instanceof TerracottaState.PortSpecific) {
            TerracottaState.PortSpecific portSpecific = (TerracottaState.PortSpecific)state;
            return new GetTask(NetworkUtils.toURI(String.format("http://127.0.0.1:%d/state/guesting?room=%s&player=%s", portSpecific.port, room, TerracottaManager.getPlayerName()))).setSignificance(Task.TaskSignificance.MINOR).thenSupplyAsync(() -> new TerracottaState.GuestStarting(-1, -1, null)).setSignificance(Task.TaskSignificance.MINOR);
        }
        return null;
    }

    private static <T extends TerracottaState> T setState(T value) {
        if (value == null) {
            throw new AssertionError();
        }
        STATE_V.set(value);
        STATE_D.accept(value);
        return value;
    }

    private static boolean compareAndSet(TerracottaState previous, TerracottaState next) {
        if (next == null) {
            throw new AssertionError();
        }
        if (STATE_V.compareAndSet(previous, next)) {
            STATE_D.accept(next);
            return true;
        }
        return false;
    }

    static {
        Task.runAsync(() -> {
            if (TerracottaMetadata.PROVIDER == null) {
                TerracottaManager.setState(new TerracottaState.Fatal(TerracottaState.Fatal.Type.OS));
                Logger.LOG.warning("Terracotta hasn't support your OS: " + String.valueOf(org.jackhuang.hmcl.util.platform.Platform.SYSTEM_PLATFORM));
            } else {
                switch (TerracottaMetadata.PROVIDER.status()) {
                    case NOT_EXIST: {
                        TerracottaManager.setState(new TerracottaState.Uninitialized(false));
                        break;
                    }
                    case LEGACY_VERSION: {
                        TerracottaManager.setState(new TerracottaState.Uninitialized(true));
                        break;
                    }
                    case READY: {
                        TerracottaManager.launch(TerracottaManager.setState(new TerracottaState.Launching()));
                    }
                }
            }
        }).whenComplete(exception -> {
            if (exception != null) {
                TerracottaManager.compareAndSet(TerracottaState.Bootstrap.INSTANCE, new TerracottaState.Fatal(TerracottaState.Fatal.Type.UNKNOWN));
            }
        }).start();
        Lang.thread(() -> {
            while (true) {
                TerracottaState next;
                int n;
                TerracottaState state;
                if (!((state = STATE_V.get()) instanceof TerracottaState.PortSpecific)) {
                    LockSupport.parkNanos(500000L);
                    continue;
                }
                TerracottaState.PortSpecific portSpecific = (TerracottaState.PortSpecific)state;
                int port = portSpecific.port;
                if (state instanceof TerracottaState.Ready) {
                    TerracottaState.Ready ready = (TerracottaState.Ready)state;
                    n = ready.index;
                } else {
                    n = Integer.MIN_VALUE;
                }
                int index = n;
                try {
                    next = new GetTask(URI.create(String.format("http://127.0.0.1:%d/state", port))).setSignificance(Task.TaskSignificance.MINOR).thenApplyAsync(jsonString -> {
                        TerracottaState.Ready object = JsonUtils.fromNonNullJson(jsonString, TypeToken.get(TerracottaState.Ready.class));
                        if (object.index <= index) {
                            return null;
                        }
                        object.port = port;
                        return object;
                    }).setSignificance(Task.TaskSignificance.MINOR).run();
                }
                catch (Exception e) {
                    Logger.LOG.warning("Cannot fetch state from Terracotta.", e);
                    next = new TerracottaState.Fatal(TerracottaState.Fatal.Type.TERRACOTTA);
                }
                if (next != null) {
                    TerracottaManager.compareAndSet(state, next);
                }
                LockSupport.parkNanos(500000L);
            }
        }, "Terracotta Background Daemon", true);
    }
}

